/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.AbortException;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;

public final class FlowInterruptedException
extends InterruptedException {
    @Nonnull
    private final Result result;
    @Nonnull
    private final List<CauseOfInterruption> causes;

    public FlowInterruptedException(@Nonnull Result result, CauseOfInterruption ... causes) {
        this.result = result;
        this.causes = Arrays.asList(causes);
    }

    @Nonnull
    public Result getResult() {
        return this.result;
    }

    @Nonnull
    public List<CauseOfInterruption> getCauses() {
        return this.causes;
    }

    public void handle(Run<?, ?> run, TaskListener listener) {
        run.addAction((Action)new InterruptedBuildAction(this.causes));
        for (CauseOfInterruption cause : this.causes) {
            cause.print(listener);
        }
        FlowInterruptedException.print(this.getCause(), listener);
        for (Throwable t : this.getSuppressed()) {
            FlowInterruptedException.print(t, listener);
        }
    }

    private static void print(@CheckForNull Throwable t, @Nonnull TaskListener listener) {
        if (t instanceof AbortException) {
            listener.getLogger().println(t.getMessage());
        } else if (t != null) {
            t.printStackTrace(listener.getLogger());
        }
    }
}

