/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.scm.ChangeLogSet;
import hudson.util.ListBoxModel;
import java.io.IOException;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.utils.Comparator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ChangeSetConditional
extends DeclarativeStageConditional<ChangeSetConditional> {
    @Deprecated
    private transient String glob;
    private String pattern;
    private boolean caseSensitive;
    private String comparator;

    @DataBoundConstructor
    public ChangeSetConditional(String pattern) {
        this.pattern = pattern;
        this.caseSensitive = false;
    }

    @Deprecated
    public String getGlob() {
        return this.glob;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getComparator() {
        return this.comparator;
    }

    protected Object readResolve() throws IOException {
        if (this.glob != null) {
            this.pattern = this.glob;
        }
        return this;
    }

    @DataBoundSetter
    public void setComparator(String comparator) {
        Comparator c = Comparator.get(comparator, null);
        this.comparator = c != null ? c.name() : null;
    }

    @DataBoundSetter
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean changeSetMatches(ChangeLogSet.Entry change, String pattern, boolean caseSensitive) {
        Comparator c = Comparator.get(this.comparator, Comparator.GLOB);
        return change.getAffectedPaths().stream().anyMatch(path -> c.compare(pattern, (String)path, caseSensitive));
    }

    @Extension
    @Symbol(value={"changeset"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<ChangeSetConditional> {
        @NonNull
        public String getDisplayName() {
            return "Execute the stage if the changeset contains a file matching a pattern";
        }

        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }

        public ListBoxModel doFillComparatorItems() {
            return Comparator.getSelectOptions(true, Comparator.GLOB);
        }
    }
}

