/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class EnvironmentConditional
extends DeclarativeStageConditional<EnvironmentConditional> {
    private final String name;
    private final String value;
    private boolean ignoreCase = false;

    @DataBoundConstructor
    public EnvironmentConditional(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @DataBoundSetter
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean environmentMatches(String v, String var) {
        if (StringUtils.isEmpty((String)var) && StringUtils.isEmpty((String)v)) {
            return true;
        }
        if (StringUtils.isEmpty((String)var)) {
            return false;
        }
        if (this.ignoreCase) {
            return var.equalsIgnoreCase(v);
        }
        return var.equals(v);
    }

    @Extension
    @Symbol(value={"environment"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<EnvironmentConditional> {
        @NonNull
        public String getDisplayName() {
            return "Execute the stage if an environment variable exists and equals a value";
        }

        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }
    }
}

