// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.modeldefinition.actions;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Restart.from.Stage}: {@code Restart from Stage}.
     * 
     * @return
     *     {@code Restart from Stage}
     */
    public static String Restart_from_Stage() {
        return holder.format("Restart.from.Stage");
    }

    /**
     * Key {@code Restart.from.Stage}: {@code Restart from Stage}.
     * 
     * @return
     *     {@code Restart from Stage}
     */
    public static Localizable _Restart_from_Stage() {
        return new Localizable(holder, "Restart.from.Stage");
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.OriginRunIncomplete}:
     * {@code The origin build {0} is not complete, so cannot be restarted.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The origin build {0} is not complete, so cannot be restarted.}
     */
    public static String RestartDeclarativePipelineAction_OriginRunIncomplete(Object arg0) {
        return holder.format("RestartDeclarativePipelineAction.OriginRunIncomplete", arg0);
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.OriginRunIncomplete}:
     * {@code The origin build {0} is not complete, so cannot be restarted.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The origin build {0} is not complete, so cannot be restarted.}
     */
    public static Localizable _RestartDeclarativePipelineAction_OriginRunIncomplete(Object arg0) {
        return new Localizable(holder, "RestartDeclarativePipelineAction.OriginRunIncomplete", arg0);
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.StageNameNotPresent}:
     * {@code Stage {0} is not present in the top-level stages for {1}, so
     * cannot be restarted.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage {0} is not present in the top-level stages for {1}, so
     *     cannot be restarted.}
     */
    public static String RestartDeclarativePipelineAction_StageNameNotPresent(Object arg0, Object arg1) {
        return holder.format("RestartDeclarativePipelineAction.StageNameNotPresent", arg0, arg1);
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.StageNameNotPresent}:
     * {@code Stage {0} is not present in the top-level stages for {1}, so
     * cannot be restarted.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage {0} is not present in the top-level stages for {1}, so
     *     cannot be restarted.}
     */
    public static Localizable _RestartDeclarativePipelineAction_StageNameNotPresent(Object arg0, Object arg1) {
        return new Localizable(holder, "RestartDeclarativePipelineAction.StageNameNotPresent", arg0, arg1);
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.NullStageName}: {@code
     * Stage name cannot be null or an empty string.}.
     * 
     * @return
     *     {@code Stage name cannot be null or an empty string.}
     */
    public static String RestartDeclarativePipelineAction_NullStageName() {
        return holder.format("RestartDeclarativePipelineAction.NullStageName");
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.NullStageName}: {@code
     * Stage name cannot be null or an empty string.}.
     * 
     * @return
     *     {@code Stage name cannot be null or an empty string.}
     */
    public static Localizable _RestartDeclarativePipelineAction_NullStageName() {
        return new Localizable(holder, "RestartDeclarativePipelineAction.NullStageName");
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.OriginWasNotDeclarative}:
     * {@code {0} was not a Declarative Pipeline, and cannot be restarted.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} was not a Declarative Pipeline, and cannot be restarted.}
     */
    public static String RestartDeclarativePipelineAction_OriginWasNotDeclarative(Object arg0) {
        return holder.format("RestartDeclarativePipelineAction.OriginWasNotDeclarative", arg0);
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.OriginWasNotDeclarative}:
     * {@code {0} was not a Declarative Pipeline, and cannot be restarted.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} was not a Declarative Pipeline, and cannot be restarted.}
     */
    public static Localizable _RestartDeclarativePipelineAction_OriginWasNotDeclarative(Object arg0) {
        return new Localizable(holder, "RestartDeclarativePipelineAction.OriginWasNotDeclarative", arg0);
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.ProjectNotBuildable}:
     * {@code Job {0} is not buildable.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Job {0} is not buildable.}
     */
    public static String RestartDeclarativePipelineAction_ProjectNotBuildable(Object arg0) {
        return holder.format("RestartDeclarativePipelineAction.ProjectNotBuildable", arg0);
    }

    /**
     * Key {@code RestartDeclarativePipelineAction.ProjectNotBuildable}:
     * {@code Job {0} is not buildable.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Job {0} is not buildable.}
     */
    public static Localizable _RestartDeclarativePipelineAction_ProjectNotBuildable(Object arg0) {
        return new Localizable(holder, "RestartDeclarativePipelineAction.ProjectNotBuildable", arg0);
    }

    /**
     * Key {@code
     * RestartDeclarativePipelineAction.OriginRunMissingExecution}: {@code
     * The origin build {0} did not execute its Pipeline, so cannot be
     * restarted.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The origin build {0} did not execute its Pipeline, so cannot be
     *     restarted.}
     */
    public static String RestartDeclarativePipelineAction_OriginRunMissingExecution(Object arg0) {
        return holder.format("RestartDeclarativePipelineAction.OriginRunMissingExecution", arg0);
    }

    /**
     * Key {@code
     * RestartDeclarativePipelineAction.OriginRunMissingExecution}: {@code
     * The origin build {0} did not execute its Pipeline, so cannot be
     * restarted.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The origin build {0} did not execute its Pipeline, so cannot be
     *     restarted.}
     */
    public static Localizable _RestartDeclarativePipelineAction_OriginRunMissingExecution(Object arg0) {
        return new Localizable(holder, "RestartDeclarativePipelineAction.OriginRunMissingExecution", arg0);
    }

}
