// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.modeldefinition.cli;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code RestartFromStageCommand.ShortDescription}: {@code Restart a
     * completed Declarative Pipeline build from a given stage.}.
     * 
     * @return
     *     {@code Restart a completed Declarative Pipeline build from a given
     *     stage.}
     */
    public static String RestartFromStageCommand_ShortDescription() {
        return holder.format("RestartFromStageCommand.ShortDescription");
    }

    /**
     * Key {@code RestartFromStageCommand.ShortDescription}: {@code Restart a
     * completed Declarative Pipeline build from a given stage.}.
     * 
     * @return
     *     {@code Restart a completed Declarative Pipeline build from a given
     *     stage.}
     */
    public static Localizable _RestartFromStageCommand_ShortDescription() {
        return new Localizable(holder, "RestartFromStageCommand.ShortDescription");
    }

    /**
     * Key {@code DeclarativeLinterCommand.ShortDescription}: {@code Validate
     * a Jenkinsfile containing a Declarative Pipeline}.
     * 
     * @return
     *     {@code Validate a Jenkinsfile containing a Declarative Pipeline}
     */
    public static String DeclarativeLinterCommand_ShortDescription() {
        return holder.format("DeclarativeLinterCommand.ShortDescription");
    }

    /**
     * Key {@code DeclarativeLinterCommand.ShortDescription}: {@code Validate
     * a Jenkinsfile containing a Declarative Pipeline}.
     * 
     * @return
     *     {@code Validate a Jenkinsfile containing a Declarative Pipeline}
     */
    public static Localizable _DeclarativeLinterCommand_ShortDescription() {
        return new Localizable(holder, "DeclarativeLinterCommand.ShortDescription");
    }

}
