// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.modeldefinition.model;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SkippedStageReason.WHEN.Message}: {@code Stage "{0}"
     * skipped due to when conditional}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to when conditional}
     */
    public static String SkippedStageReason_WHEN_Message(Object arg0) {
        return holder.format("SkippedStageReason.WHEN.Message", arg0);
    }

    /**
     * Key {@code SkippedStageReason.WHEN.Message}: {@code Stage "{0}"
     * skipped due to when conditional}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to when conditional}
     */
    public static Localizable _SkippedStageReason_WHEN_Message(Object arg0) {
        return new Localizable(holder, "SkippedStageReason.WHEN.Message", arg0);
    }

    /**
     * Key {@code SkippedStageReason.RESTART.Message}: {@code Stage "{0}"
     * skipped due to this build restarting at stage "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to this build restarting at stage
     *     "{1}"}
     */
    public static String SkippedStageReason_RESTART_Message(Object arg0, Object arg1) {
        return holder.format("SkippedStageReason.RESTART.Message", arg0, arg1);
    }

    /**
     * Key {@code SkippedStageReason.RESTART.Message}: {@code Stage "{0}"
     * skipped due to this build restarting at stage "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to this build restarting at stage
     *     "{1}"}
     */
    public static Localizable _SkippedStageReason_RESTART_Message(Object arg0, Object arg1) {
        return new Localizable(holder, "SkippedStageReason.RESTART.Message", arg0, arg1);
    }

    /**
     * Key {@code SkippedStageReason.FAILURE.Message}: {@code Stage "{0}"
     * skipped due to earlier failure(s)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to earlier failure(s)}
     */
    public static String SkippedStageReason_FAILURE_Message(Object arg0) {
        return holder.format("SkippedStageReason.FAILURE.Message", arg0);
    }

    /**
     * Key {@code SkippedStageReason.FAILURE.Message}: {@code Stage "{0}"
     * skipped due to earlier failure(s)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to earlier failure(s)}
     */
    public static Localizable _SkippedStageReason_FAILURE_Message(Object arg0) {
        return new Localizable(holder, "SkippedStageReason.FAILURE.Message", arg0);
    }

    /**
     * Key {@code SkippedStageReason.UNSTABLE.Message}: {@code Stage "{0}"
     * skipped due to earlier stage(s) marking the build as unstable}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to earlier stage(s) marking the build
     *     as unstable}
     */
    public static String SkippedStageReason_UNSTABLE_Message(Object arg0) {
        return holder.format("SkippedStageReason.UNSTABLE.Message", arg0);
    }

    /**
     * Key {@code SkippedStageReason.UNSTABLE.Message}: {@code Stage "{0}"
     * skipped due to earlier stage(s) marking the build as unstable}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stage "{0}" skipped due to earlier stage(s) marking the build
     *     as unstable}
     */
    public static Localizable _SkippedStageReason_UNSTABLE_Message(Object arg0) {
        return new Localizable(holder, "SkippedStageReason.UNSTABLE.Message", arg0);
    }

}
