// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.modeldefinition.model.conditions;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Aborted.Description}: {@code Run when the build status is
     * "Aborted"}.
     * 
     * @return
     *     {@code Run when the build status is "Aborted"}
     */
    public static String Aborted_Description() {
        return holder.format("Aborted.Description");
    }

    /**
     * Key {@code Aborted.Description}: {@code Run when the build status is
     * "Aborted"}.
     * 
     * @return
     *     {@code Run when the build status is "Aborted"}
     */
    public static Localizable _Aborted_Description() {
        return new Localizable(holder, "Aborted.Description");
    }

    /**
     * Key {@code NotBuilt.Description}: {@code Run if the build status is
     * "Not Built"}.
     * 
     * @return
     *     {@code Run if the build status is "Not Built"}
     */
    public static String NotBuilt_Description() {
        return holder.format("NotBuilt.Description");
    }

    /**
     * Key {@code NotBuilt.Description}: {@code Run if the build status is
     * "Not Built"}.
     * 
     * @return
     *     {@code Run if the build status is "Not Built"}
     */
    public static Localizable _NotBuilt_Description() {
        return new Localizable(holder, "NotBuilt.Description");
    }

    /**
     * Key {@code Regression.Description}: {@code Run if the current build's
     * status is worse than the previous build's status}.
     * 
     * @return
     *     {@code Run if the current build's status is worse than the previous
     *     build's status}
     */
    public static String Regression_Description() {
        return holder.format("Regression.Description");
    }

    /**
     * Key {@code Regression.Description}: {@code Run if the current build's
     * status is worse than the previous build's status}.
     * 
     * @return
     *     {@code Run if the current build's status is worse than the previous
     *     build's status}
     */
    public static Localizable _Regression_Description() {
        return new Localizable(holder, "Regression.Description");
    }

    /**
     * Key {@code Failure.Description}: {@code Run if the build status is
     * "Failure"}.
     * 
     * @return
     *     {@code Run if the build status is "Failure"}
     */
    public static String Failure_Description() {
        return holder.format("Failure.Description");
    }

    /**
     * Key {@code Failure.Description}: {@code Run if the build status is
     * "Failure"}.
     * 
     * @return
     *     {@code Run if the build status is "Failure"}
     */
    public static Localizable _Failure_Description() {
        return new Localizable(holder, "Failure.Description");
    }

    /**
     * Key {@code Changed.Description}: {@code Run if the current build's
     * status is different than the previous build's status}.
     * 
     * @return
     *     {@code Run if the current build's status is different than the
     *     previous build's status}
     */
    public static String Changed_Description() {
        return holder.format("Changed.Description");
    }

    /**
     * Key {@code Changed.Description}: {@code Run if the current build's
     * status is different than the previous build's status}.
     * 
     * @return
     *     {@code Run if the current build's status is different than the
     *     previous build's status}
     */
    public static Localizable _Changed_Description() {
        return new Localizable(holder, "Changed.Description");
    }

    /**
     * Key {@code Unstable.Description}: {@code Run if the build status is
     * "Unstable"}.
     * 
     * @return
     *     {@code Run if the build status is "Unstable"}
     */
    public static String Unstable_Description() {
        return holder.format("Unstable.Description");
    }

    /**
     * Key {@code Unstable.Description}: {@code Run if the build status is
     * "Unstable"}.
     * 
     * @return
     *     {@code Run if the build status is "Unstable"}
     */
    public static Localizable _Unstable_Description() {
        return new Localizable(holder, "Unstable.Description");
    }

    /**
     * Key {@code Unsuccessful.Description}: {@code Run if the current
     * build's status is "Aborted", "Failure" or "Unstable"}.
     * 
     * @return
     *     {@code Run if the current build's status is "Aborted", "Failure" or
     *     "Unstable"}
     */
    public static String Unsuccessful_Description() {
        return holder.format("Unsuccessful.Description");
    }

    /**
     * Key {@code Unsuccessful.Description}: {@code Run if the current
     * build's status is "Aborted", "Failure" or "Unstable"}.
     * 
     * @return
     *     {@code Run if the current build's status is "Aborted", "Failure" or
     *     "Unstable"}
     */
    public static Localizable _Unsuccessful_Description() {
        return new Localizable(holder, "Unsuccessful.Description");
    }

    /**
     * Key {@code Fixed.Description}: {@code Run if the previous build was
     * not successful and the current build's status is "Success"}.
     * 
     * @return
     *     {@code Run if the previous build was not successful and the current
     *     build's status is "Success"}
     */
    public static String Fixed_Description() {
        return holder.format("Fixed.Description");
    }

    /**
     * Key {@code Fixed.Description}: {@code Run if the previous build was
     * not successful and the current build's status is "Success"}.
     * 
     * @return
     *     {@code Run if the previous build was not successful and the current
     *     build's status is "Success"}
     */
    public static Localizable _Fixed_Description() {
        return new Localizable(holder, "Fixed.Description");
    }

    /**
     * Key {@code Always.Description}: {@code Always run, regardless of build
     * status}.
     * 
     * @return
     *     {@code Always run, regardless of build status}
     */
    public static String Always_Description() {
        return holder.format("Always.Description");
    }

    /**
     * Key {@code Always.Description}: {@code Always run, regardless of build
     * status}.
     * 
     * @return
     *     {@code Always run, regardless of build status}
     */
    public static Localizable _Always_Description() {
        return new Localizable(holder, "Always.Description");
    }

    /**
     * Key {@code Success.Description}: {@code Run if the build status is
     * "Success" or hasn't been set yet}.
     * 
     * @return
     *     {@code Run if the build status is "Success" or hasn't been set yet}
     */
    public static String Success_Description() {
        return holder.format("Success.Description");
    }

    /**
     * Key {@code Success.Description}: {@code Run if the build status is
     * "Success" or hasn't been set yet}.
     * 
     * @return
     *     {@code Run if the build status is "Success" or hasn't been set yet}
     */
    public static Localizable _Success_Description() {
        return new Localizable(holder, "Success.Description");
    }

    /**
     * Key {@code Cleanup.Description}: {@code Always run after all other
     * conditions, regardless of build status}.
     * 
     * @return
     *     {@code Always run after all other conditions, regardless of build
     *     status}
     */
    public static String Cleanup_Description() {
        return holder.format("Cleanup.Description");
    }

    /**
     * Key {@code Cleanup.Description}: {@code Always run after all other
     * conditions, regardless of build status}.
     * 
     * @return
     *     {@code Always run after all other conditions, regardless of build
     *     status}
     */
    public static Localizable _Cleanup_Description() {
        return new Localizable(holder, "Cleanup.Description");
    }

}
