// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.modeldefinition.validator;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Properties}: {@code
     * The properties step cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The properties step cannot be used in Declarative Pipelines}
     */
    public static String BlockedStepsAndMethodCalls_BlockedSteps_Properties() {
        return holder.format("BlockedStepsAndMethodCalls.BlockedSteps.Properties");
    }

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Properties}: {@code
     * The properties step cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The properties step cannot be used in Declarative Pipelines}
     */
    public static Localizable _BlockedStepsAndMethodCalls_BlockedSteps_Properties() {
        return new Localizable(holder, "BlockedStepsAndMethodCalls.BlockedSteps.Properties");
    }

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Parallel}: {@code
     * The parallel step can only be used as the only top-level step in a
     * stage's step block}.
     * 
     * @return
     *     {@code The parallel step can only be used as the only top-level step
     *     in a stage's step block}
     */
    public static String BlockedStepsAndMethodCalls_BlockedSteps_Parallel() {
        return holder.format("BlockedStepsAndMethodCalls.BlockedSteps.Parallel");
    }

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Parallel}: {@code
     * The parallel step can only be used as the only top-level step in a
     * stage's step block}.
     * 
     * @return
     *     {@code The parallel step can only be used as the only top-level step
     *     in a stage's step block}
     */
    public static Localizable _BlockedStepsAndMethodCalls_BlockedSteps_Parallel() {
        return new Localizable(holder, "BlockedStepsAndMethodCalls.BlockedSteps.Parallel");
    }

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Node}: {@code The
     * node step cannot be called as an argument to a method in Declarative
     * Pipelines}.
     * 
     * @return
     *     {@code The node step cannot be called as an argument to a method in
     *     Declarative Pipelines}
     */
    public static String BlockedStepsAndMethodCalls_BlockedSteps_Node() {
        return holder.format("BlockedStepsAndMethodCalls.BlockedSteps.Node");
    }

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Node}: {@code The
     * node step cannot be called as an argument to a method in Declarative
     * Pipelines}.
     * 
     * @return
     *     {@code The node step cannot be called as an argument to a method in
     *     Declarative Pipelines}
     */
    public static Localizable _BlockedStepsAndMethodCalls_BlockedSteps_Node() {
        return new Localizable(holder, "BlockedStepsAndMethodCalls.BlockedSteps.Node");
    }

    /**
     * Key {@code ParametersAndTriggersInOptions.RejectTriggers}: {@code The
     * "triggers" job property can't be used in the "options" directive. Use
     * the "triggers {...}" directive instead.}.
     * 
     * @return
     *     {@code The "triggers" job property can't be used in the "options"
     *     directive. Use the "triggers {...}" directive instead.}
     */
    public static String ParametersAndTriggersInOptions_RejectTriggers() {
        return holder.format("ParametersAndTriggersInOptions.RejectTriggers");
    }

    /**
     * Key {@code ParametersAndTriggersInOptions.RejectTriggers}: {@code The
     * "triggers" job property can't be used in the "options" directive. Use
     * the "triggers {...}" directive instead.}.
     * 
     * @return
     *     {@code The "triggers" job property can't be used in the "options"
     *     directive. Use the "triggers {...}" directive instead.}
     */
    public static Localizable _ParametersAndTriggersInOptions_RejectTriggers() {
        return new Localizable(holder, "ParametersAndTriggersInOptions.RejectTriggers");
    }

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Stage}: {@code The
     * stage step cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The stage step cannot be used in Declarative Pipelines}
     */
    public static String BlockedStepsAndMethodCalls_BlockedSteps_Stage() {
        return holder.format("BlockedStepsAndMethodCalls.BlockedSteps.Stage");
    }

    /**
     * Key {@code BlockedStepsAndMethodCalls.BlockedSteps.Stage}: {@code The
     * stage step cannot be used in Declarative Pipelines}.
     * 
     * @return
     *     {@code The stage step cannot be used in Declarative Pipelines}
     */
    public static Localizable _BlockedStepsAndMethodCalls_BlockedSteps_Stage() {
        return new Localizable(holder, "BlockedStepsAndMethodCalls.BlockedSteps.Stage");
    }

    /**
     * Key {@code ParametersAndTriggersInOptions.RejectParameters}: {@code
     * The "parameters" job property can't be used in the "options"
     * directive. Use the "parameters {...}" directive instead.}.
     * 
     * @return
     *     {@code The "parameters" job property can't be used in the "options"
     *     directive. Use the "parameters {...}" directive instead.}
     */
    public static String ParametersAndTriggersInOptions_RejectParameters() {
        return holder.format("ParametersAndTriggersInOptions.RejectParameters");
    }

    /**
     * Key {@code ParametersAndTriggersInOptions.RejectParameters}: {@code
     * The "parameters" job property can't be used in the "options"
     * directive. Use the "parameters {...}" directive instead.}.
     * 
     * @return
     *     {@code The "parameters" job property can't be used in the "options"
     *     directive. Use the "parameters {...}" directive instead.}
     */
    public static Localizable _ParametersAndTriggersInOptions_RejectParameters() {
        return new Localizable(holder, "ParametersAndTriggersInOptions.RejectParameters");
    }

}
