/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.filtering;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.filtering.ComplexMatcher;
import org.jetbrains.kotlin.abi.tools.filtering.FilterResult;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcher;
import org.jetbrains.kotlin.abi.tools.filtering.WildcardsMatcher;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0016\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherImpl;", "Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcher;", "include", "Lorg/jetbrains/kotlin/abi/tools/filtering/ComplexMatcher;", "exclude", "<init>", "(Lorg/jetbrains/kotlin/abi/tools/filtering/ComplexMatcher;Lorg/jetbrains/kotlin/abi/tools/filtering/ComplexMatcher;)V", "hasClassNameFilters", "", "getHasClassNameFilters", "()Z", "hasAnnotationFilters", "getHasAnnotationFilters", "isEmpty", "testClass", "Lorg/jetbrains/kotlin/abi/tools/filtering/FilterResult;", "className", "", "annotations", "", "isExcludedByName", "qualifiedName", "isExcludedByAnnotations", "annotationNames", "testClassMember", "Companion", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nFiltersMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FiltersMatcher.kt\norg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1915#2,2:311\n1915#2,2:313\n1915#2,2:315\n*S KotlinDebug\n*F\n+ 1 FiltersMatcher.kt\norg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherImpl\n*L\n72#1:311,2\n109#1:313,2\n132#1:315,2\n*E\n"})
final class FiltersMatcherImpl
implements FiltersMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComplexMatcher include;
    @NotNull
    private final ComplexMatcher exclude;
    private final boolean hasClassNameFilters;
    private final boolean hasAnnotationFilters;
    private final boolean isEmpty;
    @NotNull
    private static final FiltersMatcherImpl EMPTY = new FiltersMatcherImpl(new ComplexMatcher(WildcardsMatcher.Companion.getEMPTY(), WildcardsMatcher.Companion.getEMPTY()), new ComplexMatcher(WildcardsMatcher.Companion.getEMPTY(), WildcardsMatcher.Companion.getEMPTY()));

    public FiltersMatcherImpl(@NotNull ComplexMatcher include, @NotNull ComplexMatcher exclude) {
        Intrinsics.checkNotNullParameter((Object)include, (String)"include");
        Intrinsics.checkNotNullParameter((Object)exclude, (String)"exclude");
        this.include = include;
        this.exclude = exclude;
        this.hasClassNameFilters = !this.include.getClassNames().isEmpty() || !this.exclude.getClassNames().isEmpty();
        this.hasAnnotationFilters = !this.include.getAnnotations().isEmpty() || !this.exclude.getAnnotations().isEmpty();
        this.isEmpty = !this.getHasClassNameFilters() && !this.getHasAnnotationFilters();
    }

    @Override
    public boolean getHasClassNameFilters() {
        return this.hasClassNameFilters;
    }

    @Override
    public boolean getHasAnnotationFilters() {
        return this.hasAnnotationFilters;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    @NotNull
    public FilterResult testClass(@NotNull String className, @NotNull List<String> annotations) {
        boolean emptyInclusionFilters;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        boolean matchInclude = false;
        boolean bl = emptyInclusionFilters = this.include.getClassNames().isEmpty() && this.include.getAnnotations().isEmpty();
        if (this.getHasClassNameFilters()) {
            if (!this.exclude.getClassNames().isEmpty() && this.exclude.getClassNames().matches(className)) {
                return FilterResult.EXCLUDED;
            }
            if (this.include.getClassNames().matches(className)) {
                matchInclude = true;
            }
        }
        if (this.getHasAnnotationFilters()) {
            boolean checkExclude = !this.exclude.getAnnotations().isEmpty();
            boolean checkInclude = !this.include.getAnnotations().isEmpty();
            Iterable $this$forEach$iv = annotations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String annotation = (String)element$iv;
                boolean bl2 = false;
                if (checkExclude && this.exclude.getAnnotations().matches(annotation)) {
                    return FilterResult.EXCLUDED;
                }
                if (checkInclude && !matchInclude && this.include.getAnnotations().matches(annotation)) {
                    matchInclude = true;
                }
                if (checkExclude || !checkInclude || !matchInclude) continue;
            }
        }
        return emptyInclusionFilters ? FilterResult.PASSED : (matchInclude ? FilterResult.INCLUDED : FilterResult.NOT_IN_INCLUDE);
    }

    @Override
    public boolean isExcludedByName(@NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        if (!this.getHasClassNameFilters()) {
            return false;
        }
        if (!this.exclude.getClassNames().isEmpty() && this.exclude.getClassNames().matches(qualifiedName)) {
            return true;
        }
        return !this.include.getClassNames().isEmpty() && !this.include.getClassNames().matches(qualifiedName);
    }

    @Override
    public boolean isExcludedByAnnotations(@NotNull List<String> annotationNames) {
        Intrinsics.checkNotNullParameter(annotationNames, (String)"annotationNames");
        boolean checkExclude = !this.exclude.getAnnotations().isEmpty();
        boolean checkInclude = false;
        checkInclude = !this.include.getAnnotations().isEmpty();
        boolean inInclude = false;
        Iterable $this$forEach$iv = annotationNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String annotation = (String)element$iv;
            boolean bl = false;
            if (checkExclude && this.exclude.getAnnotations().matches(annotation)) {
                return true;
            }
            if (!checkInclude || !this.include.getAnnotations().matches(annotation)) continue;
            checkInclude = false;
            inInclude = true;
            if (checkExclude) continue;
            return false;
        }
        return !this.include.getAnnotations().isEmpty() && !inInclude;
    }

    @Override
    @NotNull
    public FilterResult testClassMember(@NotNull List<String> annotationNames) {
        boolean checkInclude;
        Intrinsics.checkNotNullParameter(annotationNames, (String)"annotationNames");
        boolean checkExclude = !this.exclude.getAnnotations().isEmpty();
        boolean bl = checkInclude = !this.include.getAnnotations().isEmpty();
        if (!checkExclude && !checkInclude) {
            return FilterResult.PASSED;
        }
        boolean matchInclude = false;
        Iterable $this$forEach$iv = annotationNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String annotation = (String)element$iv;
            boolean bl2 = false;
            if (checkExclude && this.exclude.getAnnotations().matches(annotation)) {
                return FilterResult.EXCLUDED;
            }
            if (checkInclude && this.include.getAnnotations().matches(annotation)) {
                matchInclude = true;
            }
            if (checkExclude || matchInclude) continue;
        }
        return !checkInclude ? FilterResult.PASSED : (matchInclude ? FilterResult.INCLUDED : FilterResult.NOT_IN_INCLUDE);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherImpl$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherImpl;", "getEMPTY", "()Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherImpl;", "abi-tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FiltersMatcherImpl getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

