/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.compat;

import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.ExecutionPolicy;
import org.jetbrains.kotlin.buildtools.api.KotlinToolchains;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmPlatformToolchain;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmClasspathSnapshottingOperation;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmCompilationOperation;
import org.jetbrains.kotlin.buildtools.internal.compat.BuildSessionV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.ExecutionPolicyV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.JvmClasspathSnapshottingOperationV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.JvmCompilationOperationV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.KotlinToolchainsV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.arguments.JvmCompilerArgumentsImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/KotlinToolchainsV1Adapter;", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;", "compilationService", "Lorg/jetbrains/kotlin/buildtools/api/CompilationService;", "<init>", "(Lorg/jetbrains/kotlin/buildtools/api/CompilationService;)V", "jvm", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmPlatformToolchain;", "getJvm", "()Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmPlatformToolchain;", "jvm$delegate", "Lkotlin/Lazy;", "getToolchain", "T", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$Toolchain;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$Toolchain;", "createInProcessExecutionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy$InProcess;", "createDaemonExecutionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy$WithDaemon;", "getCompilerVersion", "", "createBuildSession", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$BuildSession;", "kotlin-build-tools-compat"})
public final class KotlinToolchainsV1Adapter
implements KotlinToolchains {
    @NotNull
    private final CompilationService compilationService;
    @NotNull
    private final Lazy jvm$delegate;

    public KotlinToolchainsV1Adapter(@NotNull CompilationService compilationService) {
        Intrinsics.checkNotNullParameter((Object)compilationService, (String)"compilationService");
        this.compilationService = compilationService;
        this.jvm$delegate = LazyKt.lazy(() -> KotlinToolchainsV1Adapter.jvm_delegate$lambda$0(this));
    }

    private final JvmPlatformToolchain getJvm() {
        Lazy lazy = this.jvm$delegate;
        return (JvmPlatformToolchain)lazy.getValue();
    }

    @NotNull
    public <T extends KotlinToolchains.Toolchain> T getToolchain(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (!Intrinsics.areEqual(type, JvmPlatformToolchain.class)) {
            throw new IllegalStateException(("Unsupported platform toolchain type: " + type + ". Only JVM compilation is supported in BTA API v1 fallback (compiler version " + this.getCompilerVersion() + ").").toString());
        }
        JvmPlatformToolchain jvmPlatformToolchain = this.getJvm();
        Intrinsics.checkNotNull((Object)jvmPlatformToolchain, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlin.buildtools.internal.compat.KotlinToolchainsV1Adapter.getToolchain");
        return (T)((KotlinToolchains.Toolchain)jvmPlatformToolchain);
    }

    @NotNull
    public ExecutionPolicy.InProcess createInProcessExecutionPolicy() {
        return new ExecutionPolicyV1Adapter.InProcess(this.compilationService.makeCompilerExecutionStrategyConfiguration().useInProcessStrategy());
    }

    @NotNull
    public ExecutionPolicy.WithDaemon createDaemonExecutionPolicy() {
        return new ExecutionPolicyV1Adapter.WithDaemon(this.compilationService);
    }

    @NotNull
    public String getCompilerVersion() {
        return this.compilationService.getCompilerVersion();
    }

    @NotNull
    public KotlinToolchains.BuildSession createBuildSession() {
        return new BuildSessionV1Adapter(this, (ProjectId)ProjectId.Companion.RandomProjectUUID(), this.compilationService);
    }

    private static final jvm.2.1 jvm_delegate$lambda$0(KotlinToolchainsV1Adapter this$0) {
        return new JvmPlatformToolchain(this$0){
            final /* synthetic */ KotlinToolchainsV1Adapter this$0;
            {
                this.this$0 = $receiver;
            }

            public JvmCompilationOperation createJvmCompilationOperation(List<? extends Path> sources, Path destinationDirectory) {
                Intrinsics.checkNotNullParameter(sources, (String)"sources");
                Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
                return new JvmCompilationOperationV1Adapter(KotlinToolchainsV1Adapter.access$getCompilationService$p(this.this$0), sources, destinationDirectory, new JvmCompilerArgumentsImpl());
            }

            public JvmClasspathSnapshottingOperation createClasspathSnapshottingOperation(Path classpathEntry) {
                Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
                return new JvmClasspathSnapshottingOperationV1Adapter(KotlinToolchainsV1Adapter.access$getCompilationService$p(this.this$0), classpathEntry);
            }
        };
    }

    public static final /* synthetic */ CompilationService access$getCompilationService$p(KotlinToolchainsV1Adapter $this) {
        return $this.compilationService;
    }
}

