/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.compat;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.KClassesJvm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.internal.BaseOption;
import org.jetbrains.kotlin.buildtools.internal.compat.BaseOptionWithDefault;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0015\b\u0016\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ'\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0086\u0002J\"\u0010\u0011\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0011\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u0013H\u0086\u0002\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0086\u0002J\u001c\u0010\u0011\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/Options;", "", "optionsName", "", "<init>", "(Ljava/lang/String;)V", "typeForName", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "optionsMap", "", "set", "", "V", "key", "Lorg/jetbrains/kotlin/buildtools/api/internal/BaseOption;", "value", "get", "(Lorg/jetbrains/kotlin/buildtools/api/internal/BaseOption;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/buildtools/internal/compat/BaseOptionWithDefault;", "(Lorg/jetbrains/kotlin/buildtools/internal/compat/BaseOptionWithDefault;)Ljava/lang/Object;", "(Ljava/lang/String;)Ljava/lang/Object;", "kotlin-build-tools-compat"})
public final class Options {
    @NotNull
    private final String optionsName;
    @NotNull
    private final Map<String, Object> optionsMap;

    public Options(@NotNull String optionsName) {
        Intrinsics.checkNotNullParameter((Object)optionsName, (String)"optionsName");
        this.optionsName = optionsName;
        this.optionsMap = new LinkedHashMap();
    }

    public Options(@NotNull KClass<?> typeForName) {
        Intrinsics.checkNotNullParameter(typeForName, (String)"typeForName");
        String string = Reflection.getOrCreateKotlinClass(typeForName.getClass()).getQualifiedName();
        if (string == null) {
            string = KClassesJvm.getJvmName((KClass)Reflection.getOrCreateKotlinClass(typeForName.getClass()));
        }
        this(string);
    }

    public final <V> void set(@NotNull BaseOption<V> key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.optionsMap.put(key.getId(), value);
    }

    public final <V> V get(@NotNull BaseOption<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.get(key.getId());
    }

    public final <V> V get(@NotNull BaseOptionWithDefault<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.optionsMap.containsKey(key.getId()) ? this.get(key.getId()) : key.getDefaultValue();
    }

    public final void set(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.optionsMap.put(key, value);
    }

    public final <V> V get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.optionsMap.containsKey(key)) {
            throw new IllegalStateException((key + " was not set in " + this.optionsName).toString());
        }
        return (V)this.optionsMap.get(key);
    }
}

