/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.compat.arguments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.CompilerArgumentsParseException;
import org.jetbrains.kotlin.buildtools.api.KotlinReleaseVersion;
import org.jetbrains.kotlin.buildtools.api.arguments.JvmCompilerArguments;
import org.jetbrains.kotlin.buildtools.api.arguments.enums.JvmTarget;
import org.jetbrains.kotlin.buildtools.internal.compat.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.buildtools.internal.compat.arguments.CommonCompilerArgumentsImpl;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ManualLanguageFeatureSetting;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.compilerRunner.ArgumentsToStrings;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersion;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersionKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0096\u0002\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\f2\u0006\u0010\u0010\u001a\u0002H\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0096\u0002J\"\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J*\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u00142\u0006\u0010\u0010\u001a\u0002H\nH\u0086\u0002\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0012\u001a\u00020\u00132\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0086\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0018J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl;", "Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/CommonCompilerArgumentsImpl;", "Lorg/jetbrains/kotlin/buildtools/api/arguments/JvmCompilerArguments;", "<init>", "()V", "optionsMap", "", "", "", "get", "V", "key", "Lorg/jetbrains/kotlin/buildtools/api/arguments/JvmCompilerArguments$JvmCompilerArgument;", "(Lorg/jetbrains/kotlin/buildtools/api/arguments/JvmCompilerArguments$JvmCompilerArgument;)Ljava/lang/Object;", "set", "", "value", "(Lorg/jetbrains/kotlin/buildtools/api/arguments/JvmCompilerArguments$JvmCompilerArgument;Ljava/lang/Object;)V", "contains", "", "Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl$JvmCompilerArgument;", "(Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl$JvmCompilerArgument;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl$JvmCompilerArgument;Ljava/lang/Object;)V", "toCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "arguments", "applyCompilerArguments", "applyArgumentStrings", "", "toArgumentStrings", "JvmCompilerArgument", "Companion", "kotlin-build-tools-compat"})
@SourceDebugExtension(value={"SMAP\nJvmCompilerArgumentsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCompilerArgumentsImpl.kt\norg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 parseCommandLineArguments.kt\norg/jetbrains/kotlin/cli/common/arguments/ParseCommandLineArgumentsKt\n*L\n1#1,545:1\n1#2:546\n777#3:547\n873#3,2:548\n296#3,2:551\n1586#3:553\n1661#3,3:554\n107#4:550\n107#4:557\n*S KotlinDebug\n*F\n+ 1 JvmCompilerArgumentsImpl.kt\norg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl\n*L\n145#1:547\n145#1:548,2\n306#1:551,2\n312#1:553\n312#1:554,3\n227#1:550\n316#1:557\n*E\n"})
public final class JvmCompilerArgumentsImpl
extends CommonCompilerArgumentsImpl
implements JvmCompilerArguments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> optionsMap = new LinkedHashMap();
    @NotNull
    private static final Set<String> knownArguments = new LinkedHashSet();
    @NotNull
    private static final JvmCompilerArgument<String> X_ABI_STABILITY = new JvmCompilerArgument("X_ABI_STABILITY");
    @NotNull
    private static final JvmCompilerArgument<String[]> X_ADD_MODULES = new JvmCompilerArgument("X_ADD_MODULES");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_ALLOW_NO_SOURCE_FILES = new JvmCompilerArgument("X_ALLOW_NO_SOURCE_FILES");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_ALLOW_UNSTABLE_DEPENDENCIES = new JvmCompilerArgument("X_ALLOW_UNSTABLE_DEPENDENCIES");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_ANNOTATIONS_IN_METADATA = new JvmCompilerArgument("X_ANNOTATIONS_IN_METADATA");
    @NotNull
    private static final JvmCompilerArgument<String> X_ASSERTIONS = new JvmCompilerArgument("X_ASSERTIONS");
    @NotNull
    private static final JvmCompilerArgument<Integer> X_BACKEND_THREADS = new JvmCompilerArgument("X_BACKEND_THREADS");
    @NotNull
    private static final JvmCompilerArgument<String> X_BUILD_FILE = new JvmCompilerArgument("X_BUILD_FILE");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_COMPILE_BUILTINS_AS_PART_OF_STDLIB = new JvmCompilerArgument("X_COMPILE_BUILTINS_AS_PART_OF_STDLIB");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_COMPILE_JAVA = new JvmCompilerArgument("X_COMPILE_JAVA");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_DEBUG = new JvmCompilerArgument("X_DEBUG");
    @NotNull
    private static final JvmCompilerArgument<String> X_DEFAULT_SCRIPT_EXTENSION = new JvmCompilerArgument("X_DEFAULT_SCRIPT_EXTENSION");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_DISABLE_STANDARD_SCRIPT = new JvmCompilerArgument("X_DISABLE_STANDARD_SCRIPT");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_EMIT_JVM_TYPE_ANNOTATIONS = new JvmCompilerArgument("X_EMIT_JVM_TYPE_ANNOTATIONS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL = new JvmCompilerArgument("X_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_ENHANCED_COROUTINES_DEBUGGING = new JvmCompilerArgument("X_ENHANCED_COROUTINES_DEBUGGING");
    @NotNull
    private static final JvmCompilerArgument<String[]> X_FRIEND_PATHS = new JvmCompilerArgument("X_FRIEND_PATHS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_GENERATE_STRICT_METADATA_VERSION = new JvmCompilerArgument("X_GENERATE_STRICT_METADATA_VERSION");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_INDY_ALLOW_ANNOTATED_LAMBDAS = new JvmCompilerArgument("X_INDY_ALLOW_ANNOTATED_LAMBDAS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_IR_DO_NOT_CLEAR_BINDING_CONTEXT = new JvmCompilerArgument("X_IR_DO_NOT_CLEAR_BINDING_CONTEXT");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_IR_INLINER = new JvmCompilerArgument("X_IR_INLINER");
    @NotNull
    private static final JvmCompilerArgument<String> X_JAVA_PACKAGE_PREFIX = new JvmCompilerArgument("X_JAVA_PACKAGE_PREFIX");
    @NotNull
    private static final JvmCompilerArgument<String[]> X_JAVA_SOURCE_ROOTS = new JvmCompilerArgument("X_JAVA_SOURCE_ROOTS");
    @NotNull
    private static final JvmCompilerArgument<String[]> X_JAVAC_ARGUMENTS = new JvmCompilerArgument("X_JAVAC_ARGUMENTS");
    @NotNull
    private static final JvmCompilerArgument<String> X_JDK_RELEASE = new JvmCompilerArgument("X_JDK_RELEASE");
    @NotNull
    private static final JvmCompilerArgument<String> X_JSPECIFY_ANNOTATIONS = new JvmCompilerArgument("X_JSPECIFY_ANNOTATIONS");
    @NotNull
    private static final JvmCompilerArgument<String[]> X_JSR305 = new JvmCompilerArgument("X_JSR305");
    @NotNull
    private static final JvmCompilerArgument<String> X_JVM_DEFAULT = new JvmCompilerArgument("X_JVM_DEFAULT");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_JVM_ENABLE_PREVIEW = new JvmCompilerArgument("X_JVM_ENABLE_PREVIEW");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_JVM_EXPOSE_BOXED = new JvmCompilerArgument("X_JVM_EXPOSE_BOXED");
    @NotNull
    private static final JvmCompilerArgument<String> X_KLIB = new JvmCompilerArgument("X_KLIB");
    @NotNull
    private static final JvmCompilerArgument<String> X_LAMBDAS = new JvmCompilerArgument("X_LAMBDAS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_LINK_VIA_SIGNATURES = new JvmCompilerArgument("X_LINK_VIA_SIGNATURES");
    @NotNull
    private static final JvmCompilerArgument<String> X_MODULE_PATH = new JvmCompilerArgument("X_MODULE_PATH");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_MULTIFILE_PARTS_INHERIT = new JvmCompilerArgument("X_MULTIFILE_PARTS_INHERIT");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_CALL_ASSERTIONS = new JvmCompilerArgument("X_NO_CALL_ASSERTIONS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_NEW_JAVA_ANNOTATION_TARGETS = new JvmCompilerArgument("X_NO_NEW_JAVA_ANNOTATION_TARGETS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_OPTIMIZE = new JvmCompilerArgument("X_NO_OPTIMIZE");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_PARAM_ASSERTIONS = new JvmCompilerArgument("X_NO_PARAM_ASSERTIONS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_RECEIVER_ASSERTIONS = new JvmCompilerArgument("X_NO_RECEIVER_ASSERTIONS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_RESET_JAR_TIMESTAMPS = new JvmCompilerArgument("X_NO_RESET_JAR_TIMESTAMPS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_SOURCE_DEBUG_EXTENSION = new JvmCompilerArgument("X_NO_SOURCE_DEBUG_EXTENSION");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_NO_UNIFIED_NULL_CHECKS = new JvmCompilerArgument("X_NO_UNIFIED_NULL_CHECKS");
    @NotNull
    private static final JvmCompilerArgument<String[]> X_NULLABILITY_ANNOTATIONS = new JvmCompilerArgument("X_NULLABILITY_ANNOTATIONS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_OUTPUT_BUILTINS_METADATA = new JvmCompilerArgument("X_OUTPUT_BUILTINS_METADATA");
    @NotNull
    private static final JvmCompilerArgument<String> X_PROFILE = new JvmCompilerArgument("X_PROFILE");
    @NotNull
    private static final JvmCompilerArgument<String> X_SAM_CONVERSIONS = new JvmCompilerArgument("X_SAM_CONVERSIONS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_SANITIZE_PARENTHESES = new JvmCompilerArgument("X_SANITIZE_PARENTHESES");
    @NotNull
    private static final JvmCompilerArgument<String[]> X_SCRIPT_RESOLVER_ENVIRONMENT = new JvmCompilerArgument("X_SCRIPT_RESOLVER_ENVIRONMENT");
    @NotNull
    private static final JvmCompilerArgument<String> X_SERIALIZE_IR = new JvmCompilerArgument("X_SERIALIZE_IR");
    @NotNull
    private static final JvmCompilerArgument<String> X_STRING_CONCAT = new JvmCompilerArgument("X_STRING_CONCAT");
    @NotNull
    private static final JvmCompilerArgument<String> X_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS = new JvmCompilerArgument("X_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING = new JvmCompilerArgument("X_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_SUPPRESS_MISSING_BUILTINS_ERROR = new JvmCompilerArgument("X_SUPPRESS_MISSING_BUILTINS_ERROR");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE = new JvmCompilerArgument("X_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_USE_14_INLINE_CLASSES_MANGLING_SCHEME = new JvmCompilerArgument("X_USE_14_INLINE_CLASSES_MANGLING_SCHEME");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_USE_FAST_JAR_FILE_SYSTEM = new JvmCompilerArgument("X_USE_FAST_JAR_FILE_SYSTEM");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_USE_INLINE_SCOPES_NUMBERS = new JvmCompilerArgument("X_USE_INLINE_SCOPES_NUMBERS");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_USE_JAVAC = new JvmCompilerArgument("X_USE_JAVAC");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_USE_K2_KAPT = new JvmCompilerArgument("X_USE_K2_KAPT");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_USE_OLD_CLASS_FILES_READING = new JvmCompilerArgument("X_USE_OLD_CLASS_FILES_READING");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_USE_TYPE_TABLE = new JvmCompilerArgument("X_USE_TYPE_TABLE");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_VALIDATE_BYTECODE = new JvmCompilerArgument("X_VALIDATE_BYTECODE");
    @NotNull
    private static final JvmCompilerArgument<Boolean> X_VALUE_CLASSES = new JvmCompilerArgument("X_VALUE_CLASSES");
    @NotNull
    private static final JvmCompilerArgument<String> X_WHEN_EXPRESSIONS = new JvmCompilerArgument("X_WHEN_EXPRESSIONS");
    @NotNull
    private static final JvmCompilerArgument<String> CLASSPATH = new JvmCompilerArgument("CLASSPATH");
    @NotNull
    private static final JvmCompilerArgument<String> D = new JvmCompilerArgument("D");
    @NotNull
    private static final JvmCompilerArgument<String> EXPRESSION = new JvmCompilerArgument("EXPRESSION");
    @NotNull
    private static final JvmCompilerArgument<Boolean> INCLUDE_RUNTIME = new JvmCompilerArgument("INCLUDE_RUNTIME");
    @NotNull
    private static final JvmCompilerArgument<Boolean> JAVA_PARAMETERS = new JvmCompilerArgument("JAVA_PARAMETERS");
    @NotNull
    private static final JvmCompilerArgument<String> JDK_HOME = new JvmCompilerArgument("JDK_HOME");
    @NotNull
    private static final JvmCompilerArgument<String> JVM_DEFAULT = new JvmCompilerArgument("JVM_DEFAULT");
    @NotNull
    private static final JvmCompilerArgument<JvmTarget> JVM_TARGET = new JvmCompilerArgument("JVM_TARGET");
    @NotNull
    private static final JvmCompilerArgument<String> MODULE_NAME = new JvmCompilerArgument("MODULE_NAME");
    @NotNull
    private static final JvmCompilerArgument<Boolean> NO_JDK = new JvmCompilerArgument("NO_JDK");
    @NotNull
    private static final JvmCompilerArgument<Boolean> NO_REFLECT = new JvmCompilerArgument("NO_REFLECT");
    @NotNull
    private static final JvmCompilerArgument<Boolean> NO_STDLIB = new JvmCompilerArgument("NO_STDLIB");
    @NotNull
    private static final JvmCompilerArgument<String[]> SCRIPT_TEMPLATES = new JvmCompilerArgument("SCRIPT_TEMPLATES");

    public JvmCompilerArgumentsImpl() {
        this.applyCompilerArguments(new K2JVMCompilerArguments());
    }

    public <V> V get(@NotNull JvmCompilerArguments.JvmCompilerArgument<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (!this.optionsMap.containsKey(key.getId())) {
            boolean bl = false;
            String string = "Argument " + key.getId() + " is not set and has no default value";
            throw new IllegalStateException(string.toString());
        }
        return (V)this.optionsMap.get(key.getId());
    }

    public <V> void set(@NotNull JvmCompilerArguments.JvmCompilerArgument<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String string = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VERSION");
        KotlinToolingVersion currentKotlinVersion = KotlinToolingVersionKt.KotlinToolingVersion((String)string);
        if (key.getAvailableSinceVersion().compareTo(new KotlinReleaseVersion(currentKotlinVersion.getMajor(), currentKotlinVersion.getMinor(), currentKotlinVersion.getPatch())) > 0) {
            throw new IllegalStateException(key.getId() + " is available only since " + key.getAvailableSinceVersion());
        }
        this.optionsMap.put(key.getId(), value);
    }

    public boolean contains(@NotNull JvmCompilerArguments.JvmCompilerArgument<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.optionsMap.containsKey(key.getId());
    }

    public final <V> V get(@NotNull JvmCompilerArgument<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (V)this.optionsMap.get(key.getId());
    }

    public final <V> void set(@NotNull JvmCompilerArgument<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.optionsMap.put(key.getId(), value);
    }

    public final boolean contains(@NotNull JvmCompilerArgument<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.optionsMap.containsKey(key.getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final K2JVMCompilerArguments toCompilerArguments(@NotNull K2JVMCompilerArguments arguments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        super.toCompilerArguments((CommonCompilerArguments)arguments);
        Iterable $this$filter$iv = this.optionsMap.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!knownArguments.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknownArgs = (List)destination$iv$iv;
        if (!((Collection)unknownArgs).isEmpty()) {
            throw new IllegalStateException("Unknown arguments: " + CollectionsKt.joinToString$default((Iterable)unknownArgs, null, null, null, (int)0, null, null, (int)63, null));
        }
        if (this.contains(X_ABI_STABILITY)) {
            arguments.setAbiStability(this.get(X_ABI_STABILITY));
        }
        if (this.contains(X_ADD_MODULES)) {
            arguments.setAdditionalJavaModules(this.get(X_ADD_MODULES));
        }
        if (this.contains(X_ALLOW_NO_SOURCE_FILES)) {
            arguments.setAllowNoSourceFiles(this.get(X_ALLOW_NO_SOURCE_FILES).booleanValue());
        }
        if (this.contains(X_ALLOW_UNSTABLE_DEPENDENCIES)) {
            arguments.setAllowUnstableDependencies(this.get(X_ALLOW_UNSTABLE_DEPENDENCIES).booleanValue());
        }
        try {
            if (this.contains(X_ANNOTATIONS_IN_METADATA)) {
                arguments.setAnnotationsInMetadata(this.get(X_ANNOTATIONS_IN_METADATA).booleanValue());
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_ANNOTATIONS_IN_METADATA. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.2.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_ASSERTIONS)) {
            arguments.setAssertionsMode(this.get(X_ASSERTIONS));
        }
        if (this.contains(X_BACKEND_THREADS)) {
            arguments.setBackendThreads(String.valueOf(((Number)this.get(X_BACKEND_THREADS)).intValue()));
        }
        if (this.contains(X_BUILD_FILE)) {
            arguments.setBuildFile(this.get(X_BUILD_FILE));
        }
        try {
            if (this.contains(X_COMPILE_BUILTINS_AS_PART_OF_STDLIB)) {
                arguments.setExpectBuiltinsAsPartOfStdlib(this.get(X_COMPILE_BUILTINS_AS_PART_OF_STDLIB).booleanValue());
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_COMPILE_BUILTINS_AS_PART_OF_STDLIB. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.1.20").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_COMPILE_JAVA)) {
            arguments.setCompileJava(this.get(X_COMPILE_JAVA).booleanValue());
        }
        if (this.contains(X_DEBUG)) {
            arguments.setEnableDebugMode(this.get(X_DEBUG).booleanValue());
        }
        if (this.contains(X_DEFAULT_SCRIPT_EXTENSION)) {
            arguments.setDefaultScriptExtension(this.get(X_DEFAULT_SCRIPT_EXTENSION));
        }
        if (this.contains(X_DISABLE_STANDARD_SCRIPT)) {
            arguments.setDisableStandardScript(this.get(X_DISABLE_STANDARD_SCRIPT).booleanValue());
        }
        if (this.contains(X_EMIT_JVM_TYPE_ANNOTATIONS)) {
            arguments.setEmitJvmTypeAnnotations(this.get(X_EMIT_JVM_TYPE_ANNOTATIONS).booleanValue());
        }
        if (this.contains(X_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL)) {
            arguments.setEnhanceTypeParameterTypesToDefNotNull(this.get(X_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL).booleanValue());
        }
        try {
            if (this.contains(X_ENHANCED_COROUTINES_DEBUGGING)) {
                arguments.setEnhancedCoroutinesDebugging(this.get(X_ENHANCED_COROUTINES_DEBUGGING).booleanValue());
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_ENHANCED_COROUTINES_DEBUGGING. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.2.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_FRIEND_PATHS)) {
            arguments.setFriendPaths(this.get(X_FRIEND_PATHS));
        }
        if (this.contains(X_GENERATE_STRICT_METADATA_VERSION)) {
            arguments.setStrictMetadataVersionSemantics(this.get(X_GENERATE_STRICT_METADATA_VERSION).booleanValue());
        }
        try {
            if (this.contains(X_INDY_ALLOW_ANNOTATED_LAMBDAS)) {
                arguments.setIndyAllowAnnotatedLambdas(this.get(X_INDY_ALLOW_ANNOTATED_LAMBDAS));
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_INDY_ALLOW_ANNOTATED_LAMBDAS. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.2.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_IR_DO_NOT_CLEAR_BINDING_CONTEXT)) {
            arguments.setDoNotClearBindingContext(this.get(X_IR_DO_NOT_CLEAR_BINDING_CONTEXT).booleanValue());
        }
        try {
            if (this.contains(X_IR_INLINER)) {
                ArgumentUtilsKt.setUsingReflection((CommonToolArguments)arguments, "enableIrInliner", this.get(X_IR_INLINER));
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_IR_INLINER. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was removed in 2.3.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_JAVA_PACKAGE_PREFIX)) {
            arguments.setJavaPackagePrefix(this.get(X_JAVA_PACKAGE_PREFIX));
        }
        if (this.contains(X_JAVA_SOURCE_ROOTS)) {
            arguments.setJavaSourceRoots(this.get(X_JAVA_SOURCE_ROOTS));
        }
        if (this.contains(X_JAVAC_ARGUMENTS)) {
            arguments.setJavacArguments(this.get(X_JAVAC_ARGUMENTS));
        }
        if (this.contains(X_JDK_RELEASE)) {
            arguments.setJdkRelease(this.get(X_JDK_RELEASE));
        }
        if (this.contains(X_JSPECIFY_ANNOTATIONS)) {
            arguments.setJspecifyAnnotations(this.get(X_JSPECIFY_ANNOTATIONS));
        }
        if (this.contains(X_JSR305)) {
            arguments.setJsr305(this.get(X_JSR305));
        }
        if (this.contains(X_JVM_DEFAULT)) {
            arguments.setJvmDefault(this.get(X_JVM_DEFAULT));
        }
        if (this.contains(X_JVM_ENABLE_PREVIEW)) {
            arguments.setEnableJvmPreview(this.get(X_JVM_ENABLE_PREVIEW).booleanValue());
        }
        try {
            if (this.contains(X_JVM_EXPOSE_BOXED)) {
                arguments.setJvmExposeBoxed(this.get(X_JVM_EXPOSE_BOXED).booleanValue());
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_JVM_EXPOSE_BOXED. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.2.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_KLIB)) {
            arguments.setKlibLibraries(this.get(X_KLIB));
        }
        if (this.contains(X_LAMBDAS)) {
            arguments.setLambdas(this.get(X_LAMBDAS));
        }
        if (this.contains(X_LINK_VIA_SIGNATURES)) {
            arguments.setLinkViaSignatures(this.get(X_LINK_VIA_SIGNATURES).booleanValue());
        }
        if (this.contains(X_MODULE_PATH)) {
            arguments.setJavaModulePath(this.get(X_MODULE_PATH));
        }
        if (this.contains(X_MULTIFILE_PARTS_INHERIT)) {
            arguments.setInheritMultifileParts(this.get(X_MULTIFILE_PARTS_INHERIT).booleanValue());
        }
        if (this.contains(X_NO_CALL_ASSERTIONS)) {
            arguments.setNoCallAssertions(this.get(X_NO_CALL_ASSERTIONS).booleanValue());
        }
        if (this.contains(X_NO_NEW_JAVA_ANNOTATION_TARGETS)) {
            arguments.setNoNewJavaAnnotationTargets(this.get(X_NO_NEW_JAVA_ANNOTATION_TARGETS).booleanValue());
        }
        if (this.contains(X_NO_OPTIMIZE)) {
            arguments.setNoOptimize(this.get(X_NO_OPTIMIZE).booleanValue());
        }
        if (this.contains(X_NO_PARAM_ASSERTIONS)) {
            arguments.setNoParamAssertions(this.get(X_NO_PARAM_ASSERTIONS).booleanValue());
        }
        if (this.contains(X_NO_RECEIVER_ASSERTIONS)) {
            arguments.setNoReceiverAssertions(this.get(X_NO_RECEIVER_ASSERTIONS).booleanValue());
        }
        if (this.contains(X_NO_RESET_JAR_TIMESTAMPS)) {
            arguments.setNoResetJarTimestamps(this.get(X_NO_RESET_JAR_TIMESTAMPS).booleanValue());
        }
        if (this.contains(X_NO_SOURCE_DEBUG_EXTENSION)) {
            arguments.setNoSourceDebugExtension(this.get(X_NO_SOURCE_DEBUG_EXTENSION).booleanValue());
        }
        if (this.contains(X_NO_UNIFIED_NULL_CHECKS)) {
            arguments.setNoUnifiedNullChecks(this.get(X_NO_UNIFIED_NULL_CHECKS).booleanValue());
        }
        if (this.contains(X_NULLABILITY_ANNOTATIONS)) {
            arguments.setNullabilityAnnotations(this.get(X_NULLABILITY_ANNOTATIONS));
        }
        try {
            if (this.contains(X_OUTPUT_BUILTINS_METADATA)) {
                arguments.setOutputBuiltinsMetadata(this.get(X_OUTPUT_BUILTINS_METADATA).booleanValue());
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_OUTPUT_BUILTINS_METADATA. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.1.20").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_PROFILE)) {
            arguments.setProfileCompilerCommand(this.get(X_PROFILE));
        }
        if (this.contains(X_SAM_CONVERSIONS)) {
            arguments.setSamConversions(this.get(X_SAM_CONVERSIONS));
        }
        if (this.contains(X_SANITIZE_PARENTHESES)) {
            arguments.setSanitizeParentheses(this.get(X_SANITIZE_PARENTHESES).booleanValue());
        }
        if (this.contains(X_SCRIPT_RESOLVER_ENVIRONMENT)) {
            arguments.setScriptResolverEnvironment(this.get(X_SCRIPT_RESOLVER_ENVIRONMENT));
        }
        if (this.contains(X_SERIALIZE_IR)) {
            arguments.setSerializeIr(this.get(X_SERIALIZE_IR));
        }
        if (this.contains(X_STRING_CONCAT)) {
            arguments.setStringConcat(this.get(X_STRING_CONCAT));
        }
        if (this.contains(X_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS)) {
            arguments.setSupportCompatqualCheckerFrameworkAnnotations(this.get(X_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS));
        }
        if (this.contains(X_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING)) {
            arguments.setSuppressDeprecatedJvmTargetWarning(this.get(X_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING).booleanValue());
        }
        if (this.contains(X_SUPPRESS_MISSING_BUILTINS_ERROR)) {
            arguments.setSuppressMissingBuiltinsError(this.get(X_SUPPRESS_MISSING_BUILTINS_ERROR).booleanValue());
        }
        if (this.contains(X_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE)) {
            arguments.setTypeEnhancementImprovementsInStrictMode(this.get(X_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE).booleanValue());
        }
        if (this.contains(X_USE_14_INLINE_CLASSES_MANGLING_SCHEME)) {
            arguments.setUseOldInlineClassesManglingScheme(this.get(X_USE_14_INLINE_CLASSES_MANGLING_SCHEME).booleanValue());
        }
        if (this.contains(X_USE_FAST_JAR_FILE_SYSTEM)) {
            arguments.setUseFastJarFileSystem(this.get(X_USE_FAST_JAR_FILE_SYSTEM));
        }
        try {
            if (this.contains(X_USE_INLINE_SCOPES_NUMBERS)) {
                arguments.setUseInlineScopesNumbers(this.get(X_USE_INLINE_SCOPES_NUMBERS).booleanValue());
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_USE_INLINE_SCOPES_NUMBERS. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.0.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_USE_JAVAC)) {
            arguments.setUseJavac(this.get(X_USE_JAVAC).booleanValue());
        }
        try {
            if (this.contains(X_USE_K2_KAPT)) {
                ArgumentUtilsKt.setUsingReflection((CommonToolArguments)arguments, "useK2Kapt", this.get(X_USE_K2_KAPT));
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_USE_K2_KAPT. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.1.0 and removed in 2.3.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(X_USE_OLD_CLASS_FILES_READING)) {
            arguments.setUseOldClassFilesReading(this.get(X_USE_OLD_CLASS_FILES_READING).booleanValue());
        }
        if (this.contains(X_USE_TYPE_TABLE)) {
            arguments.setUseTypeTable(this.get(X_USE_TYPE_TABLE).booleanValue());
        }
        if (this.contains(X_VALIDATE_BYTECODE)) {
            arguments.setValidateBytecode(this.get(X_VALIDATE_BYTECODE).booleanValue());
        }
        if (this.contains(X_VALUE_CLASSES)) {
            arguments.setValueClasses(this.get(X_VALUE_CLASSES).booleanValue());
        }
        try {
            if (this.contains(X_WHEN_EXPRESSIONS)) {
                arguments.setWhenExpressionsGeneration(this.get(X_WHEN_EXPRESSIONS));
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: X_WHEN_EXPRESSIONS. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.2.20").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(CLASSPATH)) {
            arguments.setClasspath(this.get(CLASSPATH));
        }
        if (this.contains(D)) {
            arguments.setDestination(this.get(D));
        }
        if (this.contains(EXPRESSION)) {
            arguments.setExpression(this.get(EXPRESSION));
        }
        if (this.contains(INCLUDE_RUNTIME)) {
            arguments.setIncludeRuntime(this.get(INCLUDE_RUNTIME).booleanValue());
        }
        if (this.contains(JAVA_PARAMETERS)) {
            arguments.setJavaParameters(this.get(JAVA_PARAMETERS).booleanValue());
        }
        if (this.contains(JDK_HOME)) {
            arguments.setJdkHome(this.get(JDK_HOME));
        }
        try {
            if (this.contains(JVM_DEFAULT)) {
                arguments.setJvmDefaultStable(this.get(JVM_DEFAULT));
            }
        }
        catch (NoSuchMethodError e) {
            Throwable throwable = new IllegalStateException("Compiler parameter not recognized: JVM_DEFAULT. Current compiler version is: " + KotlinCompilerVersion.VERSION + ", but the argument was introduced in 2.2.0").initCause(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
            throw throwable;
        }
        if (this.contains(JVM_TARGET)) {
            JvmTarget jvmTarget = this.get(JVM_TARGET);
            arguments.setJvmTarget(jvmTarget != null ? jvmTarget.getStringValue() : null);
        }
        if (this.contains(MODULE_NAME)) {
            arguments.setModuleName(this.get(MODULE_NAME));
        }
        if (this.contains(NO_JDK)) {
            arguments.setNoJdk(this.get(NO_JDK).booleanValue());
        }
        if (this.contains(NO_REFLECT)) {
            arguments.setNoReflect(this.get(NO_REFLECT).booleanValue());
        }
        if (this.contains(NO_STDLIB)) {
            arguments.setNoStdlib(this.get(NO_STDLIB).booleanValue());
        }
        if (this.contains(SCRIPT_TEMPLATES)) {
            arguments.setScriptTemplates(this.get(SCRIPT_TEMPLATES));
        }
        List args$iv = CollectionsKt.toList((Iterable)this.getInternalArguments());
        boolean $i$f$parseCommandLineArguments = false;
        arguments.setInternalArguments(((K2JVMCompilerArguments)ParseCommandLineArgumentsKt.parseCommandLineArguments((KClass)Reflection.getOrCreateKotlinClass(K2JVMCompilerArguments.class), (List)args$iv)).getInternalArguments());
        return arguments;
    }

    public static /* synthetic */ K2JVMCompilerArguments toCompilerArguments$default(JvmCompilerArgumentsImpl jvmCompilerArgumentsImpl, K2JVMCompilerArguments k2JVMCompilerArguments, int n, Object object) {
        if ((n & 1) != 0) {
            k2JVMCompilerArguments = new K2JVMCompilerArguments();
        }
        return jvmCompilerArgumentsImpl.toCompilerArguments(k2JVMCompilerArguments);
    }

    /*
     * WARNING - void declaration
     */
    public final void applyCompilerArguments(@NotNull K2JVMCompilerArguments arguments) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Integer n;
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        super.applyCompilerArguments((CommonCompilerArguments)arguments);
        try {
            this.set(X_ABI_STABILITY, arguments.getAbiStability());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_ADD_MODULES, arguments.getAdditionalJavaModules());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_ALLOW_NO_SOURCE_FILES, Boolean.valueOf(arguments.getAllowNoSourceFiles()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_ALLOW_UNSTABLE_DEPENDENCIES, Boolean.valueOf(arguments.getAllowUnstableDependencies()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_ANNOTATIONS_IN_METADATA, Boolean.valueOf(arguments.getAnnotationsInMetadata()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_ASSERTIONS, arguments.getAssertionsMode());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            void it;
            object3 = arguments.getBackendThreads();
            String string = object3;
            object2 = X_BACKEND_THREADS;
            object = this;
            boolean bl = false;
            n = Integer.parseInt((String)it);
            ((JvmCompilerArgumentsImpl)object).set((JvmCompilerArgument)object2, (Object)n);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_BUILD_FILE, arguments.getBuildFile());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_COMPILE_BUILTINS_AS_PART_OF_STDLIB, Boolean.valueOf(arguments.getExpectBuiltinsAsPartOfStdlib()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_COMPILE_JAVA, Boolean.valueOf(arguments.getCompileJava()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_DEBUG, Boolean.valueOf(arguments.getEnableDebugMode()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_DEFAULT_SCRIPT_EXTENSION, arguments.getDefaultScriptExtension());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_DISABLE_STANDARD_SCRIPT, Boolean.valueOf(arguments.getDisableStandardScript()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_EMIT_JVM_TYPE_ANNOTATIONS, Boolean.valueOf(arguments.getEmitJvmTypeAnnotations()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL, Boolean.valueOf(arguments.getEnhanceTypeParameterTypesToDefNotNull()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_ENHANCED_COROUTINES_DEBUGGING, Boolean.valueOf(arguments.getEnhancedCoroutinesDebugging()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_FRIEND_PATHS, arguments.getFriendPaths());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_GENERATE_STRICT_METADATA_VERSION, Boolean.valueOf(arguments.getStrictMetadataVersionSemantics()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_INDY_ALLOW_ANNOTATED_LAMBDAS, arguments.getIndyAllowAnnotatedLambdas());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_IR_DO_NOT_CLEAR_BINDING_CONTEXT, Boolean.valueOf(arguments.getDoNotClearBindingContext()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_IR_INLINER, ArgumentUtilsKt.getUsingReflection((CommonToolArguments)arguments, "enableIrInliner"));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JAVA_PACKAGE_PREFIX, arguments.getJavaPackagePrefix());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JAVA_SOURCE_ROOTS, arguments.getJavaSourceRoots());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JAVAC_ARGUMENTS, arguments.getJavacArguments());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JDK_RELEASE, arguments.getJdkRelease());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JSPECIFY_ANNOTATIONS, arguments.getJspecifyAnnotations());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JSR305, arguments.getJsr305());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JVM_DEFAULT, arguments.getJvmDefault());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JVM_ENABLE_PREVIEW, Boolean.valueOf(arguments.getEnableJvmPreview()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_JVM_EXPOSE_BOXED, Boolean.valueOf(arguments.getJvmExposeBoxed()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_KLIB, arguments.getKlibLibraries());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_LAMBDAS, arguments.getLambdas());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_LINK_VIA_SIGNATURES, Boolean.valueOf(arguments.getLinkViaSignatures()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_MODULE_PATH, arguments.getJavaModulePath());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_MULTIFILE_PARTS_INHERIT, Boolean.valueOf(arguments.getInheritMultifileParts()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_CALL_ASSERTIONS, Boolean.valueOf(arguments.getNoCallAssertions()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_NEW_JAVA_ANNOTATION_TARGETS, Boolean.valueOf(arguments.getNoNewJavaAnnotationTargets()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_OPTIMIZE, Boolean.valueOf(arguments.getNoOptimize()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_PARAM_ASSERTIONS, Boolean.valueOf(arguments.getNoParamAssertions()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_RECEIVER_ASSERTIONS, Boolean.valueOf(arguments.getNoReceiverAssertions()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_RESET_JAR_TIMESTAMPS, Boolean.valueOf(arguments.getNoResetJarTimestamps()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_SOURCE_DEBUG_EXTENSION, Boolean.valueOf(arguments.getNoSourceDebugExtension()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NO_UNIFIED_NULL_CHECKS, Boolean.valueOf(arguments.getNoUnifiedNullChecks()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_NULLABILITY_ANNOTATIONS, arguments.getNullabilityAnnotations());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_OUTPUT_BUILTINS_METADATA, Boolean.valueOf(arguments.getOutputBuiltinsMetadata()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_PROFILE, arguments.getProfileCompilerCommand());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_SAM_CONVERSIONS, arguments.getSamConversions());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_SANITIZE_PARENTHESES, Boolean.valueOf(arguments.getSanitizeParentheses()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_SCRIPT_RESOLVER_ENVIRONMENT, arguments.getScriptResolverEnvironment());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_SERIALIZE_IR, arguments.getSerializeIr());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_STRING_CONCAT, arguments.getStringConcat());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS, arguments.getSupportCompatqualCheckerFrameworkAnnotations());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING, Boolean.valueOf(arguments.getSuppressDeprecatedJvmTargetWarning()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_SUPPRESS_MISSING_BUILTINS_ERROR, Boolean.valueOf(arguments.getSuppressMissingBuiltinsError()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE, Boolean.valueOf(arguments.getTypeEnhancementImprovementsInStrictMode()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_USE_14_INLINE_CLASSES_MANGLING_SCHEME, Boolean.valueOf(arguments.getUseOldInlineClassesManglingScheme()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_USE_FAST_JAR_FILE_SYSTEM, arguments.getUseFastJarFileSystem());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_USE_INLINE_SCOPES_NUMBERS, Boolean.valueOf(arguments.getUseInlineScopesNumbers()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_USE_JAVAC, Boolean.valueOf(arguments.getUseJavac()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_USE_K2_KAPT, ArgumentUtilsKt.getUsingReflection((CommonToolArguments)arguments, "useK2Kapt"));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_USE_OLD_CLASS_FILES_READING, Boolean.valueOf(arguments.getUseOldClassFilesReading()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_USE_TYPE_TABLE, Boolean.valueOf(arguments.getUseTypeTable()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_VALIDATE_BYTECODE, Boolean.valueOf(arguments.getValidateBytecode()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_VALUE_CLASSES, Boolean.valueOf(arguments.getValueClasses()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X_WHEN_EXPRESSIONS, arguments.getWhenExpressionsGeneration());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(CLASSPATH, arguments.getClasspath());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(D, arguments.getDestination());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(EXPRESSION, arguments.getExpression());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(INCLUDE_RUNTIME, Boolean.valueOf(arguments.getIncludeRuntime()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(JAVA_PARAMETERS, Boolean.valueOf(arguments.getJavaParameters()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(JDK_HOME, arguments.getJdkHome());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(JVM_DEFAULT, arguments.getJvmDefaultStable());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            Integer n2;
            Object object4 = this;
            JvmCompilerArgument<Object> jvmCompilerArgument = JVM_TARGET;
            object3 = arguments.getJvmTarget();
            String string = object3;
            if (string != null) {
                Object v3;
                void it;
                block161: {
                    String bl = string;
                    object2 = jvmCompilerArgument;
                    object = object4;
                    boolean bl2 = false;
                    Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$0;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        JvmTarget entry = (JvmTarget)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)entry.getStringValue(), (Object)it)) continue;
                        v3 = element$iv;
                        break block161;
                    }
                    v3 = null;
                }
                JvmTarget jvmTarget = v3;
                if (jvmTarget == null) {
                    throw new CompilerArgumentsParseException("Unknown -jvm-target value: " + (String)it);
                }
                n = jvmTarget;
                object4 = object;
                jvmCompilerArgument = object2;
                n2 = n;
            } else {
                n2 = null;
            }
            ((JvmCompilerArgumentsImpl)object4).set(jvmCompilerArgument, n2);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(MODULE_NAME, arguments.getModuleName());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(NO_JDK, Boolean.valueOf(arguments.getNoJdk()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(NO_REFLECT, Boolean.valueOf(arguments.getNoReflect()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(NO_STDLIB, Boolean.valueOf(arguments.getNoStdlib()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(SCRIPT_TEMPLATES, arguments.getScriptTemplates());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        object3 = arguments.getInternalArguments();
        object = this.getInternalArguments();
        boolean $i$f$map = false;
        void it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Object element$iv;
            element$iv = (ManualLanguageFeatureSetting)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(it2.getStringRepresentation());
        }
        object.addAll((List)destination$iv$iv);
    }

    public void applyArgumentStrings(@NotNull List<String> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        List<String> args$iv = arguments;
        boolean $i$f$parseCommandLineArguments = false;
        K2JVMCompilerArguments compilerArgs = (K2JVMCompilerArguments)ParseCommandLineArgumentsKt.parseCommandLineArguments((KClass)Reflection.getOrCreateKotlinClass(K2JVMCompilerArguments.class), args$iv);
        String string = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)compilerArgs.getErrors());
        if (string != null) {
            String it = string;
            boolean bl = false;
            throw new CompilerArgumentsParseException(it);
        }
        this.applyCompilerArguments(compilerArgs);
    }

    @NotNull
    public List<String> toArgumentStrings() {
        List arguments = ArgumentsToStrings.toArgumentStrings$default((CommonToolArguments)((CommonToolArguments)JvmCompilerArgumentsImpl.toCompilerArguments$default(this, null, 1, null)), (boolean)false, (boolean)false, (int)3, null);
        return arguments;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0003\b\u0084\u0001\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0019\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\nR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\nR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\nR\u0019\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\nR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\nR\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\nR\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\nR\u001f\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\nR\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\nR\u0019\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\nR\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\nR\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\nR\u0019\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\nR\u001f\u00108\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\nR\u001f\u0010:\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\nR\u0019\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\nR\u0019\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\nR\u001f\u0010@\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\nR\u0019\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\nR\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\nR\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\nR\u0019\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\nR\u0019\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\nR\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\nR\u0019\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\nR\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\nR\u0017\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\nR\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\nR\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\nR\u0017\u0010X\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\nR\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\nR\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\nR\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\nR\u0017\u0010`\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\nR\u001f\u0010b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\nR\u0017\u0010d\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\nR\u0019\u0010f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\nR\u0019\u0010h\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\nR\u0017\u0010j\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\nR\u001f\u0010l\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010\nR\u0017\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010\nR\u0019\u0010p\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010\nR\u0019\u0010r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010\nR\u0017\u0010t\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\nR\u0017\u0010v\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010\nR\u0017\u0010x\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010\nR\u0017\u0010z\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010\nR\u0019\u0010|\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010\nR\u0017\u0010~\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010\nR\u0019\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010\nR\u001b\u0010\u0082\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0001\u0010\nR\u0019\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0085\u0001\u0010\nR\u0019\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0001\u0010\nR\u0019\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0089\u0001\u0010\nR\u0019\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008b\u0001\u0010\nR\u001b\u0010\u008c\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008d\u0001\u0010\nR\u001b\u0010\u008e\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0001\u0010\nR\u001b\u0010\u0090\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0091\u0001\u0010\nR\u001b\u0010\u0092\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0093\u0001\u0010\nR\u0019\u0010\u0094\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0095\u0001\u0010\nR\u0019\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0097\u0001\u0010\nR\u001b\u0010\u0098\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0099\u0001\u0010\nR\u001b\u0010\u009a\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009b\u0001\u0010\nR\u001c\u0010\u009c\u0001\u001a\u000b\u0012\u0007\u0012\u0005\u0018\u00010\u009d\u00010\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009e\u0001\u0010\nR\u001b\u0010\u009f\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a0\u0001\u0010\nR\u0019\u0010\u00a1\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a2\u0001\u0010\nR\u0019\u0010\u00a3\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a4\u0001\u0010\nR\u0019\u0010\u00a5\u0001\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a6\u0001\u0010\nR!\u0010\u00a7\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f0\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a8\u0001\u0010\n\u00a8\u0006\u00a9\u0001"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl$Companion;", "", "<init>", "()V", "knownArguments", "", "", "X_ABI_STABILITY", "Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl$JvmCompilerArgument;", "getX_ABI_STABILITY", "()Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl$JvmCompilerArgument;", "X_ADD_MODULES", "", "getX_ADD_MODULES", "X_ALLOW_NO_SOURCE_FILES", "", "getX_ALLOW_NO_SOURCE_FILES", "X_ALLOW_UNSTABLE_DEPENDENCIES", "getX_ALLOW_UNSTABLE_DEPENDENCIES", "X_ANNOTATIONS_IN_METADATA", "getX_ANNOTATIONS_IN_METADATA", "X_ASSERTIONS", "getX_ASSERTIONS", "X_BACKEND_THREADS", "", "getX_BACKEND_THREADS", "X_BUILD_FILE", "getX_BUILD_FILE", "X_COMPILE_BUILTINS_AS_PART_OF_STDLIB", "getX_COMPILE_BUILTINS_AS_PART_OF_STDLIB", "X_COMPILE_JAVA", "getX_COMPILE_JAVA", "X_DEBUG", "getX_DEBUG", "X_DEFAULT_SCRIPT_EXTENSION", "getX_DEFAULT_SCRIPT_EXTENSION", "X_DISABLE_STANDARD_SCRIPT", "getX_DISABLE_STANDARD_SCRIPT", "X_EMIT_JVM_TYPE_ANNOTATIONS", "getX_EMIT_JVM_TYPE_ANNOTATIONS", "X_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL", "getX_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL", "X_ENHANCED_COROUTINES_DEBUGGING", "getX_ENHANCED_COROUTINES_DEBUGGING", "X_FRIEND_PATHS", "getX_FRIEND_PATHS", "X_GENERATE_STRICT_METADATA_VERSION", "getX_GENERATE_STRICT_METADATA_VERSION", "X_INDY_ALLOW_ANNOTATED_LAMBDAS", "getX_INDY_ALLOW_ANNOTATED_LAMBDAS", "X_IR_DO_NOT_CLEAR_BINDING_CONTEXT", "getX_IR_DO_NOT_CLEAR_BINDING_CONTEXT", "X_IR_INLINER", "getX_IR_INLINER", "X_JAVA_PACKAGE_PREFIX", "getX_JAVA_PACKAGE_PREFIX", "X_JAVA_SOURCE_ROOTS", "getX_JAVA_SOURCE_ROOTS", "X_JAVAC_ARGUMENTS", "getX_JAVAC_ARGUMENTS", "X_JDK_RELEASE", "getX_JDK_RELEASE", "X_JSPECIFY_ANNOTATIONS", "getX_JSPECIFY_ANNOTATIONS", "X_JSR305", "getX_JSR305", "X_JVM_DEFAULT", "getX_JVM_DEFAULT", "X_JVM_ENABLE_PREVIEW", "getX_JVM_ENABLE_PREVIEW", "X_JVM_EXPOSE_BOXED", "getX_JVM_EXPOSE_BOXED", "X_KLIB", "getX_KLIB", "X_LAMBDAS", "getX_LAMBDAS", "X_LINK_VIA_SIGNATURES", "getX_LINK_VIA_SIGNATURES", "X_MODULE_PATH", "getX_MODULE_PATH", "X_MULTIFILE_PARTS_INHERIT", "getX_MULTIFILE_PARTS_INHERIT", "X_NO_CALL_ASSERTIONS", "getX_NO_CALL_ASSERTIONS", "X_NO_NEW_JAVA_ANNOTATION_TARGETS", "getX_NO_NEW_JAVA_ANNOTATION_TARGETS", "X_NO_OPTIMIZE", "getX_NO_OPTIMIZE", "X_NO_PARAM_ASSERTIONS", "getX_NO_PARAM_ASSERTIONS", "X_NO_RECEIVER_ASSERTIONS", "getX_NO_RECEIVER_ASSERTIONS", "X_NO_RESET_JAR_TIMESTAMPS", "getX_NO_RESET_JAR_TIMESTAMPS", "X_NO_SOURCE_DEBUG_EXTENSION", "getX_NO_SOURCE_DEBUG_EXTENSION", "X_NO_UNIFIED_NULL_CHECKS", "getX_NO_UNIFIED_NULL_CHECKS", "X_NULLABILITY_ANNOTATIONS", "getX_NULLABILITY_ANNOTATIONS", "X_OUTPUT_BUILTINS_METADATA", "getX_OUTPUT_BUILTINS_METADATA", "X_PROFILE", "getX_PROFILE", "X_SAM_CONVERSIONS", "getX_SAM_CONVERSIONS", "X_SANITIZE_PARENTHESES", "getX_SANITIZE_PARENTHESES", "X_SCRIPT_RESOLVER_ENVIRONMENT", "getX_SCRIPT_RESOLVER_ENVIRONMENT", "X_SERIALIZE_IR", "getX_SERIALIZE_IR", "X_STRING_CONCAT", "getX_STRING_CONCAT", "X_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS", "getX_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS", "X_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING", "getX_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING", "X_SUPPRESS_MISSING_BUILTINS_ERROR", "getX_SUPPRESS_MISSING_BUILTINS_ERROR", "X_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE", "getX_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE", "X_USE_14_INLINE_CLASSES_MANGLING_SCHEME", "getX_USE_14_INLINE_CLASSES_MANGLING_SCHEME", "X_USE_FAST_JAR_FILE_SYSTEM", "getX_USE_FAST_JAR_FILE_SYSTEM", "X_USE_INLINE_SCOPES_NUMBERS", "getX_USE_INLINE_SCOPES_NUMBERS", "X_USE_JAVAC", "getX_USE_JAVAC", "X_USE_K2_KAPT", "getX_USE_K2_KAPT", "X_USE_OLD_CLASS_FILES_READING", "getX_USE_OLD_CLASS_FILES_READING", "X_USE_TYPE_TABLE", "getX_USE_TYPE_TABLE", "X_VALIDATE_BYTECODE", "getX_VALIDATE_BYTECODE", "X_VALUE_CLASSES", "getX_VALUE_CLASSES", "X_WHEN_EXPRESSIONS", "getX_WHEN_EXPRESSIONS", "CLASSPATH", "getCLASSPATH", "D", "getD", "EXPRESSION", "getEXPRESSION", "INCLUDE_RUNTIME", "getINCLUDE_RUNTIME", "JAVA_PARAMETERS", "getJAVA_PARAMETERS", "JDK_HOME", "getJDK_HOME", "JVM_DEFAULT", "getJVM_DEFAULT", "JVM_TARGET", "Lorg/jetbrains/kotlin/buildtools/api/arguments/enums/JvmTarget;", "getJVM_TARGET", "MODULE_NAME", "getMODULE_NAME", "NO_JDK", "getNO_JDK", "NO_REFLECT", "getNO_REFLECT", "NO_STDLIB", "getNO_STDLIB", "SCRIPT_TEMPLATES", "getSCRIPT_TEMPLATES", "kotlin-build-tools-compat"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_ABI_STABILITY() {
            return X_ABI_STABILITY;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getX_ADD_MODULES() {
            return X_ADD_MODULES;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_ALLOW_NO_SOURCE_FILES() {
            return X_ALLOW_NO_SOURCE_FILES;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_ALLOW_UNSTABLE_DEPENDENCIES() {
            return X_ALLOW_UNSTABLE_DEPENDENCIES;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_ANNOTATIONS_IN_METADATA() {
            return X_ANNOTATIONS_IN_METADATA;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_ASSERTIONS() {
            return X_ASSERTIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Integer> getX_BACKEND_THREADS() {
            return X_BACKEND_THREADS;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_BUILD_FILE() {
            return X_BUILD_FILE;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_COMPILE_BUILTINS_AS_PART_OF_STDLIB() {
            return X_COMPILE_BUILTINS_AS_PART_OF_STDLIB;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_COMPILE_JAVA() {
            return X_COMPILE_JAVA;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_DEBUG() {
            return X_DEBUG;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_DEFAULT_SCRIPT_EXTENSION() {
            return X_DEFAULT_SCRIPT_EXTENSION;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_DISABLE_STANDARD_SCRIPT() {
            return X_DISABLE_STANDARD_SCRIPT;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_EMIT_JVM_TYPE_ANNOTATIONS() {
            return X_EMIT_JVM_TYPE_ANNOTATIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL() {
            return X_ENHANCE_TYPE_PARAMETER_TYPES_TO_DEF_NOT_NULL;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_ENHANCED_COROUTINES_DEBUGGING() {
            return X_ENHANCED_COROUTINES_DEBUGGING;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getX_FRIEND_PATHS() {
            return X_FRIEND_PATHS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_GENERATE_STRICT_METADATA_VERSION() {
            return X_GENERATE_STRICT_METADATA_VERSION;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_INDY_ALLOW_ANNOTATED_LAMBDAS() {
            return X_INDY_ALLOW_ANNOTATED_LAMBDAS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_IR_DO_NOT_CLEAR_BINDING_CONTEXT() {
            return X_IR_DO_NOT_CLEAR_BINDING_CONTEXT;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_IR_INLINER() {
            return X_IR_INLINER;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_JAVA_PACKAGE_PREFIX() {
            return X_JAVA_PACKAGE_PREFIX;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getX_JAVA_SOURCE_ROOTS() {
            return X_JAVA_SOURCE_ROOTS;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getX_JAVAC_ARGUMENTS() {
            return X_JAVAC_ARGUMENTS;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_JDK_RELEASE() {
            return X_JDK_RELEASE;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_JSPECIFY_ANNOTATIONS() {
            return X_JSPECIFY_ANNOTATIONS;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getX_JSR305() {
            return X_JSR305;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_JVM_DEFAULT() {
            return X_JVM_DEFAULT;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_JVM_ENABLE_PREVIEW() {
            return X_JVM_ENABLE_PREVIEW;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_JVM_EXPOSE_BOXED() {
            return X_JVM_EXPOSE_BOXED;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_KLIB() {
            return X_KLIB;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_LAMBDAS() {
            return X_LAMBDAS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_LINK_VIA_SIGNATURES() {
            return X_LINK_VIA_SIGNATURES;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_MODULE_PATH() {
            return X_MODULE_PATH;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_MULTIFILE_PARTS_INHERIT() {
            return X_MULTIFILE_PARTS_INHERIT;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_CALL_ASSERTIONS() {
            return X_NO_CALL_ASSERTIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_NEW_JAVA_ANNOTATION_TARGETS() {
            return X_NO_NEW_JAVA_ANNOTATION_TARGETS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_OPTIMIZE() {
            return X_NO_OPTIMIZE;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_PARAM_ASSERTIONS() {
            return X_NO_PARAM_ASSERTIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_RECEIVER_ASSERTIONS() {
            return X_NO_RECEIVER_ASSERTIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_RESET_JAR_TIMESTAMPS() {
            return X_NO_RESET_JAR_TIMESTAMPS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_SOURCE_DEBUG_EXTENSION() {
            return X_NO_SOURCE_DEBUG_EXTENSION;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_NO_UNIFIED_NULL_CHECKS() {
            return X_NO_UNIFIED_NULL_CHECKS;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getX_NULLABILITY_ANNOTATIONS() {
            return X_NULLABILITY_ANNOTATIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_OUTPUT_BUILTINS_METADATA() {
            return X_OUTPUT_BUILTINS_METADATA;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_PROFILE() {
            return X_PROFILE;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_SAM_CONVERSIONS() {
            return X_SAM_CONVERSIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_SANITIZE_PARENTHESES() {
            return X_SANITIZE_PARENTHESES;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getX_SCRIPT_RESOLVER_ENVIRONMENT() {
            return X_SCRIPT_RESOLVER_ENVIRONMENT;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_SERIALIZE_IR() {
            return X_SERIALIZE_IR;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_STRING_CONCAT() {
            return X_STRING_CONCAT;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS() {
            return X_SUPPORT_COMPATQUAL_CHECKER_FRAMEWORK_ANNOTATIONS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING() {
            return X_SUPPRESS_DEPRECATED_JVM_TARGET_WARNING;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_SUPPRESS_MISSING_BUILTINS_ERROR() {
            return X_SUPPRESS_MISSING_BUILTINS_ERROR;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE() {
            return X_TYPE_ENHANCEMENT_IMPROVEMENTS_STRICT_MODE;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_USE_14_INLINE_CLASSES_MANGLING_SCHEME() {
            return X_USE_14_INLINE_CLASSES_MANGLING_SCHEME;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_USE_FAST_JAR_FILE_SYSTEM() {
            return X_USE_FAST_JAR_FILE_SYSTEM;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_USE_INLINE_SCOPES_NUMBERS() {
            return X_USE_INLINE_SCOPES_NUMBERS;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_USE_JAVAC() {
            return X_USE_JAVAC;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_USE_K2_KAPT() {
            return X_USE_K2_KAPT;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_USE_OLD_CLASS_FILES_READING() {
            return X_USE_OLD_CLASS_FILES_READING;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_USE_TYPE_TABLE() {
            return X_USE_TYPE_TABLE;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_VALIDATE_BYTECODE() {
            return X_VALIDATE_BYTECODE;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getX_VALUE_CLASSES() {
            return X_VALUE_CLASSES;
        }

        @NotNull
        public final JvmCompilerArgument<String> getX_WHEN_EXPRESSIONS() {
            return X_WHEN_EXPRESSIONS;
        }

        @NotNull
        public final JvmCompilerArgument<String> getCLASSPATH() {
            return CLASSPATH;
        }

        @NotNull
        public final JvmCompilerArgument<String> getD() {
            return D;
        }

        @NotNull
        public final JvmCompilerArgument<String> getEXPRESSION() {
            return EXPRESSION;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getINCLUDE_RUNTIME() {
            return INCLUDE_RUNTIME;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getJAVA_PARAMETERS() {
            return JAVA_PARAMETERS;
        }

        @NotNull
        public final JvmCompilerArgument<String> getJDK_HOME() {
            return JDK_HOME;
        }

        @NotNull
        public final JvmCompilerArgument<String> getJVM_DEFAULT() {
            return JVM_DEFAULT;
        }

        @NotNull
        public final JvmCompilerArgument<JvmTarget> getJVM_TARGET() {
            return JVM_TARGET;
        }

        @NotNull
        public final JvmCompilerArgument<String> getMODULE_NAME() {
            return MODULE_NAME;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getNO_JDK() {
            return NO_JDK;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getNO_REFLECT() {
            return NO_REFLECT;
        }

        @NotNull
        public final JvmCompilerArgument<Boolean> getNO_STDLIB() {
            return NO_STDLIB;
        }

        @NotNull
        public final JvmCompilerArgument<String[]> getSCRIPT_TEMPLATES() {
            return SCRIPT_TEMPLATES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<JvmTarget> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])JvmTarget.values()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/arguments/JvmCompilerArgumentsImpl$JvmCompilerArgument;", "V", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "kotlin-build-tools-compat"})
    public static final class JvmCompilerArgument<V> {
        @NotNull
        private final String id;

        public JvmCompilerArgument(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            knownArguments.add(this.id);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }
    }
}

