/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.internal.serialization.SerializationException;
import org.jetbrains.kotlin.buildtools.internal.serialization.descriptors.PolymorphicKind;
import org.jetbrains.kotlin.buildtools.internal.serialization.descriptors.SerialDescriptor;
import org.jetbrains.kotlin.buildtools.internal.serialization.encoding.CompositeEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.encoding.Encoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.ProtoBuf;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.HelpersKt;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.OneOfElementEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.ProtobufEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.ProtobufWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/OneOfPolymorphicEncoder;", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtobufEncoder;", "proto", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/ProtoBuf;", "parentWriter", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtobufWriter;", "descriptor", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "beginStructure", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/encoding/CompositeEncoder;", "encodeInline", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/encoding/Encoder;", "encodeTaggedString", "", "tag", "", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtoDesc;", "value", "", "getTag", "index", "", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/OneOfPolymorphicEncoder\n+ 2 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n1#1,291:1\n52#2:292\n*S KotlinDebug\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/OneOfPolymorphicEncoder\n*L\n216#1:292\n*E\n"})
final class OneOfPolymorphicEncoder
extends ProtobufEncoder {
    @NotNull
    private final ProtobufWriter parentWriter;

    public OneOfPolymorphicEncoder(@NotNull ProtoBuf proto, @NotNull ProtobufWriter parentWriter, @NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)parentWriter, (String)"parentWriter");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(proto, parentWriter, descriptor);
        this.parentWriter = parentWriter;
        if (!(descriptor.getKind() instanceof PolymorphicKind)) {
            boolean bl = false;
            String string = "The serializer of one of type " + descriptor.getSerialName() + " should be using generic polymorphic serializer, but got " + descriptor.getKind() + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return Intrinsics.areEqual((Object)descriptor, (Object)this.descriptor) ? (CompositeEncoder)this : (CompositeEncoder)new OneOfElementEncoder(this.proto, this.parentWriter, descriptor);
    }

    @Override
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        long $this$protoId$iv = HelpersKt.extractParameters(descriptor, 0);
        boolean $i$f$getProtoId = false;
        return this.encodeTaggedInline(HelpersKt.overrideId(this.popTag(), (int)($this$protoId$iv & Integer.MAX_VALUE)), descriptor);
    }

    @Override
    protected void encodeTaggedString(long tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (tag != 19501L) {
            super.encodeTaggedString(tag, value);
        }
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
        switch (index) {
            case 0: {
                l = 19501L;
                break;
            }
            case 1: {
                l = HelpersKt.extractParameters($this$getTag, index);
                break;
            }
            default: {
                throw new SerializationException("Unsupported index: " + index + " in a oneOf type " + $this$getTag.getSerialName() + ", which should be using generic polymorphic serializer");
            }
        }
        return l;
    }
}

