/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.ProtoIntegerType;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.ByteArrayOutput;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.BytesKt;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.ProtoWireType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bJ\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u001c\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00132\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u001d\u001a\u00020\u000b*\u00020\u0019H\u0002J\f\u0010\u001d\u001a\u00020\u0013*\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtobufWriter;", "", "out", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ByteArrayOutput;", "<init>", "(Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;)V", "writeBytes", "", "bytes", "", "tag", "", "writeOutput", "output", "writeInt", "value", "format", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/ProtoIntegerType;", "writeLong", "", "writeString", "", "writeDouble", "", "writeFloat", "", "encode32", "number", "encode64", "reverseBytes", "kotlinx-serialization-protobuf"})
public final class ProtobufWriter {
    @NotNull
    private final ByteArrayOutput out;

    public ProtobufWriter(@NotNull ByteArrayOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
    }

    public final void writeBytes(@NotNull byte[] bytes, int tag) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ProtobufWriter.encode32$default(this, this.out, ProtoWireType.SIZE_DELIMITED.wireIntWithTag(tag), null, 2, null);
        this.writeBytes(bytes);
    }

    public final void writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ProtobufWriter.encode32$default(this, this.out, bytes.length, null, 2, null);
        this.out.write(bytes);
    }

    public final void writeOutput(@NotNull ByteArrayOutput output, int tag) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ProtobufWriter.encode32$default(this, this.out, ProtoWireType.SIZE_DELIMITED.wireIntWithTag(tag), null, 2, null);
        this.writeOutput(output);
    }

    public final void writeOutput(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ProtobufWriter.encode32$default(this, this.out, output.size(), null, 2, null);
        this.out.write(output);
    }

    public final void writeInt(int value, int tag, @NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        ProtoWireType wireType = format == ProtoIntegerType.FIXED ? ProtoWireType.i32 : ProtoWireType.VARINT;
        ProtobufWriter.encode32$default(this, this.out, wireType.wireIntWithTag(tag), null, 2, null);
        this.encode32(this.out, value, format);
    }

    public final void writeInt(int value) {
        ProtobufWriter.encode32$default(this, this.out, value, null, 2, null);
    }

    public final void writeLong(long value, int tag, @NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        ProtoWireType wireType = format == ProtoIntegerType.FIXED ? ProtoWireType.i64 : ProtoWireType.VARINT;
        ProtobufWriter.encode32$default(this, this.out, wireType.wireIntWithTag(tag), null, 2, null);
        this.encode64(this.out, value, format);
    }

    public final void writeLong(long value) {
        ProtobufWriter.encode64$default(this, this.out, value, null, 2, null);
    }

    public final void writeString(@NotNull String value, int tag) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] bytes = StringsKt.encodeToByteArray((String)value);
        this.writeBytes(bytes, tag);
    }

    public final void writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] bytes = StringsKt.encodeToByteArray((String)value);
        this.writeBytes(bytes);
    }

    public final void writeDouble(double value, int tag) {
        ProtobufWriter.encode32$default(this, this.out, ProtoWireType.i64.wireIntWithTag(tag), null, 2, null);
        this.out.writeLong(this.reverseBytes(value));
    }

    public final void writeDouble(double value) {
        this.out.writeLong(this.reverseBytes(value));
    }

    public final void writeFloat(float value, int tag) {
        ProtobufWriter.encode32$default(this, this.out, ProtoWireType.i32.wireIntWithTag(tag), null, 2, null);
        this.out.writeInt(this.reverseBytes(value));
    }

    public final void writeFloat(float value) {
        this.out.writeInt(this.reverseBytes(value));
    }

    private final void encode32(ByteArrayOutput $this$encode32, int number, ProtoIntegerType format) {
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                this.out.writeInt(BytesKt.reverseBytes(number));
                break;
            }
            case 2: {
                $this$encode32.encodeVarint64(number);
                break;
            }
            case 3: {
                $this$encode32.encodeVarint32(number << 1 ^ number >> 31);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static /* synthetic */ void encode32$default(ProtobufWriter protobufWriter, ByteArrayOutput byteArrayOutput, int n, ProtoIntegerType protoIntegerType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        protobufWriter.encode32(byteArrayOutput, n, protoIntegerType);
    }

    private final void encode64(ByteArrayOutput $this$encode64, long number, ProtoIntegerType format) {
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                this.out.writeLong(BytesKt.reverseBytes(number));
                break;
            }
            case 2: {
                $this$encode64.encodeVarint64(number);
                break;
            }
            case 3: {
                $this$encode64.encodeVarint64(number << 1 ^ number >> 63);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static /* synthetic */ void encode64$default(ProtobufWriter protobufWriter, ByteArrayOutput byteArrayOutput, long l, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 2) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        protobufWriter.encode64(byteArrayOutput, l, protoIntegerType);
    }

    private final int reverseBytes(float $this$reverseBytes) {
        return BytesKt.reverseBytes(Float.floatToRawIntBits($this$reverseBytes));
    }

    private final long reverseBytes(double $this$reverseBytes) {
        return BytesKt.reverseBytes(Double.doubleToRawLongBits($this$reverseBytes));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoIntegerType.values().length];
            try {
                nArray[ProtoIntegerType.FIXED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.DEFAULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.SIGNED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

