/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.jvm.operations;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.buildtools.api.CompilationResult;
import org.jetbrains.kotlin.buildtools.api.ExecutionPolicy;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.SourcesChanges;
import org.jetbrains.kotlin.buildtools.api.internal.BaseOption;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmIncrementalCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmSnapshotBasedIncrementalCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmSnapshotBasedIncrementalCompilationOptions;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmCompilationOperation;
import org.jetbrains.kotlin.buildtools.api.trackers.CompilerLookupTracker;
import org.jetbrains.kotlin.buildtools.internal.BaseOptionWithDefault;
import org.jetbrains.kotlin.buildtools.internal.BuildOperationImpl;
import org.jetbrains.kotlin.buildtools.internal.BuildToolsApiBuildICReporter;
import org.jetbrains.kotlin.buildtools.internal.CompilationServiceImplKt;
import org.jetbrains.kotlin.buildtools.internal.DaemonAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.DaemonCompilationResults;
import org.jetbrains.kotlin.buildtools.internal.DaemonExecutionPolicyImpl;
import org.jetbrains.kotlin.buildtools.internal.DefaultKotlinLogger;
import org.jetbrains.kotlin.buildtools.internal.IcAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.InProcessExecutionPolicyImpl;
import org.jetbrains.kotlin.buildtools.internal.KotlinLoggerMessageCollectorAdapter;
import org.jetbrains.kotlin.buildtools.internal.Options;
import org.jetbrains.kotlin.buildtools.internal.UseFromImplModuleRestricted;
import org.jetbrains.kotlin.buildtools.internal.arguments.CommonToolArgumentsImpl;
import org.jetbrains.kotlin.buildtools.internal.arguments.JvmCompilerArgumentsImpl;
import org.jetbrains.kotlin.buildtools.internal.jvm.JvmSnapshotBasedIncrementalCompilationOptionsImpl;
import org.jetbrains.kotlin.buildtools.internal.jvm.operations.JvmCompilationOperationImplKt;
import org.jetbrains.kotlin.buildtools.internal.trackers.BuildMetricsReporterAdapterKt;
import org.jetbrains.kotlin.buildtools.internal.trackers.LookupTrackerAdapter;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompatKt;
import org.jetbrains.kotlin.compilerRunner.ArgumentsToStrings;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.RestPropMapper;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.CompilerRunnerUtils;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunnerKt;
import org.jetbrains.kotlin.incremental.IncrementalFirJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.storage.FileLocations;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 K2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002JKB;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\"\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0097\u0002\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\u001b\u001a\u0002H\u0015H\u0097\u0002\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001dH\u0082\u0002\u00a2\u0006\u0002\u0010\u001eJ*\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001d2\u0006\u0010\u001b\u001a\u0002H\u0015H\u0082\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n /*\u0004\u0018\u00010\r0\r0\u0005H\u0002J\u0010\u00100\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020-H\u0002J*\u00100\u001a\u00020\u0002*\u0002042\u0006\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020-2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002JN\u00108\u001a\u000209*\u00020\u00002\u0006\u0010:\u001a\u00020\u00062\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>0<2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010C\u001a\u00020DH\u0002JN\u0010E\u001a\u00020F*\u00020\u00002\u0006\u0010:\u001a\u00020\u00062\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>0<2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010C\u001a\u00020DH\u0002J \u0010G\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u0010H\u001a\u00020IH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl;", "Lorg/jetbrains/kotlin/buildtools/internal/BuildOperationImpl;", "Lorg/jetbrains/kotlin/buildtools/api/CompilationResult;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmCompilationOperation;", "kotlinSources", "", "Ljava/nio/file/Path;", "destinationDirectory", "compilerArguments", "Lorg/jetbrains/kotlin/buildtools/internal/arguments/JvmCompilerArgumentsImpl;", "buildIdToSessionFlagFile", "", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "Ljava/io/File;", "<init>", "(Ljava/util/List;Ljava/nio/file/Path;Lorg/jetbrains/kotlin/buildtools/internal/arguments/JvmCompilerArgumentsImpl;Ljava/util/Map;)V", "getCompilerArguments", "()Lorg/jetbrains/kotlin/buildtools/internal/arguments/JvmCompilerArgumentsImpl;", "options", "Lorg/jetbrains/kotlin/buildtools/internal/Options;", "get", "V", "key", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmCompilationOperation$Option;", "(Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmCompilationOperation$Option;)Ljava/lang/Object;", "set", "", "value", "(Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmCompilationOperation$Option;Ljava/lang/Object;)V", "Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl$Option;", "(Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl$Option;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl$Option;Ljava/lang/Object;)V", "createSnapshotBasedIcOptions", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmSnapshotBasedIncrementalCompilationOptions;", "execute", "projectId", "executionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "toDaemonCompilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "compileWithDaemon", "Lorg/jetbrains/kotlin/buildtools/internal/DaemonExecutionPolicyImpl;", "loggerAdapter", "Lorg/jetbrains/kotlin/buildtools/internal/KotlinLoggerMessageCollectorAdapter;", "getCurrentClasspath", "kotlin.jvm.PlatformType", "compileInProcess", "compileInProcessWithoutIc", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmSnapshotBasedIncrementalCompilationConfiguration;", "kotlinFilenameExtensions", "", "", "getNonFirRunner", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCompilerRunner;", "workingDirectory", "buildReporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "aggregatedIcConfigurationOptions", "Lorg/jetbrains/kotlin/buildtools/internal/jvm/JvmSnapshotBasedIncrementalCompilationOptionsImpl;", "classpathChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges$ClasspathSnapshotEnabled;", "icFeatures", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationFeatures;", "getFirRunner", "Lorg/jetbrains/kotlin/incremental/IncrementalFirJvmCompilerRunner;", "logCompilerArguments", "argumentsLogLevel", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmCompilationOperation$CompilerArgumentsLogLevel;", "Option", "Companion", "kotlin-build-tools-impl"})
@SourceDebugExtension(value={"SMAP\nJvmCompilationOperationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCompilationOperationImpl.kt\norg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,454:1\n1#2:455\n37#3,2:456\n37#3,2:472\n1586#4:458\n1661#4,3:459\n1391#4:462\n1480#4,5:463\n1586#4:468\n1661#4,3:469\n1586#4:478\n1661#4,3:479\n777#4:482\n873#4,2:483\n1586#4:485\n1661#4,3:486\n1586#4:489\n1661#4,3:490\n1586#4:493\n1661#4,3:494\n1586#4:497\n1661#4,3:498\n1586#4:501\n1661#4,3:502\n1586#4:505\n1661#4,3:506\n11705#5:474\n12052#5,3:475\n*S KotlinDebug\n*F\n+ 1 JvmCompilationOperationImpl.kt\norg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl\n*L\n132#1:456,2\n229#1:472,2\n143#1:458\n143#1:459,3\n209#1:462\n209#1:463,5\n220#1:468\n220#1:469,3\n285#1:478\n285#1:479,3\n300#1:482\n300#1:483,2\n300#1:485\n300#1:486,3\n308#1:489\n308#1:490,3\n360#1:493\n360#1:494,3\n372#1:497\n372#1:498,3\n389#1:501\n389#1:502,3\n401#1:505\n401#1:506,3\n257#1:474\n257#1:475,3\n*E\n"})
public final class JvmCompilationOperationImpl
extends BuildOperationImpl<CompilationResult>
implements JvmCompilationOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Path> kotlinSources;
    @NotNull
    private final Path destinationDirectory;
    @NotNull
    private final JvmCompilerArgumentsImpl compilerArguments;
    @NotNull
    private final Map<ProjectId, File> buildIdToSessionFlagFile;
    @NotNull
    private final Options options;
    @NotNull
    private static final Option<JvmIncrementalCompilationConfiguration> INCREMENTAL_COMPILATION = new Option<Object>("INCREMENTAL_COMPILATION", null);
    @NotNull
    private static final Option<CompilerLookupTracker> LOOKUP_TRACKER = new Option<Object>("LOOKUP_TRACKER", null);
    @NotNull
    private static final Option<String[]> KOTLINSCRIPT_EXTENSIONS = new Option<Object>("KOTLINSCRIPT_EXTENSIONS", null);
    @NotNull
    private static final Option<JvmCompilationOperation.CompilerArgumentsLogLevel> COMPILER_ARGUMENTS_LOG_LEVEL = new Option<JvmCompilationOperation.CompilerArgumentsLogLevel>("COMPILER_ARGUMENTS_LOG_LEVEL", JvmCompilationOperation.CompilerArgumentsLogLevel.DEBUG);

    public JvmCompilationOperationImpl(@NotNull List<? extends Path> kotlinSources, @NotNull Path destinationDirectory, @NotNull JvmCompilerArgumentsImpl compilerArguments, @NotNull Map<ProjectId, File> buildIdToSessionFlagFile) {
        Intrinsics.checkNotNullParameter(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter(buildIdToSessionFlagFile, (String)"buildIdToSessionFlagFile");
        this.kotlinSources = kotlinSources;
        this.destinationDirectory = destinationDirectory;
        this.compilerArguments = compilerArguments;
        this.buildIdToSessionFlagFile = buildIdToSessionFlagFile;
        this.options = new Options(Reflection.getOrCreateKotlinClass(JvmCompilationOperation.class));
    }

    public /* synthetic */ JvmCompilationOperationImpl(List list, Path path, JvmCompilerArgumentsImpl jvmCompilerArgumentsImpl, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jvmCompilerArgumentsImpl = new JvmCompilerArgumentsImpl();
        }
        this(list, path, jvmCompilerArgumentsImpl, map);
    }

    @NotNull
    public JvmCompilerArgumentsImpl getCompilerArguments() {
        return this.compilerArguments;
    }

    @Override
    @UseFromImplModuleRestricted
    public <V> V get(@NotNull JvmCompilationOperation.Option<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.options.get((BaseOption)key);
    }

    @Override
    @UseFromImplModuleRestricted
    public <V> void set(@NotNull JvmCompilationOperation.Option<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.options.set((BaseOption)key, value);
    }

    @Override
    private final <V> V get(Option<V> key) {
        return this.options.get(key);
    }

    @Override
    private final <V> void set(Option<V> key, V value) {
        this.options.set(key, value);
    }

    @NotNull
    public JvmSnapshotBasedIncrementalCompilationOptions createSnapshotBasedIcOptions() {
        return new JvmSnapshotBasedIncrementalCompilationOptionsImpl();
    }

    @Override
    @NotNull
    public CompilationResult execute(@NotNull ProjectId projectId, @NotNull ExecutionPolicy executionPolicy, @Nullable KotlinLogger logger) {
        CompilationResult compilationResult;
        KotlinLoggerMessageCollectorAdapter kotlinLoggerMessageCollectorAdapter;
        KotlinLogger it;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)executionPolicy, (String)"executionPolicy");
        KotlinLogger kotlinLogger = logger;
        if (kotlinLogger != null) {
            it = kotlinLogger;
            boolean bl = false;
            kotlinLoggerMessageCollectorAdapter = new KotlinLoggerMessageCollectorAdapter(it);
        } else {
            kotlinLoggerMessageCollectorAdapter = new KotlinLoggerMessageCollectorAdapter(DefaultKotlinLogger.INSTANCE);
        }
        KotlinLoggerMessageCollectorAdapter loggerAdapter = kotlinLoggerMessageCollectorAdapter;
        ExecutionPolicy executionPolicy2 = executionPolicy;
        if (Intrinsics.areEqual((Object)executionPolicy2, (Object)InProcessExecutionPolicyImpl.INSTANCE)) {
            compilationResult = this.compileInProcess(loggerAdapter);
        } else if (executionPolicy2 instanceof DaemonExecutionPolicyImpl) {
            compilationResult = this.compileWithDaemon(projectId, (DaemonExecutionPolicyImpl)executionPolicy, loggerAdapter);
        } else {
            CompilationResult compilationResult2 = CompilationResult.COMPILATION_ERROR;
            it = compilationResult2;
            boolean bl = false;
            KotlinLogger.error$default((KotlinLogger)loggerAdapter.getKotlinLogger$kotlin_build_tools_impl(), (String)("Unknown execution mode: " + Reflection.getOrCreateKotlinClass(executionPolicy.getClass()).getQualifiedName()), null, (int)2, null);
            compilationResult = compilationResult2;
        }
        return compilationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationOptions toDaemonCompilationOptions() {
        CompilationOptions compilationOptions;
        String[] ktsExtensionsAsArray = this.get(KOTLINSCRIPT_EXTENSIONS);
        Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.IC_MESSAGE.getCode()};
        Integer[] reportCategories = integerArray;
        int reportSeverity = ((CommonToolArgumentsImpl)this.getCompilerArguments()).contains(CommonToolArgumentsImpl.Companion.getVERBOSE()) && ((CommonToolArgumentsImpl)this.getCompilerArguments()).get(CommonToolArgumentsImpl.Companion.getVERBOSE()) != false ? ReportSeverity.DEBUG.getCode() : ReportSeverity.INFO.getCode();
        JvmIncrementalCompilationConfiguration aggregatedIcConfiguration = this.get(INCREMENTAL_COMPILATION);
        JvmIncrementalCompilationConfiguration jvmIncrementalCompilationConfiguration = aggregatedIcConfiguration;
        if (jvmIncrementalCompilationConfiguration instanceof JvmSnapshotBasedIncrementalCompilationConfiguration) {
            List list;
            void $this$toTypedArray$iv;
            JvmSnapshotBasedIncrementalCompilationOptions jvmSnapshotBasedIncrementalCompilationOptions = ((JvmSnapshotBasedIncrementalCompilationConfiguration)aggregatedIcConfiguration).getOptions();
            Intrinsics.checkNotNull((Object)jvmSnapshotBasedIncrementalCompilationOptions, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.buildtools.internal.jvm.JvmSnapshotBasedIncrementalCompilationOptionsImpl");
            JvmSnapshotBasedIncrementalCompilationOptionsImpl aggregatedIcConfigurationOptions = (JvmSnapshotBasedIncrementalCompilationOptionsImpl)jvmSnapshotBasedIncrementalCompilationOptions;
            SourcesChanges sourcesChanges = ((JvmSnapshotBasedIncrementalCompilationConfiguration)aggregatedIcConfiguration).getSourcesChanges();
            Object object = new Integer[2];
            object[0] = CompilationResultCategory.IC_COMPILE_ITERATION.getCode();
            Integer n = CompilationResultCategory.BUILD_METRICS.getCode();
            int n2 = ((Number)n).intValue();
            int n3 = 1;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = ((BuildOperationImpl)this).get(BuildOperationImpl.Companion.getXX_KGP_METRICS_COLLECTOR());
            object2[n3] = bl2 ? n : null;
            object = CollectionsKt.listOfNotNull((Object[])object);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Integer[] requestedCompilationResults = thisCollection$iv.toArray(new Integer[0]);
            ClasspathChanges.ClasspathSnapshotEnabled classpathChanges = IcAdaptersKt.getClasspathChanges((JvmSnapshotBasedIncrementalCompilationConfiguration)aggregatedIcConfiguration);
            File file = ((JvmSnapshotBasedIncrementalCompilationConfiguration)aggregatedIcConfiguration).getWorkingDirectory().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            File file2 = file;
            CompilerMode compilerMode = CompilerMode.INCREMENTAL_COMPILER;
            CompileService.TargetPlatform targetPlatform = CompileService.TargetPlatform.JVM;
            Set<Path> set = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getOUTPUT_DIRS());
            if (set != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl3 = false;
                    object2.add(it.toFile());
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List list2 = list;
            Path path = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getROOT_PROJECT_DIR());
            File file3 = path != null ? path.toFile() : null;
            Path path2 = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getMODULE_BUILD_DIR());
            File file4 = path2 != null ? path2.toFile() : null;
            IncrementalCompilationFeatures incrementalCompilationFeatures = IcAdaptersKt.extractIncrementalCompilationFeatures((JvmSnapshotBasedIncrementalCompilationConfiguration)aggregatedIcConfiguration);
            boolean bl4 = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getUSE_FIR_RUNNER());
            compilationOptions = (CompilationOptions)new IncrementalCompilationOptions(sourcesChanges, (ClasspathChanges)classpathChanges, file2, compilerMode, targetPlatform, reportCategories, reportSeverity, requestedCompilationResults, bl4, (Collection)list2, null, null, file3, file4, ktsExtensionsAsArray, incrementalCompilationFeatures);
        } else if (jvmIncrementalCompilationConfiguration == null) {
            compilationOptions = new CompilationOptions(CompilerMode.NON_INCREMENTAL_COMPILER, CompileService.TargetPlatform.JVM, reportCategories, reportSeverity, new Integer[0], ktsExtensionsAsArray);
        } else {
            throw new IllegalStateException(("Unexpected incremental compilation configuration: " + aggregatedIcConfiguration + ". In this version, it must be an instance of JvmIncrementalCompilationConfiguration for incremental compilation, or null for non-incremental compilation.").toString());
        }
        return compilationOptions;
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileWithDaemon(ProjectId projectId, DaemonExecutionPolicyImpl executionPolicy, KotlinLoggerMessageCollectorAdapter loggerAdapter) {
        ExitCode exitCode;
        Object v9;
        int exitCode2;
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> metricsReporter;
        Object element$iv$iv2;
        Object object;
        CompilationResult compilationResult;
        block14: {
            JvmSnapshotBasedIncrementalCompilationOptionsImpl aggregatedIcConfigurationOptions;
            JvmSnapshotBasedIncrementalCompilationConfiguration aggregatedIcConfiguration;
            Collection<String> collection;
            JvmSnapshotBasedIncrementalCompilationOptions $this$mapTo$iv$iv;
            void $this$map$iv;
            PropMapper it;
            StringBuilder stringBuilder;
            Object object2;
            DaemonOptions daemonOptions;
            boolean bl;
            DaemonJVMOptions daemonJVMOptions;
            loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().debug("Compiling using the daemon strategy");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)this.getCurrentClasspath());
            File file = this.buildIdToSessionFlagFile.computeIfAbsent(projectId, arg_0 -> JvmCompilationOperationImpl.compileWithDaemon$lambda$1(JvmCompilationOperationImpl::compileWithDaemon$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"computeIfAbsent(...)");
            File sessionIsAliveFlagFile = file;
            DaemonJVMOptions opts = daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])new String[0], (boolean)true, (boolean)false, (boolean)true);
            boolean bl2 = false;
            List<String> list = executionPolicy.get(DaemonExecutionPolicyImpl.Companion.getJVM_ARGUMENTS());
            if (list != null) {
                List<String> list2;
                List<String> it2 = list2 = list;
                boolean bl3 = false;
                list = !((Collection)it2).isEmpty() ? list2 : null;
                if (list != null) {
                    List<String> daemonJvmArguments = list;
                    bl = false;
                    CollectionsKt.addAll((Collection)opts.getJvmParams(), (Iterable)DaemonParamsKt.filterExtractProps((Iterable)daemonJvmArguments, (List)opts.getMappers(), (String)"", (RestPropMapper)opts.getRestMapper()));
                }
            }
            DaemonJVMOptions jvmOptions = daemonJVMOptions;
            DaemonOptions $this$compileWithDaemon_u24lambda_u243 = daemonOptions = new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null);
            boolean bl4 = false;
            Long l = executionPolicy.get(DaemonExecutionPolicyImpl.Companion.getSHUTDOWN_DELAY_MILLIS());
            if (l != null) {
                long shutdownDelay = ((Number)l).longValue();
                boolean bl5 = false;
                $this$compileWithDaemon_u24lambda_u243.setShutdownDelayMilliseconds(shutdownDelay);
            }
            DaemonOptions daemonOptions2 = DaemonParamsKt.configureDaemonOptions((DaemonOptions)daemonOptions);
            File shutdownDelay = DaemonAdaptersKt.getClientIsAliveFile();
            bl = loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().isDebugEnabled() || ((object2 = System.getProperty("kotlin.daemon.debug.log")) != null && (object2 = StringsKt.toBooleanStrictOrNull((String)object2)) != null ? (Boolean)object2 : true);
            CompileServiceSession compileServiceSession = KotlinCompilerRunnerUtils.newDaemonConnection((CompilerId)compilerId, (File)shutdownDelay, (File)sessionIsAliveFlagFile, (MessageCollector)loggerAdapter, (boolean)bl, (DaemonOptions)daemonOptions2, (DaemonJVMOptions)jvmOptions);
            if (compileServiceSession == null) {
                return CompilationServiceImplKt.getAsCompilationResult(ExitCode.INTERNAL_ERROR);
            }
            daemonOptions = compileServiceSession;
            CompileService daemon = daemonOptions.component1();
            int sessionId = daemonOptions.component2();
            if (loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().isDebugEnabled()) {
                CompileService.CallResult it3 = bl = daemon.getDaemonJVMOptions();
                boolean bl6 = false;
                Object object3 = it3.isGood() ? bl : null;
                if (object3 != null) {
                    Iterator $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    CompileService.CallResult jvmOpts = object3;
                    boolean bl7 = false;
                    Iterable iterable = ((DaemonJVMOptions)jvmOpts.get()).getMappers();
                    stringBuilder = new StringBuilder().append("Kotlin compile daemon JVM options: ");
                    KotlinLogger kotlinLogger = loggerAdapter.getKotlinLogger$kotlin_build_tools_impl();
                    boolean $i$f$flatMap = false;
                    compilationResult = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    object = $this$flatMapTo$iv$iv.iterator();
                    while (object.hasNext()) {
                        element$iv$iv2 = object.next();
                        it = (PropMapper)element$iv$iv2;
                        boolean bl8 = false;
                        Iterable list$iv$iv = it.toArgs("-");
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv;
                    kotlinLogger.debug(stringBuilder.append(list3).toString());
                }
            }
            CompilationOptions daemonCompileOptions = this.toDaemonCompilationOptions();
            loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().info("Options for KOTLIN DAEMON: " + daemonCompileOptions);
            boolean isIncrementalCompilation = daemonCompileOptions instanceof IncrementalCompilationOptions;
            if (isIncrementalCompilation && ((IncrementalCompilationOptions)daemonCompileOptions).getUseJvmFirRunner()) {
                JvmCompilationOperationImplKt.access$checkJvmFirRequirements(this.getCompilerArguments());
            }
            K2JVMCompilerArguments arguments = JvmCompilerArgumentsImpl.toCompilerArguments$default(this.getCompilerArguments(), null, 1, null);
            Iterable bl7 = this.kotlinSources;
            Collection collection2 = arguments.getFreeArgs();
            K2JVMCompilerArguments k2JVMCompilerArguments = arguments;
            boolean $i$f$map22 = false;
            stringBuilder = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                Path $i$f$flatMapTo = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                collection.add(((Object)it4.toAbsolutePath()).toString());
            }
            collection = (List)destination$iv$iv;
            k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
            arguments.setDestination(((Object)this.destinationDirectory.toAbsolutePath()).toString());
            JvmIncrementalCompilationConfiguration $i$f$map22 = this.get(INCREMENTAL_COMPILATION);
            JvmSnapshotBasedIncrementalCompilationConfiguration jvmSnapshotBasedIncrementalCompilationConfiguration = aggregatedIcConfiguration = $i$f$map22 instanceof JvmSnapshotBasedIncrementalCompilationConfiguration ? (JvmSnapshotBasedIncrementalCompilationConfiguration)$i$f$map22 : null;
            $this$mapTo$iv$iv = jvmSnapshotBasedIncrementalCompilationConfiguration != null ? jvmSnapshotBasedIncrementalCompilationConfiguration.getOptions() : null;
            JvmSnapshotBasedIncrementalCompilationOptionsImpl jvmSnapshotBasedIncrementalCompilationOptionsImpl = aggregatedIcConfigurationOptions = $this$mapTo$iv$iv instanceof JvmSnapshotBasedIncrementalCompilationOptionsImpl ? (JvmSnapshotBasedIncrementalCompilationOptionsImpl)$this$mapTo$iv$iv : null;
            Path rootProjectDir = jvmSnapshotBasedIncrementalCompilationOptionsImpl != null ? jvmSnapshotBasedIncrementalCompilationOptionsImpl.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getROOT_PROJECT_DIR()) : null;
            this.logCompilerArguments(loggerAdapter, arguments, this.get(COMPILER_ARGUMENTS_LOG_LEVEL));
            metricsReporter = BuildMetricsReporterAdapterKt.getMetricsReporter(this);
            Collection $this$toTypedArray$iv = ArgumentsToStrings.toArgumentStrings$default((CommonToolArguments)((CommonToolArguments)arguments), (boolean)false, (boolean)false, (int)3, null);
            boolean $i$f$toTypedArray = false;
            Iterable thisCollection$iv = $this$toTypedArray$iv;
            Path path = rootProjectDir;
            exitCode2 = ((Number)daemon.compile(sessionId, thisCollection$iv.toArray(new String[0]), daemonCompileOptions, (CompilerServicesFacadeBase)new BasicCompilerServicesWithResultsFacadeServer((MessageCollector)loggerAdapter, null, 0, 6, null), (CompilationResults)new DaemonCompilationResults(loggerAdapter.getKotlinLogger$kotlin_build_tools_impl(), path != null ? path.toFile() : null, metricsReporter)).get()).intValue();
            try {
                daemon.releaseCompileSession(sessionId);
            }
            catch (RemoteException e) {
                loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().warn("Unable to release compile session, maybe daemon is already down: " + e);
            }
            thisCollection$iv = (Iterable)EntriesMappings.entries$0;
            for (Object element$iv$iv2 : thisCollection$iv) {
                it = (ExitCode)element$iv$iv2;
                boolean bl10 = false;
                if (!(it.getCode() == exitCode2)) continue;
                v9 = element$iv$iv2;
                break block14;
            }
            v9 = null;
        }
        if ((exitCode = (ExitCode)v9) == null) {
            exitCode = exitCode2 == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
        }
        CompilationResult it = compilationResult = CompilationServiceImplKt.getAsCompilationResult(exitCode);
        boolean bl = false;
        if (((BuildOperationImpl)this).get(BuildOperationImpl.Companion.getXX_KGP_METRICS_COLLECTOR()).booleanValue() && metricsReporter instanceof BuildMetricsReporterImpl) {
            void $this$compileWithDaemon_u24lambda_u248_u240;
            object = new ByteArrayOutputStream();
            element$iv$iv2 = object;
            BuildOperationImpl.Option<byte[]> option = BuildOperationImpl.Companion.getXX_KGP_METRICS_COLLECTOR_OUT();
            JvmCompilationOperationImpl jvmCompilationOperationImpl = this;
            boolean bl11 = false;
            new ObjectOutputStream((OutputStream)$this$compileWithDaemon_u24lambda_u248_u240).writeObject(metricsReporter);
            Unit unit = Unit.INSTANCE;
            ((BuildOperationImpl)jvmCompilationOperationImpl).set(option, ((ByteArrayOutputStream)object).toByteArray());
        }
        return compilationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getCurrentClasspath() {
        void $this$mapTo$iv$iv;
        ClassLoader classLoader = JvmCompilationOperationImpl.class.getClassLoader();
        Intrinsics.checkNotNull((Object)classLoader, (String)"null cannot be cast to non-null type java.net.URLClassLoader");
        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
        Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
        Object[] $this$map$iv = uRLArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URL uRL = (URL)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(CompilationServiceImplKt.transformUrlToFile((URL)it));
        }
        return (List)destination$iv$iv;
    }

    private final CompilationResult compileInProcess(KotlinLoggerMessageCollectorAdapter loggerAdapter) {
        CompilationResult compilationResult;
        K2JVMCompilerArguments k2JVMCompilerArguments;
        loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().debug("Compiling using the in-process strategy");
        CompatKt.setupIdeaStandaloneExecution();
        K2JVMCompilerArguments compilerArguments = k2JVMCompilerArguments = JvmCompilerArgumentsImpl.toCompilerArguments$default(this.getCompilerArguments(), null, 1, null);
        boolean bl = false;
        compilerArguments.setDestination(((Object)this.destinationDirectory.toAbsolutePath()).toString());
        K2JVMCompilerArguments arguments = k2JVMCompilerArguments;
        Set set = SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS();
        Object[] objectArray = this.get(KOTLINSCRIPT_EXTENSIONS);
        if (objectArray == null) {
            objectArray = new String[]{};
        }
        Set kotlinFilenameExtensions = SetsKt.plus((Set)set, (Object[])objectArray);
        JvmIncrementalCompilationConfiguration aggregatedIcConfiguration = this.get(INCREMENTAL_COMPILATION);
        if (aggregatedIcConfiguration instanceof JvmSnapshotBasedIncrementalCompilationConfiguration) {
            compilationResult = this.compileInProcess((JvmSnapshotBasedIncrementalCompilationConfiguration)aggregatedIcConfiguration, arguments, loggerAdapter, kotlinFilenameExtensions);
        } else if (aggregatedIcConfiguration == null) {
            compilationResult = this.compileInProcessWithoutIc(arguments, loggerAdapter);
        } else {
            throw new IllegalStateException(("Unexpected incremental compilation configuration: " + aggregatedIcConfiguration + ". In this version, it must be an instance of JvmSnapshotBasedIncrementalCompilationConfiguration for incremental compilation, or null for non-incremental compilation.").toString());
        }
        return compilationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileInProcessWithoutIc(K2JVMCompilerArguments arguments, KotlinLoggerMessageCollectorAdapter loggerAdapter) {
        Services.Builder builder;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        K2JVMCompiler compiler = new K2JVMCompiler();
        Iterable iterable = this.kotlinSources;
        Collection collection2 = arguments.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments = arguments;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)it.toAbsolutePath()).toString());
        }
        collection = (List)destination$iv$iv;
        k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        Services.Builder $this$compileInProcessWithoutIc_u24lambda_u241 = builder = new Services.Builder();
        boolean bl = false;
        CompilerLookupTracker compilerLookupTracker = this.get(LOOKUP_TRACKER);
        if (compilerLookupTracker != null) {
            CompilerLookupTracker tracker = compilerLookupTracker;
            boolean bl2 = false;
            $this$compileInProcessWithoutIc_u24lambda_u241.register(LookupTracker.class, (Object)new LookupTrackerAdapter(tracker));
        }
        Services services = builder.build();
        this.logCompilerArguments(loggerAdapter, arguments, this.get(COMPILER_ARGUMENTS_LOG_LEVEL));
        return CompilationServiceImplKt.getAsCompilationResult(compiler.exec((MessageCollector)loggerAdapter, services, (CommonCompilerArguments)arguments));
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileInProcess(JvmSnapshotBasedIncrementalCompilationConfiguration $this$compileInProcess, K2JVMCompilerArguments arguments, KotlinLoggerMessageCollectorAdapter loggerAdapter, Set<String> kotlinFilenameExtensions) {
        Path path;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Path it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = this.kotlinSources;
        Collection collection = arguments.getFreeArgs();
        Object object = arguments;
        boolean $i$f$filter = false;
        void var7_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            File file = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (!FileUtilsKt.isJavaFile((File)file)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection2 = (List)destination$iv$iv;
        $this$filter$iv = collection2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            it = (Path)item$iv$iv2;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((Object)it.toAbsolutePath()).toString());
        }
        collection2 = (List)destination$iv$iv;
        object.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)collection2));
        JvmSnapshotBasedIncrementalCompilationOptions jvmSnapshotBasedIncrementalCompilationOptions = $this$compileInProcess.getOptions();
        Intrinsics.checkNotNull((Object)jvmSnapshotBasedIncrementalCompilationOptions, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.buildtools.internal.jvm.JvmSnapshotBasedIncrementalCompilationOptionsImpl");
        JvmSnapshotBasedIncrementalCompilationOptionsImpl aggregatedIcConfigurationOptions = (JvmSnapshotBasedIncrementalCompilationOptionsImpl)jvmSnapshotBasedIncrementalCompilationOptions;
        Path path2 = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getROOT_PROJECT_DIR());
        File projectDir = path2 != null ? path2.toFile() : null;
        Path path3 = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getMODULE_BUILD_DIR());
        File buildDir = path3 != null ? path3.toFile() : null;
        Iterable $i$f$mapTo22 = this.kotlinSources;
        object = IncrementalCompilerRunnerKt.extractKotlinSourcesFromFreeCompilerArguments((CommonCompilerArguments)((CommonCompilerArguments)arguments), (Set)SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS(), (boolean)true);
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it2;
            path = (Path)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.toFile());
        }
        List kotlinSources = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv2));
        ClasspathChanges.ClasspathSnapshotEnabled classpathChanges = IcAdaptersKt.getClasspathChanges($this$compileInProcess);
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> metricsReporter = BuildMetricsReporterAdapterKt.getMetricsReporter(this);
        BuildReporter buildReporter = new BuildReporter((ICReporter)new BuildToolsApiBuildICReporter(loggerAdapter.getKotlinLogger$kotlin_build_tools_impl(), projectDir), metricsReporter);
        boolean verifiedPreciseJavaTracking = CompilerRunnerUtils.disablePreciseJavaTrackingIfK2((K2JVMCompilerArguments)arguments, (boolean)aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getPRECISE_JAVA_TRACKING()));
        IncrementalCompilationFeatures icFeatures = IncrementalCompilationFeatures.copy$default((IncrementalCompilationFeatures)IcAdaptersKt.extractIncrementalCompilationFeatures($this$compileInProcess), (boolean)verifiedPreciseJavaTracking, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)62, null);
        IncrementalJvmCompilerRunner incrementalCompiler = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getUSE_FIR_RUNNER()) != false && JvmCompilationOperationImplKt.access$checkJvmFirRequirements(this.getCompilerArguments()) ? (IncrementalJvmCompilerRunner)this.getFirRunner(this, $this$compileInProcess.getWorkingDirectory(), (BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric>)buildReporter, aggregatedIcConfigurationOptions, classpathChanges, kotlinFilenameExtensions, icFeatures) : this.getNonFirRunner(this, $this$compileInProcess.getWorkingDirectory(), (BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric>)buildReporter, aggregatedIcConfigurationOptions, classpathChanges, kotlinFilenameExtensions, icFeatures);
        arguments.setIncrementalCompilation(Boolean.valueOf(true));
        this.logCompilerArguments(loggerAdapter, arguments, this.get(COMPILER_ARGUMENTS_LOG_LEVEL));
        FileLocations fileLocations = projectDir != null && buildDir != null ? new FileLocations(projectDir, buildDir) : null;
        Path it3 = path = CompilationServiceImplKt.getAsCompilationResult(incrementalCompiler.compile(kotlinSources, (CommonCompilerArguments)arguments, (MessageCollector)loggerAdapter, IcAdaptersKt.getAsChangedFiles($this$compileInProcess.getSourcesChanges()), fileLocations));
        boolean bl = false;
        if (((BuildOperationImpl)this).get(BuildOperationImpl.Companion.getXX_KGP_METRICS_COLLECTOR()).booleanValue() && metricsReporter instanceof BuildMetricsReporterImpl) {
            void $this$compileInProcess_u24lambda_u244_u240;
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
            BuildOperationImpl.Option<byte[]> option = BuildOperationImpl.Companion.getXX_KGP_METRICS_COLLECTOR_OUT();
            JvmCompilationOperationImpl jvmCompilationOperationImpl = this;
            boolean bl2 = false;
            new ObjectOutputStream((OutputStream)$this$compileInProcess_u24lambda_u244_u240).writeObject(metricsReporter);
            Unit unit = Unit.INSTANCE;
            ((BuildOperationImpl)jvmCompilationOperationImpl).set(option, byteArrayOutputStream.toByteArray());
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private final IncrementalJvmCompilerRunner getNonFirRunner(JvmCompilationOperationImpl $this$getNonFirRunner, Path workingDirectory, BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter, JvmSnapshotBasedIncrementalCompilationOptionsImpl aggregatedIcConfigurationOptions, ClasspathChanges.ClasspathSnapshotEnabled classpathChanges, Set<String> kotlinFilenameExtensions, IncrementalCompilationFeatures icFeatures) {
        IncrementalJvmCompilerRunner incrementalJvmCompilerRunner;
        CompilerLookupTracker compilerLookupTracker = $this$getNonFirRunner.get(LOOKUP_TRACKER);
        if (compilerLookupTracker != null) {
            List list;
            CompilerLookupTracker tracker = compilerLookupTracker;
            boolean bl = false;
            File file = workingDirectory.toFile();
            Set<Path> set = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getOUTPUT_DIRS());
            if (set != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.toFile());
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List list2 = list;
            incrementalJvmCompilerRunner = new IncrementalJvmCompilerRunner(buildReporter, classpathChanges, kotlinFilenameExtensions, icFeatures, tracker, file, list2){
                final /* synthetic */ CompilerLookupTracker $tracker;
                {
                    this.$tracker = $tracker;
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($super_call_param$1, $buildReporter, (Collection)$super_call_param$2, (ClasspathChanges)$classpathChanges, $kotlinFilenameExtensions, $icFeatures);
                }

                public LookupTracker getLookupTrackerDelegate() {
                    return new LookupTrackerAdapter(this.$tracker);
                }
            };
        } else {
            List list;
            File file = workingDirectory.toFile();
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter2 = buildReporter;
            Set<Path> set = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getOUTPUT_DIRS());
            if (set != null) {
                Collection<File> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable tracker = set;
                BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter3 = buildReporter2;
                File file3 = file2;
                boolean $i$f$map = false;
                void var10_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path $i$f$mapTo2 = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toFile());
                }
                collection = (List)destination$iv$iv;
                file2 = file3;
                buildReporter2 = buildReporter3;
                list = collection;
            } else {
                list = null;
            }
            IncrementalCompilationFeatures incrementalCompilationFeatures = icFeatures;
            Set<String> set2 = kotlinFilenameExtensions;
            ClasspathChanges classpathChanges2 = (ClasspathChanges)classpathChanges;
            Collection collection = list;
            BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter4 = buildReporter2;
            File file4 = file2;
            incrementalJvmCompilerRunner = new IncrementalJvmCompilerRunner(file4, buildReporter4, collection, classpathChanges2, set2, incrementalCompilationFeatures);
        }
        return incrementalJvmCompilerRunner;
    }

    /*
     * WARNING - void declaration
     */
    private final IncrementalFirJvmCompilerRunner getFirRunner(JvmCompilationOperationImpl $this$getFirRunner, Path workingDirectory, BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter, JvmSnapshotBasedIncrementalCompilationOptionsImpl aggregatedIcConfigurationOptions, ClasspathChanges.ClasspathSnapshotEnabled classpathChanges, Set<String> kotlinFilenameExtensions, IncrementalCompilationFeatures icFeatures) {
        IncrementalFirJvmCompilerRunner incrementalFirJvmCompilerRunner;
        CompilerLookupTracker compilerLookupTracker = $this$getFirRunner.get(LOOKUP_TRACKER);
        if (compilerLookupTracker != null) {
            List list;
            CompilerLookupTracker tracker = compilerLookupTracker;
            boolean bl = false;
            File file = workingDirectory.toFile();
            Set<Path> set = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getOUTPUT_DIRS());
            if (set != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.toFile());
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List list2 = list;
            incrementalFirJvmCompilerRunner = new IncrementalFirJvmCompilerRunner(buildReporter, classpathChanges, kotlinFilenameExtensions, icFeatures, tracker, file, list2){
                final /* synthetic */ CompilerLookupTracker $tracker;
                {
                    this.$tracker = $tracker;
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($super_call_param$1, $buildReporter, (Collection)$super_call_param$2, (ClasspathChanges)$classpathChanges, $kotlinFilenameExtensions, $icFeatures);
                }

                public LookupTracker getLookupTrackerDelegate() {
                    return new LookupTrackerAdapter(this.$tracker);
                }
            };
        } else {
            List list;
            File file = workingDirectory.toFile();
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter2 = buildReporter;
            Set<Path> set = aggregatedIcConfigurationOptions.get(JvmSnapshotBasedIncrementalCompilationOptionsImpl.Companion.getOUTPUT_DIRS());
            if (set != null) {
                Collection<File> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable tracker = set;
                BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter3 = buildReporter2;
                File file3 = file2;
                boolean $i$f$map = false;
                void var10_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path $i$f$mapTo2 = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toFile());
                }
                collection = (List)destination$iv$iv;
                file2 = file3;
                buildReporter2 = buildReporter3;
                list = collection;
            } else {
                list = null;
            }
            IncrementalCompilationFeatures incrementalCompilationFeatures = icFeatures;
            Set<String> set2 = kotlinFilenameExtensions;
            ClasspathChanges classpathChanges2 = (ClasspathChanges)classpathChanges;
            Collection collection = list;
            BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter4 = buildReporter2;
            File file4 = file2;
            incrementalFirJvmCompilerRunner = new IncrementalFirJvmCompilerRunner(file4, buildReporter4, collection, classpathChanges2, set2, incrementalCompilationFeatures);
        }
        return incrementalFirJvmCompilerRunner;
    }

    private final void logCompilerArguments(KotlinLoggerMessageCollectorAdapter loggerAdapter, K2JVMCompilerArguments arguments, JvmCompilationOperation.CompilerArgumentsLogLevel argumentsLogLevel) {
        KotlinLogger $this$logCompilerArguments_u24lambda_u240 = loggerAdapter.getKotlinLogger$kotlin_build_tools_impl();
        boolean bl = false;
        String message = "Kotlin compiler args: " + CollectionsKt.joinToString$default((Iterable)ArgumentsToStrings.toArgumentStrings$default((CommonToolArguments)((CommonToolArguments)arguments), (boolean)false, (boolean)false, (int)3, null), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        switch (WhenMappings.$EnumSwitchMapping$0[argumentsLogLevel.ordinal()]) {
            case 1: {
                KotlinLogger.error$default((KotlinLogger)$this$logCompilerArguments_u24lambda_u240, (String)message, null, (int)2, null);
                break;
            }
            case 2: {
                $this$logCompilerArguments_u24lambda_u240.warn(message);
                break;
            }
            case 3: {
                $this$logCompilerArguments_u24lambda_u240.info(message);
                break;
            }
            case 4: {
                $this$logCompilerArguments_u24lambda_u240.debug(message);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final File compileWithDaemon$lambda$0(ProjectId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DaemonAdaptersKt.createSessionIsAliveFlagFile();
    }

    private static final File compileWithDaemon$lambda$1(Function1 $tmp0, Object p0) {
        return (File)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl$Companion;", "", "<init>", "()V", "INCREMENTAL_COMPILATION", "Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl$Option;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmIncrementalCompilationConfiguration;", "getINCREMENTAL_COMPILATION", "()Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl$Option;", "LOOKUP_TRACKER", "Lorg/jetbrains/kotlin/buildtools/api/trackers/CompilerLookupTracker;", "getLOOKUP_TRACKER", "KOTLINSCRIPT_EXTENSIONS", "", "", "getKOTLINSCRIPT_EXTENSIONS", "COMPILER_ARGUMENTS_LOG_LEVEL", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmCompilationOperation$CompilerArgumentsLogLevel;", "getCOMPILER_ARGUMENTS_LOG_LEVEL", "kotlin-build-tools-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Option<JvmIncrementalCompilationConfiguration> getINCREMENTAL_COMPILATION() {
            return INCREMENTAL_COMPILATION;
        }

        @NotNull
        public final Option<CompilerLookupTracker> getLOOKUP_TRACKER() {
            return LOOKUP_TRACKER;
        }

        @NotNull
        public final Option<String[]> getKOTLINSCRIPT_EXTENSIONS() {
            return KOTLINSCRIPT_EXTENSIONS;
        }

        @NotNull
        public final Option<JvmCompilationOperation.CompilerArgumentsLogLevel> getCOMPILER_ARGUMENTS_LOG_LEVEL() {
            return COMPILER_ARGUMENTS_LOG_LEVEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ExitCode> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ExitCode.values()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmCompilationOperationImpl$Option;", "V", "Lorg/jetbrains/kotlin/buildtools/internal/BaseOptionWithDefault;", "id", "", "<init>", "(Ljava/lang/String;)V", "default", "(Ljava/lang/String;Ljava/lang/Object;)V", "kotlin-build-tools-impl"})
    public static final class Option<V>
    extends BaseOptionWithDefault<V> {
        public Option(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(id);
        }

        public Option(@NotNull String id, V v) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(id, v);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JvmCompilationOperation.CompilerArgumentsLogLevel.values().length];
            try {
                nArray[JvmCompilationOperation.CompilerArgumentsLogLevel.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmCompilationOperation.CompilerArgumentsLogLevel.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmCompilationOperation.CompilerArgumentsLogLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmCompilationOperation.CompilerArgumentsLogLevel.DEBUG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

