/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.CancellableBuildOperation;
import org.jetbrains.kotlin.buildtools.api.ExecutionPolicy;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.OperationCancelledException;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.internal.BuildOperationImpl;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0014\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ'\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH&\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001e\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/CancellableBuildOperationImpl;", "R", "Lorg/jetbrains/kotlin/buildtools/internal/BuildOperationImpl;", "Lorg/jetbrains/kotlin/buildtools/api/CancellableBuildOperation;", "<init>", "()V", "isCancelled", "Lkotlin/concurrent/atomics/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onCancelAction", "Lkotlin/concurrent/atomics/AtomicReference;", "Lkotlin/Function0;", "", "Ljava/util/concurrent/atomic/AtomicReference;", "compilationId", "", "getCompilationId", "()I", "cancel", "onCancel", "action", "cancellationHandle", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "getCancellationHandle", "()Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "executeImpl", "projectId", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "executionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/jetbrains/kotlin/buildtools/api/ProjectId;Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)Ljava/lang/Object;", "execute", "Companion", "kotlin-build-tools-impl"})
@SourceDebugExtension(value={"SMAP\nCancellableBuildOperationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CancellableBuildOperationImpl.kt\norg/jetbrains/kotlin/buildtools/internal/CancellableBuildOperationImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public abstract class CancellableBuildOperationImpl<R>
extends BuildOperationImpl<R>
implements CancellableBuildOperation<R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    @NotNull
    private final AtomicReference<Function0<Unit>> onCancelAction = new AtomicReference<Object>(null);
    private final int compilationId = AtomicsKt.incrementAndFetch((AtomicInteger)compilationIdCounter);
    @NotNull
    private final CompilationCanceledStatus cancellationHandle = new CompilationCanceledStatus(this){
        final /* synthetic */ CancellableBuildOperationImpl<R> this$0;
        {
            this.this$0 = $receiver;
        }

        public void checkCanceled() {
            if (CancellableBuildOperationImpl.access$isCancelled$p(this.this$0).get()) {
                throw new CompilationCanceledException();
            }
        }
    };
    @NotNull
    private static final AtomicInteger compilationIdCounter = new AtomicInteger(0);

    protected final int getCompilationId() {
        return this.compilationId;
    }

    public void cancel() {
        block1: {
            boolean wasCancelled = this.isCancelled.getAndSet(true);
            if (wasCancelled) break block1;
            Function0<Unit> function0 = this.onCancelAction.get();
            if (function0 != null) {
                function0.invoke();
            }
        }
    }

    public final void onCancel(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean actionWasSet = this.onCancelAction.compareAndSet(null, action);
        if (!actionWasSet) {
            boolean bl = false;
            String string = "onCancel action was already set. Setting it again is an error.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    protected final CompilationCanceledStatus getCancellationHandle() {
        return this.cancellationHandle;
    }

    public abstract R executeImpl(@NotNull ProjectId var1, @NotNull ExecutionPolicy var2, @Nullable KotlinLogger var3);

    @Override
    public final R execute(@NotNull ProjectId projectId, @NotNull ExecutionPolicy executionPolicy, @Nullable KotlinLogger logger) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)executionPolicy, (String)"executionPolicy");
        R returnValue = this.executeImpl(projectId, executionPolicy, logger);
        if (this.isCancelled.get()) {
            throw new OperationCancelledException(null, null, 3, null);
        }
        return returnValue;
    }

    public static final /* synthetic */ AtomicBoolean access$isCancelled$p(CancellableBuildOperationImpl $this) {
        return $this.isCancelled;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/CancellableBuildOperationImpl$Companion;", "", "<init>", "()V", "compilationIdCounter", "Lkotlin/concurrent/atomics/AtomicInt;", "Ljava/util/concurrent/atomic/AtomicInteger;", "kotlin-build-tools-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

