/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.arguments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.KotlinReleaseVersion;
import org.jetbrains.kotlin.buildtools.api.arguments.CommonToolArguments;
import org.jetbrains.kotlin.buildtools.internal.UseFromImplModuleRestricted;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ManualLanguageFeatureSetting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0097\u0002\u00a2\u0006\u0002\u0010\u0010J*\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0013\u001a\u0002H\rH\u0097\u0002\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0096\u0002J\"\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u0017H\u0086\u0002\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u00172\u0006\u0010\u0013\u001a\u0002H\rH\u0086\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u0015\u001a\u00020\u00162\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0086\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl;", "Lorg/jetbrains/kotlin/buildtools/api/arguments/CommonToolArguments;", "<init>", "()V", "internalArguments", "", "", "getInternalArguments", "()Ljava/util/Set;", "optionsMap", "", "", "get", "V", "key", "Lorg/jetbrains/kotlin/buildtools/api/arguments/CommonToolArguments$CommonToolArgument;", "(Lorg/jetbrains/kotlin/buildtools/api/arguments/CommonToolArguments$CommonToolArgument;)Ljava/lang/Object;", "set", "", "value", "(Lorg/jetbrains/kotlin/buildtools/api/arguments/CommonToolArguments$CommonToolArgument;Ljava/lang/Object;)V", "contains", "", "Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl$CommonToolArgument;", "(Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl$CommonToolArgument;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl$CommonToolArgument;Ljava/lang/Object;)V", "toCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "arguments", "applyCompilerArguments", "CommonToolArgument", "Companion", "kotlin-build-tools-impl"})
@SourceDebugExtension(value={"SMAP\nCommonToolArgumentsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonToolArgumentsImpl.kt\norg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n777#3:119\n873#3,2:120\n1586#3:122\n1661#3,3:123\n*S KotlinDebug\n*F\n+ 1 CommonToolArgumentsImpl.kt\norg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl\n*L\n66#1:119\n66#1:120,2\n89#1:122\n89#1:123,3\n*E\n"})
public abstract class CommonToolArgumentsImpl
implements org.jetbrains.kotlin.buildtools.api.arguments.CommonToolArguments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> internalArguments = new LinkedHashSet();
    @NotNull
    private final Map<String, Object> optionsMap = new LinkedHashMap();
    @NotNull
    private static final Set<String> knownArguments = new LinkedHashSet();
    @NotNull
    private static final CommonToolArgument<Boolean> WERROR = new CommonToolArgument("WERROR");
    @NotNull
    private static final CommonToolArgument<Boolean> WEXTRA = new CommonToolArgument("WEXTRA");
    @NotNull
    private static final CommonToolArgument<Boolean> X = new CommonToolArgument("X");
    @NotNull
    private static final CommonToolArgument<Boolean> HELP = new CommonToolArgument("HELP");
    @NotNull
    private static final CommonToolArgument<Boolean> NOWARN = new CommonToolArgument("NOWARN");
    @NotNull
    private static final CommonToolArgument<Boolean> VERBOSE = new CommonToolArgument("VERBOSE");
    @NotNull
    private static final CommonToolArgument<Boolean> VERSION = new CommonToolArgument("VERSION");

    @NotNull
    protected final Set<String> getInternalArguments() {
        return this.internalArguments;
    }

    @UseFromImplModuleRestricted
    public <V> V get(@NotNull CommonToolArguments.CommonToolArgument<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (!this.optionsMap.containsKey(key.getId())) {
            boolean bl = false;
            String string = "Argument " + key.getId() + " is not set and has no default value";
            throw new IllegalStateException(string.toString());
        }
        return (V)this.optionsMap.get(key.getId());
    }

    @UseFromImplModuleRestricted
    public <V> void set(@NotNull CommonToolArguments.CommonToolArgument<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (key.getAvailableSinceVersion().compareTo(new KotlinReleaseVersion(2, 3, 20)) > 0) {
            throw new IllegalStateException(key.getId() + " is available only since " + key.getAvailableSinceVersion());
        }
        this.optionsMap.put(key.getId(), value);
    }

    public boolean contains(@NotNull CommonToolArguments.CommonToolArgument<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.optionsMap.containsKey(key.getId());
    }

    public final <V> V get(@NotNull CommonToolArgument<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (V)this.optionsMap.get(key.getId());
    }

    public final <V> void set(@NotNull CommonToolArgument<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.optionsMap.put(key.getId(), value);
    }

    public final boolean contains(@NotNull CommonToolArgument<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.optionsMap.containsKey(key.getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CommonToolArguments toCompilerArguments(@NotNull CommonToolArguments arguments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Iterable $this$filter$iv = this.optionsMap.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!knownArguments.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknownArgs = (List)destination$iv$iv;
        if (!((Collection)unknownArgs).isEmpty()) {
            throw new IllegalStateException("Unknown arguments: " + CollectionsKt.joinToString$default((Iterable)unknownArgs, null, null, null, (int)0, null, null, (int)63, null));
        }
        if (this.contains(WERROR)) {
            arguments.setAllWarningsAsErrors(this.get(WERROR).booleanValue());
        }
        if (this.contains(WEXTRA)) {
            arguments.setExtraWarnings(this.get(WEXTRA).booleanValue());
        }
        if (this.contains(X)) {
            arguments.setExtraHelp(this.get(X).booleanValue());
        }
        if (this.contains(HELP)) {
            arguments.setHelp(this.get(HELP).booleanValue());
        }
        if (this.contains(NOWARN)) {
            arguments.setSuppressWarnings(this.get(NOWARN).booleanValue());
        }
        if (this.contains(VERBOSE)) {
            arguments.setVerbose(this.get(VERBOSE).booleanValue());
        }
        if (this.contains(VERSION)) {
            arguments.setVersion(this.get(VERSION).booleanValue());
        }
        return arguments;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyCompilerArguments(@NotNull CommonToolArguments arguments) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        try {
            this.set(WERROR, Boolean.valueOf(arguments.getAllWarningsAsErrors()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(WEXTRA, Boolean.valueOf(arguments.getExtraWarnings()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(X, Boolean.valueOf(arguments.getExtraHelp()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(HELP, Boolean.valueOf(arguments.getHelp()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(NOWARN, Boolean.valueOf(arguments.getSuppressWarnings()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(VERBOSE, Boolean.valueOf(arguments.getVerbose()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.set(VERSION, Boolean.valueOf(arguments.getVersion()));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        Iterable iterable = arguments.getInternalArguments();
        Set<String> set = this.internalArguments;
        boolean $i$f$map = false;
        void var4_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ManualLanguageFeatureSetting manualLanguageFeatureSetting = (ManualLanguageFeatureSetting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStringRepresentation());
        }
        set.addAll((List)destination$iv$iv);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl$CommonToolArgument;", "V", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "kotlin-build-tools-impl"})
    public static final class CommonToolArgument<V> {
        @NotNull
        private final String id;

        public CommonToolArgument(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            knownArguments.add(this.id);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl$Companion;", "", "<init>", "()V", "knownArguments", "", "", "WERROR", "Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl$CommonToolArgument;", "", "getWERROR", "()Lorg/jetbrains/kotlin/buildtools/internal/arguments/CommonToolArgumentsImpl$CommonToolArgument;", "WEXTRA", "getWEXTRA", "X", "getX", "HELP", "getHELP", "NOWARN", "getNOWARN", "VERBOSE", "getVERBOSE", "VERSION", "getVERSION", "kotlin-build-tools-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommonToolArgument<Boolean> getWERROR() {
            return WERROR;
        }

        @NotNull
        public final CommonToolArgument<Boolean> getWEXTRA() {
            return WEXTRA;
        }

        @NotNull
        public final CommonToolArgument<Boolean> getX() {
            return X;
        }

        @NotNull
        public final CommonToolArgument<Boolean> getHELP() {
            return HELP;
        }

        @NotNull
        public final CommonToolArgument<Boolean> getNOWARN() {
            return NOWARN;
        }

        @NotNull
        public final CommonToolArgument<Boolean> getVERBOSE() {
            return VERBOSE;
        }

        @NotNull
        public final CommonToolArgument<Boolean> getVERSION() {
            return VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

