/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.trackers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTimeMetric;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.metrics.ValueType;
import org.jetbrains.kotlin.buildtools.api.trackers.BuildMetricsCollector;
import org.jetbrains.kotlin.buildtools.internal.trackers.BuildMetricsReporterAdapterKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030!H\u0016J \u0010\"\u001a\u00020\u00102\u0016\u0010#\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0006\b\u0001\u0012\u00020\u00030!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/trackers/BuildMetricsReporterAdapter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimeMetric;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "collector", "Lorg/jetbrains/kotlin/buildtools/api/trackers/BuildMetricsCollector;", "<init>", "(Lorg/jetbrains/kotlin/buildtools/api/trackers/BuildMetricsCollector;)V", "myBuildTimeStartNs", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "myGcPerformance", "", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "startMeasure", "", "time", "endMeasure", "addTimeMetricNs", "durationNs", "addMetric", "metric", "value", "addTimeMetric", "addGcMetric", "startGcMetric", "name", "endGcMetric", "addAttribute", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "getMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addMetrics", "metrics", "kotlin-build-tools-impl"})
@SourceDebugExtension(value={"SMAP\nBuildMetricsReporterAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildMetricsReporterAdapter.kt\norg/jetbrains/kotlin/buildtools/internal/trackers/BuildMetricsReporterAdapter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n221#2:106\n222#2:108\n221#2,2:109\n221#2,2:111\n221#2,2:113\n1#3:107\n*S KotlinDebug\n*F\n+ 1 BuildMetricsReporterAdapter.kt\norg/jetbrains/kotlin/buildtools/internal/trackers/BuildMetricsReporterAdapter\n*L\n74#1:106\n74#1:108\n77#1:109,2\n80#1:111,2\n83#1:113,2\n*E\n"})
public final class BuildMetricsReporterAdapter
implements BuildMetricsReporter<BuildTimeMetric, BuildPerformanceMetric> {
    @NotNull
    private final BuildMetricsCollector collector;
    @NotNull
    private final HashMap<BuildTimeMetric, Long> myBuildTimeStartNs;
    @NotNull
    private final HashMap<String, GcMetric> myGcPerformance;

    public BuildMetricsReporterAdapter(@NotNull BuildMetricsCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        this.collector = collector2;
        this.myBuildTimeStartNs = new HashMap();
        this.myGcPerformance = new HashMap();
    }

    public void startMeasure(@NotNull BuildTimeMetric time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        if (((Map)this.myBuildTimeStartNs).containsKey(time)) {
            throw new IllegalStateException((time + " was restarted before it finished").toString());
        }
        ((Map)this.myBuildTimeStartNs).put(time, System.nanoTime());
    }

    public void endMeasure(@NotNull BuildTimeMetric time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Long l = this.myBuildTimeStartNs.remove(time);
        if (l == null) {
            throw new IllegalStateException((time + " finished before it started").toString());
        }
        long startNs = l;
        long durationNs = System.nanoTime() - startNs;
        this.collector.collectMetric(time.getReadableString(), BuildMetricsCollector.ValueType.NANOSECONDS, durationNs);
    }

    public void addTimeMetricNs(@NotNull BuildTimeMetric time, long durationNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.collector.collectMetric(time.getReadableString(), BuildMetricsCollector.ValueType.NANOSECONDS, durationNs);
    }

    public void addMetric(@NotNull BuildPerformanceMetric metric, long value) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.collector.collectMetric(metric.getReadableString(), BuildMetricsReporterAdapterKt.access$toMetricsReporterType(metric.getType()), value);
    }

    public void addTimeMetric(@NotNull BuildPerformanceMetric metric) {
        long l;
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        switch (WhenMappings.$EnumSwitchMapping$0[metric.getType().ordinal()]) {
            case 1: {
                l = System.nanoTime();
                break;
            }
            case 2: 
            case 3: {
                l = System.currentTimeMillis();
                break;
            }
            default: {
                throw new IllegalStateException(("Unable to add time metric for '" + metric.getType() + "' type").toString());
            }
        }
        long time = l;
        this.collector.collectMetric(metric.getReadableString(), BuildMetricsReporterAdapterKt.access$toMetricsReporterType(metric.getType()), time);
    }

    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.collector.collectMetric(metric, BuildMetricsCollector.ValueType.MILLISECONDS, value.getTime());
    }

    public void startGcMetric(@NotNull String name, @NotNull GcMetric value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((Map)this.myGcPerformance).containsKey(name)) {
            throw new IllegalStateException((name + " was restarted before it finished").toString());
        }
        ((Map)this.myGcPerformance).put(name, value);
    }

    public void endGcMetric(@NotNull String name, @NotNull GcMetric value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GcMetric gcMetric = this.myGcPerformance.remove(name);
        if (gcMetric == null) {
            throw new IllegalStateException((name + " finished before it started").toString());
        }
        GcMetric startValue = gcMetric;
        GcMetric diff = value.minus(startValue);
        this.collector.collectMetric(name, BuildMetricsCollector.ValueType.MILLISECONDS, diff.getTime());
    }

    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.collector.collectMetric(attribute.getReadableString(), BuildMetricsCollector.ValueType.ATTRIBUTE, 1L);
    }

    @NotNull
    public BuildMetrics<BuildTimeMetric, BuildPerformanceMetric> getMetrics() {
        throw new IllegalStateException("Not supported".toString());
    }

    public void addMetrics(@NotNull BuildMetrics<? extends BuildTimeMetric, ? extends BuildPerformanceMetric> metrics) {
        Object metric;
        Map.Entry entry;
        Map.Entry element$iv;
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        Map $this$forEach$iv = metrics.getBuildAttributes().asMap();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            BuildAttribute attribute = (BuildAttribute)entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            int n = 0;
            while (n < value) {
                int it = n++;
                boolean bl2 = false;
                this.addAttribute(attribute);
            }
        }
        $this$forEach$iv = metrics.getBuildTimes().buildTimesMapMs();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            BuildTimeMetric time = (BuildTimeMetric)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            this.addTimeMetricNs(time, value * (long)1000000);
        }
        $this$forEach$iv = metrics.getBuildPerformanceMetrics().asMap();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            metric = (BuildPerformanceMetric)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            this.addMetric((BuildPerformanceMetric)metric, value);
        }
        $this$forEach$iv = metrics.getGcMetrics().asMap();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            metric = (String)entry.getKey();
            GcMetric value = (GcMetric)entry.getValue();
            this.addGcMetric((String)metric, value);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.NANOSECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.TIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

