/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassDeclaredMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirDeclaredMemberScopeProvider;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "declaredMemberCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirClassDeclaredMemberScope;", "nestedClassifierCache", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "declaredMemberScope", "klass", "useLazyNestedClassifierScope", "", "existingNames", "", "Lorg/jetbrains/kotlin/name/Name;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getClassByClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "nestedClassifierScope", "resolve"})
public final class FirDeclaredMemberScopeProvider
implements FirSessionComponent {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final Map<FirClass, FirClassDeclaredMemberScope> declaredMemberCache;
    @NotNull
    private final Map<FirClass, FirNestedClassifierScope> nestedClassifierCache;

    public FirDeclaredMemberScopeProvider(@NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        this.useSiteSession = useSiteSession;
        this.declaredMemberCache = new LinkedHashMap();
        this.nestedClassifierCache = new LinkedHashMap();
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @Nullable
    public final FirClass getClassByClassId(@NotNull ClassId classId) {
        FirClass clazz;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        for (Map.Entry<FirClass, FirClassDeclaredMemberScope> entry : this.declaredMemberCache.entrySet()) {
            clazz = entry.getKey();
            if (!Intrinsics.areEqual((Object)FirDeclarationUtilKt.getClassId(clazz).getPackageFqName(), (Object)classId.getPackageFqName()) || !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getClassId(clazz).getRelativeClassName(), (Object)classId.getRelativeClassName())) continue;
            return clazz;
        }
        for (Map.Entry<FirClass, FirScope> entry : this.nestedClassifierCache.entrySet()) {
            clazz = entry.getKey();
            if (!Intrinsics.areEqual((Object)FirDeclarationUtilKt.getClassId(clazz).getPackageFqName(), (Object)classId.getPackageFqName()) || !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getClassId(clazz).getRelativeClassName(), (Object)classId.getRelativeClassName())) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public final FirClassDeclaredMemberScope declaredMemberScope(@NotNull FirClass klass, boolean useLazyNestedClassifierScope, @Nullable List<Name> existingNames, @Nullable FirSymbolProvider symbolProvider2) {
        FirClassDeclaredMemberScope firClassDeclaredMemberScope;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Map<FirClass, FirClassDeclaredMemberScope> $this$getOrPut$iv = this.declaredMemberCache;
        boolean $i$f$getOrPut = false;
        FirClassDeclaredMemberScope value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            FirClassDeclaredMemberScope answer$iv = new FirClassDeclaredMemberScope(this.getUseSiteSession(), klass, useLazyNestedClassifierScope, existingNames, symbolProvider2);
            $this$getOrPut$iv.put(klass, answer$iv);
            firClassDeclaredMemberScope = answer$iv;
        } else {
            firClassDeclaredMemberScope = value$iv;
        }
        return firClassDeclaredMemberScope;
    }

    @Nullable
    public final FirNestedClassifierScope nestedClassifierScope(@NotNull FirClass klass) {
        FirNestedClassifierScope firNestedClassifierScope;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Map<FirClass, FirNestedClassifierScope> $this$getOrPutNullable$iv = this.nestedClassifierCache;
        boolean $i$f$getOrPutNullable = false;
        if (!$this$getOrPutNullable$iv.containsKey(klass)) {
            FirNestedClassifierScope firNestedClassifierScope2;
            boolean bl = false;
            FirNestedClassifierScope it = firNestedClassifierScope2 = new FirNestedClassifierScope(klass, this.getUseSiteSession());
            boolean bl2 = false;
            FirNestedClassifierScope answer$iv = !it.isEmpty() ? firNestedClassifierScope2 : null;
            $this$getOrPutNullable$iv.put(klass, answer$iv);
            firNestedClassifierScope = answer$iv;
        } else {
            firNestedClassifierScope = $this$getOrPutNullable$iv.get(klass);
        }
        return firNestedClassifierScope;
    }
}

