/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirExtensionService;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractPhaseTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirAbstractAnnotationResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirAnnotationResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirPartialImportResolveTransformer;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J'\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J'\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%\u00a2\u0006\u0002\u0010&J@\u0010'\u001a\u0012\u0012\b\u0012\u00060)j\u0002`*\u0012\u0004\u0012\u00020\u001e0(*\u00020\u00192\u0010\u0010+\u001a\f\u0012\b\u0012\u00060)j\u0002`*0,2\u0010\u0010-\u001a\f\u0012\b\u0012\u00060)j\u0002`*0,H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompilerRequiredAnnotationsResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractPhaseTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompilerRequiredAnnotationsResolveTransformer$Mode;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "annotationTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirAnnotationResolveTransformer;", "extensionService", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionService;", "getExtensionService", "()Lorg/jetbrains/kotlin/fir/extensions/FirExtensionService;", "importTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPartialImportResolveTransformer;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompilerRequiredAnnotationsResolveTransformer$Mode;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "withFileAndScopes", "T", "f", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "resolveAnnotations", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "annotations", "", "metaAnnotations", "Mode", "resolve"})
public class FirCompilerRequiredAnnotationsResolveTransformer
extends FirAbstractPhaseTransformer<Mode> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirAnnotationResolveTransformer annotationTransformer;
    @NotNull
    private final FirPartialImportResolveTransformer importTransformer;
    @NotNull
    private final FirExtensionService extensionService;

    public FirCompilerRequiredAnnotationsResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        this.session = session2;
        this.annotationTransformer = new FirAnnotationResolveTransformer(this.session, scopeSession);
        this.importTransformer = new FirPartialImportResolveTransformer(this.session);
        this.extensionService = FirExtensionServiceKt.getExtensionService(this.session);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirExtensionService getExtensionService() {
        return this.extensionService;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @NotNull Mode data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        throw new IllegalStateException("Should not be here");
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @NotNull Mode data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this.checkSessionConsistency(file2);
        FirRegisteredPluginAnnotations registeredPluginAnnotations = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session);
        Set<FqName> regularAnnotations = null;
        Set metaAnnotations = null;
        switch (WhenMappings.$EnumSwitchMapping$0[data.ordinal()]) {
            case 1: {
                regularAnnotations = SetsKt.emptySet();
                metaAnnotations = registeredPluginAnnotations.getMetaAnnotations();
                break;
            }
            case 2: {
                regularAnnotations = registeredPluginAnnotations.getAnnotations();
                metaAnnotations = SetsKt.emptySet();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Multimap<FqName, FirRegularClass> newAnnotations = this.resolveAnnotations(file2, regularAnnotations, metaAnnotations);
        if (!newAnnotations.isEmpty()) {
            for (FqName metaAnnotation : newAnnotations.keySet()) {
                Intrinsics.checkNotNullExpressionValue((Object)metaAnnotation, (String)"metaAnnotation");
                Collection<FirRegularClass> collection = newAnnotations.get(metaAnnotation);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"newAnnotations[metaAnnotation]");
                registeredPluginAnnotations.registerUserDefinedAnnotation(metaAnnotation, collection);
            }
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public final <T> T withFileAndScopes(@NotNull FirFile file2, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        FirAnnotationResolveTransformer this_$iv = this.annotationTransformer;
        boolean $i$f$withFile = false;
        FirSpecificTypeResolverTransformer this_$iv$iv = FirAnnotationResolveTransformer.access$getTypeResolverTransformer$p(this_$iv);
        boolean $i$f$withFile2 = false;
        FirFile oldValue$iv$iv = this_$iv$iv.currentFile;
        this_$iv$iv.currentFile = file2;
        try {
            int n;
            Object object;
            void $this$mapTo$iv$iv$iv$iv;
            void $this$map$iv$iv$iv;
            void this_$iv$iv2;
            FirSpecificTypeResolverTransformer $this$withFile_u24lambda_u249$iv = this_$iv$iv;
            boolean bl = false;
            BodyResolveContext bodyResolveContext = FirAnnotationResolveTransformer.access$getArgumentsTransformer$p(this_$iv).getContext();
            SessionHolder holder$iv$iv = FirAnnotationResolveTransformer.access$getArgumentsTransformer$p(this_$iv).getComponents();
            boolean $i$f$withFile3 = false;
            this_$iv$iv2.clear();
            this_$iv$iv2.setFile(file2);
            List<FirScope> scopes$iv$iv$iv = this_$iv$iv2.getFileImportsScope();
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv$iv$iv = scopes$iv$iv$iv.size();
            boolean bl2 = false;
            void this_$iv$iv$iv = this_$iv$iv2;
            boolean $i$f$withTowerDataCleanup = false;
            FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv.getTowerDataContext();
            boolean bl3 = false;
            List importingScopes$iv$iv = ImportingScopesKt.createImportingScopes$default(file2, holder$iv$iv.getSession(), holder$iv$iv.getScopeSession(), false, 8, null);
            CollectionsKt.addAll((Collection)this_$iv$iv2.getFileImportsScope(), (Iterable)importingScopes$iv$iv);
            Iterable iterable = importingScopes$iv$iv;
            void var23_23 = this_$iv$iv2;
            boolean $i$f$map = false;
            void var25_25 = $this$map$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                void it$iv$iv;
                FirScope firScope = (FirScope)item$iv$iv$iv$iv;
                Collection collection = destination$iv$iv$iv$iv;
                boolean bl4 = false;
                collection.add(ImplicitReceiverUtilsKt.asTowerDataElement((FirScope)it$iv$iv, false));
            }
            var23_23.addNonLocalTowerDataElements((List)destination$iv$iv$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            FirAbstractAnnotationResolveTransformer this_$iv2 = this.annotationTransformer;
            boolean $i$f$withFileScopes = false;
            FirAbstractAnnotationResolveTransformer.access$setScopes(this_$iv2, ImportingScopesKt.createImportingScopes(file2, FirAbstractAnnotationResolveTransformer.access$getSession(this_$iv2), FirAbstractAnnotationResolveTransformer.access$getScopeSession(this_$iv2), false));
            Object state$iv = FirAbstractAnnotationResolveTransformer.access$beforeTransformingChildren(this_$iv2, file2);
            try {
                object = f.invoke();
            }
            finally {
                FirAbstractAnnotationResolveTransformer.access$afterTransformingChildren(this_$iv2, state$iv);
            }
            Object object2 = object;
            this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
            Object object3 = object2;
            int n2 = scopes$iv$iv$iv.size();
            int n3 = n = n2 >= sizeBefore$iv$iv$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = n2 - sizeBefore$iv$iv$iv;
            for (int i = 0; i < n; ++i) {
                List<FirScope> list2 = scopes$iv$iv$iv;
                list2.remove(list2.size() - 1);
            }
            Object object4 = object3;
            return (T)object4;
            {
                catch (Throwable throwable) {
                    try {
                        this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        int n4;
                        int size$iv$iv$iv = scopes$iv$iv$iv.size();
                        int n5 = n4 = size$iv$iv$iv >= sizeBefore$iv$iv$iv ? 1 : 0;
                        if (_Assertions.ENABLED && n4 == 0) {
                            String string3 = "Assertion failed";
                            throw new AssertionError((Object)string3);
                        }
                        n4 = size$iv$iv$iv - sizeBefore$iv$iv$iv;
                        int n6 = 0;
                        while (n6 < n4) {
                            int it$iv$iv$iv = n6++;
                            boolean bl7 = false;
                            List<FirScope> it$iv$iv$iv2 = scopes$iv$iv$iv;
                            boolean bl8 = false;
                            it$iv$iv$iv2.remove(it$iv$iv$iv2.size() - 1);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            this_$iv$iv.currentFile = oldValue$iv$iv;
        }
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @NotNull Mode data) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, (String)"create()");
        return this.annotationTransformer.transformRegularClass(regularClass, linkedHashMultimap);
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Mode data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, (String)"create()");
        return this.annotationTransformer.transformTypeAlias(typeAlias, linkedHashMultimap);
    }

    private final Multimap<FqName, FirRegularClass> resolveAnnotations(FirFile $this$resolveAnnotations, Set<FqName> annotations2, Set<FqName> metaAnnotations) {
        Set acceptableNames = SetsKt.plus(annotations2, (Iterable)metaAnnotations);
        this.importTransformer.setAcceptableFqNames(acceptableNames);
        $this$resolveAnnotations.transformImports(this.importTransformer, null);
        this.annotationTransformer.setAcceptableFqNames(acceptableNames);
        this.annotationTransformer.setMetaAnnotations(metaAnnotations);
        LinkedHashMultimap newAnnotations = LinkedHashMultimap.create();
        FirTransformer firTransformer = this.annotationTransformer;
        Intrinsics.checkNotNullExpressionValue(newAnnotations, (String)"newAnnotations");
        $this$resolveAnnotations.transform(firTransformer, newAnnotations);
        return newAnnotations;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompilerRequiredAnnotationsResolveTransformer$Mode;", "", "(Ljava/lang/String;I)V", "MetaAnnotations", "RegularAnnotations", "resolve"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode MetaAnnotations = new Mode();
        public static final /* enum */ Mode RegularAnnotations = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value2) {
            return Enum.valueOf(Mode.class, value2);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.MetaAnnotations, Mode.RegularAnnotations};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.MetaAnnotations.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.RegularAnnotations.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

