/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.OldResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForImplicitConstructorDelegationCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolutionOldInference;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.PerformanceCounter;

public class CallResolver {
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private ArgumentTypeResolver argumentTypeResolver;
    private GenericCandidateResolver genericCandidateResolver;
    private CallCompleter callCompleter;
    private SyntheticScopes syntheticScopes;
    private NewResolutionOldInference newResolutionOldInference;
    private PSICallResolver PSICallResolver;
    private final DataFlowValueFactory dataFlowValueFactory;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private static final PerformanceCounter callResolvePerfCounter = PerformanceCounter.Companion.create("Call resolve", ExpressionTypingVisitorDispatcher.typeInfoPerfCounter);

    public CallResolver(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        if (builtIns == null) {
            CallResolver.$$$reportNull$$$0(0);
        }
        if (languageVersionSettings2 == null) {
            CallResolver.$$$reportNull$$$0(1);
        }
        if (dataFlowValueFactory == null) {
            CallResolver.$$$reportNull$$$0(2);
        }
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings2;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            CallResolver.$$$reportNull$$$0(3);
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            CallResolver.$$$reportNull$$$0(4);
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            CallResolver.$$$reportNull$$$0(5);
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setGenericCandidateResolver(GenericCandidateResolver genericCandidateResolver) {
        this.genericCandidateResolver = genericCandidateResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        if (callCompleter == null) {
            CallResolver.$$$reportNull$$$0(6);
        }
        this.callCompleter = callCompleter;
    }

    @Inject
    public void setResolutionOldInference(@NotNull NewResolutionOldInference newResolutionOldInference) {
        if (newResolutionOldInference == null) {
            CallResolver.$$$reportNull$$$0(7);
        }
        this.newResolutionOldInference = newResolutionOldInference;
    }

    @Inject
    public void setPSICallResolver(@NotNull PSICallResolver PSICallResolver2) {
        if (PSICallResolver2 == null) {
            CallResolver.$$$reportNull$$$0(8);
        }
        this.PSICallResolver = PSICallResolver2;
    }

    @Inject
    public void setSyntheticScopes(@NotNull SyntheticScopes syntheticScopes) {
        if (syntheticScopes == null) {
            CallResolver.$$$reportNull$$$0(9);
        }
        this.syntheticScopes = syntheticScopes;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(10);
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof KtSimpleNameExpression);
        KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, referencedName, nameExpression, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Variable.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(11);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<CallableDescriptor> resolveCallForMember(@NotNull KtSimpleNameExpression nameExpression, @NotNull BasicCallResolutionContext context) {
        if (nameExpression == null) {
            CallResolver.$$$reportNull$$$0(12);
        }
        if (context == null) {
            CallResolver.$$$reportNull$$$0(13);
        }
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, nameExpression.getReferencedNameAsName(), nameExpression, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.CallableReference.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(14);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context, @NotNull Call call2, @NotNull KtReferenceExpression functionReference2, @NotNull Name name) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(15);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(16);
        }
        if (functionReference2 == null) {
            CallResolver.$$$reportNull$$$0(17);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(18);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(callResolutionContext, name, functionReference2, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(19);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context, @NotNull Call call2, @NotNull Name name, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(20);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(21);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(22);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(23);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(callResolutionContext, name, tracing, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(24);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(25);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(26);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, OperatorNameConventions.INVOKE, tracing, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Invoke.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(27);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull KtReferenceExpression referenceExpression2, @NotNull NewResolutionOldInference.ResolutionKind kind) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(28);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(29);
        }
        if (referenceExpression2 == null) {
            CallResolver.$$$reportNull$$$0(30);
        }
        if (kind == null) {
            CallResolver.$$$reportNull$$$0(31);
        }
        TracingStrategy tracing = TracingStrategyImpl.create(referenceExpression2, context.call);
        OverloadResolutionResults<D> overloadResolutionResults = this.computeTasksAndResolveCall(context, name, tracing, kind);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(32);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull TracingStrategy tracing, @NotNull NewResolutionOldInference.ResolutionKind kind) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(33);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(34);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(35);
        }
        if (kind == null) {
            CallResolver.$$$reportNull$$$0(36);
        }
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            ResolutionTask resolutionTask = new ResolutionTask(kind, name, null);
            return this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
        });
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(37);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression referenceExpression2, @NotNull Collection<OldResolutionCandidate<D>> candidates2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(38);
        }
        if (referenceExpression2 == null) {
            CallResolver.$$$reportNull$$$0(39);
        }
        if (candidates2 == null) {
            CallResolver.$$$reportNull$$$0(40);
        }
        return this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, TracingStrategyImpl.create(referenceExpression2, context.call));
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull Collection<OldResolutionCandidate<D>> candidates2, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(41);
        }
        if (candidates2 == null) {
            CallResolver.$$$reportNull$$$0(42);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(43);
        }
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
        });
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(44);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context, ExpressionReceiver receiver, KtBinaryExpression binaryExpression, Name name) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(45);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCollectionLiteralCallWithGivenDescriptor(@NotNull ExpressionTypingContext context, @NotNull KtCollectionLiteralExpression expression2, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(46);
        }
        if (expression2 == null) {
            CallResolver.$$$reportNull$$$0(47);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(48);
        }
        if (functionDescriptors2 == null) {
            CallResolver.$$$reportNull$$$0(49);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List candidates2 = CollectionsKt.map(functionDescriptors2, descriptor2 -> OldResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null));
        return this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, candidates2, TracingStrategyImpl.create(expression2, call2));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveEqualsCallWithGivenDescriptors(@NotNull ExpressionTypingContext context, @NotNull KtReferenceExpression expression2, @NotNull ExpressionReceiver receiver, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(50);
        }
        if (expression2 == null) {
            CallResolver.$$$reportNull$$$0(51);
        }
        if (receiver == null) {
            CallResolver.$$$reportNull$$$0(52);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(53);
        }
        if (functionDescriptors2 == null) {
            CallResolver.$$$reportNull$$$0(54);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List resolutionCandidates = CollectionsKt.map(functionDescriptors2, descriptor2 -> OldResolutionCandidate.create(call2, descriptor2, receiver, ExplicitReceiverKind.DISPATCH_RECEIVER, null));
        return this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, resolutionCandidates, TracingStrategyImpl.create(expression2, call2));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull Call call2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext, @Nullable InferenceSession inferenceSession) {
        if (trace == null) {
            CallResolver.$$$reportNull$$$0(55);
        }
        if (scope2 == null) {
            CallResolver.$$$reportNull$$$0(56);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(57);
        }
        if (expectedType == null) {
            CallResolver.$$$reportNull$$$0(58);
        }
        if (dataFlowInfo == null) {
            CallResolver.$$$reportNull$$$0(59);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope2, call2, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, isAnnotationContext, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession != null ? inferenceSession : InferenceSession.Companion.getDefault()));
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(60);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(61);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Call.CallType callType = context.call.getCallType();
        if (callType == Call.CallType.ARRAY_GET_METHOD || callType == Call.CallType.ARRAY_SET_METHOD) {
            Name name = callType == Call.CallType.ARRAY_GET_METHOD ? OperatorNameConventions.GET : OperatorNameConventions.SET;
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)context.call.getCallElement();
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, name, arrayAccessExpression, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
            if (overloadResolutionResults == null) {
                CallResolver.$$$reportNull$$$0(62);
            }
            return overloadResolutionResults;
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression expression2 = (KtSimpleNameExpression)calleeExpression;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, expression2.getReferencedNameAsName(), expression2, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
            if (overloadResolutionResults == null) {
                CallResolver.$$$reportNull$$$0(63);
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorCalleeExpression) {
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForConstructor(context, (KtConstructorCalleeExpression)calleeExpression);
            if (overloadResolutionResults == null) {
                CallResolver.$$$reportNull$$$0(64);
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorDelegationReferenceExpression) {
            KtConstructorDelegationCall delegationCall = (KtConstructorDelegationCall)context.call.getCallElement();
            DeclarationDescriptor container = context.scope.getOwnerDescriptor();
            assert (container instanceof ConstructorDescriptor) : "Trying to resolve KtConstructorDelegationCall not in constructor. scope.ownerDescriptor = " + container;
            return this.resolveConstructorDelegationCall(context, delegationCall, (KtConstructorDelegationReferenceExpression)calleeExpression, (ClassDescriptor)container.getContainingDeclaration());
        }
        if (calleeExpression == null) {
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(65);
            }
            return overloadResolutionResultsImpl;
        }
        SimpleType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        if (calleeExpression instanceof KtLambdaExpression) {
            int parameterNumber = ((KtLambdaExpression)calleeExpression).getValueParameters().size();
            ArrayList<SimpleType> parameterTypes = new ArrayList<SimpleType>(parameterNumber);
            for (int i = 0; i < parameterNumber; ++i) {
                parameterTypes.add(TypeUtils.NO_EXPECTED_TYPE);
            }
            expectedType = FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), parameterTypes, null, context.expectedType);
        }
        KotlinType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, expectedType, context.dataFlowInfo, context.inferenceSession, context.trace);
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(calleeExpression, calleeType, context.trace.getBindingContext());
        CallTransformer.CallForImplicitInvoke call2 = new CallTransformer.CallForImplicitInvoke(context.call.getExplicitReceiver(), expressionReceiver, context.call, false);
        TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, call2, calleeType);
        return this.resolveCallForInvoke(context.replaceCall(call2), tracingForInvoke);
    }

    private OverloadResolutionResults<ConstructorDescriptor> resolveCallForConstructor(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorCalleeExpression expression2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(66);
        }
        if (expression2 == null) {
            CallResolver.$$$reportNull$$$0(67);
        }
        assert (context.call.getExplicitReceiver() == null) : "Constructor can't be invoked with explicit receiver: " + context.call.getCallElement().getText();
        context.trace.record(BindingContext.LEXICAL_SCOPE, context.call.getCallElement(), context.scope);
        KtSimpleNameExpression functionReference2 = expression2.getConstructorReferenceExpression();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (functionReference2 == null || typeReference == null) {
            CallResolverUtilKt.checkForConstructorCallOnFunctionalType(typeReference, context);
            return this.checkArgumentTypesAndFail(context);
        }
        KotlinType constructedType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        if (KotlinTypeKt.isError(constructedType)) {
            return this.checkArgumentTypesAndFail(context);
        }
        ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            context.trace.report(Errors.NOT_A_CLASS.on(expression2));
            return this.checkArgumentTypesAndFail(context);
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        Collection<ClassConstructorDescriptor> constructors2 = classDescriptor2.getConstructors();
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            return this.checkArgumentTypesAndFail(context);
        }
        return this.resolveConstructorCall(context, functionReference2, constructedType);
    }

    @NotNull
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression functionReference2, @NotNull KotlinType constructedType) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(68);
        }
        if (functionReference2 == null) {
            CallResolver.$$$reportNull$$$0(69);
        }
        if (constructedType == null) {
            CallResolver.$$$reportNull$$$0(70);
        }
        Pair<Collection<OldResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(constructedType, context, this.syntheticScopes);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        return this.computeTasksFromCandidatesAndResolvedCall(context, functionReference2, candidates2);
    }

    @Nullable
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull KtConstructorDelegationCall call2, @Nullable InferenceSession inferenceSession) {
        if (trace == null) {
            CallResolver.$$$reportNull$$$0(71);
        }
        if (scope2 == null) {
            CallResolver.$$$reportNull$$$0(72);
        }
        if (dataFlowInfo == null) {
            CallResolver.$$$reportNull$$$0(73);
        }
        if (constructorDescriptor == null) {
            CallResolver.$$$reportNull$$$0(74);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(75);
        }
        BasicCallResolutionContext context = BasicCallResolutionContext.create(trace, scope2, CallMaker.makeCall(null, null, call2), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession != null ? inferenceSession : InferenceSession.Companion.getDefault());
        KtConstructorDelegationReferenceExpression calleeExpression = call2.getCalleeExpression();
        if (calleeExpression == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        ClassDescriptor currentClassDescriptor = constructorDescriptor.getContainingDeclaration();
        if (constructorDescriptor.getConstructedClass().getKind() == ClassKind.ENUM_CLASS && call2.isImplicit()) {
            if (currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
                DiagnosticFactory0<PsiElement> warningOrError = this.languageVersionSettings.supportsFeature(LanguageFeature.RequiredPrimaryConstructorDelegationCallInEnums) ? Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED : Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED_IN_ENUM;
                PsiElement reportOn = this.calcReportOn(calleeExpression);
                context.trace.report(warningOrError.on(reportOn));
            }
            return null;
        }
        return this.resolveConstructorDelegationCall(context, call2, call2.getCalleeExpression(), currentClassDescriptor);
    }

    @NotNull
    private OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorDelegationCall call2, @NotNull KtConstructorDelegationReferenceExpression calleeExpression, @NotNull ClassDescriptor currentClassDescriptor) {
        KtElementImpl reportOn;
        if (context == null) {
            CallResolver.$$$reportNull$$$0(76);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(77);
        }
        if (calleeExpression == null) {
            CallResolver.$$$reportNull$$$0(78);
        }
        if (currentClassDescriptor == null) {
            CallResolver.$$$reportNull$$$0(79);
        }
        context.trace.record(BindingContext.LEXICAL_SCOPE, call2, context.scope);
        boolean isThisCall = calleeExpression.isThis();
        if (currentClassDescriptor.getKind() == ClassKind.ENUM_CLASS && !isThisCall) {
            context.trace.report(Errors.DELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR.on(calleeExpression));
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(80);
            }
            return overloadResolutionResultsImpl;
        }
        ClassDescriptor delegateClassDescriptor = isThisCall ? currentClassDescriptor : DescriptorUtilsKt.getSuperClassOrAny(currentClassDescriptor);
        Collection<ClassConstructorDescriptor> constructors2 = delegateClassDescriptor.getConstructors();
        if (!isThisCall && currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            if (DescriptorUtils.canHaveDeclaredConstructors(currentClassDescriptor)) {
                PsiElement reportOn2 = this.calcReportOn(calleeExpression);
                context.trace.report(Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED.on(reportOn2));
            }
            if (call2.isImplicit()) {
                OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
                if (overloadResolutionResultsImpl == null) {
                    CallResolver.$$$reportNull$$$0(81);
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(82);
            }
            return overloadResolutionResultsImpl;
        }
        KotlinType superType2 = isThisCall ? currentClassDescriptor.getDefaultType() : DescriptorUtils.getSuperClassType(currentClassDescriptor);
        Pair<Collection<OldResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(superType2, context, this.syntheticScopes);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        TracingStrategy tracing = call2.isImplicit() ? new TracingStrategyForImplicitConstructorDelegationCall(call2, context.call) : TracingStrategyImpl.create(calleeExpression, context.call);
        KtElementImpl ktElementImpl = reportOn = call2.isImplicit() ? call2 : calleeExpression;
        if (delegateClassDescriptor.isInner() && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, reportOn, (ClassDescriptor)delegateClassDescriptor.getContainingDeclaration())) {
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(83);
            }
            return overloadResolutionResultsImpl;
        }
        return this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, tracing);
    }

    @Nullable
    private PsiElement calcReportOn(@NotNull KtConstructorDelegationReferenceExpression calleeExpression) {
        if (calleeExpression == null) {
            CallResolver.$$$reportNull$$$0(84);
        }
        PsiElement delegationCall = calleeExpression.getParent();
        return CallResolverUtilKt.reportOnElement(delegationCall);
    }

    @NotNull
    private static Pair<Collection<OldResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> prepareCandidatesAndContextForConstructorCall(@NotNull KotlinType superType2, @NotNull BasicCallResolutionContext context, @NotNull SyntheticScopes syntheticScopes) {
        if (superType2 == null) {
            CallResolver.$$$reportNull$$$0(85);
        }
        if (context == null) {
            CallResolver.$$$reportNull$$$0(86);
        }
        if (syntheticScopes == null) {
            CallResolver.$$$reportNull$$$0(87);
        }
        if (!(superType2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return new Pair(Collections.emptyList(), (Object)context);
        }
        boolean anyConstructorHasDeclaredTypeParameters = CallResolver.anyConstructorHasDeclaredTypeParameters(superType2.getConstructor().getDeclarationDescriptor());
        if (anyConstructorHasDeclaredTypeParameters) {
            context = (BasicCallResolutionContext)context.replaceExpectedType(superType2);
        }
        List<OldResolutionCandidate<ConstructorDescriptor>> candidates2 = CallResolverUtilKt.createResolutionCandidatesForConstructors(context.scope, context.call, superType2, !anyConstructorHasDeclaredTypeParameters, syntheticScopes);
        return new Pair(candidates2, (Object)context);
    }

    private static boolean anyConstructorHasDeclaredTypeParameters(@Nullable ClassifierDescriptor classDescriptor2) {
        if (!(classDescriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        for (ConstructorDescriptor constructorDescriptor : ((ClassDescriptor)classDescriptor2).getConstructors()) {
            if (constructorDescriptor.getTypeParameters().size() <= constructorDescriptor.getContainingDeclaration().getDeclaredTypeParameters().size()) continue;
            return true;
        }
        return false;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(@NotNull Call call2, @NotNull TracingStrategy tracing, @NotNull ResolutionContext<?> context, @NotNull OldResolutionCandidate<FunctionDescriptor> candidate2, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(88);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(89);
        }
        if (context == null) {
            CallResolver.$$$reportNull$$$0(90);
        }
        if (candidate2 == null) {
            CallResolver.$$$reportNull$$$0(91);
        }
        return (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, dataFlowInfoForArguments);
            Set<OldResolutionCandidate> candidates2 = Collections.singleton(candidate2);
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(basicCallResolutionContext, resolutionTask, tracing);
        });
    }

    private <D extends CallableDescriptor> OverloadResolutionResults<D> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(92);
        }
        if (resolutionTask == null) {
            CallResolver.$$$reportNull$$$0(93);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(94);
        }
        Call call2 = context.call;
        tracing.bindCall(context.trace, call2);
        boolean newInferenceEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
        NewResolutionOldInference.ResolutionKind resolutionKind = resolutionTask.resolutionKind;
        if (newInferenceEnabled && this.PSICallResolver.getDefaultResolutionKinds().contains(resolutionKind)) {
            assert (resolutionTask.name != null);
            BindingContextUtilsKt.recordScope(context.trace, context.scope, context.call.getCalleeExpression());
            return this.PSICallResolver.runResolutionAndInference(context, resolutionTask.name, resolutionKind, tracing);
        }
        if (newInferenceEnabled && resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates) {
            assert (resolutionTask.givenCandidates != null);
            BindingContextUtilsKt.recordScope(context.trace, context.scope, context.call.getCalleeExpression());
            return this.PSICallResolver.runResolutionAndInferenceForGivenCandidates(context, resolutionTask.givenCandidates, tracing);
        }
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context.trace, "trace to resolve call", call2);
        BasicCallResolutionContext newContext = (BasicCallResolutionContext)context.replaceBindingTrace(traceToResolveCall);
        BindingContextUtilsKt.recordScope(newContext.trace, newContext.scope, newContext.call.getCalleeExpression());
        BindingContextUtilsKt.recordDataFlowInfo(newContext, newContext.call.getCalleeExpression());
        OverloadResolutionResultsImpl<D> results = this.doResolveCall(newContext, resolutionTask, tracing);
        if (BuilderInferenceUtilKt.isResultWithBuilderInference(results)) {
            traceToResolveCall.commit();
            return results;
        }
        DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
        if (deltasTraceForTypeInference != null) {
            deltasTraceForTypeInference.addOwnDataTo(traceToResolveCall);
        }
        this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            CallResolver.cacheResults(context, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            results = this.callCompleter.completeCall(context, results, tracing);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(95);
        }
        if (results == null) {
            CallResolver.$$$reportNull$$$0(96);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(97);
        }
        if (CallResolverUtilKt.isInvokeCallOnVariable(context.call)) {
            return;
        }
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall(), context, tracing);
        this.genericCandidateResolver.completeTypeInferenceDependentOnFunctionArgumentsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        Call call2;
        if (context == null) {
            CallResolver.$$$reportNull$$$0(98);
        }
        if (results == null) {
            CallResolver.$$$reportNull$$$0(99);
        }
        if (traceToResolveCall == null) {
            CallResolver.$$$reportNull$$$0(100);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(101);
        }
        if (CallResolverUtilKt.isInvokeCallOnVariable(call2 = context.call)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context.call, BindingTraceFilter.Companion.getACCEPT_ALL(), false);
        traceToResolveCall.addOwnDataTo(deltasTraceToCacheResolve);
        context.resolutionResultsCache.record(call2, results, context, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        DeclarationDescriptor declaration;
        Object descriptor2;
        OverloadResolutionResultsImpl result2;
        if (context == null) {
            CallResolver.$$$reportNull$$$0(102);
        }
        if (resolutionTask == null) {
            CallResolver.$$$reportNull$$$0(103);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(104);
        }
        DataFlowInfo initialInfo = context.dataFlowInfoForArguments.getResultInfo();
        if (context.checkArguments == CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        }
        List<KtTypeProjection> typeArguments = context.call.getTypeArguments();
        for (KtTypeProjection projection : typeArguments) {
            KotlinType type2;
            if (projection.getProjectionKind() != KtProjectionKind.NONE) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                ModifierCheckerCore.INSTANCE.check(projection, context.trace, null, this.languageVersionSettings);
            }
            if ((type2 = this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context.scope, context.trace, null)) == null) continue;
            ForceResolveUtil.forceResolveAllContents(type2);
        }
        if (!(resolutionTask.resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates)) {
            assert (resolutionTask.name != null);
            result2 = this.newResolutionOldInference.runResolution(context, resolutionTask.name, resolutionTask.resolutionKind, tracing);
        } else {
            assert (resolutionTask.givenCandidates != null);
            result2 = this.newResolutionOldInference.runResolutionForGivenCandidates(context, tracing, resolutionTask.givenCandidates);
        }
        if (this.languageVersionSettings.getFlag(AnalysisFlags.getIgnoreDataFlowInAssert()).booleanValue() && result2.isSingleResult() && (descriptor2 = result2.getResultingDescriptor()).getName().equals(Name.identifier("assert")) && (declaration = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor && ((PackageFragmentDescriptor)declaration).getFqName().asString().equals("kotlin")) {
            context.dataFlowInfoForArguments.updateInfo(context.call.getValueArguments().get(0), initialInfo);
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = result2;
        if (overloadResolutionResultsImpl == null) {
            CallResolver.$$$reportNull$$$0(105);
        }
        return overloadResolutionResultsImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 37: 
            case 44: 
            case 45: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 105: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 37: 
            case 44: 
            case 45: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 105: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowValueFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypeResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callCompleter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResolutionOldInference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "PSICallResolver";
                break;
            }
            case 9: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntheticScopes";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 25: 
            case 28: 
            case 33: 
            case 38: 
            case 41: 
            case 46: 
            case 50: 
            case 61: 
            case 66: 
            case 68: 
            case 76: 
            case 86: 
            case 90: 
            case 92: 
            case 95: 
            case 98: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 14: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 37: 
            case 44: 
            case 45: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/CallResolver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 16: 
            case 21: 
            case 48: 
            case 53: 
            case 57: 
            case 75: 
            case 77: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 17: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 18: 
            case 22: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 26: 
            case 35: 
            case 43: 
            case 89: 
            case 94: 
            case 97: 
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracing";
                break;
            }
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 47: 
            case 51: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptors";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 55: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 56: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 59: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructedType";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorDescriptor";
                break;
            }
            case 78: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeExpression";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentClassDescriptor";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 93: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolutionTask";
                break;
            }
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceToResolveCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/CallResolver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleProperty";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallForMember";
                break;
            }
            case 19: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallWithGivenName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallForInvoke";
                break;
            }
            case 32: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTasksAndResolveCall";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTasksFromCandidatesAndResolvedCall";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBinaryCall";
                break;
            }
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunctionCall";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorDelegationCall";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionTypingServices";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTypeResolver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setArgumentTypeResolver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCallCompleter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setResolutionOldInference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPSICallResolver";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSyntheticScopes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleProperty";
                break;
            }
            case 11: 
            case 14: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 37: 
            case 44: 
            case 45: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 105: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallForMember";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallWithGivenName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallForInvoke";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "computeTasksAndResolveCall";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "computeTasksFromCandidatesAndResolvedCall";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveCollectionLiteralCallWithGivenDescriptor";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "resolveEqualsCallWithGivenDescriptors";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionCall";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallForConstructor";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorCall";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorDelegationCall";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "calcReportOn";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "prepareCandidatesAndContextForConstructorCall";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallWithKnownCandidate";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "doResolveCallOrGetCachedResults";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "completeTypeInferenceDependentOnFunctionLiterals";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "cacheResults";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "doResolveCall";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 14: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 37: 
            case 44: 
            case 45: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 105: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResolutionTask<D extends CallableDescriptor> {
        @Nullable
        final Name name;
        @Nullable
        final Collection<OldResolutionCandidate<D>> givenCandidates;
        @NotNull
        final NewResolutionOldInference.ResolutionKind resolutionKind;

        private ResolutionTask(@NotNull NewResolutionOldInference.ResolutionKind kind, @Nullable Name name, @Nullable Collection<OldResolutionCandidate<D>> candidates2) {
            if (kind == null) {
                ResolutionTask.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.givenCandidates = candidates2;
            this.resolutionKind = kind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver$ResolutionTask", "<init>"));
        }
    }
}

