/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002\u001a\u001b\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0010*\u00020\u0002\u001a\u001a\u0010\u0013\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u001a\n\u0010\u0017\u001a\u00020\u0010*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0010*\u00020\u0018\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00f2\u0001\u0004\n\u00020\u0004\u00a8\u0006\u001c"}, d2={"containingPackage", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findContinuationClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "lookupLocation", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "findContinuationClassDescriptorOrNull", "getContinuationOfTypeOrAny", "Lorg/jetbrains/kotlin/types/SimpleType;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTopLevelContainingClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "isSealed", "", "isSupportedForCallableReference", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isTopLevelInPackage", "name", "", "packageName", "isTypedEqualsInValueClass", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "overridesEqualsFromAny", "resolveClassByFqName", "fqName", "descriptors"})
@SourceDebugExtension(value={"SMAP\ndescriptorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 descriptorUtil.kt\norg/jetbrains/kotlin/descriptors/DescriptorUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,108:1\n1#2:109\n19#3:110\n*S KotlinDebug\n*F\n+ 1 descriptorUtil.kt\norg/jetbrains/kotlin/descriptors/DescriptorUtilKt\n*L\n38#1:110\n*E\n"})
public final class DescriptorUtilKt {
    @Nullable
    public static final ClassDescriptor resolveClassByFqName(@NotNull ModuleDescriptor $this$resolveClassByFqName, @NotNull FqName fqName2, @NotNull LookupLocation lookupLocation) {
        ClassifierDescriptor classifierDescriptor;
        MemberScope memberScope2;
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter((Object)$this$resolveClassByFqName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        if (fqName2.isRoot()) {
            return null;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
        MemberScope memberScope3 = $this$resolveClassByFqName.getPackage(fqName3).getMemberScope();
        Name name = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"fqName.shortName()");
        ClassifierDescriptor classifierDescriptor2 = memberScope3.getContributedClassifier(name, lookupLocation);
        ClassDescriptor classDescriptor3 = classDescriptor2 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
        if (classDescriptor2 != null) {
            ClassDescriptor it = classDescriptor2;
            boolean bl = false;
            return it;
        }
        FqName fqName4 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"fqName.parent()");
        classifierDescriptor2 = DescriptorUtilKt.resolveClassByFqName($this$resolveClassByFqName, fqName4, lookupLocation);
        if (classifierDescriptor2 != null && (memberScope2 = classifierDescriptor2.getUnsubstitutedInnerClassesScope()) != null) {
            Name name2 = fqName2.shortName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"fqName.shortName()");
            classifierDescriptor = memberScope2.getContributedClassifier(name2, lookupLocation);
        } else {
            classifierDescriptor = null;
        }
        classDescriptor2 = classifierDescriptor;
        return classDescriptor2 instanceof ClassDescriptor ? classDescriptor2 : null;
    }

    @Nullable
    public static final ClassDescriptor findContinuationClassDescriptorOrNull(@NotNull ModuleDescriptor $this$findContinuationClassDescriptorOrNull, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$findContinuationClassDescriptorOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        return DescriptorUtilKt.resolveClassByFqName($this$findContinuationClassDescriptorOrNull, StandardNames.CONTINUATION_INTERFACE_FQ_NAME, lookupLocation);
    }

    @NotNull
    public static final ClassDescriptor findContinuationClassDescriptor(@NotNull ModuleDescriptor $this$findContinuationClassDescriptor, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$findContinuationClassDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        ClassDescriptor $this$sure$iv = DescriptorUtilKt.findContinuationClassDescriptorOrNull($this$findContinuationClassDescriptor, lookupLocation);
        boolean $i$f$sure = false;
        ClassDescriptor classDescriptor2 = $this$sure$iv;
        if (classDescriptor2 == null) {
            boolean bl = false;
            String string2 = "Continuation interface is not found";
            throw new AssertionError((Object)string2);
        }
        return classDescriptor2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SimpleType getContinuationOfTypeOrAny(@NotNull ModuleDescriptor $this$getContinuationOfTypeOrAny, @NotNull KotlinType kotlinType) {
        SimpleType simpleType2;
        SimpleType simpleType3;
        Intrinsics.checkNotNullParameter((Object)$this$getContinuationOfTypeOrAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        ClassDescriptor classDescriptor2 = DescriptorUtilKt.findContinuationClassDescriptorOrNull(DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny), NoLookupLocation.FROM_DESERIALIZATION);
        if (classDescriptor2 != null && (simpleType3 = classDescriptor2.getDefaultType()) != null) {
            SimpleType it = simpleType3;
            boolean bl = false;
            SimpleType simpleType4 = KotlinTypeFactory.simpleType$default(it, null, null, CollectionsKt.listOf((Object)TypeUtilsKt.asTypeProjection(kotlinType)), false, 22, null);
            if (simpleType4 != null) {
                simpleType2 = simpleType4;
                return simpleType2;
            }
        }
        SimpleType simpleType5 = DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny).getBuiltIns().getNullableAnyType();
        simpleType2 = simpleType5;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType5, (String)"module.builtIns.nullableAnyType");
        return simpleType2;
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage, @NotNull String name, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelInPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!Intrinsics.areEqual((Object)name, (Object)$this$isTopLevelInPackage.getName().asString())) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = $this$isTopLevelInPackage.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingDeclaration = packageFragmentDescriptor;
        String string2 = containingDeclaration.getFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"containingDeclaration.fqName.asString()");
        String packageFqName = string2;
        return Intrinsics.areEqual((Object)packageName, (Object)packageFqName);
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelInPackage, (String)"<this>");
        return $this$isTopLevelInPackage.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    @Nullable
    public static final ClassifierDescriptor getTopLevelContainingClassifier(@NotNull DeclarationDescriptor $this$getTopLevelContainingClassifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelContainingClassifier, (String)"<this>");
        DeclarationDescriptor containingDeclaration = $this$getTopLevelContainingClassifier.getContainingDeclaration();
        if (containingDeclaration == null || $this$getTopLevelContainingClassifier instanceof PackageFragmentDescriptor) {
            return null;
        }
        return !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration) ? DescriptorUtilKt.getTopLevelContainingClassifier(containingDeclaration) : (containingDeclaration instanceof ClassifierDescriptor ? (ClassifierDescriptor)containingDeclaration : null);
    }

    public static final boolean isSupportedForCallableReference(@NotNull CallableDescriptor $this$isSupportedForCallableReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedForCallableReference, (String)"<this>");
        return $this$isSupportedForCallableReference instanceof PropertyDescriptor || $this$isSupportedForCallableReference instanceof FunctionDescriptor;
    }

    public static final boolean isSealed(@NotNull DeclarationDescriptor $this$isSealed) {
        Intrinsics.checkNotNullParameter((Object)$this$isSealed, (String)"<this>");
        return DescriptorUtils.isSealedClass($this$isSealed);
    }

    @Nullable
    public static final FqName containingPackage(@NotNull DeclarationDescriptor $this$containingPackage) {
        DeclarationDescriptor container;
        Intrinsics.checkNotNullParameter((Object)$this$containingPackage, (String)"<this>");
        for (container = $this$containingPackage.getContainingDeclaration(); container != null && !(container instanceof PackageFragmentDescriptor); container = container.getContainingDeclaration()) {
        }
        DeclarationDescriptor declarationDescriptor = container;
        if (!(declarationDescriptor == null ? true : declarationDescriptor instanceof PackageFragmentDescriptor)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)container;
        return packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTypedEqualsInValueClass(@NotNull FunctionDescriptor $this$isTypedEqualsInValueClass) {
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter((Object)$this$isTypedEqualsInValueClass, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$isTypedEqualsInValueClass.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor3 = (ClassDescriptor)declarationDescriptor;
        Annotated annotated = classDescriptor3;
        if (classDescriptor3 == null) return false;
        ClassDescriptor it = classDescriptor2 = annotated;
        boolean bl = false;
        if (!InlineClassesUtilsKt.isValueClass(it)) return false;
        ClassDescriptor classDescriptor4 = classDescriptor2;
        annotated = classDescriptor4;
        if (classDescriptor4 == null) return false;
        SimpleType simpleType2 = annotated.getDefaultType();
        annotated = simpleType2;
        if (simpleType2 == null) return false;
        if ((annotated = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)annotated)) == null) {
            return false;
        }
        Annotated annotated2 = annotated;
        KotlinType kotlinType = $this$isTypedEqualsInValueClass.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType2 = kotlinType;
        if (!Intrinsics.areEqual((Object)$this$isTypedEqualsInValueClass.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        if (!TypeUtilsKt.isBoolean(returnType2)) {
            if (!TypeUtilsKt.isNothing(returnType2)) return false;
        }
        if ($this$isTypedEqualsInValueClass.getValueParameters().size() != 1) return false;
        KotlinType kotlinType2 = $this$isTypedEqualsInValueClass.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"valueParameters[0].type");
        if (!Intrinsics.areEqual((Object)TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType2), (Object)annotated2)) return false;
        if (!$this$isTypedEqualsInValueClass.getContextReceiverParameters().isEmpty()) return false;
        if ($this$isTypedEqualsInValueClass.getExtensionReceiverParameter() != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean overridesEqualsFromAny(@NotNull FunctionDescriptor $this$overridesEqualsFromAny) {
        Intrinsics.checkNotNullParameter((Object)$this$overridesEqualsFromAny, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$overridesEqualsFromAny.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        if ($this$overridesEqualsFromAny.getValueParameters().size() != 1) return false;
        KotlinType kotlinType = $this$overridesEqualsFromAny.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"valueParameters[0].type");
        if (!TypeUtilsKt.isNullableAny(kotlinType)) return false;
        if (!$this$overridesEqualsFromAny.getContextReceiverParameters().isEmpty()) return false;
        if ($this$overridesEqualsFromAny.getExtensionReceiverParameter() != null) return false;
        return true;
    }
}

