/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.dce.JsUsefulDeclarationProcessor;
import org.jetbrains.kotlin.ir.backend.js.dce.UselessDeclarationsRemover;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetector;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetectorKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\b\u001a\u00020\t2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\f\u001a\u00020\t*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\u000f\u001a\u00020\u000b*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u000b*\u00020\u0010H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\u0015"}, d2={"buildRoots", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "eliminateDeadDeclarations", "", "removeUnusedAssociatedObjects", "", "addRootsTo", "nestedVisitor", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "isConstant", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isKotlinPackage", "unreachableDeclarationMethod", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/js/config/RuntimeDiagnostic;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nDce.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dce.kt\norg/jetbrains/kotlin/ir/backend/js/dce/DceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1855#2:137\n1855#2,2:138\n1856#2:140\n1360#2:141\n1446#2,5:142\n1855#2:147\n1855#2,2:148\n1856#2:150\n*S KotlinDebug\n*F\n+ 1 Dce.kt\norg/jetbrains/kotlin/ir/backend/js/dce/DceKt\n*L\n39#1:137\n40#1:138,2\n39#1:140\n104#1:141\n104#1:142,5\n105#1:147\n106#1:148,2\n105#1:150\n*E\n"})
public final class DceKt {
    public static final void eliminateDeadDeclarations(@NotNull Iterable<? extends IrModuleFragment> modules, @NotNull JsIrBackendContext context, boolean removeUnusedAssociatedObjects) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<IrDeclaration> allRoots = DceKt.buildRoots(modules, context);
        boolean printReachabilityInfo = context.getConfiguration().getBoolean(JSConfigurationKeys.PRINT_REACHABILITY_INFO) || Boolean.getBoolean("kotlin.js.ir.dce.print.reachability.info");
        JsUsefulDeclarationProcessor usefulDeclarationProcessor = new JsUsefulDeclarationProcessor(context, printReachabilityInfo, removeUnusedAssociatedObjects);
        Set<IrDeclaration> usefulDeclarations = usefulDeclarationProcessor.collectDeclarations((Iterable<? extends IrDeclaration>)allRoots);
        UselessDeclarationsRemover uselessDeclarationsProcessor = new UselessDeclarationsRemover(removeUnusedAssociatedObjects, usefulDeclarations, context, context.getDceRuntimeDiagnostic());
        Iterable<? extends IrModuleFragment> $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        Iterator<? extends IrModuleFragment> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IrModuleFragment element$iv;
            IrModuleFragment module2 = element$iv = iterator2.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = module2.getFiles();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrFile it = (IrFile)element$iv2;
                boolean bl2 = false;
                IrVisitorsKt.acceptVoid(it, uselessDeclarationsProcessor);
                context.getPolyfills().saveOnlyIntersectionOfNextDeclarationsFor(it, (Set<? extends IrDeclaration>)usefulDeclarationProcessor.getUsefulPolyfilledDeclarations());
            }
        }
    }

    public static /* synthetic */ void eliminateDeadDeclarations$default(Iterable iterable, JsIrBackendContext jsIrBackendContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        DceKt.eliminateDeadDeclarations(iterable, jsIrBackendContext, bl);
    }

    private static final boolean isConstant(IrField $this$isConstant) {
        Object object = $this$isConstant.getCorrespondingPropertySymbol();
        return object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : false;
    }

    private static final void addRootsTo(IrDeclaration $this$addRootsTo, IrElementVisitorVoid nestedVisitor, JsIrBackendContext context) {
        block16: {
            block19: {
                block20: {
                    block18: {
                        block17: {
                            IrProperty correspondingProperty2;
                            IrProperty irProperty2;
                            block15: {
                                if (!($this$addRootsTo instanceof IrProperty)) break block15;
                                IrField irField = ((IrProperty)$this$addRootsTo).getBackingField();
                                if (irField != null) {
                                    DceKt.addRootsTo(irField, nestedVisitor, context);
                                }
                                IrSimpleFunction irSimpleFunction = ((IrProperty)$this$addRootsTo).getGetter();
                                if (irSimpleFunction != null) {
                                    DceKt.addRootsTo(irSimpleFunction, nestedVisitor, context);
                                }
                                IrSimpleFunction irSimpleFunction2 = ((IrProperty)$this$addRootsTo).getSetter();
                                if (irSimpleFunction2 != null) {
                                    DceKt.addRootsTo(irSimpleFunction2, nestedVisitor, context);
                                }
                                break block16;
                            }
                            if (!IrUtilsKt.isEffectivelyExternal($this$addRootsTo)) break block17;
                            IrDeclaration irDeclaration2 = $this$addRootsTo;
                            if (irDeclaration2 instanceof IrField) {
                                IrPropertySymbol irPropertySymbol = ((IrField)$this$addRootsTo).getCorrespondingPropertySymbol();
                                irProperty2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                            } else if (irDeclaration2 instanceof IrSimpleFunction) {
                                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$addRootsTo).getCorrespondingPropertySymbol();
                                irProperty2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                            } else {
                                irProperty2 = correspondingProperty2 = null;
                            }
                            if (!AnnotationUtilsKt.hasJsPolyfill($this$addRootsTo)) {
                                IrProperty irProperty3 = correspondingProperty2;
                                if (!(irProperty3 != null ? AnnotationUtilsKt.hasJsPolyfill(irProperty3) : false)) {
                                    IrVisitorsKt.acceptVoid($this$addRootsTo, nestedVisitor);
                                }
                            }
                            break block16;
                        }
                        if (!ExportModelGeneratorKt.isExported($this$addRootsTo, context)) break block18;
                        IrVisitorsKt.acceptVoid($this$addRootsTo, nestedVisitor);
                        break block16;
                    }
                    if (!($this$addRootsTo instanceof IrField)) break block19;
                    if (((IrField)$this$addRootsTo).getInitializer() != null && !DceKt.isKotlinPackage((IrField)$this$addRootsTo)) break block20;
                    Object object = ((IrField)$this$addRootsTo).getCorrespondingPropertySymbol();
                    boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null ? ExportModelGeneratorKt.isExported((IrDeclaration)object, context) : false;
                    if (!bl) break block16;
                }
                if (!DceKt.isConstant((IrField)$this$addRootsTo)) {
                    IrVisitorsKt.acceptVoid($this$addRootsTo, nestedVisitor);
                }
                break block16;
            }
            if ($this$addRootsTo instanceof IrSimpleFunction) {
                Object object = ((IrSimpleFunction)$this$addRootsTo).getCorrespondingPropertySymbol();
                if (object == null || (object = (IrProperty)object.getOwner()) == null) {
                    return;
                }
                Object correspondingProperty3 = object;
                if (ExportModelGeneratorKt.isExported((IrDeclaration)correspondingProperty3, context)) {
                    IrVisitorsKt.acceptVoid($this$addRootsTo, nestedVisitor);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IrDeclaration> buildRoots(Iterable<? extends IrModuleFragment> modules, JsIrBackendContext context) {
        void $this$flatMapTo$iv$iv;
        List list2;
        List $this$buildRoots_u24lambda_u246 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        IrElementVisitorVoid declarationsCollector2 = new IrElementVisitorVoid($this$buildRoots_u24lambda_u246){
            final /* synthetic */ List<IrDeclaration> $this_buildList;
            {
                this.$this_buildList = $receiver;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitBody(@NotNull IrBody body2) {
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                this.$this_buildList.add(declaration);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClass(@NotNull IrClass declaration) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
            }

            public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConst(@NotNull IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
            }

            public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
            }

            public void visitField(@NotNull IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
            }

            public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        };
        Iterable<? extends IrModuleFragment> $this$flatMap$iv = modules;
        boolean $i$f$flatMap = false;
        Iterable<? extends IrModuleFragment> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allFiles = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)context.getPackageLevelJsModules()), (Iterable)context.getExternalPackageFragment().values());
        Iterable $this$forEach$iv = allFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFile file2 = (IrFile)element$iv;
            boolean bl3 = false;
            Iterable $this$forEach$iv2 = file2.getDeclarations();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrDeclaration declaration = (IrDeclaration)element$iv2;
                boolean bl4 = false;
                DceKt.addRootsTo(declaration, declarationsCollector2, context);
            }
        }
        RuntimeDiagnostic dceRuntimeDiagnostic = context.getDceRuntimeDiagnostic();
        if (dceRuntimeDiagnostic != null) {
            IrVisitorsKt.acceptVoid((IrElement)DceKt.unreachableDeclarationMethod(dceRuntimeDiagnostic, context).getOwner(), declarationsCollector2);
        }
        IrSimpleFunction irSimpleFunction = new JsMainFunctionDetector(context).getMainFunctionOrNull((IrModuleFragment)CollectionsKt.last(modules));
        if (irSimpleFunction != null) {
            IrSimpleFunction mainFunction = irSimpleFunction;
            boolean bl5 = false;
            $this$buildRoots_u24lambda_u246.add(mainFunction);
            if (JsMainFunctionDetectorKt.isLoweredSuspendFunction(mainFunction, context)) {
                IrVisitorsKt.acceptVoid((IrElement)context.getCoroutineEmptyContinuation().getOwner(), declarationsCollector2);
            }
        }
        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull($this$buildRoots_u24lambda_u246, ((IrProperty)context.getIntrinsics().getVoid().getOwner()).getBackingField());
        $this$buildRoots_u24lambda_u246.addAll(context.getTestFunsPerFile().values());
        $this$buildRoots_u24lambda_u246.addAll((Collection)context.getAdditionalExportedDeclarations());
        return CollectionsKt.build((List)list2);
    }

    @NotNull
    public static final IrSimpleFunctionSymbol unreachableDeclarationMethod(@NotNull RuntimeDiagnostic $this$unreachableDeclarationMethod, @NotNull JsIrBackendContext context) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$unreachableDeclarationMethod), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$unreachableDeclarationMethod.ordinal()]) {
            case 1: {
                irSimpleFunctionSymbol = context.getIntrinsics().getJsUnreachableDeclarationLog();
                break;
            }
            case 2: {
                irSimpleFunctionSymbol = context.getIntrinsics().getJsUnreachableDeclarationException();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irSimpleFunctionSymbol;
    }

    public static final boolean isKotlinPackage(@NotNull IrField $this$isKotlinPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinPackage, (String)"<this>");
        Object object = IrUtilsKt.getFqNameWhenAvailable($this$isKotlinPackage);
        return object != null && (object = ((FqName)object).asString()) != null ? StringsKt.startsWith$default((String)object, (String)"kotlin", (boolean)false, (int)2, null) : false;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RuntimeDiagnostic.values().length];
            try {
                nArray[RuntimeDiagnostic.LOG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeDiagnostic.EXCEPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

