/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils.serialization;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.serialization.ConstantsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J7\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ4\u0010\u001d\u001a\u00020\u000e\"\u0004\b\u0000\u0010\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\n0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0019J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/serialization/DataWriter;", "", "()V", "data", "Ljava/io/ByteArrayOutputStream;", "getData", "()Ljava/io/ByteArrayOutputStream;", "output", "Ljava/io/DataOutputStream;", "ifNotNull", "T", "t", "write", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "ifTrue", "condition", "", "Lkotlin/Function0;", "saveTo", "writeBoolean", "boolean", "writeByte", "byte", "", "writeByteArray", "byteArray", "", "writeCollection", "collection", "", "writeItem", "writeDouble", "double", "", "writeInt", "int", "writeString", "string", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsIrAstSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsIrAstSerializer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/serialization/DataWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,608:1\n1855#2,2:609\n*S KotlinDebug\n*F\n+ 1 JsIrAstSerializer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/serialization/DataWriter\n*L\n64#1:609,2\n*E\n"})
final class DataWriter {
    @NotNull
    private final ByteArrayOutputStream data = new ByteArrayOutputStream();
    @NotNull
    private final DataOutputStream output = new DataOutputStream(this.data);

    @NotNull
    public final ByteArrayOutputStream getData() {
        return this.data;
    }

    public final void saveTo(@NotNull DataOutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        DataOutputStream it = output;
        boolean bl = false;
        this.data.writeTo(it);
    }

    public final void writeByte(int n) {
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalStateException(("Byte out of bounds: " + n).toString());
        }
        this.output.writeByte(n);
    }

    public final void writeByteArray(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.output.writeInt(byteArray.length);
        this.output.write(byteArray);
    }

    public final void writeString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        byte[] byArray = string2.getBytes(ConstantsKt.getSerializationCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.writeByteArray(byArray);
    }

    public final void writeBoolean(boolean bl) {
        this.output.writeBoolean(bl);
    }

    public final void writeInt(int n) {
        this.output.writeInt(n);
    }

    public final void writeDouble(double d) {
        this.output.writeDouble(d);
    }

    public final <T> void writeCollection(@NotNull Collection<? extends T> collection, @NotNull Function1<? super T, Unit> writeItem) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(writeItem, (String)"writeItem");
        boolean $i$f$writeCollection = false;
        this.output.writeInt(collection.size());
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            writeItem.invoke(element$iv);
        }
    }

    @Nullable
    public final <T> T ifNotNull(@Nullable T t, @NotNull Function1<? super T, Unit> write2) {
        Intrinsics.checkNotNullParameter(write2, (String)"write");
        boolean $i$f$ifNotNull = false;
        this.output.writeBoolean(t != null);
        if (t != null) {
            write2.invoke(t);
        }
        return t;
    }

    public final void ifTrue(boolean condition, @NotNull Function0<Unit> write2) {
        Intrinsics.checkNotNullParameter(write2, (String)"write");
        boolean $i$f$ifTrue = false;
        this.output.writeBoolean(condition);
        if (condition) {
            write2.invoke();
        }
    }
}

