/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTWrapperPsiElement;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiParser;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementType;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinParser;
import org.jetbrains.kotlin.psi.KtCommonFile;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0017\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/parsing/KotlinCommonParserDefinition;", "Lorg/jetbrains/kotlin/com/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lorg/jetbrains/kotlin/com/intellij/lexer/Lexer;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "createParser", "Lorg/jetbrains/kotlin/com/intellij/lang/PsiParser;", "getFileNodeType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IFileElementType;", "getWhitespaceTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "getCommentTokens", "getStringLiteralElements", "createElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "astNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "createFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "fileViewProvider", "Lorg/jetbrains/kotlin/com/intellij/psi/FileViewProvider;", "spaceExistanceTypeBetweenTokens", "Lorg/jetbrains/kotlin/com/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "psi"})
@SourceDebugExtension(value={"SMAP\nKotlinParserDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinParserDefinition.kt\norg/jetbrains/kotlin/parsing/KotlinCommonParserDefinition\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,129:1\n146#2:130\n146#2:131\n*S KotlinDebug\n*F\n+ 1 KotlinParserDefinition.kt\norg/jetbrains/kotlin/parsing/KotlinCommonParserDefinition\n*L\n95#1:130\n97#1:131\n*E\n"})
public class KotlinCommonParserDefinition
implements ParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new KotlinLexer();
    }

    @Override
    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new KotlinParser(project);
    }

    @Override
    @NotNull
    public IFileElementType getFileNodeType() {
        KtFileElementType ktFileElementType = KtFileElementType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)ktFileElementType, (String)"INSTANCE");
        return ktFileElementType;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = KtTokens.WHITESPACES;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITESPACES");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = KtTokens.COMMENTS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"COMMENTS");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = KtTokens.STRINGS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"STRINGS");
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode astNode) {
        PsiElement psiElement;
        IElementType elementType;
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        IElementType iElementType = astNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType iElementType2 = elementType = iElementType;
        if (iElementType2 instanceof KtStubElementType) {
            Object PsiT = ((KtStubElementType)elementType).createPsiFromAst(astNode);
            Intrinsics.checkNotNullExpressionValue(PsiT, (String)"createPsiFromAst(...)");
            psiElement = (PsiElement)PsiT;
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.TYPE_CODE_FRAGMENT) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.EXPRESSION_CODE_FRAGMENT) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.BLOCK_CODE_FRAGMENT)) {
            psiElement = new ASTWrapperPsiElement(astNode);
        } else if (iElementType2 instanceof KDocElementType) {
            PsiElement psiElement2 = ((KDocElementType)elementType).createPsi(astNode);
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createPsi(...)");
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KDocTokens.MARKDOWN_LINK)) {
            psiElement = new KDocLink(astNode);
        } else {
            KtElement ktElement = ((KtNodeType)elementType).createPsi(astNode);
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"createPsi(...)");
            psiElement = ktElement;
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        Intrinsics.checkNotNullParameter((Object)fileViewProvider, (String)"fileViewProvider");
        return new KtCommonFile(fileViewProvider, false);
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        IElementType iElementType = right.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType rightTokenType = iElementType;
        if (Intrinsics.areEqual((Object)rightTokenType, (Object)KtTokens.GET_KEYWORD) || Intrinsics.areEqual((Object)rightTokenType, (Object)KtTokens.SET_KEYWORD)) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        IElementType iElementType2 = left.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
        IElementType leftTokenType = iElementType2;
        if (leftTokenType instanceof KtKeywordToken && rightTokenType instanceof KtKeywordToken) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        PsiElement psiElement = right.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        PsiElement $this$getNonStrictParentOfType$iv = psiElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtWhenEntry rightWhenEntry = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtWhenEntry.class, false);
        if (rightWhenEntry != null) {
            PsiElement psiElement2 = left.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsi(...)");
            PsiElement $this$getNonStrictParentOfType$iv2 = psiElement2;
            boolean $i$f$getNonStrictParentOfType2 = false;
            KtWhenEntry leftWhenEntry = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv2, KtWhenEntry.class, false);
            if (leftWhenEntry != null && !Intrinsics.areEqual((Object)leftWhenEntry, (Object)rightWhenEntry) && !Intrinsics.areEqual((Object)leftTokenType, (Object)KtTokens.SEMICOLON)) {
                return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            }
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

