/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrFlags;
import org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import org.jetbrains.kotlin.backend.common.serialization.IrKlibBytesSource;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFileFromBytes;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryNameAndType;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryTypeProjection;
import org.jetbrains.kotlin.backend.common.serialization.encodings.ClassFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.FunctionFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.PropertyFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.TypeParameterFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.ValueParameterFlags;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileEntry;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrClass;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclarationBase;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDefinitelyNotNullType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrEnumEntry;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFunctionBase;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrProperty;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrSimpleType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrSimpleTypeLegacy;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrSimpleTypeNullability;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrTypeParameter;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrValueParameter;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IdSignatureRenderer;
import org.jetbrains.kotlin.ir.util.IdSignatureRendererKt;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.abi.AbiAnnotation;
import org.jetbrains.kotlin.library.abi.AbiClass;
import org.jetbrains.kotlin.library.abi.AbiClassKind;
import org.jetbrains.kotlin.library.abi.AbiClassifierReference;
import org.jetbrains.kotlin.library.abi.AbiCompoundName;
import org.jetbrains.kotlin.library.abi.AbiDeclaration;
import org.jetbrains.kotlin.library.abi.AbiEnumEntry;
import org.jetbrains.kotlin.library.abi.AbiField;
import org.jetbrains.kotlin.library.abi.AbiFunction;
import org.jetbrains.kotlin.library.abi.AbiModality;
import org.jetbrains.kotlin.library.abi.AbiProperty;
import org.jetbrains.kotlin.library.abi.AbiPropertyKind;
import org.jetbrains.kotlin.library.abi.AbiQualifiedName;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.AbiSignatures;
import org.jetbrains.kotlin.library.abi.AbiTopLevelDeclarations;
import org.jetbrains.kotlin.library.abi.AbiType;
import org.jetbrains.kotlin.library.abi.AbiTypeArgument;
import org.jetbrains.kotlin.library.abi.AbiTypeNullability;
import org.jetbrains.kotlin.library.abi.AbiTypeParameter;
import org.jetbrains.kotlin.library.abi.AbiValueParameter;
import org.jetbrains.kotlin.library.abi.AbiValueParameterKind;
import org.jetbrains.kotlin.library.abi.AbiVariance;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.impl.AbiAnnotationImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiAnnotationListImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiClassImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiConstructorImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiEnumEntryImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiFieldImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiFunctionImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiPropertyImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiSignatureVersions;
import org.jetbrains.kotlin.library.abi.impl.AbiSignaturesImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiTopLevelDeclarationsImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiTypeParameterImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiValueParameterImpl;
import org.jetbrains.kotlin.library.abi.impl.ClassReferenceImpl;
import org.jetbrains.kotlin.library.abi.impl.DynamicTypeImpl;
import org.jetbrains.kotlin.library.abi.impl.ErrorTypeImpl;
import org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer;
import org.jetbrains.kotlin.library.abi.impl.SimpleTypeImpl;
import org.jetbrains.kotlin.library.abi.impl.StarProjectionImpl;
import org.jetbrains.kotlin.library.abi.impl.TypeParameterReferenceImpl;
import org.jetbrains.kotlin.library.abi.impl.TypeProjectionImpl;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartList;

@ExperimentalLibraryAbiReader
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u0010\b\u0003\u0018\u0000  2\u00020\u0001:\u0006\u001b\u001c\u001d\u001e\u001f B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u0017*\u0004\u0018\u0001H\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer;", "", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "supportedSignatureVersions", "", "Lorg/jetbrains/kotlin/library/abi/AbiSignatureVersion;", "compositeFilter", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite;", "<init>", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Ljava/util/Set;Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite;)V", "platform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "interner", "Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;", "annotationInterner", "org/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$annotationInterner$1", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$annotationInterner$1;", "needV1Signatures", "", "needV2Signatures", "discardIfExcluded", "T", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "(Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;)Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "deserialize", "Lorg/jetbrains/kotlin/library/abi/AbiTopLevelDeclarations;", "FileDeserializer", "ContainingEntity", "TypeParameterResolver", "TypeDeserializer", "VisibilityStatus", "Companion", "kotlin-util-klib-abi"})
final class LibraryDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinLibrary library;
    @Nullable
    private final AbiReadingFilter.Composite compositeFilter;
    @Nullable
    private final BuiltInsPlatform platform;
    @NotNull
    private final IrInterningService interner;
    @NotNull
    private final annotationInterner.1 annotationInterner;
    private final boolean needV1Signatures;
    private final boolean needV2Signatures;
    @NotNull
    private static final String INIT_SUFFIX = '.' + SpecialNames.INIT.asString();
    @NotNull
    private static final String KOTLIN_COMPOUND_NAME = AbiCompoundName.constructor-impl("kotlin");
    @NotNull
    private static final AbiQualifiedName PUBLISHED_API_CONSTRUCTOR_QUALIFIED_NAME = new AbiQualifiedName(KOTLIN_COMPOUND_NAME, AbiCompoundName.constructor-impl("PublishedApi"), null);
    @NotNull
    private static final AbiQualifiedName KOTLIN_ANY_QUALIFIED_NAME = new AbiQualifiedName(KOTLIN_COMPOUND_NAME, AbiCompoundName.constructor-impl("Any"), null);
    @NotNull
    private static final AbiQualifiedName KOTLIN_UNIT_QUALIFIED_NAME = new AbiQualifiedName(KOTLIN_COMPOUND_NAME, AbiCompoundName.constructor-impl("Unit"), null);

    public LibraryDeserializer(@NotNull KotlinLibrary library, @NotNull Set<? extends AbiSignatureVersion> supportedSignatureVersions, @Nullable AbiReadingFilter.Composite compositeFilter) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter(supportedSignatureVersions, (String)"supportedSignatureVersions");
        this.library = library;
        this.compositeFilter = compositeFilter;
        this.platform = KotlinLibraryKt.getBuiltInsPlatform(this.library);
        this.interner = new IrInterningService();
        this.annotationInterner = new Object(){
            private final ObjectOpenHashSet<AbiAnnotationImpl> uniqueAnnotations;
            {
                this.uniqueAnnotations = new ObjectOpenHashSet<K>();
            }

            public final AbiAnnotationImpl intern(AbiAnnotationImpl annotation) {
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                AbiAnnotationImpl abiAnnotationImpl = this.uniqueAnnotations.addOrGet(annotation);
                Intrinsics.checkNotNullExpressionValue((Object)abiAnnotationImpl, (String)"addOrGet(...)");
                return abiAnnotationImpl;
            }
        };
        this.needV1Signatures = supportedSignatureVersions.contains(AbiSignatureVersions.Supported.V1);
        this.needV2Signatures = supportedSignatureVersions.contains(AbiSignatureVersions.Supported.V2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T extends AbiDeclaration> T discardIfExcluded(T $this$discardIfExcluded) {
        T t2;
        if ($this$discardIfExcluded != null) {
            AbiReadingFilter.Composite composite = this.compositeFilter;
            boolean bl = composite != null ? composite.isDeclarationExcluded($this$discardIfExcluded) : false;
            if (bl) {
                t2 = null;
                return t2;
            }
        }
        t2 = $this$discardIfExcluded;
        return t2;
    }

    @NotNull
    public final AbiTopLevelDeclarations deserialize() {
        ArrayList topLevels = new ArrayList();
        int n2 = this.library.getMainIr().fileCount();
        for (int fileIndex = 0; fileIndex < n2; ++fileIndex) {
            new FileDeserializer(fileIndex).deserializeTo(topLevels);
        }
        return new AbiTopLevelDeclarationsImpl(org.jetbrains.kotlin.utils.CollectionsKt.compact(topLevels));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J#\u0010\u0014\u001a\u00020\n*\u00020\u00152\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017H\u0082\bJ\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$Companion;", "", "<init>", "()V", "INIT_SUFFIX", "", "KOTLIN_COMPOUND_NAME", "Lorg/jetbrains/kotlin/library/abi/AbiCompoundName;", "Ljava/lang/String;", "PUBLISHED_API_CONSTRUCTOR_QUALIFIED_NAME", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "KOTLIN_ANY_QUALIFIED_NAME", "KOTLIN_UNIT_QUALIFIED_NAME", "isKotlinBuiltInType", "", "type", "Lorg/jetbrains/kotlin/library/abi/AbiType;", "className", "nullability", "Lorg/jetbrains/kotlin/library/abi/AbiTypeNullability;", "extractQualifiedName", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "transformRelativeName", "Lkotlin/Function1;", "toAbiModality", "Lorg/jetbrains/kotlin/library/abi/AbiModality;", "Lorg/jetbrains/kotlin/descriptors/Modality;", "containingClassModality", "toAbiVariance", "Lorg/jetbrains/kotlin/library/abi/AbiVariance;", "Lorg/jetbrains/kotlin/types/Variance;", "kotlin-util-klib-abi"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isKotlinBuiltInType(AbiType type, AbiQualifiedName className, AbiTypeNullability nullability) {
            if (!(type instanceof AbiType.Simple) || ((AbiType.Simple)type).getNullability() != nullability) {
                return false;
            }
            AbiClassifierReference abiClassifierReference = ((AbiType.Simple)type).getClassifierReference();
            AbiClassifierReference.ClassReference classReference = abiClassifierReference instanceof AbiClassifierReference.ClassReference ? (AbiClassifierReference.ClassReference)abiClassifierReference : null;
            return Intrinsics.areEqual((Object)(classReference != null ? classReference.getClassName() : null), (Object)className);
        }

        private final AbiModality toAbiModality(Modality $this$toAbiModality, AbiModality containingClassModality) {
            AbiModality abiModality;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toAbiModality.ordinal()]) {
                case 1: {
                    abiModality = AbiModality.FINAL;
                    break;
                }
                case 2: {
                    if (containingClassModality == AbiModality.FINAL) {
                        abiModality = AbiModality.FINAL;
                        break;
                    }
                    abiModality = AbiModality.OPEN;
                    break;
                }
                case 3: {
                    abiModality = AbiModality.ABSTRACT;
                    break;
                }
                case 4: {
                    abiModality = AbiModality.SEALED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return abiModality;
        }

        private final AbiVariance toAbiVariance(Variance $this$toAbiVariance) {
            AbiVariance abiVariance;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$toAbiVariance.ordinal()]) {
                case 1: {
                    abiVariance = AbiVariance.INVARIANT;
                    break;
                }
                case 2: {
                    abiVariance = AbiVariance.IN;
                    break;
                }
                case 3: {
                    abiVariance = AbiVariance.OUT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return abiVariance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Modality.values().length];
                try {
                    nArray[Modality.FINAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Modality.OPEN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Modality.ABSTRACT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Modality.SEALED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Variance.values().length];
                try {
                    nArray[Variance.INVARIANT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Variance.IN_VARIANCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u0000 \t2\u00020\u0001:\u0004\u0006\u0007\b\tJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0003\n\u000b\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity;", "", "computeNestedName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "simpleName", "", "Package", "Class", "Property", "Companion", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class;", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Package;", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Property;", "kotlin-util-klib-abi"})
    private static interface ContainingEntity {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public AbiQualifiedName computeNestedName(@NotNull String var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class;", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity;", "className", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "modality", "Lorg/jetbrains/kotlin/library/abi/AbiModality;", "lazyExcludeFakeOverrides", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;Lorg/jetbrains/kotlin/library/abi/AbiModality;Lkotlin/jvm/functions/Function0;)V", "getClassName", "()Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "getModality", "()Lorg/jetbrains/kotlin/library/abi/AbiModality;", "excludeFakeOverrides", "getExcludeFakeOverrides", "()Z", "excludeFakeOverrides$delegate", "Lkotlin/Lazy;", "computeNestedName", "simpleName", "", "Companion", "kotlin-util-klib-abi"})
        public static final class Class
        implements ContainingEntity {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final AbiQualifiedName className;
            @NotNull
            private final AbiModality modality;
            @NotNull
            private final Lazy excludeFakeOverrides$delegate;

            public Class(@NotNull AbiQualifiedName className, @NotNull AbiModality modality, @NotNull Function0<Boolean> lazyExcludeFakeOverrides) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                Intrinsics.checkNotNullParameter((Object)((Object)modality), (String)"modality");
                Intrinsics.checkNotNullParameter(lazyExcludeFakeOverrides, (String)"lazyExcludeFakeOverrides");
                this.className = className;
                this.modality = modality;
                this.excludeFakeOverrides$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, lazyExcludeFakeOverrides);
            }

            @NotNull
            public final AbiQualifiedName getClassName() {
                return this.className;
            }

            @NotNull
            public final AbiModality getModality() {
                return this.modality;
            }

            private final boolean getExcludeFakeOverrides() {
                Lazy lazy = this.excludeFakeOverrides$delegate;
                return (Boolean)lazy.getValue();
            }

            @Override
            @NotNull
            public AbiQualifiedName computeNestedName(@NotNull String simpleName) {
                Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
                return Companion.qualifiedName(this.className, simpleName);
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\u00020\u0005*\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class$Companion;", "", "<init>", "()V", "excludeFakeOverrides", "", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class;", "getExcludeFakeOverrides", "(Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class;)Z", "kotlin-util-klib-abi"})
            public static final class Companion {
                private Companion() {
                }

                public final boolean getExcludeFakeOverrides(@Nullable Class $this$excludeFakeOverrides) {
                    Class clazz = $this$excludeFakeOverrides;
                    return clazz != null ? clazz.getExcludeFakeOverrides() : false;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Companion;", "", "<init>", "()V", "qualifiedName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "packageName", "Lorg/jetbrains/kotlin/library/abi/AbiCompoundName;", "topLevelSimpleName", "", "qualifiedName-7cjYDiI", "(Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "parentName", "memberSimpleName", "kotlin-util-klib-abi"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            private final AbiQualifiedName qualifiedName-7cjYDiI(String string, String topLevelSimpleName) {
                return new AbiQualifiedName(string, AbiCompoundName.constructor-impl(topLevelSimpleName), null);
            }

            private final AbiQualifiedName qualifiedName(AbiQualifiedName parentName, String memberSimpleName) {
                return new AbiQualifiedName(parentName.getPackageName-l9-qHIQ(), AbiCompoundName.constructor-impl(AbiCompoundName.toString-impl(parentName.getRelativeName-l9-qHIQ()) + '.' + memberSimpleName), null);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Package;", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity;", "packageName", "Lorg/jetbrains/kotlin/library/abi/AbiCompoundName;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getPackageName-l9-qHIQ", "()Ljava/lang/String;", "Ljava/lang/String;", "computeNestedName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "simpleName", "", "kotlin-util-klib-abi"})
        public static final class Package
        implements ContainingEntity {
            @NotNull
            private final String packageName;

            private Package(String packageName2) {
                Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
                this.packageName = packageName2;
            }

            @NotNull
            public final String getPackageName-l9-qHIQ() {
                return this.packageName;
            }

            @Override
            @NotNull
            public AbiQualifiedName computeNestedName(@NotNull String simpleName) {
                Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
                return Companion.qualifiedName-7cjYDiI(this.packageName, simpleName);
            }

            public /* synthetic */ Package(String packageName2, DefaultConstructorMarker $constructor_marker) {
                this(packageName2);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Property;", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity;", "propertyName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "containingClass", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class;", "propertyVisibilityStatus", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$VisibilityStatus;", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class;Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$VisibilityStatus;)V", "getPropertyName", "()Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "getContainingClass", "()Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity$Class;", "getPropertyVisibilityStatus", "()Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$VisibilityStatus;", "computeNestedName", "simpleName", "", "kotlin-util-klib-abi"})
        public static final class Property
        implements ContainingEntity {
            @NotNull
            private final AbiQualifiedName propertyName;
            @Nullable
            private final Class containingClass;
            @NotNull
            private final VisibilityStatus propertyVisibilityStatus;

            public Property(@NotNull AbiQualifiedName propertyName, @Nullable Class containingClass, @NotNull VisibilityStatus propertyVisibilityStatus) {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                Intrinsics.checkNotNullParameter((Object)((Object)propertyVisibilityStatus), (String)"propertyVisibilityStatus");
                this.propertyName = propertyName;
                this.containingClass = containingClass;
                this.propertyVisibilityStatus = propertyVisibilityStatus;
            }

            @NotNull
            public final AbiQualifiedName getPropertyName() {
                return this.propertyName;
            }

            @Nullable
            public final Class getContainingClass() {
                return this.containingClass;
            }

            @NotNull
            public final VisibilityStatus getPropertyVisibilityStatus() {
                return this.propertyVisibilityStatus;
            }

            @Override
            @NotNull
            public AbiQualifiedName computeNestedName(@NotNull String simpleName) {
                Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
                return Companion.qualifiedName(this.propertyName, simpleName);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J$\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J9\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010%\u001a\u00020\u001c2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020!0'H\u0082\bJ\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J,\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0017\u001a\u00020-2\u0006\u0010.\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J$\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0017\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\f\u00109\u001a\u00020:*\u000206H\u0002J$\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\f2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\f2\u0006\u0010%\u001a\u00020\u001cH\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u0017\u001a\u00020AH\u0002J.\u0010B\u001a\u00020C2\u0006\u0010\u0017\u001a\u00020A2\u0006\u0010D\u001a\u00020@2\b\u0010E\u001a\u0004\u0018\u00010F2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010CH\u0002J \u0010H\u001a\u00020I2\u0006\u0010\u0017\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010%\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$FileDeserializer;", "", "fileIndex", "", "<init>", "(Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer;I)V", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "packageName", "Lorg/jetbrains/kotlin/library/abi/AbiCompoundName;", "Ljava/lang/String;", "topLevelDeclarationIds", "", "signatureDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "typeDeserializer", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeDeserializer;", "deserializeTo", "", "output", "", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "deserializeDeclaration", "proto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclaration;", "containingEntity", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$ContainingEntity;", "parentTypeParameterResolver", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeParameterResolver;", "deserializeClass", "Lorg/jetbrains/kotlin/library/abi/AbiClass;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrClass;", "isDirectlyInheritedFromNativeInteropClass", "", "deserializeTypes", "Lorg/jetbrains/kotlin/library/abi/AbiType;", "typeIds", "typeParameterResolver", "predicate", "Lkotlin/Function1;", "deserializeEnumEntry", "Lorg/jetbrains/kotlin/library/abi/AbiEnumEntry;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrEnumEntry;", "deserializeFunction", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFunctionBase;", "isConstructor", "deserializeProperty", "Lorg/jetbrains/kotlin/library/abi/AbiProperty;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrProperty;", "deserializeQualifiedName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "nameId", "deserializeIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "symbolId", "", "toAbiSignatures", "Lorg/jetbrains/kotlin/library/abi/AbiSignatures;", "deserializeTypeParameters", "Lorg/jetbrains/kotlin/library/abi/AbiTypeParameter;", "protos", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrTypeParameter;", "deserializeAnnotations", "Lorg/jetbrains/kotlin/library/abi/impl/AbiAnnotationListImpl;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclarationBase;", "computeVisibilityStatus", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$VisibilityStatus;", "annotations", "containingClassModality", "Lorg/jetbrains/kotlin/library/abi/AbiModality;", "parentPropertyVisibilityStatus", "deserializeValueParameter", "Lorg/jetbrains/kotlin/library/abi/AbiValueParameter;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrValueParameter;", "kind", "Lorg/jetbrains/kotlin/library/abi/AbiValueParameterKind;", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$FileDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$Companion\n*L\n1#1,831:1\n277#1:843\n278#1:847\n279#1:851\n277#1:876\n278#1:880\n279#1:884\n1651#2:832\n1915#2:833\n1916#2:835\n1652#2:836\n1651#2:838\n1915#2:839\n1916#2:841\n1652#2:842\n1651#2:845\n1915#2:846\n1916#2:849\n1652#2:850\n1807#2,2:852\n1809#2:855\n1651#2:857\n1915#2:858\n1916#2:860\n1652#2:861\n1661#2,3:862\n1661#2,3:865\n1629#2,3:873\n1651#2:878\n1915#2:879\n1916#2:882\n1652#2:883\n1632#2:885\n1661#2,3:887\n1#3:834\n1#3:840\n1#3:848\n1#3:854\n1#3:859\n1#3:868\n1#3:881\n32#4:837\n32#4:844\n32#4:856\n24#4:872\n32#4:877\n16#4:886\n282#5:869\n282#5:870\n282#5:871\n815#6:890\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$FileDeserializer\n*L\n247#1:843\n247#1:847\n247#1:851\n488#1:876\n488#1:880\n488#1:884\n160#1:832\n160#1:833\n160#1:835\n160#1:836\n227#1:838\n227#1:839\n227#1:841\n227#1:842\n247#1:845\n247#1:846\n247#1:849\n247#1:850\n267#1:852,2\n267#1:855\n277#1:857\n277#1:858\n277#1:860\n277#1:861\n368#1:862,3\n376#1:865,3\n481#1:873,3\n488#1:878\n488#1:879\n488#1:882\n488#1:883\n481#1:885\n514#1:887,3\n160#1:834\n227#1:840\n247#1:848\n277#1:859\n488#1:881\n227#1:837\n247#1:844\n277#1:856\n481#1:872\n488#1:877\n514#1:886\n442#1:869\n450#1:870\n458#1:871\n501#1:890\n*E\n"})
    private final class FileDeserializer {
        @NotNull
        private final IrLibraryFileFromBytes fileReader;
        @NotNull
        private final String packageName;
        @NotNull
        private final List<Integer> topLevelDeclarationIds;
        @NotNull
        private final IdSignatureDeserializer signatureDeserializer;
        @NotNull
        private final TypeDeserializer typeDeserializer;

        public FileDeserializer(int fileIndex) {
            this.fileReader = new IrLibraryFileFromBytes(new IrKlibBytesSource(LibraryDeserializer.this.library.getMainIr(), fileIndex));
            IrLibrary.IrDirectory mainIr2 = LibraryDeserializer.this.library.getMainIr();
            IrFile proto = IrFile.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(mainIr2.file(fileIndex)), IrLibraryFileFromBytes.Companion.getExtensionRegistryLite());
            List<Integer> list = proto.getDeclarationIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclarationIdList(...)");
            this.topLevelDeclarationIds = list;
            IrLibraryFile irLibraryFile = this.fileReader;
            List<Integer> list2 = proto.getFqNameList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getFqNameList(...)");
            String packageFQN = IrFileDeserializerKt.deserializeFqName(irLibraryFile, list2);
            this.packageName = AbiCompoundName.constructor-impl(packageFQN);
            Intrinsics.checkNotNull((Object)proto);
            FileEntry fileEntry = IrFileDeserializerKt.fileEntry(mainIr2, proto, fileIndex);
            String fileName = IrFileDeserializerKt.deserializeFileEntryName(this.fileReader, fileEntry);
            IdSignature.FileSignature fileSignature = new IdSignature.FileSignature(new Object(), new FqName(packageFQN), fileName);
            this.signatureDeserializer = new IdSignatureDeserializer(this.fileReader, fileSignature, LibraryDeserializer.this.interner);
            this.typeDeserializer = new TypeDeserializer(new LockBasedStorageManager("file '" + fileName + "', package '" + packageFQN + '\''), this.fileReader, this.signatureDeserializer);
        }

        /*
         * WARNING - void declaration
         */
        public final void deserializeTo(@NotNull List<AbiDeclaration> output2) {
            void $this$mapNotNullTo$iv;
            Intrinsics.checkNotNullParameter(output2, (String)"output");
            AbiReadingFilter.Composite composite = LibraryDeserializer.this.compositeFilter;
            boolean bl = composite != null ? composite.isPackageExcluded-6OaPNJE(this.packageName) : false;
            if (bl) {
                return;
            }
            Iterable iterable = this.topLevelDeclarationIds;
            Collection destination$iv = output2;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                AbiDeclaration it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                int topLevelDeclarationId = ((Number)element$iv).intValue();
                boolean bl3 = false;
                if (this.deserializeDeclaration(this.fileReader.declaration(topLevelDeclarationId), new ContainingEntity.Package(this.packageName, null), null) == null) continue;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
        }

        private final AbiDeclaration deserializeDeclaration(IrDeclaration proto, ContainingEntity containingEntity, TypeParameterResolver parentTypeParameterResolver) {
            AbiDeclaration abiDeclaration;
            IrDeclaration.DeclaratorCase declaratorCase = proto.getDeclaratorCase();
            switch (declaratorCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[declaratorCase.ordinal()]) {
                case 1: {
                    IrClass irClass = proto.getIrClass();
                    Intrinsics.checkNotNullExpressionValue((Object)irClass, (String)"getIrClass(...)");
                    abiDeclaration = this.deserializeClass(irClass, containingEntity, parentTypeParameterResolver);
                    break;
                }
                case 2: {
                    IrFunctionBase irFunctionBase = proto.getIrConstructor().getBase();
                    Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"getBase(...)");
                    abiDeclaration = this.deserializeFunction(irFunctionBase, true, containingEntity, parentTypeParameterResolver);
                    break;
                }
                case 3: {
                    IrFunctionBase irFunctionBase = proto.getIrFunction().getBase();
                    Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"getBase(...)");
                    abiDeclaration = this.deserializeFunction(irFunctionBase, false, containingEntity, parentTypeParameterResolver);
                    break;
                }
                case 4: {
                    IrProperty irProperty = proto.getIrProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)irProperty, (String)"getIrProperty(...)");
                    abiDeclaration = this.deserializeProperty(irProperty, containingEntity, parentTypeParameterResolver);
                    break;
                }
                case 5: {
                    IrEnumEntry irEnumEntry = proto.getIrEnumEntry();
                    Intrinsics.checkNotNullExpressionValue((Object)irEnumEntry, (String)"getIrEnumEntry(...)");
                    abiDeclaration = this.deserializeEnumEntry(irEnumEntry, containingEntity);
                    break;
                }
                default: {
                    abiDeclaration = null;
                }
            }
            return LibraryDeserializer.this.discardIfExcluded(abiDeclaration);
        }

        /*
         * WARNING - void declaration
         */
        private final AbiClass deserializeClass(IrClass proto, ContainingEntity containingEntity, TypeParameterResolver parentTypeParameterResolver) {
            void $this$mapNotNullTo$iv$iv$iv;
            void typeIds$iv;
            AbiClassKind abiClassKind;
            TypeParameterResolver $this$mapNotNullTo$iv$iv;
            IrDeclarationBase irDeclarationBase = proto.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"getBase(...)");
            AbiAnnotationListImpl annotations2 = this.deserializeAnnotations(irDeclarationBase);
            ContainingEntity.Class clazz = containingEntity instanceof ContainingEntity.Class ? (ContainingEntity.Class)containingEntity : null;
            AbiModality containingClassModality = clazz != null ? clazz.getModality() : null;
            IrDeclarationBase irDeclarationBase2 = proto.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase2, (String)"getBase(...)");
            if (!FileDeserializer.computeVisibilityStatus$default(this, irDeclarationBase2, annotations2, containingClassModality, null, 8, null).isPubliclyVisible()) {
                return null;
            }
            long flags = ClassFlags.Companion.decode-K2PyDQs(proto.getBase().getFlags());
            AbiModality modality = Companion.toAbiModality(ClassFlags.getModality-impl(flags), null);
            AbiQualifiedName qualifiedName = this.deserializeQualifiedName(proto.getName(), containingEntity);
            ContainingEntity.Class thisClassEntity = new ContainingEntity.Class(qualifiedName, modality, (Function0<Boolean>)((Function0)() -> FileDeserializer.deserializeClass$lambda$0(LibraryDeserializer.this, this, proto)));
            TypeParameterResolver thisClassTypeParameterResolver = new TypeParameterResolver(qualifiedName, ClassFlags.isInner-impl(flags) ? parentTypeParameterResolver : null, !ClassFlags.isInner-impl(flags) && parentTypeParameterResolver != null ? parentTypeParameterResolver.getLevel() + 1 : 0);
            List<IrDeclaration> list = proto.getDeclarationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclarationList(...)");
            Collection $this$memoryOptimizedMapNotNull$iv = list;
            boolean $i$f$memoryOptimizedMapNotNull22 = false;
            Iterable iterable = $this$memoryOptimizedMapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach22 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                AbiDeclaration it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrDeclaration declaration = (IrDeclaration)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)declaration);
                if (this.deserializeDeclaration(declaration, thisClassEntity, thisClassTypeParameterResolver) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List memberDeclarations = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            AbiSignatures abiSignatures = this.toAbiSignatures(this.deserializeIdSignature(proto.getBase().getSymbol()));
            Object kind = ClassFlags.getKind-impl(flags);
            switch (WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
                case 1: {
                    abiClassKind = AbiClassKind.CLASS;
                    break;
                }
                case 2: {
                    abiClassKind = AbiClassKind.INTERFACE;
                    break;
                }
                case 3: {
                    abiClassKind = AbiClassKind.OBJECT;
                    break;
                }
                case 4: {
                    abiClassKind = AbiClassKind.ENUM_CLASS;
                    break;
                }
                case 5: {
                    abiClassKind = AbiClassKind.ANNOTATION_CLASS;
                    break;
                }
                case 6: {
                    throw new IllegalStateException(("Unexpected class kind: " + (Object)kind).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean bl = ClassFlags.isInner-impl(flags);
            boolean bl4 = ClassFlags.isValue-impl(flags);
            boolean bl5 = ClassFlags.isFun-impl(flags);
            kind = this;
            List<Integer> list2 = proto.getSuperTypeList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSuperTypeList(...)");
            List<Integer> $i$f$memoryOptimizedMapNotNull22 = list2;
            $this$mapNotNullTo$iv$iv = thisClassTypeParameterResolver;
            boolean bl6 = bl5;
            boolean bl7 = bl4;
            boolean bl8 = bl;
            AbiClassKind abiClassKind2 = abiClassKind;
            AbiModality abiModality = modality;
            AbiAnnotationListImpl abiAnnotationListImpl = annotations2;
            AbiSignatures abiSignatures2 = abiSignatures;
            AbiQualifiedName abiQualifiedName = qualifiedName;
            boolean $i$f$deserializeTypes = false;
            Collection $this$memoryOptimizedMapNotNull$iv$iv = (Collection)typeIds$iv;
            boolean $i$f$memoryOptimizedMapNotNull = false;
            Iterable $i$f$forEach22 = $this$memoryOptimizedMapNotNull$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                AbiType it$iv$iv$iv;
                void typeParameterResolver$iv;
                void this_$iv;
                AbiType abiType;
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator3.next();
                boolean bl9 = false;
                int typeId$iv = ((Number)element$iv$iv$iv).intValue();
                boolean bl10 = false;
                AbiType type = abiType = this_$iv.typeDeserializer.deserializeType(typeId$iv, (TypeParameterResolver)typeParameterResolver$iv);
                boolean bl11 = false;
                if ((!Companion.isKotlinBuiltInType(type, KOTLIN_ANY_QUALIFIED_NAME, AbiTypeNullability.DEFINITELY_NOT_NULL) && this.typeDeserializer.isPubliclyVisible(type) ? abiType : null) == null) continue;
                it$iv$iv$iv = it$iv$iv$iv;
                boolean bl12 = false;
                destination$iv$iv$iv.add(it$iv$iv$iv);
            }
            List list3 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv$iv);
            List<IrTypeParameter> list4 = proto.getTypeParameterList();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getTypeParameterList(...)");
            List<AbiTypeParameter> list5 = this.deserializeTypeParameters(list4, thisClassTypeParameterResolver);
            List list6 = memberDeclarations;
            List list7 = list3;
            boolean bl13 = bl6;
            boolean bl14 = bl7;
            boolean bl15 = bl8;
            AbiClassKind abiClassKind3 = abiClassKind2;
            AbiModality abiModality2 = abiModality;
            AbiAnnotationListImpl abiAnnotationListImpl2 = abiAnnotationListImpl;
            AbiSignatures abiSignatures3 = abiSignatures2;
            AbiQualifiedName abiQualifiedName2 = abiQualifiedName;
            return new AbiClassImpl(abiQualifiedName2, abiSignatures3, abiAnnotationListImpl2, abiModality2, abiClassKind3, bl15, bl14, bl13, list7, list6, list5);
        }

        private final boolean isDirectlyInheritedFromNativeInteropClass(IrClass proto) {
            boolean bl;
            block5: {
                List<Integer> list = proto.getSuperTypeList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getSuperTypeList(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        Integer superTypeId = (Integer)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)superTypeId);
                        if (FileDeserializer.isDirectlyInheritedFromNativeInteropClass$extractIdSignature(this, superTypeId) == null) {
                            bl2 = false;
                        } else {
                            IdSignature idSignature;
                            IdSignature $this$isDirectlyInheritedFromNativeInteropClass_u24lambda_u240_u240 = idSignature;
                            boolean bl4 = false;
                            bl2 = $this$isDirectlyInheritedFromNativeInteropClass_u24lambda_u240_u240.test(IdSignature.Flags.IS_NATIVE_INTEROP_LIBRARY);
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final AbiEnumEntry deserializeEnumEntry(IrEnumEntry proto, ContainingEntity containingEntity) {
            AbiQualifiedName abiQualifiedName = this.deserializeQualifiedName(proto.getName(), containingEntity);
            AbiSignatures abiSignatures = this.toAbiSignatures(this.deserializeIdSignature(proto.getBase().getSymbol()));
            IrDeclarationBase irDeclarationBase = proto.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"getBase(...)");
            return new AbiEnumEntryImpl(abiQualifiedName, abiSignatures, this.deserializeAnnotations(irDeclarationBase));
        }

        /*
         * WARNING - void declaration
         */
        private final AbiFunction deserializeFunction(IrFunctionBase proto, boolean isConstructor, ContainingEntity containingEntity, TypeParameterResolver parentTypeParameterResolver) {
            AbiFunction abiFunction;
            IrValueParameter contextParameterProto;
            Collection collection;
            Iterable $this$mapTo$iv;
            AbiValueParameter abiValueParameter;
            TypeParameterResolver thisFunctionTypeParameterResolver;
            TypeParameterResolver typeParameterResolver;
            IrDeclarationBase irDeclarationBase = proto.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"getBase(...)");
            AbiAnnotationListImpl annotations2 = this.deserializeAnnotations(irDeclarationBase);
            ContainingEntity.Property containingProperty = null;
            ContainingEntity.Class containingClass = null;
            ContainingEntity containingEntity2 = containingEntity;
            if (containingEntity2 instanceof ContainingEntity.Class) {
                containingProperty = null;
                containingClass = (ContainingEntity.Class)containingEntity;
                if (isConstructor && containingClass.getModality() == AbiModality.SEALED) {
                    return null;
                }
            } else if (containingEntity2 instanceof ContainingEntity.Property) {
                containingProperty = (ContainingEntity.Property)containingEntity;
                containingClass = ((ContainingEntity.Property)containingEntity).getContainingClass();
            } else {
                containingProperty = null;
                containingClass = null;
            }
            ContainingEntity.Property property2 = containingProperty;
            VisibilityStatus parentPropertyVisibilityStatus = property2 != null ? property2.getPropertyVisibilityStatus() : null;
            IrDeclarationBase irDeclarationBase2 = proto.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase2, (String)"getBase(...)");
            ContainingEntity.Class clazz = containingClass;
            if (!this.computeVisibilityStatus(irDeclarationBase2, annotations2, clazz != null ? clazz.getModality() : null, parentPropertyVisibilityStatus).isPubliclyVisible()) {
                return null;
            }
            long flags = FunctionFlags.Companion.decode-UIJRpeM(proto.getBase().getFlags());
            if (FunctionFlags.isFakeOverride-impl(flags) && ContainingEntity.Class.Companion.getExcludeFakeOverrides(containingClass)) {
                return null;
            }
            long nameAndType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            AbiQualifiedName functionName = this.deserializeQualifiedName(BinaryNameAndType.getNameIndex-impl(nameAndType), containingEntity);
            if (isConstructor) {
                TypeParameterResolver typeParameterResolver2 = parentTypeParameterResolver;
                typeParameterResolver = typeParameterResolver2;
                Intrinsics.checkNotNull((Object)typeParameterResolver2);
            } else {
                typeParameterResolver = thisFunctionTypeParameterResolver = containingProperty != null ? new TypeParameterResolver(containingProperty.getPropertyName(), parentTypeParameterResolver, 1) : new TypeParameterResolver(functionName, parentTypeParameterResolver, 0, 4, null);
            }
            if (proto.hasExtensionReceiver()) {
                IrValueParameter irValueParameter = proto.getExtensionReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)irValueParameter, (String)"getExtensionReceiver(...)");
                abiValueParameter = this.deserializeValueParameter(irValueParameter, AbiValueParameterKind.EXTENSION_RECEIVER, thisFunctionTypeParameterResolver);
            } else {
                abiValueParameter = null;
            }
            AbiValueParameter extensionReceiver = abiValueParameter;
            ArrayList allValueParameters = new ArrayList();
            List<IrValueParameter> list = proto.getContextParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getContextParameterList(...)");
            Iterable iterable = list;
            Collection destination$iv = allValueParameters;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                collection = destination$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)contextParameterProto);
                collection.add(this.deserializeValueParameter(contextParameterProto, AbiValueParameterKind.CONTEXT, thisFunctionTypeParameterResolver));
            }
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(allValueParameters, extensionReceiver);
            List<IrValueParameter> list2 = proto.getRegularParameterList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRegularParameterList(...)");
            $this$mapTo$iv = list2;
            destination$iv = allValueParameters;
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void regularParameterProto;
                contextParameterProto = (IrValueParameter)item$iv;
                collection = destination$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)regularParameterProto);
                collection.add(this.deserializeValueParameter((IrValueParameter)regularParameterProto, AbiValueParameterKind.REGULAR, thisFunctionTypeParameterResolver));
            }
            if (isConstructor) {
                if (!(extensionReceiver == null)) {
                    boolean bl = false;
                    String string = "Unexpected extension receiver found for constructor " + functionName;
                    throw new IllegalStateException(string.toString());
                }
                abiFunction = new AbiConstructorImpl(functionName, this.toAbiSignatures(this.deserializeIdSignature(proto.getBase().getSymbol())), annotations2, FunctionFlags.isInline-impl(flags), org.jetbrains.kotlin.utils.CollectionsKt.compact(allValueParameters));
            } else {
                AbiType abiType;
                AbiType it = abiType = this.typeDeserializer.deserializeType(BinaryNameAndType.getTypeIndex-impl(nameAndType), thisFunctionTypeParameterResolver);
                boolean bl = false;
                AbiType nonTrivialReturnType = !Companion.isKotlinBuiltInType(it, KOTLIN_UNIT_QUALIFIED_NAME, AbiTypeNullability.DEFINITELY_NOT_NULL) ? abiType : null;
                AbiSignatures abiSignatures = this.toAbiSignatures(this.deserializeIdSignature(proto.getBase().getSymbol()));
                ContainingEntity.Class clazz2 = containingClass;
                AbiModality abiModality = Companion.toAbiModality(FunctionFlags.getModality-impl(flags), clazz2 != null ? clazz2.getModality() : null);
                boolean bl2 = FunctionFlags.isInline-impl(flags);
                boolean bl3 = FunctionFlags.isSuspend-impl(flags);
                List<IrTypeParameter> list3 = proto.getTypeParameterList();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getTypeParameterList(...)");
                abiFunction = new AbiFunctionImpl(functionName, abiSignatures, annotations2, abiModality, bl2, bl3, this.deserializeTypeParameters(list3, thisFunctionTypeParameterResolver), org.jetbrains.kotlin.utils.CollectionsKt.compact(allValueParameters), nonTrivialReturnType);
            }
            return abiFunction;
        }

        private final AbiProperty deserializeProperty(IrProperty proto, ContainingEntity containingEntity, TypeParameterResolver typeParameterResolver) {
            AbiFieldImpl abiFieldImpl;
            AbiFunction abiFunction;
            AbiFunction abiFunction2;
            AbiFunction abiFunction3;
            AbiFunction abiFunction4;
            AbiQualifiedName abiQualifiedName;
            AbiSignatures abiSignatures;
            AbiAnnotationListImpl abiAnnotationListImpl;
            AbiModality abiModality;
            AbiPropertyKind abiPropertyKind;
            boolean $this$ifTrue$iv;
            IrDeclarationBase irDeclarationBase = proto.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"getBase(...)");
            AbiAnnotationListImpl annotations2 = this.deserializeAnnotations(irDeclarationBase);
            ContainingEntity.Class containingClass = containingEntity instanceof ContainingEntity.Class ? (ContainingEntity.Class)containingEntity : null;
            IrDeclarationBase irDeclarationBase2 = proto.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase2, (String)"getBase(...)");
            ContainingEntity.Class clazz = containingClass;
            VisibilityStatus visibilityStatus = FileDeserializer.computeVisibilityStatus$default(this, irDeclarationBase2, annotations2, clazz != null ? clazz.getModality() : null, null, 8, null);
            if (!visibilityStatus.isPubliclyVisible()) {
                return null;
            }
            long flags = PropertyFlags.Companion.decode-85tB66k(proto.getBase().getFlags());
            if (PropertyFlags.isFakeOverride-impl(flags) && ContainingEntity.Class.Companion.getExcludeFakeOverrides(containingClass)) {
                return null;
            }
            AbiQualifiedName qualifiedName = this.deserializeQualifiedName(proto.getName(), containingEntity);
            ContainingEntity.Property thisPropertyEntity = new ContainingEntity.Property(qualifiedName, containingClass, visibilityStatus);
            AbiQualifiedName abiQualifiedName2 = qualifiedName;
            AbiSignatures abiSignatures2 = this.toAbiSignatures(this.deserializeIdSignature(proto.getBase().getSymbol()));
            AbiAnnotationListImpl abiAnnotationListImpl2 = annotations2;
            ContainingEntity.Class clazz2 = containingClass;
            AbiModality abiModality2 = Companion.toAbiModality(PropertyFlags.getModality-impl(flags), clazz2 != null ? clazz2.getModality() : null);
            AbiPropertyKind abiPropertyKind2 = PropertyFlags.isConst-impl(flags) ? AbiPropertyKind.CONST_VAL : (PropertyFlags.isVar-impl(flags) ? AbiPropertyKind.VAR : AbiPropertyKind.VAL);
            boolean bl = proto.hasGetter();
            LibraryDeserializer libraryDeserializer = LibraryDeserializer.this;
            boolean $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                abiPropertyKind = abiPropertyKind2;
                abiModality = abiModality2;
                abiAnnotationListImpl = abiAnnotationListImpl2;
                abiSignatures = abiSignatures2;
                abiQualifiedName = abiQualifiedName2;
                boolean bl2 = false;
                IrFunctionBase irFunctionBase = proto.getGetter().getBase();
                Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"getBase(...)");
                abiFunction4 = (AbiFunction)libraryDeserializer.discardIfExcluded(this.deserializeFunction(irFunctionBase, false, thisPropertyEntity, typeParameterResolver));
                abiQualifiedName2 = abiQualifiedName;
                abiSignatures2 = abiSignatures;
                abiAnnotationListImpl2 = abiAnnotationListImpl;
                abiModality2 = abiModality;
                abiPropertyKind2 = abiPropertyKind;
                abiFunction3 = abiFunction4;
            } else {
                abiFunction3 = null;
            }
            $this$ifTrue$iv = proto.hasSetter();
            libraryDeserializer = LibraryDeserializer.this;
            $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                abiFunction4 = abiFunction3;
                abiPropertyKind = abiPropertyKind2;
                abiModality = abiModality2;
                abiAnnotationListImpl = abiAnnotationListImpl2;
                abiSignatures = abiSignatures2;
                abiQualifiedName = abiQualifiedName2;
                boolean bl3 = false;
                IrFunctionBase irFunctionBase = proto.getSetter().getBase();
                Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"getBase(...)");
                abiFunction2 = (AbiFunction)libraryDeserializer.discardIfExcluded(this.deserializeFunction(irFunctionBase, false, thisPropertyEntity, typeParameterResolver));
                abiQualifiedName2 = abiQualifiedName;
                abiSignatures2 = abiSignatures;
                abiAnnotationListImpl2 = abiAnnotationListImpl;
                abiModality2 = abiModality;
                abiPropertyKind2 = abiPropertyKind;
                abiFunction3 = abiFunction4;
                abiFunction = abiFunction2;
            } else {
                abiFunction = null;
            }
            $this$ifTrue$iv = proto.hasBackingField();
            boolean $i$f$ifTrue2 = false;
            if ($this$ifTrue$iv) {
                abiFunction2 = abiFunction;
                abiFunction4 = abiFunction3;
                abiPropertyKind = abiPropertyKind2;
                abiModality = abiModality2;
                abiAnnotationListImpl = abiAnnotationListImpl2;
                abiSignatures = abiSignatures2;
                abiQualifiedName = abiQualifiedName2;
                boolean bl4 = false;
                IrDeclarationBase irDeclarationBase3 = proto.getBackingField().getBase();
                Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase3, (String)"getBase(...)");
                AbiFieldImpl abiFieldImpl2 = new AbiFieldImpl(this.deserializeAnnotations(irDeclarationBase3));
                abiQualifiedName2 = abiQualifiedName;
                abiSignatures2 = abiSignatures;
                abiAnnotationListImpl2 = abiAnnotationListImpl;
                abiModality2 = abiModality;
                abiPropertyKind2 = abiPropertyKind;
                abiFunction3 = abiFunction4;
                abiFunction = abiFunction2;
                abiFieldImpl = abiFieldImpl2;
            } else {
                abiFieldImpl = null;
            }
            AbiField abiField = abiFieldImpl;
            AbiFunction abiFunction5 = abiFunction;
            AbiFunction abiFunction6 = abiFunction3;
            AbiPropertyKind abiPropertyKind3 = abiPropertyKind2;
            AbiModality abiModality3 = abiModality2;
            AbiAnnotationListImpl abiAnnotationListImpl3 = abiAnnotationListImpl2;
            AbiSignatures abiSignatures3 = abiSignatures2;
            AbiQualifiedName abiQualifiedName3 = abiQualifiedName2;
            return new AbiPropertyImpl(abiQualifiedName3, abiSignatures3, abiAnnotationListImpl3, abiModality3, abiPropertyKind3, abiFunction6, abiFunction5, abiField);
        }

        private final AbiQualifiedName deserializeQualifiedName(int nameId, ContainingEntity containingEntity) {
            return containingEntity.computeNestedName(this.fileReader.string(nameId));
        }

        private final IdSignature deserializeIdSignature(long symbolId) {
            int signatureId = BinarySymbolData.getSignatureId-impl(BinarySymbolData.Companion.decode-9x8F8T0(symbolId));
            return this.signatureDeserializer.deserializeIdSignature(signatureId);
        }

        private final AbiSignatures toAbiSignatures(IdSignature $this$toAbiSignatures) {
            return new AbiSignaturesImpl(LibraryDeserializer.this.needV1Signatures ? IdSignatureRendererKt.render($this$toAbiSignatures, IdSignatureRenderer.Companion.getLEGACY()) : null, LibraryDeserializer.this.needV2Signatures ? IdSignatureRendererKt.render($this$toAbiSignatures, IdSignatureRenderer.Companion.getDEFAULT()) : null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<AbiTypeParameter> deserializeTypeParameters(List<IrTypeParameter> protos, TypeParameterResolver typeParameterResolver) {
            void $this$mapIndexedTo$iv$iv;
            Collection $this$memoryOptimizedMapIndexed$iv = protos;
            boolean $i$f$memoryOptimizedMapIndexed = false;
            Iterable iterable = $this$memoryOptimizedMapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMapIndexed$iv.size());
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                List list;
                void $this$mapNotNullTo$iv$iv$iv;
                void typeIds$iv;
                void index;
                void proto;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                int n3 = n2;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                long flags = TypeParameterFlags.Companion.decode-dTrNHuw(proto.getBase().getFlags());
                String string = typeParameterResolver.computeTypeParameterTag((int)index);
                AbiVariance abiVariance = Companion.toAbiVariance(TypeParameterFlags.getVariance-impl(flags));
                boolean bl2 = TypeParameterFlags.isReified-impl(flags);
                FileDeserializer fileDeserializer = this;
                Intrinsics.checkNotNullExpressionValue(proto.getSuperTypeList(), (String)"getSuperTypeList(...)");
                TypeParameterResolver typeParameterResolver2 = typeParameterResolver;
                boolean bl3 = bl2;
                AbiVariance abiVariance2 = abiVariance;
                String string2 = string;
                boolean $i$f$deserializeTypes = false;
                Collection $this$memoryOptimizedMapNotNull$iv$iv = (Collection)typeIds$iv;
                boolean $i$f$memoryOptimizedMapNotNull = false;
                Iterable iterable2 = $this$memoryOptimizedMapNotNull$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    AbiType it$iv$iv$iv;
                    void typeParameterResolver$iv;
                    void this_$iv;
                    AbiType abiType;
                    Object element$iv$iv$iv$iv;
                    Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    int typeId$iv = ((Number)element$iv$iv$iv).intValue();
                    boolean bl5 = false;
                    AbiType type = abiType = this_$iv.typeDeserializer.deserializeType(typeId$iv, (TypeParameterResolver)typeParameterResolver$iv);
                    boolean bl6 = false;
                    if ((!Companion.isKotlinBuiltInType(type, KOTLIN_ANY_QUALIFIED_NAME, AbiTypeNullability.MARKED_NULLABLE) ? abiType : null) == null) continue;
                    it$iv$iv$iv = it$iv$iv$iv;
                    boolean bl7 = false;
                    destination$iv$iv$iv.add(it$iv$iv$iv);
                }
                List list2 = list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv$iv);
                boolean bl8 = bl3;
                AbiVariance abiVariance3 = abiVariance2;
                String string3 = string2;
                collection.add(new AbiTypeParameterImpl(string3, abiVariance3, bl8, list2));
            }
            return org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final AbiAnnotationListImpl deserializeAnnotations(IrDeclarationBase proto) {
            void $this$mapTo$iv$iv;
            void $this$memoryOptimizedMap$iv;
            if (proto.getAnnotationCount() == 0) {
                return AbiAnnotationListImpl.Companion.getEMPTY();
            }
            List<IrConstructorCall> list = proto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
            Collection collection = list;
            LibraryDeserializer libraryDeserializer = LibraryDeserializer.this;
            boolean $i$f$memoryOptimizedMap = false;
            Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(FileDeserializer.deserializeAnnotations$deserialize(this, libraryDeserializer, (IrConstructorCall)p0));
            }
            List list2 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            return new AbiAnnotationListImpl(list2);
        }

        private final VisibilityStatus computeVisibilityStatus(IrDeclarationBase proto, AbiAnnotationListImpl annotations2, AbiModality containingClassModality, VisibilityStatus parentPropertyVisibilityStatus) {
            VisibilityStatus visibilityStatus;
            ProtoBuf.Visibility visibility = (ProtoBuf.Visibility)IrFlags.VISIBILITY.get((int)proto.getFlags());
            switch (visibility == null ? -1 : WhenMappings.$EnumSwitchMapping$3[visibility.ordinal()]) {
                case 1: {
                    visibilityStatus = VisibilityStatus.PUBLIC;
                    break;
                }
                case 2: {
                    if (containingClassModality == AbiModality.FINAL) {
                        visibilityStatus = VisibilityStatus.NON_PUBLIC;
                        break;
                    }
                    visibilityStatus = VisibilityStatus.PUBLIC;
                    break;
                }
                case 3: {
                    if (parentPropertyVisibilityStatus == VisibilityStatus.INTERNAL_PUBLISHED_API) {
                        visibilityStatus = VisibilityStatus.INTERNAL_PUBLISHED_API;
                        break;
                    }
                    if (annotations2.hasAnnotation(PUBLISHED_API_CONSTRUCTOR_QUALIFIED_NAME)) {
                        visibilityStatus = VisibilityStatus.INTERNAL_PUBLISHED_API;
                        break;
                    }
                    visibilityStatus = VisibilityStatus.NON_PUBLIC;
                    break;
                }
                default: {
                    visibilityStatus = VisibilityStatus.NON_PUBLIC;
                }
            }
            return visibilityStatus;
        }

        static /* synthetic */ VisibilityStatus computeVisibilityStatus$default(FileDeserializer fileDeserializer, IrDeclarationBase irDeclarationBase, AbiAnnotationListImpl abiAnnotationListImpl, AbiModality abiModality, VisibilityStatus visibilityStatus, int n2, Object object) {
            if ((n2 & 8) != 0) {
                visibilityStatus = null;
            }
            return fileDeserializer.computeVisibilityStatus(irDeclarationBase, abiAnnotationListImpl, abiModality, visibilityStatus);
        }

        private final AbiValueParameter deserializeValueParameter(IrValueParameter proto, AbiValueParameterKind kind, TypeParameterResolver typeParameterResolver) {
            long flags = ValueParameterFlags.Companion.decode-eyNVhwA(proto.getBase().getFlags());
            return new AbiValueParameterImpl(kind, this.typeDeserializer.deserializeType(BinaryNameAndType.getTypeIndex-impl(BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType())), typeParameterResolver), proto.hasVarargElementType(), proto.hasDefaultValue(), ValueParameterFlags.isNoInline-impl(flags), ValueParameterFlags.isCrossInline-impl(flags));
        }

        private static final boolean deserializeClass$lambda$0(LibraryDeserializer this$0, FileDeserializer this$1, IrClass $proto) {
            return this$0.platform != BuiltInsPlatform.NATIVE || !this$1.isDirectlyInheritedFromNativeInteropClass($proto);
        }

        private static final IdSignature isDirectlyInheritedFromNativeInteropClass$extractIdSignature(FileDeserializer this$0, int typeId) {
            long l2;
            IrType type = this$0.fileReader.type(typeId);
            IrType.KindCase kindCase = type.getKindCase();
            switch (kindCase == null ? -1 : WhenMappings.$EnumSwitchMapping$2[kindCase.ordinal()]) {
                case 1: {
                    IrDefinitelyNotNullType irDefinitelyNotNullType = type.getDnn();
                    Intrinsics.checkNotNullExpressionValue((Object)irDefinitelyNotNullType, (String)"getDnn(...)");
                    return FileDeserializer.isDirectlyInheritedFromNativeInteropClass$extractIdSignature(this$0, TypeDeserializer.Companion.getUnderlyingTypeId(irDefinitelyNotNullType));
                }
                case 2: {
                    l2 = type.getSimple().getClassifier();
                    break;
                }
                case 3: {
                    l2 = type.getLegacySimple().getClassifier();
                    break;
                }
                case -1: 
                case 4: 
                case 5: 
                case 6: {
                    return null;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            long symbolId = l2;
            return this$0.deserializeIdSignature(symbolId);
        }

        /*
         * WARNING - void declaration
         */
        private static final AbiAnnotation deserializeAnnotations$deserialize(FileDeserializer this$0, LibraryDeserializer this$1, IrConstructorCall annotation) {
            void rawRelativeName;
            void $this$extractQualifiedName$iv;
            IdSignature.CommonSignature commonSignature;
            IdSignature idSignature = this$0.deserializeIdSignature(annotation.getSymbol());
            Companion companion = Companion;
            if (idSignature instanceof IdSignature.CommonSignature) {
                commonSignature = (IdSignature.CommonSignature)idSignature;
            } else if (idSignature instanceof IdSignature.CompositeSignature && ((IdSignature.CompositeSignature)idSignature).getContainer() instanceof IdSignature.FileSignature) {
                IdSignature idSignature2 = ((IdSignature.CompositeSignature)idSignature).getInner();
                Intrinsics.checkNotNull((Object)idSignature2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.CommonSignature");
                commonSignature = (IdSignature.CommonSignature)idSignature2;
            } else {
                throw new IllegalStateException(("Unexpected annotation signature encountered: " + idSignature.getClass() + ", " + IdSignatureRendererKt.render$default(idSignature, null, 1, null)).toString());
            }
            IdSignature.CommonSignature commonSignature2 = commonSignature;
            boolean $i$f$extractQualifiedName = false;
            String string = $this$extractQualifiedName$iv.getDeclarationFqName();
            String string2 = AbiCompoundName.constructor-impl($this$extractQualifiedName$iv.getPackageFqName());
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)rawRelativeName, (String)INIT_SUFFIX, (boolean)false, (int)2, null)) {
                boolean bl2 = false;
                String string3 = "Annotation constructor name does not have '" + INIT_SUFFIX + "' suffix: " + (String)rawRelativeName;
                throw new IllegalStateException(string3.toString());
            }
            String string4 = rawRelativeName.substring(0, rawRelativeName.length() - INIT_SUFFIX.length());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            DefaultConstructorMarker defaultConstructorMarker = null;
            String string5 = AbiCompoundName.constructor-impl(string4);
            String string6 = string2;
            AbiQualifiedName annotationClassName = new AbiQualifiedName(string6, string5, defaultConstructorMarker);
            return this$1.annotationInterner.intern(new AbiAnnotationImpl(annotationClassName));
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;

            static {
                int[] nArray = new int[IrDeclaration.DeclaratorCase.values().length];
                try {
                    nArray[IrDeclaration.DeclaratorCase.IR_CLASS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrDeclaration.DeclaratorCase.IR_CONSTRUCTOR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrDeclaration.DeclaratorCase.IR_FUNCTION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrDeclaration.DeclaratorCase.IR_PROPERTY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrDeclaration.DeclaratorCase.IR_ENUM_ENTRY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ClassKind.values().length];
                try {
                    nArray[ClassKind.CLASS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ClassKind.INTERFACE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ClassKind.OBJECT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ClassKind.ENUM_CLASS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ClassKind.ENUM_ENTRY.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[IrType.KindCase.values().length];
                try {
                    nArray[IrType.KindCase.DNN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.SIMPLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.LEGACYSIMPLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.DYNAMIC.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.ERROR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.KIND_NOT_SET.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[ProtoBuf.Visibility.values().length];
                try {
                    nArray[ProtoBuf.Visibility.PUBLIC.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Visibility.PROTECTED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Visibility.INTERNAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$3 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020'0#2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeDeserializer;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "libraryFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "signatureDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;)V", "typeIdToTypeCache", "Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "", "Lorg/jetbrains/kotlin/library/abi/AbiType;", "nonPublicTopLevelClassNames", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "Lkotlin/collections/HashSet;", "deserializeType", "typeId", "typeParameterResolver", "Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeParameterResolver;", "isPubliclyVisible", "", "type", "deserializeDefinitelyNotNullType", "proto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDefinitelyNotNullType;", "deserializeSimpleType", "Lorg/jetbrains/kotlin/library/abi/AbiType$Simple;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrSimpleType;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrSimpleTypeLegacy;", "symbolId", "", "typeArgumentIds", "", "nullability", "Lorg/jetbrains/kotlin/library/abi/AbiTypeNullability;", "deserializeTypeArguments", "Lorg/jetbrains/kotlin/library/abi/AbiTypeArgument;", "Companion", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeDeserializer\n+ 2 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$Companion\n+ 3 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$Companion$extractQualifiedName$1\n+ 4 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,831:1\n814#2,2:832\n814#2,2:835\n814#2,2:838\n814#3:834\n814#3:837\n814#3:840\n16#4:841\n1661#5,3:842\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeDeserializer\n*L\n724#1:832,2\n735#1:835,2\n750#1:838,2\n724#1:834\n735#1:837\n750#1:840\n769#1:841\n769#1:842,3\n*E\n"})
    private static final class TypeDeserializer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IrLibraryFile libraryFile;
        @NotNull
        private final IdSignatureDeserializer signatureDeserializer;
        @NotNull
        private final CacheWithNotNullValues<Integer, AbiType> typeIdToTypeCache;
        @NotNull
        private final HashSet<AbiQualifiedName> nonPublicTopLevelClassNames;

        public TypeDeserializer(@NotNull StorageManager storageManager, @NotNull IrLibraryFile libraryFile, @NotNull IdSignatureDeserializer signatureDeserializer) {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
            Intrinsics.checkNotNullParameter((Object)signatureDeserializer, (String)"signatureDeserializer");
            this.libraryFile = libraryFile;
            this.signatureDeserializer = signatureDeserializer;
            this.typeIdToTypeCache = storageManager.createCacheWithNotNullValues();
            this.nonPublicTopLevelClassNames = new HashSet();
        }

        @NotNull
        public final AbiType deserializeType(int typeId, @NotNull TypeParameterResolver typeParameterResolver) {
            Intrinsics.checkNotNullParameter((Object)typeParameterResolver, (String)"typeParameterResolver");
            return this.typeIdToTypeCache.computeIfAbsent(typeId, (Function0<AbiType>)((Function0)() -> TypeDeserializer.deserializeType$lambda$0(this, typeId, typeParameterResolver)));
        }

        public final boolean isPubliclyVisible(@NotNull AbiType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            AbiType.Simple simple2 = type instanceof AbiType.Simple ? (AbiType.Simple)type : null;
            AbiClassifierReference abiClassifierReference = simple2 != null ? simple2.getClassifierReference() : null;
            AbiClassifierReference.ClassReference classReference = abiClassifierReference instanceof AbiClassifierReference.ClassReference ? (AbiClassifierReference.ClassReference)abiClassifierReference : null;
            return !CollectionsKt.contains((Iterable)this.nonPublicTopLevelClassNames, (Object)(classReference != null ? classReference.getClassName() : null));
        }

        private final AbiType deserializeDefinitelyNotNullType(IrDefinitelyNotNullType proto, TypeParameterResolver typeParameterResolver) {
            AbiType underlyingType = this.deserializeType(Companion.getUnderlyingTypeId(proto), typeParameterResolver);
            return underlyingType instanceof AbiType.Simple && ((AbiType.Simple)underlyingType).getNullability() != AbiTypeNullability.DEFINITELY_NOT_NULL ? (AbiType)new SimpleTypeImpl(((AbiType.Simple)underlyingType).getClassifierReference(), ((AbiType.Simple)underlyingType).getArguments(), AbiTypeNullability.DEFINITELY_NOT_NULL) : underlyingType;
        }

        private final AbiType.Simple deserializeSimpleType(IrSimpleType proto, TypeParameterResolver typeParameterResolver) {
            AbiTypeNullability abiTypeNullability;
            List<Long> list;
            long l2;
            block6: {
                block5: {
                    l2 = proto.getClassifier();
                    list = proto.getArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
                    if (!proto.hasNullability()) break block5;
                    IrSimpleTypeNullability irSimpleTypeNullability = proto.getNullability();
                    Intrinsics.checkNotNull((Object)irSimpleTypeNullability);
                    switch (WhenMappings.$EnumSwitchMapping$1[irSimpleTypeNullability.ordinal()]) {
                        case 1: {
                            abiTypeNullability = AbiTypeNullability.MARKED_NULLABLE;
                            break block6;
                        }
                        case 2: {
                            abiTypeNullability = AbiTypeNullability.NOT_SPECIFIED;
                            break block6;
                        }
                        case 3: {
                            abiTypeNullability = AbiTypeNullability.DEFINITELY_NOT_NULL;
                            break block6;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                abiTypeNullability = AbiTypeNullability.NOT_SPECIFIED;
            }
            return this.deserializeSimpleType(l2, list, abiTypeNullability, typeParameterResolver);
        }

        private final AbiType.Simple deserializeSimpleType(IrSimpleTypeLegacy proto, TypeParameterResolver typeParameterResolver) {
            long l2 = proto.getClassifier();
            List<Long> list = proto.getArgumentList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
            return this.deserializeSimpleType(l2, list, proto.hasHasQuestionMark() && proto.getHasQuestionMark() ? AbiTypeNullability.MARKED_NULLABLE : AbiTypeNullability.NOT_SPECIFIED, typeParameterResolver);
        }

        private final AbiType.Simple deserializeSimpleType(long symbolId, List<Long> typeArgumentIds, AbiTypeNullability nullability, TypeParameterResolver typeParameterResolver) {
            AbiType.Simple simple2;
            long symbolData = BinarySymbolData.Companion.decode-9x8F8T0(symbolId);
            IdSignature idSignature = this.signatureDeserializer.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            BinarySymbolData.SymbolKind symbolKind = BinarySymbolData.getKind-impl(symbolData);
            if (symbolKind == BinarySymbolData.SymbolKind.CLASS_SYMBOL && idSignature instanceof IdSignature.CommonSignature) {
                org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer$Companion companion = Companion;
                IdSignature.CommonSignature $receiver$iv = (IdSignature.CommonSignature)idSignature;
                boolean $i$f$extractQualifiedName = false;
                String string = $receiver$iv.getDeclarationFqName();
                String string2 = AbiCompoundName.constructor-impl($receiver$iv.getPackageFqName());
                boolean bl = false;
                String it = string;
                DefaultConstructorMarker defaultConstructorMarker = null;
                String string3 = AbiCompoundName.constructor-impl(it);
                String string4 = string2;
                AbiQualifiedName abiQualifiedName = new AbiQualifiedName(string4, string3, defaultConstructorMarker);
                AbiTypeNullability abiTypeNullability = nullability;
                List<AbiTypeArgument> list = this.deserializeTypeArguments(typeArgumentIds, typeParameterResolver);
                AbiClassifierReference abiClassifierReference = new ClassReferenceImpl(abiQualifiedName);
                simple2 = new SimpleTypeImpl(abiClassifierReference, list, abiTypeNullability);
            } else if (symbolKind == BinarySymbolData.SymbolKind.CLASS_SYMBOL && idSignature instanceof IdSignature.CompositeSignature && ((IdSignature.CompositeSignature)idSignature).getContainer() instanceof IdSignature.FileSignature) {
                org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer$Companion $receiver$iv = Companion;
                IdSignature idSignature2 = ((IdSignature.CompositeSignature)idSignature).getInner();
                Intrinsics.checkNotNull((Object)idSignature2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.CommonSignature");
                IdSignature.CommonSignature $receiver$iv2 = (IdSignature.CommonSignature)idSignature2;
                boolean $i$f$extractQualifiedName2 = false;
                String bl = $receiver$iv2.getDeclarationFqName();
                String string = AbiCompoundName.constructor-impl($receiver$iv2.getPackageFqName());
                boolean $i$a$-extractQualifiedName-LibraryDeserializer$Companion$extractQualifiedName$2 = false;
                String it = bl;
                DefaultConstructorMarker defaultConstructorMarker = null;
                String string5 = AbiCompoundName.constructor-impl(it);
                String string6 = string;
                AbiQualifiedName className = new AbiQualifiedName(string6, string5, defaultConstructorMarker);
                ((Collection)this.nonPublicTopLevelClassNames).add(className);
                simple2 = new SimpleTypeImpl(new ClassReferenceImpl(className), this.deserializeTypeArguments(typeArgumentIds, typeParameterResolver), nullability);
            } else if (symbolKind == BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL && idSignature instanceof IdSignature.CompositeSignature) {
                String it;
                org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer$Companion className = Companion;
                IdSignature idSignature3 = ((IdSignature.CompositeSignature)idSignature).getContainer();
                Intrinsics.checkNotNull((Object)idSignature3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.CommonSignature");
                IdSignature.CommonSignature $receiver$iv = (IdSignature.CommonSignature)idSignature3;
                boolean $i$f$extractQualifiedName = false;
                String $i$f$extractQualifiedName2 = $receiver$iv.getDeclarationFqName();
                String string = AbiCompoundName.constructor-impl($receiver$iv.getPackageFqName());
                TypeParameterResolver typeParameterResolver2 = typeParameterResolver;
                boolean $i$a$-extractQualifiedName-LibraryDeserializer$Companion$extractQualifiedName$3 = false;
                String string7 = it = $i$f$extractQualifiedName2;
                DefaultConstructorMarker defaultConstructorMarker = null;
                String string8 = AbiCompoundName.constructor-impl(string7);
                String string9 = string;
                AbiQualifiedName abiQualifiedName = new AbiQualifiedName(string9, string8, defaultConstructorMarker);
                IdSignature idSignature4 = ((IdSignature.CompositeSignature)idSignature).getInner();
                Intrinsics.checkNotNull((Object)idSignature4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.LocalSignature");
                String string10 = typeParameterResolver2.resolveTypeParameterTag(abiQualifiedName, ((IdSignature.LocalSignature)idSignature4).index());
                AbiTypeNullability abiTypeNullability = nullability;
                List list = CollectionsKt.emptyList();
                AbiClassifierReference abiClassifierReference = new TypeParameterReferenceImpl(string10);
                simple2 = new SimpleTypeImpl(abiClassifierReference, list, abiTypeNullability);
            } else {
                throw new IllegalStateException(("Unexpected combination of symbol kind (" + (Object)((Object)symbolKind) + ") and a signature: " + idSignature.getClass() + ", " + IdSignatureRendererKt.render$default(idSignature, null, 1, null)).toString());
            }
            return simple2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<AbiTypeArgument> deserializeTypeArguments(List<Long> typeArgumentIds, TypeParameterResolver typeParameterResolver) {
            List list;
            if (typeArgumentIds.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                Collection $this$memoryOptimizedMap$iv = typeArgumentIds;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = $this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void typeArgumentId;
                    long l2 = ((Number)item$iv$iv).longValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    long typeProjection = BinaryTypeProjection.Companion.decode-2ztXSlc((long)typeArgumentId);
                    collection.add(BinaryTypeProjection.isStarProjection-impl(typeProjection) ? (AbiTypeArgument)StarProjectionImpl.INSTANCE : (AbiTypeArgument)new TypeProjectionImpl(this.deserializeType(BinaryTypeProjection.getTypeIndex-impl(typeProjection), typeParameterResolver), Companion.toAbiVariance(BinaryTypeProjection.getVariance-impl(typeProjection))));
                }
                list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            }
            return list;
        }

        private static final AbiType deserializeType$lambda$0(TypeDeserializer this$0, int $typeId, TypeParameterResolver $typeParameterResolver) {
            AbiType abiType;
            IrType.KindCase kindCase;
            IrType proto = this$0.libraryFile.type($typeId);
            IrType.KindCase kindCase2 = kindCase = proto.getKindCase();
            switch (kindCase2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[kindCase2.ordinal()]) {
                case 1: {
                    IrDefinitelyNotNullType irDefinitelyNotNullType = proto.getDnn();
                    Intrinsics.checkNotNullExpressionValue((Object)irDefinitelyNotNullType, (String)"getDnn(...)");
                    abiType = this$0.deserializeDefinitelyNotNullType(irDefinitelyNotNullType, $typeParameterResolver);
                    break;
                }
                case 2: {
                    IrSimpleType irSimpleType = proto.getSimple();
                    Intrinsics.checkNotNullExpressionValue((Object)irSimpleType, (String)"getSimple(...)");
                    abiType = this$0.deserializeSimpleType(irSimpleType, $typeParameterResolver);
                    break;
                }
                case 3: {
                    IrSimpleTypeLegacy irSimpleTypeLegacy = proto.getLegacySimple();
                    Intrinsics.checkNotNullExpressionValue((Object)irSimpleTypeLegacy, (String)"getLegacySimple(...)");
                    abiType = this$0.deserializeSimpleType(irSimpleTypeLegacy, $typeParameterResolver);
                    break;
                }
                case 4: {
                    abiType = DynamicTypeImpl.INSTANCE;
                    break;
                }
                case 5: {
                    abiType = ErrorTypeImpl.INSTANCE;
                    break;
                }
                case -1: 
                case 6: {
                    throw new IllegalStateException(("Unexpected IR type: " + kindCase).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return abiType;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeDeserializer$Companion;", "", "<init>", "()V", "underlyingTypeId", "", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDefinitelyNotNullType;", "getUnderlyingTypeId", "(Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDefinitelyNotNullType;)I", "kotlin-util-klib-abi"})
        public static final class Companion {
            private Companion() {
            }

            public final int getUnderlyingTypeId(@NotNull IrDefinitelyNotNullType $this$underlyingTypeId) {
                Intrinsics.checkNotNullParameter((Object)$this$underlyingTypeId, (String)"<this>");
                List<Integer> list = $this$underlyingTypeId.getTypesList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTypesList(...)");
                Integer n2 = (Integer)CollectionsKt.singleOrNull(list);
                if (n2 == null) {
                    throw new IllegalStateException("Only DefinitelyNotNull type is now supported".toString());
                }
                return n2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[IrType.KindCase.values().length];
                try {
                    nArray[IrType.KindCase.DNN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.SIMPLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.LEGACYSIMPLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.DYNAMIC.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.ERROR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrType.KindCase.KIND_NOT_SET.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[IrSimpleTypeNullability.values().length];
                try {
                    nArray[IrSimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrSimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IrSimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeParameterResolver;", "", "declarationName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "parent", "levelAdjustment", "", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeParameterResolver;I)V", "getParent", "()Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeParameterResolver;", "level", "getLevel", "()I", "computeTypeParameterTag", "", "index", "resolveTypeParameterTag", "Companion", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeParameterResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,831:1\n1#2:832\n*E\n"})
    private static final class TypeParameterResolver {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AbiQualifiedName declarationName;
        @Nullable
        private final TypeParameterResolver parent;
        private final int level;

        /*
         * WARNING - void declaration
         */
        public TypeParameterResolver(@NotNull AbiQualifiedName declarationName, @Nullable TypeParameterResolver parent2, int levelAdjustment) {
            int n2;
            Intrinsics.checkNotNullParameter((Object)declarationName, (String)"declarationName");
            this.declarationName = declarationName;
            this.parent = parent2;
            TypeParameterResolver typeParameterResolver = this;
            TypeParameterResolver typeParameterResolver2 = this.parent;
            if (typeParameterResolver2 != null) {
                void it;
                TypeParameterResolver typeParameterResolver3 = typeParameterResolver2;
                TypeParameterResolver typeParameterResolver4 = typeParameterResolver;
                boolean bl = false;
                int n3 = it.level + 1;
                typeParameterResolver = typeParameterResolver4;
                n2 = n3;
            } else {
                n2 = 0;
            }
            typeParameterResolver.level = n2 + levelAdjustment;
        }

        public /* synthetic */ TypeParameterResolver(AbiQualifiedName abiQualifiedName, TypeParameterResolver typeParameterResolver, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(abiQualifiedName, typeParameterResolver, n2);
        }

        @Nullable
        public final TypeParameterResolver getParent() {
            return this.parent;
        }

        public final int getLevel() {
            return this.level;
        }

        @NotNull
        public final String computeTypeParameterTag(int index) {
            String tagPrefix = TypeParameterResolver.Companion.computeTagPrefix(index);
            return this.level > 0 ? tagPrefix + this.level : tagPrefix;
        }

        @NotNull
        public final String resolveTypeParameterTag(@NotNull AbiQualifiedName declarationName, int index) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)declarationName, (String)"declarationName");
            if (Intrinsics.areEqual((Object)declarationName, (Object)this.declarationName)) {
                object = this.computeTypeParameterTag(index);
            } else {
                object = this.parent;
                if (object == null || (object = ((TypeParameterResolver)object).resolveTypeParameterTag(declarationName, index)) == null) {
                    throw new IllegalStateException(("Type parameter with local index " + index + " can not be resolved for " + declarationName).toString());
                }
            }
            return object;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$TypeParameterResolver$Companion;", "", "<init>", "()V", "ALPHABET_SIZE", "", "computeTagPrefix", "", "index", "kotlin-util-klib-abi"})
        public static final class Companion {
            private Companion() {
            }

            private final String computeTagPrefix(int index) {
                SmartList result2 = new SmartList();
                int quotient = index;
                int remainder = quotient % 26;
                do {
                    ((Collection)result2).add(Character.valueOf((char)(65 + remainder)));
                    remainder = ((quotient /= 26) - 1) % 26;
                } while (quotient != 0);
                return result2.size() == 1 ? String.valueOf(result2.get(0)) : CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversedMutable((List)result2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryDeserializer$VisibilityStatus;", "", "isPubliclyVisible", "", "<init>", "(Ljava/lang/String;IZ)V", "()Z", "PUBLIC", "INTERNAL_PUBLISHED_API", "NON_PUBLIC", "kotlin-util-klib-abi"})
    private static final class VisibilityStatus
    extends Enum<VisibilityStatus> {
        private final boolean isPubliclyVisible;
        public static final /* enum */ VisibilityStatus PUBLIC = new VisibilityStatus(true);
        public static final /* enum */ VisibilityStatus INTERNAL_PUBLISHED_API = new VisibilityStatus(true);
        public static final /* enum */ VisibilityStatus NON_PUBLIC = new VisibilityStatus(false);
        private static final /* synthetic */ VisibilityStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VisibilityStatus(boolean isPubliclyVisible) {
            this.isPubliclyVisible = isPubliclyVisible;
        }

        public final boolean isPubliclyVisible() {
            return this.isPubliclyVisible;
        }

        public static VisibilityStatus[] values() {
            return (VisibilityStatus[])$VALUES.clone();
        }

        public static VisibilityStatus valueOf(String value2) {
            return Enum.valueOf(VisibilityStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<VisibilityStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = visibilityStatusArray = new VisibilityStatus[]{VisibilityStatus.PUBLIC, VisibilityStatus.INTERNAL_PUBLISHED_API, VisibilityStatus.NON_PUBLIC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

