/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 N2\u00020\u0001:\u0001NBO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J@\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d0\u001b2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J:\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010(0\u001b2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020/H\u0002J*\u00100\u001a\u0002012\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020/J4\u00100\u001a\u0002012\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020/2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u00102\u001a\u0002012\u0006\u00103\u001a\u0002042\u0006\u0010!\u001a\u00020/J4\u00105\u001a\u0002012\u0006\u00103\u001a\u0002042\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020/2\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020807*\u0002092\u0006\u0010!\u001a\u00020/H\u0002J&\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\u0006\u0010!\u001a\u00020/2\u0006\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020?H\u0002J4\u0010@\u001a\u0002012\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010!\u001a\u00020/2\u0006\u0010%\u001a\u00020&H\u0002J \u0010C\u001a\u0002012\u0006\u0010+\u001a\u00020,2\u0006\u0010D\u001a\u0002082\u0006\u0010!\u001a\u00020/H\u0002J \u0010E\u001a\u0002012\u0006\u0010F\u001a\u0002092\u0006\u0010G\u001a\u0002012\u0006\u0010!\u001a\u00020/H\u0002J \u0010H\u001a\u00020\u00192\u0006\u0010F\u001a\u0002092\u0006\u0010I\u001a\u0002012\u0006\u0010!\u001a\u00020/H\u0002J\u0016\u0010J\u001a\u0002012\u0006\u0010=\u001a\u0002092\u0006\u0010!\u001a\u00020/J\"\u0010K\u001a\u00020\u00192\u0006\u0010L\u001a\u00020M2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010!\u001a\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)V", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "setExpressionTypingServices", "", "getResolvedCallForFunction", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "initialDataFlowInfoForArguments", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getVariableType", "Lorg/jetbrains/kotlin/types/KotlinType;", "nameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "callOperationNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getSimpleNameExpressionTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "getCallExpressionTypeInfo", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getCallExpressionTypeInfoWithoutFinalTypeCheck", "elementChain", "", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "resolveSimpleName", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "expression", "traceAndCache", "Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryTraceAndCache;", "getUnsafeSelectorTypeInfo", "selectorExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getSafeOrUnsafeSelectorTypeInfo", "element", "checkSelectorTypeInfo", "qualified", "selectorTypeInfo", "recordResultTypeInfo", "resultTypeInfo", "getQualifiedExpressionTypeInfo", "resolveDeferredReceiverInQualifiedExpression", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "Companion", "frontend"})
@SourceDebugExtension(value={"SMAP\nCallExpressionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallExpressionResolver.kt\norg/jetbrains/kotlin/resolve/calls/CallExpressionResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,574:1\n1#2:575\n*E\n"})
public final class CallExpressionResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    private ExpressionTypingServices expressionTypingServices;

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)callResolver, (String)"callResolver");
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)qualifiedExpressionResolver, (String)"qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    @Inject
    public final void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.expressionTypingServices = expressionTypingServices;
    }

    private final Pair<Boolean, ResolvedCall<FunctionDescriptor>> getResolvedCallForFunction(Call call2, ResolutionContext<?> context2, CheckArgumentTypesMode checkArguments, DataFlowInfo initialDataFlowInfoForArguments) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context2, call2, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call2)));
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"resolveFunctionCall(...)");
        OverloadResolutionResults<FunctionDescriptor> results = overloadResolutionResults;
        return !results.isNothing() ? new Pair((Object)true, OverloadResolutionResultsUtil.getResultingCall(results, context2)) : new Pair((Object)false, null);
    }

    private final Pair<Boolean, KotlinType> getVariableType(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context2) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as local variable or property", nameExpression);
        Call call2 = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makePropertyCall(...)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2.replaceTraceAndCache(temporaryForVariable), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)basicCallResolutionContext, (String)"create(...)");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"resolveSimpleProperty(...)");
        OverloadResolutionResults<VariableDescriptor> resolutionResult = overloadResolutionResults;
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                temporaryForVariable.commit();
                return new Pair((Object)true, resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null);
            }
        }
        temporaryForVariable.commit();
        return new Pair((Object)(!resolutionResult.isNothing() ? 1 : 0), resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null);
    }

    @NotNull
    public final KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)nameExpression, (String)"nameExpression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        return this.getSimpleNameExpressionTypeInfo(nameExpression, receiver, callOperationNode, context2, dataFlowInfo);
    }

    private final KotlinTypeInfo getSimpleNameExpressionTypeInfo(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable", nameExpression);
        Object Context2 = context2.replaceTraceAndCache(temporaryForVariable);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceTraceAndCache(...)");
        Pair<Boolean, KotlinType> pair = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)Context2);
        boolean notNothing = (Boolean)pair.component1();
        KotlinType type = (KotlinType)pair.component2();
        if (notNothing) {
            temporaryForVariable.commit();
            return TypeInfoFactoryKt.createTypeInfo(type, initialDataFlowInfoForArguments);
        }
        Call call2 = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(...)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function", nameExpression);
        Object Context3 = context2.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context3, (String)"replaceTraceAndCache(...)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context3;
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair2 = this.getResolvedCallForFunction(call3, newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean resolveResult = (Boolean)pair2.component1();
        ResolvedCall resolvedCall2 = (ResolvedCall)pair2.component2();
        if (resolveResult) {
            FunctionDescriptor functionDescriptor;
            ResolvedCall resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor2 = functionDescriptor = resolvedCall3 != null ? (FunctionDescriptor)resolvedCall3.getResultingDescriptor() : null;
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                temporaryForFunction.commit();
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)nameExpression), nameExpression, hasValueParameters));
                FunctionDescriptor functionDescriptor3 = functionDescriptor;
                return TypeInfoFactoryKt.createTypeInfo(functionDescriptor3 != null ? functionDescriptor3.getReturnType() : null, context2);
            }
        }
        TemporaryTraceAndCache temporaryForQualifier = TemporaryTraceAndCache.create(context2, "trace to resolve as qualifier", nameExpression);
        Object Context4 = context2.replaceTraceAndCache(temporaryForQualifier);
        Intrinsics.checkNotNullExpressionValue(Context4, (String)"replaceTraceAndCache(...)");
        ExpressionTypingContext contextForQualifier = (ExpressionTypingContext)Context4;
        Qualifier qualifier = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver, contextForQualifier);
        if (qualifier != null) {
            Qualifier it = qualifier;
            boolean bl = false;
            QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(it, contextForQualifier);
            temporaryForQualifier.commit();
        } else {
            temporaryForVariable.commit();
        }
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @NotNull
    public final KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, null, null, context2, dataFlowInfo);
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context2);
        }
        return typeInfo;
    }

    private final KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(KtCallExpression callExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        Call call2 = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(...)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function call", callExpression);
        Object Context2 = context2.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceTraceAndCache(...)");
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair = this.getResolvedCallForFunction(call3, (ResolutionContext<?>)Context2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean resolveResult = (Boolean)pair.component1();
        ResolvedCall resolvedCall2 = (ResolvedCall)pair.component2();
        if (resolveResult) {
            DataFlowInfo resultFlowInfo;
            ResolvedCall resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor = resolvedCall3 != null ? (FunctionDescriptor)resolvedCall3.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)callExpression), callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return TypeInfoFactoryKt.noTypeInfo(context2);
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
                ClassDescriptor constructedClass = classDescriptor;
                if (DescriptorUtils.isAnnotationClass(constructedClass)) {
                    boolean supported;
                    BindingTrace bindingTrace = context2.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                    if (!Companion.canInstantiateAnnotationClass(callExpression, bindingTrace) && !(supported = context2.languageVersionSettings.supportsFeature(LanguageFeature.InstantiationOfAnnotationClasses))) {
                        context2.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                    }
                }
                if (DescriptorUtils.isEnumClass(constructedClass)) {
                    context2.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
                if (DescriptorUtils.isSealedClass(constructedClass)) {
                    context2.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
            }
            KotlinType type = functionDescriptor.getReturnType();
            List<KtValueArgument> arguments = callExpression.getValueArguments();
            DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"getResultInfo(...)");
            DataFlowInfo jumpFlowInfo = resultFlowInfo = dataFlowInfo;
            boolean jumpOutPossible = false;
            for (KtValueArgument argument : arguments) {
                KotlinTypeInfo argTypeInfo = (KotlinTypeInfo)context2.trace.get(BindingContext.EXPRESSION_TYPE_INFO, argument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            return TypeInfoFactoryKt.createTypeInfo(type, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable with 'invoke' call", callExpression);
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)calleeExpression;
            Object Context3 = context2.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"replaceTraceAndCache(...)");
            Pair<Boolean, KotlinType> pair2 = this.getVariableType(ktSimpleNameExpression, receiver, callOperationNode, (ExpressionTypingContext)Context3);
            boolean notNothing = (Boolean)pair2.component1();
            KotlinType type = (KotlinType)pair2.component2();
            TemporaryBindingTrace temporaryBindingTrace = temporaryForVariable.trace;
            WritableSlice<KtExpression, Qualifier> writableSlice = BindingContext.QUALIFIER;
            Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"QUALIFIER");
            Qualifier qualifier = (Qualifier)temporaryBindingTrace.get(writableSlice, calleeExpression);
            if (notNothing && (qualifier == null || !(qualifier instanceof PackageQualifier))) {
                ResolvedCall<? extends CallableDescriptor> it = CallUtilKt.getResolvedCall(callExpression, temporaryForVariable.trace.getBindingContext());
                boolean bl = false;
                ResolvedCallImpl resolvedCallImpl = it instanceof ResolvedCallImpl ? (ResolvedCallImpl)it : null;
                if (resolvedCallImpl != null) {
                    resolvedCallImpl.addStatus(ResolutionStatus.OTHER_ERROR);
                }
                temporaryForVariable.commit();
                BindingTrace bindingTrace = context2.trace;
                PsiElement psiElement = calleeExpression;
                KotlinType kotlinType = type;
                if (kotlinType == null) {
                    kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_EXPECTED_TYPE, new String[0]);
                }
                bindingTrace.report(Errors.FUNCTION_EXPECTED.on((KtExpression)psiElement, calleeExpression, kotlinType));
                this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(BasicCallResolutionContext.create(context2, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call3)), ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
                return TypeInfoFactoryKt.noTypeInfo(context2);
            }
        }
        temporaryForFunction.commit();
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    private final List<CallExpressionElement> elementChain(KtQualifiedExpression $this$elementChain, ExpressionTypingContext context2) {
        return this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll($this$elementChain, context2, (Function1<? super KtSimpleNameExpression, Boolean>)((Function1)arg_0 -> CallExpressionResolver.elementChain$lambda$0(context2, this, arg_0)));
    }

    private final OverloadResolutionResults<VariableDescriptor> resolveSimpleName(ExpressionTypingContext context2, KtSimpleNameExpression expression2, TemporaryTraceAndCache traceAndCache) {
        Call call2 = CallMaker.makePropertyCall(null, null, expression2);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makePropertyCall(...)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2.replaceTraceAndCache(traceAndCache), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)basicCallResolutionContext, (String)"create(...)");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"resolveSimpleProperty(...)");
        return overloadResolutionResults;
    }

    private final KotlinTypeInfo getUnsafeSelectorTypeInfo(Receiver receiver, ASTNode callOperationNode, KtExpression selectorExpression, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        KotlinTypeInfo kotlinTypeInfo;
        KtExpression ktExpression = selectorExpression;
        if (ktExpression instanceof KtCallExpression) {
            kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode, context2, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode, context2, initialDataFlowInfoForArguments);
        } else if (ktExpression != null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"expressionTypingServices");
                expressionTypingServices = null;
            }
            expressionTypingServices.getTypeInfo(selectorExpression, context2);
            context2.trace.report(Errors.ILLEGAL_SELECTOR.on((KtExpression)((PsiElement)selectorExpression)));
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        } else {
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        }
        return kotlinTypeInfo;
    }

    private final KotlinTypeInfo getSafeOrUnsafeSelectorTypeInfo(Receiver receiver, CallExpressionElement element, ExpressionTypingContext context2) {
        KotlinType selectorType;
        KotlinTypeInfo kotlinTypeInfo;
        DataFlowValue dataFlowValue;
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        DataFlowInfo initialDataFlowInfoForArguments = dataFlowInfo;
        ReceiverValue receiverValue = receiver instanceof ReceiverValue ? (ReceiverValue)receiver : null;
        if (receiverValue != null) {
            ReceiverValue it = receiverValue;
            boolean bl = false;
            dataFlowValue = this.dataFlowValueFactory.createDataFlowValue(it, context2);
        } else {
            dataFlowValue = null;
        }
        DataFlowValue receiverDataFlowValue = dataFlowValue;
        boolean receiverCanBeNull = receiverDataFlowValue != null && initialDataFlowInfoForArguments.getStableNullability(receiverDataFlowValue).canBeNull();
        boolean shouldNullifySafeCallType = receiverCanBeNull || context2.languageVersionSettings.supportsFeature(LanguageFeature.SafeCallsAreAlwaysNullable);
        ASTNode callOperationNode = AstLoadingFilter.forceAllowTreeLoading(element.getQualified().getContainingFile(), () -> CallExpressionResolver.getSafeOrUnsafeSelectorTypeInfo$lambda$1(element));
        if (receiverDataFlowValue != null && element.getSafe()) {
            if (shouldNullifySafeCallType) {
                initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.Companion.nullValue(this.builtIns), this.languageVersionSettings);
            }
            if (!receiverCanBeNull) {
                BindingTrace bindingTrace = context2.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                KotlinType kotlinType = ((ReceiverValue)receiver).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                KtQualifiedExpression ktQualifiedExpression = element.getQualified();
                Intrinsics.checkNotNull((Object)callOperationNode);
                LanguageVersionSettings languageVersionSettings = context2.languageVersionSettings;
                Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"languageVersionSettings");
                Companion.reportUnnecessarySafeCall(bindingTrace, kotlinType, ktQualifiedExpression, callOperationNode, receiver, languageVersionSettings);
            }
        }
        KtExpression selector = element.getSelector();
        KotlinTypeInfo $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u242 = this.getUnsafeSelectorTypeInfo(receiver, callOperationNode, selector, context2, initialDataFlowInfoForArguments);
        boolean bl = false;
        KotlinType kotlinType = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u242.getType();
        if (kotlinType == null) {
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u242;
        } else {
            KotlinType type = kotlinType;
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u242.replaceType(this.kotlinTypeRefiner.refineType(type));
        }
        KotlinTypeInfo selectorTypeInfo = kotlinTypeInfo;
        if (receiver instanceof Qualifier) {
            this.resolveDeferredReceiverInQualifiedExpression((Qualifier)receiver, selector, context2);
        }
        if ((selectorType = selectorTypeInfo.getType()) != null) {
            if (element.getSafe() && shouldNullifySafeCallType) {
                selectorTypeInfo = selectorTypeInfo.replaceType(TypeUtils.makeNullable(selectorType));
            }
            if (selector != null) {
                context2.trace.recordType(selector, selectorTypeInfo.getType());
            }
        }
        return selectorTypeInfo;
    }

    private final KotlinTypeInfo checkSelectorTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo selectorTypeInfo, ExpressionTypingContext context2) {
        KotlinTypeInfo kotlinTypeInfo;
        CallExpressionResolver.Companion.checkNestedClassAccess(qualified, context2);
        KtExpression ktExpression = qualified;
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        CompileTimeConstant<?> value2 = this.constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, context2.expectedType);
        if (value2 != null && value2.isPure()) {
            KotlinTypeInfo kotlinTypeInfo2 = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, qualified, context2);
            Intrinsics.checkNotNull((Object)kotlinTypeInfo2);
            kotlinTypeInfo = kotlinTypeInfo2;
        } else {
            if (context2.contextDependency == ContextDependency.INDEPENDENT) {
                this.dataFlowAnalyzer.checkType(selectorTypeInfo.getType(), (KtExpression)qualified, (ResolutionContext)context2);
            }
            kotlinTypeInfo = selectorTypeInfo;
        }
        return kotlinTypeInfo;
    }

    private final void recordResultTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo resultTypeInfo, ExpressionTypingContext context2) {
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        BindingTrace trace = bindingTrace;
        if (!Intrinsics.areEqual(trace.get(BindingContext.PROCESSED, qualified), (Object)true)) {
            trace.record(BindingContext.PROCESSED, qualified);
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, qualified, resultTypeInfo);
            LexicalScope lexicalScope = context2.scope;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
            BindingContextUtilsKt.recordScope(trace, lexicalScope, qualified);
            Object Context2 = context2.replaceDataFlowInfo(resultTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceDataFlowInfo(...)");
            BindingContextUtilsKt.recordDataFlowInfo(Context2, qualified);
        }
    }

    @NotNull
    public final KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression2, @NotNull ExpressionTypingContext context2) {
        KotlinTypeInfo receiverTypeInfo;
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object Context2 = ((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceContextDependency(...)");
        ExpressionTypingContext currentContext = (ExpressionTypingContext)Context2;
        BindingTrace bindingTrace = currentContext.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        BindingTrace trace = bindingTrace;
        List<CallExpressionElement> elementChain = this.elementChain(expression2, currentContext);
        KtExpression firstReceiver = ((CallExpressionElement)CollectionsKt.first(elementChain)).getReceiver();
        if ((Qualifier)trace.get(BindingContext.QUALIFIER, firstReceiver) == null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"expressionTypingServices");
                expressionTypingServices = null;
            }
            kotlinTypeInfo = expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
        } else {
            DataFlowInfo dataFlowInfo = currentContext.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            kotlinTypeInfo = new KotlinTypeInfo(null, dataFlowInfo, false, null, 12, null);
        }
        KotlinTypeInfo kotlinTypeInfo2 = kotlinTypeInfo;
        Intrinsics.checkNotNull((Object)kotlinTypeInfo2);
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo = kotlinTypeInfo2;
        boolean allUnsafe = true;
        DataFlowInfo branchPointDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        for (CallExpressionElement element : elementChain) {
            Receiver receiver;
            KotlinType kotlinType = receiverTypeInfo.getType();
            if (kotlinType == null) {
                String[] stringArray = new String[1];
                KtExpression receiver2 = element.getReceiver();
                String string = receiver2 instanceof KtNameReferenceExpression ? ((KtNameReferenceExpression)receiver2).getReferencedName() : receiver2.getText();
                Intrinsics.checkNotNull((Object)string);
                stringArray[0] = string;
                kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_RECEIVER_TYPE, stringArray);
            }
            KotlinType receiverType = kotlinType;
            Qualifier qualifier = (Qualifier)trace.get(BindingContext.QUALIFIER, element.getReceiver());
            if (qualifier != null) {
                receiver = qualifier;
            } else {
                KtExpression ktExpression = element.getReceiver();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                receiver = ExpressionReceiver.Companion.create(ktExpression, receiverType, bindingContext);
            }
            Receiver receiver3 = receiver;
            KtQualifiedExpression qualifiedExpression = element.getQualified();
            boolean lastStage = qualifiedExpression == expression2;
            Object Context3 = (lastStage ? context2 : currentContext).replaceDataFlowInfo(receiver3 instanceof ReceiverValue && TypeUtils.isNullableType(((ReceiverValue)receiver3).getType()) && !element.getSafe() ? branchPointDataFlowInfo : receiverTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"replaceDataFlowInfo(...)");
            ExpressionTypingContext contextForSelector = (ExpressionTypingContext)Context3;
            KotlinTypeInfo selectorTypeInfo = this.getSafeOrUnsafeSelectorTypeInfo(receiver3, element, contextForSelector);
            boolean bl = allUnsafe = allUnsafe && !element.getSafe();
            if (allUnsafe) {
                branchPointDataFlowInfo = selectorTypeInfo.getDataFlowInfo();
            }
            resultTypeInfo = this.checkSelectorTypeInfo(qualifiedExpression, selectorTypeInfo, contextForSelector).replaceDataFlowInfo(branchPointDataFlowInfo);
            if (!lastStage) {
                this.recordResultTypeInfo(qualifiedExpression, resultTypeInfo, contextForSelector);
            }
            receiverTypeInfo = selectorTypeInfo;
        }
        return resultTypeInfo;
    }

    private final void resolveDeferredReceiverInQualifiedExpression(Qualifier qualifier, KtExpression selectorExpression, ExpressionTypingContext context2) {
        DeclarationDescriptor declarationDescriptor;
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(PsiUtilsKt.getCalleeExpressionIfAny(selectorExpression));
        KtReferenceExpression ktReferenceExpression = calleeExpression instanceof KtReferenceExpression ? (KtReferenceExpression)calleeExpression : null;
        if (ktReferenceExpression != null) {
            KtReferenceExpression it = ktReferenceExpression;
            boolean bl = false;
            declarationDescriptor = (DeclarationDescriptor)context2.trace.get(BindingContext.REFERENCE_TARGET, it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor selectorDescriptor = declarationDescriptor;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifier, selectorDescriptor, context2);
    }

    private static final boolean elementChain$lambda$0(ExpressionTypingContext $context, CallExpressionResolver this$0, KtSimpleNameExpression nameExpression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)nameExpression, (String)"nameExpression");
        TemporaryTraceAndCache temporaryTraceAndCache = TemporaryTraceAndCache.create($context, "trace to resolve as local variable or property", nameExpression);
        Intrinsics.checkNotNull((Object)temporaryTraceAndCache);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = this$0.resolveSimpleName($context, nameExpression, temporaryTraceAndCache);
        if (resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject) {
            bl = false;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[resolutionResult.getResultCode().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                default: {
                    boolean success;
                    boolean newInferenceEnabled = $context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
                    boolean bl2 = success = !newInferenceEnabled || resolutionResult.isSuccess();
                    if (newInferenceEnabled && success) {
                        temporaryTraceAndCache.commit();
                    }
                    bl = success;
                }
            }
        }
        return bl;
    }

    private static final ASTNode getSafeOrUnsafeSelectorTypeInfo$lambda$1(CallExpressionElement $element) {
        return $element.getNode();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion;", "", "<init>", "()V", "canInstantiateAnnotationClass", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isUnderAnnotationClassDeclaration", "parent", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "reportUnnecessarySafeCall", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "callElement", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "callOperationNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkNestedClassAccess", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nCallExpressionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallExpressionResolver.kt\norg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,574:1\n232#2:575\n232#2:576\n232#2:577\n1#3:578\n*S KotlinDebug\n*F\n+ 1 CallExpressionResolver.kt\norg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion\n*L\n518#1:575\n521#1:576\n532#1:577\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canInstantiateAnnotationClass(@NotNull KtCallExpression expression2, @NotNull BindingTrace trace) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Object object = new Class[]{KtValueArgument.class, KtParameter.class};
            Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, object);
            if (parent2 instanceof KtValueArgument) {
                Object $this$getParentOfType$iv;
                object = parent2;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtAnnotationEntry.class, strict$iv) != null) {
                    return true;
                }
                $this$getParentOfType$iv = parent2;
                strict$iv = true;
                $i$f$getParentOfType = false;
                parent2 = PsiTreeUtil.getParentOfType($this$getParentOfType$iv, KtParameter.class, strict$iv);
                if (parent2 != null) {
                    return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
                }
            } else if (parent2 instanceof KtParameter) {
                return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isUnderAnnotationClassDeclaration(BindingTrace trace, PsiElement parent2) {
            boolean bl;
            void $this$getParentOfType$iv;
            PsiElement psiElement = parent2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtClass ktClass = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, strict$iv);
            if (ktClass != null) {
                KtClass it = ktClass;
                boolean bl2 = false;
                bl = DescriptorUtils.isAnnotationClass(trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it));
            } else {
                bl = false;
            }
            return bl;
        }

        public final void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type, @NotNull KtQualifiedExpression callElement, @NotNull ASTNode callOperationNode, @Nullable Receiver explicitReceiver, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
            Intrinsics.checkNotNullParameter((Object)callOperationNode, (String)"callOperationNode");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            if (explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression) {
                trace.report(Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode.getPsi()));
            } else if (!KotlinTypeKt.isError(type)) {
                trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type));
                if (!languageVersionSettings.supportsFeature(LanguageFeature.SafeCallsAreAlwaysNullable)) {
                    trace.report(Errors.SAFE_CALL_WILL_CHANGE_NULLABILITY.on((KtQualifiedExpression)((PsiElement)callElement)));
                }
            }
        }

        private final void checkNestedClassAccess(KtQualifiedExpression expression2, ExpressionTypingContext context2) {
            KtExpression ktExpression = expression2.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selectorExpression = ktExpression;
            Qualifier expressionQualifier = (Qualifier)context2.trace.get(BindingContext.QUALIFIER, expression2);
            Qualifier receiverQualifier = (Qualifier)context2.trace.get(BindingContext.QUALIFIER, expression2.getReceiverExpression());
            if (receiverQualifier == null && expressionQualifier != null) {
                boolean bl = expressionQualifier instanceof ClassifierQualifier;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
                    throw new AssertionError((Object)string);
                }
                ClassifierDescriptorWithTypeParameters descriptor = ((ClassifierQualifier)expressionQualifier).getDescriptor();
                context2.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on((KtExpression)((PsiElement)selectorExpression), descriptor));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OverloadResolutionResults.Code.values().length];
            try {
                nArray[OverloadResolutionResults.Code.NAME_NOT_FOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

