/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.EnumEntryVsCompanionPriorityCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/EnumEntryVsCompanionPriorityCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "containsEntryWithName", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "frontend"})
public final class EnumEntryVsCompanionPriorityCallChecker
implements CallChecker {
    @NotNull
    public static final EnumEntryVsCompanionPriorityCallChecker INSTANCE = new EnumEntryVsCompanionPriorityCallChecker();

    private EnumEntryVsCompanionPriorityCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getCandidateDescriptor(...)");
        Object descriptor = obj;
        if (!(descriptor instanceof PropertyDescriptor)) {
            return;
        }
        Name name2 = ((PropertyDescriptor)descriptor).getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name propertyName = name2;
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        if (!(containingDescriptor instanceof ClassDescriptor) || !((ClassDescriptor)containingDescriptor).isCompanionObject()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)containingDescriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor grandParent = declarationDescriptor2;
        if (grandParent instanceof ClassDescriptor && ((ClassDescriptor)grandParent).getKind() == ClassKind.ENUM_CLASS && this.containsEntryWithName((ClassDescriptor)grandParent, propertyName) && EnumEntryVsCompanionPriorityCallCheckerKt.isQualifierFor(resolvedCall2.getDispatchReceiver(), (ClassDescriptor)grandParent)) {
            context2.getResolutionContext().trace.report(Errors.DEPRECATED_ACCESS_TO_ENUM_COMPANION_PROPERTY.on(reportOn, (PropertyDescriptor)descriptor));
        }
    }

    private final boolean containsEntryWithName(ClassDescriptor $this$containsEntryWithName, Name name2) {
        ClassifierDescriptor foundDescriptor = $this$containsEntryWithName.getUnsubstitutedMemberScope().getContributedClassifier(name2, NoLookupLocation.FOR_ALREADY_TRACKED);
        return foundDescriptor instanceof ClassDescriptor && ((ClassDescriptor)foundDescriptor).getKind() == ClassKind.ENUM_ENTRY;
    }
}

