/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PropertiesWithBackingFieldsInsideValueClass;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class PropertiesWithBackingFieldsInsideValueClass
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(declaration instanceof KtProperty)) {
                return;
            }
            if (!(descriptor instanceof PropertyDescriptor)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            if (!InlineClassesUtilsKt.isValueClass(declarationDescriptor)) {
                return;
            }
            if (Intrinsics.areEqual(context2.getTrace().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor), (Object)true)) {
                context2.getTrace().report(Errors.PROPERTY_WITH_BACKING_FIELD_INSIDE_VALUE_CLASS.on((KtProperty)declaration));
            }
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration).getDelegate();
            if (ktPropertyDelegate == null) break block4;
            KtPropertyDelegate it = ktPropertyDelegate;
            boolean bl = false;
            context2.getTrace().report(Errors.DELEGATED_PROPERTY_INSIDE_VALUE_CLASS.on(it));
        }
    }
}

