/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.metadata;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.cli.pipeline.FrontendPipelineArtifact;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.pipeline.FirResult;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0014\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0083\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020'H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataFrontendPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/FrontendPipelineArtifact;", "result", "Lorg/jetbrains/kotlin/fir/pipeline/FirResult;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "diagnosticCollector", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "sourceFiles", "", "Lorg/jetbrains/kotlin/KtSourceFile;", "<init>", "(Lorg/jetbrains/kotlin/fir/pipeline/FirResult;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;Ljava/util/List;)V", "getResult", "()Lorg/jetbrains/kotlin/fir/pipeline/FirResult;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getDiagnosticCollector", "()Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "getSourceFiles", "()Ljava/util/List;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "withNewDiagnosticCollectorImpl", "newDiagnosticsCollector", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cli"})
public final class MetadataFrontendPipelineArtifact
extends FrontendPipelineArtifact {
    @NotNull
    private final FirResult result;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final BaseDiagnosticsCollector diagnosticCollector;
    @NotNull
    private final List<KtSourceFile> sourceFiles;
    @NotNull
    private final BuiltInsBinaryVersion metadataVersion;

    public MetadataFrontendPipelineArtifact(@NotNull FirResult result2, @NotNull CompilerConfiguration configuration, @NotNull BaseDiagnosticsCollector diagnosticCollector, @NotNull List<? extends KtSourceFile> sourceFiles) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)diagnosticCollector, (String)"diagnosticCollector");
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        this.result = result2;
        this.configuration = configuration;
        this.diagnosticCollector = diagnosticCollector;
        this.sourceFiles = sourceFiles;
        BinaryVersion binaryVersion = CommonConfigurationKeysKt.getMetadataVersion(this.getConfiguration());
        BuiltInsBinaryVersion builtInsBinaryVersion = binaryVersion instanceof BuiltInsBinaryVersion ? (BuiltInsBinaryVersion)binaryVersion : null;
        if (builtInsBinaryVersion == null) {
            builtInsBinaryVersion = BuiltInsBinaryVersion.INSTANCE;
        }
        this.metadataVersion = builtInsBinaryVersion;
    }

    @Override
    @NotNull
    public FirResult getResult() {
        return this.result;
    }

    @Override
    @NotNull
    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public BaseDiagnosticsCollector getDiagnosticCollector() {
        return this.diagnosticCollector;
    }

    @NotNull
    public final List<KtSourceFile> getSourceFiles() {
        return this.sourceFiles;
    }

    @NotNull
    public final BuiltInsBinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    @NotNull
    public MetadataFrontendPipelineArtifact withNewDiagnosticCollectorImpl(@NotNull BaseDiagnosticsCollector newDiagnosticsCollector) {
        Intrinsics.checkNotNullParameter((Object)newDiagnosticsCollector, (String)"newDiagnosticsCollector");
        return MetadataFrontendPipelineArtifact.copy$default(this, null, null, newDiagnosticsCollector, null, 11, null);
    }

    @NotNull
    public final FirResult component1() {
        return this.result;
    }

    @NotNull
    public final CompilerConfiguration component2() {
        return this.configuration;
    }

    @NotNull
    public final BaseDiagnosticsCollector component3() {
        return this.diagnosticCollector;
    }

    @NotNull
    public final List<KtSourceFile> component4() {
        return this.sourceFiles;
    }

    @NotNull
    public final MetadataFrontendPipelineArtifact copy(@NotNull FirResult result2, @NotNull CompilerConfiguration configuration, @NotNull BaseDiagnosticsCollector diagnosticCollector, @NotNull List<? extends KtSourceFile> sourceFiles) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)diagnosticCollector, (String)"diagnosticCollector");
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        return new MetadataFrontendPipelineArtifact(result2, configuration, diagnosticCollector, sourceFiles);
    }

    public static /* synthetic */ MetadataFrontendPipelineArtifact copy$default(MetadataFrontendPipelineArtifact metadataFrontendPipelineArtifact, FirResult firResult, CompilerConfiguration compilerConfiguration, BaseDiagnosticsCollector baseDiagnosticsCollector, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            firResult = metadataFrontendPipelineArtifact.result;
        }
        if ((n2 & 2) != 0) {
            compilerConfiguration = metadataFrontendPipelineArtifact.configuration;
        }
        if ((n2 & 4) != 0) {
            baseDiagnosticsCollector = metadataFrontendPipelineArtifact.diagnosticCollector;
        }
        if ((n2 & 8) != 0) {
            list = metadataFrontendPipelineArtifact.sourceFiles;
        }
        return metadataFrontendPipelineArtifact.copy(firResult, compilerConfiguration, baseDiagnosticsCollector, list);
    }

    @NotNull
    public String toString() {
        return "MetadataFrontendPipelineArtifact(result=" + this.result + ", configuration=" + this.configuration + ", diagnosticCollector=" + this.diagnosticCollector + ", sourceFiles=" + this.sourceFiles + ')';
    }

    public int hashCode() {
        int result2 = this.result.hashCode();
        result2 = result2 * 31 + this.configuration.hashCode();
        result2 = result2 * 31 + this.diagnosticCollector.hashCode();
        result2 = result2 * 31 + ((Object)this.sourceFiles).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetadataFrontendPipelineArtifact)) {
            return false;
        }
        MetadataFrontendPipelineArtifact metadataFrontendPipelineArtifact = (MetadataFrontendPipelineArtifact)other;
        if (!Intrinsics.areEqual((Object)this.result, (Object)metadataFrontendPipelineArtifact.result)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configuration, (Object)metadataFrontendPipelineArtifact.configuration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.diagnosticCollector, (Object)metadataFrontendPipelineArtifact.diagnosticCollector)) {
            return false;
        }
        return Intrinsics.areEqual(this.sourceFiles, metadataFrontendPipelineArtifact.sourceFiles);
    }
}

