/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.kotlin.io.vavr.collection.AbstractIterator;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.Seq;

public interface IndexedSeq<T>
extends Seq<T> {
    public static final long serialVersionUID = 1L;

    @Override
    public IndexedSeq<T> append(T var1);

    @Override
    public IndexedSeq<T> appendAll(Iterable<? extends T> var1);

    @Override
    public IndexedSeq<T> filter(Predicate<? super T> var1);

    @Override
    public IndexedSeq<T> insert(int var1, T var2);

    @Override
    public IndexedSeq<T> insertAll(int var1, Iterable<? extends T> var2);

    @Override
    default public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("last of empty IndexedSeq");
        }
        return this.get(this.length() - 1);
    }

    @Override
    public <U> IndexedSeq<U> map(Function<? super T, ? extends U> var1);

    @Override
    public IndexedSeq<T> remove(T var1);

    @Override
    public IndexedSeq<T> removeAt(int var1);

    @Override
    public IndexedSeq<T> removeAll(Iterable<? extends T> var1);

    @Override
    public IndexedSeq<T> retainAll(Iterable<? extends T> var1);

    @Override
    public IndexedSeq<T> reverse();

    @Override
    default public Iterator<T> reverseIterator() {
        return new AbstractIterator<T>(){
            private int i;
            {
                this.i = IndexedSeq.this.length();
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public T getNext() {
                return IndexedSeq.this.get(--this.i);
            }
        };
    }

    @Override
    public IndexedSeq<T> sorted(Comparator<? super T> var1);

    @Override
    public IndexedSeq<T> subSequence(int var1, int var2);

    @Override
    public IndexedSeq<T> tail();

    @Override
    public IndexedSeq<T> take(int var1);

    @Override
    public IndexedSeq<T> update(int var1, T var2);
}

