/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */
package org.jetbrains.kotlin.js.config

enum class ModuleKind(val jsExtension: String, val tsExtension: String) {
    PLAIN(".js", ".ts"),
    AMD(".js", ".ts"),
    COMMON_JS(".js", ".ts"),
    UMD(".js", ".ts"),
    ES(".mjs", ".mts");

    val dtsExtension: String
        get() = ".d$tsExtension"
}
