/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.platform

import org.jetbrains.kotlin.platform.js.JsPlatforms.allJsPlatforms
import org.jetbrains.kotlin.platform.js.JsPlatforms.defaultJsPlatform
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms.allJvmPlatforms
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms.unspecifiedJvmPlatform
import org.jetbrains.kotlin.platform.konan.NativePlatforms.allNativePlatforms
import org.jetbrains.kotlin.platform.konan.NativePlatforms.unspecifiedNativePlatform
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms.allWasmPlatforms

object CommonPlatforms {
    private object CompatCommonPlatform : TargetPlatform(
        setOf(
            unspecifiedJvmPlatform.single(),
            defaultJsPlatform.single(),
            WasmPlatforms.wasmJs.single(),
            WasmPlatforms.wasmWasi.single(),
            unspecifiedNativePlatform.single()
        )
    )

    val defaultCommonPlatform: TargetPlatform
        get() = CompatCommonPlatform

    val allSimplePlatforms: List<TargetPlatform>
        // TODO(auskov): migrate to SimplePlatform?
        get() = sequence {
            yieldAll(allJvmPlatforms)
            yieldAll(allNativePlatforms)
            yieldAll(allJsPlatforms)
            yieldAll(allWasmPlatforms)

            // TODO(dsavvinov): extensions points?
        }.toList()

    val allDefaultTargetPlatforms: List<TargetPlatform>
        get() = sequence {
            yieldAll(allSimplePlatforms)
            yieldAll(listOf(defaultCommonPlatform))
        }.toList()
}

