/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    private static final Function<Object, Class> TO_CLASS = new Function<Object, Class>(){

        @Override
        public Class fun(Object o) {
            return o.getClass();
        }
    };
    private static final Function PAIR_FIRST = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getFirst(pair);
        }
    };
    private static final Function PAIR_SECOND = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getSecond(pair);
        }
    };
    private static final Function WRAP_ARRAY = new Function<Object[], Iterable<Object>>(){

        @Override
        public Iterable<Object> fun(Object[] t) {
            return t == null ? Collections.emptyList() : Arrays.asList(t);
        }
    };

    public static <A> Function.Mono<A> id() {
        return (Function.Mono)Function.ID;
    }

    public static <A, B> Function<A, B> constant(final B b) {
        return new Function<A, B>(){

            @Override
            public B fun(A a) {
                return b;
            }
        };
    }

    public static <A, B> Function<A, B> identity() {
        return Function.ID;
    }

    public static <A, B, C> Function<A, C> compose(final Function<? super A, ? extends B> f1, final Function<? super B, ? extends C> f2) {
        if (f1 == Function.ID || f2 == Function.ID) {
            return f1 == f2 ? Function.ID : (f1 == Function.ID ? f2 : f1);
        }
        return new Function<A, C>(){

            @Override
            public C fun(A a) {
                return f2.fun(f1.fun(a));
            }
        };
    }
}

