/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierListKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirModifierChecker$WhenMappings;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u00014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016JD\u0010\u0012\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002J)\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\t2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010&J!\u0010'\u001a\u00020\f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u00020\f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010(J!\u0010*\u001a\u00020\f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J(\u0010.\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J(\u00100\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J(\u00101\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J \u00102\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u00103\u001a\u00020\bH\u0002RB\u0010\u0005\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "compatibilityTypeMap", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker$CompatibilityType;", "Lkotlin/collections/HashMap;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkCompatibilityType", "firstModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "secondModifier", "reportedNodes", "", "owner", "checkModifiers", "list", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "deduceCompatibilityType", "firstKeyword", "secondKeyword", "isDeclarationMappedToSourceCorrectly", "", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "recordCompatibilityType", "compatibilityType", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker$CompatibilityType;[Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "recordDeprecatedPairs", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "recordIncompatiblePairs", "recordPairsCompatibleForClasses", "recordRedundantPairs", "redundantKeyword", "sufficientKeyword", "reportDeprecatedModifierPair", "modifier", "reportIncompatibleModifiers", "reportRedundantModifier", "reportRepeatedModifier", "keyword", "CompatibilityType", "checkers"})
public final class FirModifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    private static final HashMap<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, CompatibilityType> compatibilityTypeMap;
    public static final FirModifierChecker INSTANCE;

    private final void recordCompatibilityType(CompatibilityType compatibilityType, KtModifierKeywordToken ... list2) {
        for (KtModifierKeywordToken firstKeyword : list2) {
            for (KtModifierKeywordToken secondKeyword : list2) {
                if (!(Intrinsics.areEqual((Object)firstKeyword, (Object)secondKeyword) ^ true)) continue;
                ((Map)compatibilityTypeMap).put(new Pair((Object)firstKeyword, (Object)secondKeyword), compatibilityType);
            }
        }
    }

    private final void recordPairsCompatibleForClasses(KtModifierKeywordToken ... list2) {
        this.recordCompatibilityType(CompatibilityType.COMPATIBLE_FOR_CLASSES, Arrays.copyOf(list2, list2.length));
    }

    private final void recordIncompatiblePairs(KtModifierKeywordToken ... list2) {
        this.recordCompatibilityType(CompatibilityType.INCOMPATIBLE, Arrays.copyOf(list2, list2.length));
    }

    private final void recordRedundantPairs(KtModifierKeywordToken redundantKeyword, KtModifierKeywordToken sufficientKeyword) {
        ((Map)compatibilityTypeMap).put(new Pair((Object)redundantKeyword, (Object)sufficientKeyword), CompatibilityType.REDUNDANT_1_TO_2);
        ((Map)compatibilityTypeMap).put(new Pair((Object)sufficientKeyword, (Object)redundantKeyword), CompatibilityType.REDUNDANT_2_TO_1);
    }

    private final CompatibilityType deduceCompatibilityType(KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        CompatibilityType compatibilityType;
        if (Intrinsics.areEqual((Object)firstKeyword, (Object)secondKeyword)) {
            compatibilityType = CompatibilityType.REPEATED;
        } else {
            CompatibilityType compatibilityType2 = compatibilityTypeMap.get(new Pair((Object)firstKeyword, (Object)secondKeyword));
            if (compatibilityType2 == null) {
                compatibilityType2 = CompatibilityType.COMPATIBLE;
            }
            compatibilityType = compatibilityType2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)compatibilityType2), (String)"compatibilityTypeMap[Pai\u2026patibilityType.COMPATIBLE");
        }
        return compatibilityType;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCompatibilityType(FirModifier<?> firstModifier, FirModifier<?> secondModifier, DiagnosticReporter reporter, Set<FirModifier<?>> reportedNodes, FirDeclaration owner) {
        KtModifierKeywordToken firstToken = firstModifier.getToken();
        KtModifierKeywordToken secondToken = secondModifier.getToken();
        CompatibilityType compatibilityType = this.deduceCompatibilityType(firstToken, secondToken);
        switch (FirModifierChecker$WhenMappings.$EnumSwitchMapping$0[compatibilityType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!reportedNodes.add(secondModifier)) break;
                this.reportRepeatedModifier(reporter, secondModifier, secondToken);
                break;
            }
            case 3: {
                this.reportRedundantModifier(reporter, secondModifier, secondToken, firstToken);
                break;
            }
            case 4: {
                this.reportRedundantModifier(reporter, firstModifier, firstToken, secondToken);
                break;
            }
            case 5: {
                this.reportDeprecatedModifierPair(reporter, firstModifier, firstToken, secondToken);
                this.reportDeprecatedModifierPair(reporter, secondModifier, secondToken, firstToken);
                break;
            }
            case 6: 
            case 7: {
                void compatibilityType2;
                if (compatibilityType2 == CompatibilityType.COMPATIBLE_FOR_CLASSES && owner instanceof FirClass) {
                    return;
                }
                if (reportedNodes.add(firstModifier)) {
                    this.reportIncompatibleModifiers(reporter, firstModifier, firstToken, secondToken);
                }
                if (!reportedNodes.add(secondModifier)) break;
                this.reportIncompatibleModifiers(reporter, secondModifier, secondToken, firstToken);
                break;
            }
        }
    }

    private final void checkModifiers(FirModifierList list2, FirDeclaration owner, DiagnosticReporter reporter) {
        boolean bl = false;
        HashSet reportedNodes = new HashSet();
        List<FirModifier<?>> modifiers2 = list2.getModifiers();
        for (FirModifier<?> secondModifier : modifiers2) {
            for (FirModifier<?> firstModifier : modifiers2) {
                if (Intrinsics.areEqual(firstModifier, secondModifier)) break;
                this.checkCompatibilityType(firstModifier, secondModifier, reporter, reportedNodes, owner);
            }
        }
    }

    private final boolean isDeclarationMappedToSourceCorrectly(FirDeclaration declaration2, FirSourceElement source) {
        IElementType iElementType = source.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS) ? declaration2 instanceof FirClass : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION) ? declaration2 instanceof FirClass : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY) ? declaration2 instanceof FirProperty : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_PARAMETER) ? declaration2 instanceof FirValueParameter : true)));
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block3: {
            FirModifierList modifierList2;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirSourceElement firSourceElement = declaration2.getSource();
            if (firSourceElement == null) {
                return;
            }
            FirSourceElement source = firSourceElement;
            if (!this.isDeclarationMappedToSourceCorrectly(declaration2, source)) {
                return;
            }
            if (CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirDefaultPropertyAccessor) {
                return;
            }
            FirModifierList firModifierList = modifierList2 = FirModifierListKt.getModifierList(source);
            if (firModifierList == null) break block3;
            FirModifierList firModifierList2 = firModifierList;
            boolean bl = false;
            boolean bl2 = false;
            FirModifierList it = firModifierList2;
            boolean bl3 = false;
            INSTANCE.checkModifiers(it, declaration2, reporter);
        }
    }

    private final void reportRepeatedModifier(DiagnosticReporter $this$reportRepeatedModifier, FirModifier<?> modifier, KtModifierKeywordToken keyword) {
        block0: {
            FirSourceElement source;
            FirSourceElement firSourceElement = source = FirModifierListKt.getSource(modifier);
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportRepeatedModifier.report((FirDiagnostic)FirErrors.INSTANCE.getREPEATED_MODIFIER().on(it, keyword));
        }
    }

    private final void reportRedundantModifier(DiagnosticReporter $this$reportRedundantModifier, FirModifier<?> modifier, KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        block0: {
            FirSourceElement source;
            FirSourceElement firSourceElement = source = FirModifierListKt.getSource(modifier);
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportRedundantModifier.report((FirDiagnostic)FirErrors.INSTANCE.getREDUNDANT_MODIFIER().on(it, firstKeyword, secondKeyword));
        }
    }

    private final void reportDeprecatedModifierPair(DiagnosticReporter $this$reportDeprecatedModifierPair, FirModifier<?> modifier, KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        block0: {
            FirSourceElement source;
            FirSourceElement firSourceElement = source = FirModifierListKt.getSource(modifier);
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportDeprecatedModifierPair.report((FirDiagnostic)FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR().on(it, firstKeyword, secondKeyword));
        }
    }

    private final void reportIncompatibleModifiers(DiagnosticReporter $this$reportIncompatibleModifiers, FirModifier<?> modifier, KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        block0: {
            FirSourceElement source;
            FirSourceElement firSourceElement = source = FirModifierListKt.getSource(modifier);
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportIncompatibleModifiers.report((FirDiagnostic)FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS().on(it, firstKeyword, secondKeyword));
        }
    }

    private FirModifierChecker() {
    }

    static {
        FirModifierChecker firModifierChecker;
        INSTANCE = firModifierChecker = new FirModifierChecker();
        boolean bl = false;
        compatibilityTypeMap = new HashMap();
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"IN_KEYWORD");
        ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OUT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"OUT_KEYWORD");
        ktModifierKeywordTokenArray[1] = ktModifierKeywordToken2;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray2[0] = ktModifierKeywordToken3;
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.PROTECTED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken4, (String)"PROTECTED_KEYWORD");
        ktModifierKeywordTokenArray2[1] = ktModifierKeywordToken4;
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.PUBLIC_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken5, (String)"PUBLIC_KEYWORD");
        ktModifierKeywordTokenArray2[2] = ktModifierKeywordToken5;
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.INTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken6, (String)"INTERNAL_KEYWORD");
        ktModifierKeywordTokenArray2[3] = ktModifierKeywordToken6;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray2);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray3 = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken7 = KtTokens.HEADER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken7, (String)"HEADER_KEYWORD");
        ktModifierKeywordTokenArray3[0] = ktModifierKeywordToken7;
        KtModifierKeywordToken ktModifierKeywordToken8 = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken8, (String)"EXPECT_KEYWORD");
        ktModifierKeywordTokenArray3[1] = ktModifierKeywordToken8;
        KtModifierKeywordToken ktModifierKeywordToken9 = KtTokens.IMPL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken9, (String)"IMPL_KEYWORD");
        ktModifierKeywordTokenArray3[2] = ktModifierKeywordToken9;
        KtModifierKeywordToken ktModifierKeywordToken10 = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken10, (String)"ACTUAL_KEYWORD");
        ktModifierKeywordTokenArray3[3] = ktModifierKeywordToken10;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray3);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray4 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken11 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken11, (String)"FINAL_KEYWORD");
        ktModifierKeywordTokenArray4[0] = ktModifierKeywordToken11;
        KtModifierKeywordToken ktModifierKeywordToken12 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken12, (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray4[1] = ktModifierKeywordToken12;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray4);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray5 = new KtModifierKeywordToken[3];
        KtModifierKeywordToken ktModifierKeywordToken13 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken13, (String)"FINAL_KEYWORD");
        ktModifierKeywordTokenArray5[0] = ktModifierKeywordToken13;
        KtModifierKeywordToken ktModifierKeywordToken14 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken14, (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray5[1] = ktModifierKeywordToken14;
        KtModifierKeywordToken ktModifierKeywordToken15 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken15, (String)"SEALED_KEYWORD");
        ktModifierKeywordTokenArray5[2] = ktModifierKeywordToken15;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray5);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray6 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken16 = KtTokens.CROSSINLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken16, (String)"CROSSINLINE_KEYWORD");
        ktModifierKeywordTokenArray6[0] = ktModifierKeywordToken16;
        KtModifierKeywordToken ktModifierKeywordToken17 = KtTokens.NOINLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken17, (String)"NOINLINE_KEYWORD");
        ktModifierKeywordTokenArray6[1] = ktModifierKeywordToken17;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray6);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray7 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken18 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken18, (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray7[0] = ktModifierKeywordToken18;
        KtModifierKeywordToken ktModifierKeywordToken19 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken19, (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray7[1] = ktModifierKeywordToken19;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray7);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray8 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken20 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken20, (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray8[0] = ktModifierKeywordToken20;
        KtModifierKeywordToken ktModifierKeywordToken21 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken21, (String)"INNER_KEYWORD");
        ktModifierKeywordTokenArray8[1] = ktModifierKeywordToken21;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray8);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray9 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken22 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken22, (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray9[0] = ktModifierKeywordToken22;
        KtModifierKeywordToken ktModifierKeywordToken23 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken23, (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray9[1] = ktModifierKeywordToken23;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray9);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray10 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken24 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken24, (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray10[0] = ktModifierKeywordToken24;
        KtModifierKeywordToken ktModifierKeywordToken25 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken25, (String)"SEALED_KEYWORD");
        ktModifierKeywordTokenArray10[1] = ktModifierKeywordToken25;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray10);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray11 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken26 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken26, (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray11[0] = ktModifierKeywordToken26;
        KtModifierKeywordToken ktModifierKeywordToken27 = KtTokens.INLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken27, (String)"INLINE_KEYWORD");
        ktModifierKeywordTokenArray11[1] = ktModifierKeywordToken27;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray11);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray12 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken28 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken28, (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray12[0] = ktModifierKeywordToken28;
        KtModifierKeywordToken ktModifierKeywordToken29 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken29, (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray12[1] = ktModifierKeywordToken29;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray12);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray13 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken30 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken30, (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray13[0] = ktModifierKeywordToken30;
        KtModifierKeywordToken ktModifierKeywordToken31 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken31, (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray13[1] = ktModifierKeywordToken31;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray13);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray14 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken32 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken32, (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray14[0] = ktModifierKeywordToken32;
        KtModifierKeywordToken ktModifierKeywordToken33 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken33, (String)"OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray14[1] = ktModifierKeywordToken33;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray14);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray15 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken34 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken34, (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray15[0] = ktModifierKeywordToken34;
        KtModifierKeywordToken ktModifierKeywordToken35 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken35, (String)"OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray15[1] = ktModifierKeywordToken35;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray15);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray16 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken36 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken36, (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray16[0] = ktModifierKeywordToken36;
        KtModifierKeywordToken ktModifierKeywordToken37 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken37, (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray16[1] = ktModifierKeywordToken37;
        firModifierChecker.recordPairsCompatibleForClasses(ktModifierKeywordTokenArray16);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray17 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken38 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken38, (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray17[0] = ktModifierKeywordToken38;
        KtModifierKeywordToken ktModifierKeywordToken39 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken39, (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray17[1] = ktModifierKeywordToken39;
        firModifierChecker.recordPairsCompatibleForClasses(ktModifierKeywordTokenArray17);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray18 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken40 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken40, (String)"SEALED_KEYWORD");
        ktModifierKeywordTokenArray18[0] = ktModifierKeywordToken40;
        KtModifierKeywordToken ktModifierKeywordToken41 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken41, (String)"INNER_KEYWORD");
        ktModifierKeywordTokenArray18[1] = ktModifierKeywordToken41;
        firModifierChecker.recordIncompatiblePairs(ktModifierKeywordTokenArray18);
        KtModifierKeywordToken ktModifierKeywordToken42 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken42, (String)"OPEN_KEYWORD");
        KtModifierKeywordToken ktModifierKeywordToken43 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken43, (String)"ABSTRACT_KEYWORD");
        firModifierChecker.recordRedundantPairs(ktModifierKeywordToken42, ktModifierKeywordToken43);
        KtModifierKeywordToken ktModifierKeywordToken44 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken44, (String)"ABSTRACT_KEYWORD");
        KtModifierKeywordToken ktModifierKeywordToken45 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken45, (String)"SEALED_KEYWORD");
        firModifierChecker.recordRedundantPairs(ktModifierKeywordToken44, ktModifierKeywordToken45);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker$CompatibilityType;", "", "(Ljava/lang/String;I)V", "COMPATIBLE", "COMPATIBLE_FOR_CLASSES", "REDUNDANT_1_TO_2", "REDUNDANT_2_TO_1", "DEPRECATED", "REPEATED", "INCOMPATIBLE", "checkers"})
    private static final class CompatibilityType
    extends Enum<CompatibilityType> {
        public static final /* enum */ CompatibilityType COMPATIBLE;
        public static final /* enum */ CompatibilityType COMPATIBLE_FOR_CLASSES;
        public static final /* enum */ CompatibilityType REDUNDANT_1_TO_2;
        public static final /* enum */ CompatibilityType REDUNDANT_2_TO_1;
        public static final /* enum */ CompatibilityType DEPRECATED;
        public static final /* enum */ CompatibilityType REPEATED;
        public static final /* enum */ CompatibilityType INCOMPATIBLE;
        private static final /* synthetic */ CompatibilityType[] $VALUES;

        static {
            CompatibilityType[] compatibilityTypeArray = new CompatibilityType[7];
            CompatibilityType[] compatibilityTypeArray2 = compatibilityTypeArray;
            compatibilityTypeArray[0] = COMPATIBLE = new CompatibilityType();
            compatibilityTypeArray[1] = COMPATIBLE_FOR_CLASSES = new CompatibilityType();
            compatibilityTypeArray[2] = REDUNDANT_1_TO_2 = new CompatibilityType();
            compatibilityTypeArray[3] = REDUNDANT_2_TO_1 = new CompatibilityType();
            compatibilityTypeArray[4] = DEPRECATED = new CompatibilityType();
            compatibilityTypeArray[5] = REPEATED = new CompatibilityType();
            compatibilityTypeArray[6] = INCOMPATIBLE = new CompatibilityType();
            $VALUES = compatibilityTypeArray;
        }

        public static CompatibilityType[] values() {
            return (CompatibilityType[])$VALUES.clone();
        }

        public static CompatibilityType valueOf(String string2) {
            return Enum.valueOf(CompatibilityType.class, string2);
        }
    }
}

