/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.fir.symbols

import org.jetbrains.kotlin.descriptors.DeclarationDescriptor
import org.jetbrains.kotlin.ir.ObsoleteDescriptorBasedAPI
import org.jetbrains.kotlin.ir.declarations.*
import org.jetbrains.kotlin.ir.descriptors.*
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol
import org.jetbrains.kotlin.ir.util.IdSignature
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource

abstract class Fir2IrBindableSymbol<out D : DeclarationDescriptor, B : IrDeclaration>(
    override val signature: IdSignature,
    private val containerSource: DeserializedContainerSource? = null
) : IrBindableSymbol<D, B> {

    private var _owner: B? = null
    override val owner: B
        get() = _owner ?: throw IllegalStateException("Symbol is unbound")

    override fun bind(owner: B) {
        if (_owner == null) {
            _owner = owner
        } else {
            throw IllegalStateException("${javaClass.simpleName} is already bound")
        }
    }

    override val isBound: Boolean
        get() = _owner != null

    @ObsoleteDescriptorBasedAPI
    override val descriptor: D
        @Suppress("UNCHECKED_CAST")
        get() = owner.toIrBasedDescriptor() as D

    @ObsoleteDescriptorBasedAPI
    override val hasDescriptor: Boolean
        get() = false

    companion object {
        private const val GETTER_PREFIX = "<get"
        private const val SETTER_PREFIX = "<set"
    }
}
