/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.ir.serialization

import org.jetbrains.kotlin.backend.common.serialization.codedInputStream
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall as ProtoIrConstructorCall
import org.jetbrains.kotlin.backend.common.serialization.proto.IrInlineClassRepresentation as ProtoIrInlineClassRepresentation
import org.jetbrains.kotlin.backend.common.serialization.proto.IrVariable as ProtoIrVariable
import org.jetbrains.kotlin.backend.common.serialization.proto.PirAnonymousInitializerCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirClassCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirConstructorCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirEnumEntryCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirErrorDeclarationCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirFieldCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirFunctionCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirLocalDelegatedPropertyCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirPropertyCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirTypeAliasCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirTypeParameterCarrier
import org.jetbrains.kotlin.backend.common.serialization.proto.PirValueParameterCarrier
import org.jetbrains.kotlin.descriptors.DescriptorVisibility
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation
import org.jetbrains.kotlin.descriptors.Modality
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin
import org.jetbrains.kotlin.ir.declarations.IrVariable
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.AnonymousInitializerCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.AnonymousInitializerCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ClassCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ClassCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ConstructorCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ConstructorCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.EnumEntryCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.EnumEntryCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ErrorDeclarationCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ErrorDeclarationCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.FieldCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.FieldCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.FunctionCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.FunctionCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.LocalDelegatedPropertyCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.LocalDelegatedPropertyCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.PropertyCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.PropertyCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.TypeAliasCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.TypeAliasCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.TypeParameterCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.TypeParameterCarrierImpl
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ValueParameterCarrier
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ValueParameterCarrierImpl
import org.jetbrains.kotlin.ir.expressions.IrBlockBody
import org.jetbrains.kotlin.ir.expressions.IrBody
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol
import org.jetbrains.kotlin.ir.symbols.IrSymbol
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol
import org.jetbrains.kotlin.ir.types.IrSimpleType
import org.jetbrains.kotlin.ir.types.IrType
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite

// Auto-generated by compiler/ir/ir.tree.persistent/generator/src/org/jetbrains/kotlin/ir/persistentIrGenerator/Main.kt. DO NOT EDIT!

internal abstract class IrCarrierDeserializer {

    abstract fun deserializeParentSymbol(proto: Long): IrSymbol

    abstract fun deserializeOrigin(proto: Int): IrDeclarationOrigin

    abstract fun deserializeAnnotation(proto: ProtoIrConstructorCall): IrConstructorCall

    abstract fun deserializeBody(proto: Int): IrBody

    abstract fun deserializeBlockBody(proto: Int): IrBlockBody

    abstract fun deserializeExpressionBody(proto: Int): IrExpressionBody

    abstract fun deserializeValueParameter(proto: Long): IrValueParameterSymbol

    abstract fun deserializeTypeParameter(proto: Long): IrTypeParameterSymbol

    abstract fun deserializeSuperType(proto: Int): IrType

    abstract fun deserializeType(proto: Int): IrType

    abstract fun deserializeClass(proto: Long): IrClassSymbol

    abstract fun deserializePropertySymbol(proto: Long): IrPropertySymbol

    abstract fun deserializeSimpleFunction(proto: Long): IrSimpleFunctionSymbol

    abstract fun deserializeSimpleFunctionSymbol(proto: Long): IrSimpleFunctionSymbol

    abstract fun deserializeField(proto: Long): IrFieldSymbol

    abstract fun deserializeVariable(proto: ProtoIrVariable): IrVariable

    abstract fun deserializeVisibility(proto: Long): DescriptorVisibility

    abstract fun deserializeModality(proto: Long): Modality

    abstract fun deserializeInlineClassRepresentation(proto: ProtoIrInlineClassRepresentation): InlineClassRepresentation<IrSimpleType>

    abstract fun deserializeIsExternalClass(proto: Long): Boolean

    abstract fun deserializeIsExternalField(proto: Long): Boolean

    abstract fun deserializeIsExternalFunction(proto: Long): Boolean

    abstract fun deserializeIsExternalProperty(proto: Long): Boolean

    fun deserializeAnonymousInitializerCarrier(bytes: ByteArray): AnonymousInitializerCarrier {
        val proto = PirAnonymousInitializerCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return AnonymousInitializerCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            if (proto.hasBody()) deserializeBlockBody(proto.body) else null
        )
    }

    fun deserializeClassCarrier(bytes: ByteArray): ClassCarrier {
        val proto = PirClassCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return ClassCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            if (proto.hasThisReceiver()) deserializeValueParameter(proto.thisReceiver) else null,
            deserializeVisibility(proto.flags),
            deserializeModality(proto.flags),
            proto.typeParametersList.map { deserializeTypeParameter(it) },
            proto.superTypesList.map { deserializeSuperType(it) },
            if (proto.hasInlineClassRepresentation()) deserializeInlineClassRepresentation(proto.inlineClassRepresentation) else null
        )
    }

    fun deserializeConstructorCarrier(bytes: ByteArray): ConstructorCarrier {
        val proto = PirConstructorCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return ConstructorCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            deserializeType(proto.returnTypeField),
            if (proto.hasDispatchReceiverParameter()) deserializeValueParameter(proto.dispatchReceiverParameter) else null,
            if (proto.hasExtensionReceiverParameter()) deserializeValueParameter(proto.extensionReceiverParameter) else null,
            if (proto.hasBody()) deserializeBody(proto.body) else null,
            deserializeVisibility(proto.flags),
            proto.typeParametersList.map { deserializeTypeParameter(it) },
            proto.valueParametersList.map { deserializeValueParameter(it) }
        )
    }

    fun deserializeEnumEntryCarrier(bytes: ByteArray): EnumEntryCarrier {
        val proto = PirEnumEntryCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return EnumEntryCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            if (proto.hasCorrespondingClass()) deserializeClass(proto.correspondingClass) else null,
            if (proto.hasInitializerExpression()) deserializeExpressionBody(proto.initializerExpression) else null
        )
    }

    fun deserializeErrorDeclarationCarrier(bytes: ByteArray): ErrorDeclarationCarrier {
        val proto = PirErrorDeclarationCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return ErrorDeclarationCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) }
        )
    }

    fun deserializeFieldCarrier(bytes: ByteArray): FieldCarrier {
        val proto = PirFieldCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return FieldCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            deserializeType(proto.type),
            if (proto.hasInitializer()) deserializeExpressionBody(proto.initializer) else null,
            if (proto.hasCorrespondingPropertySymbol()) deserializePropertySymbol(proto.correspondingPropertySymbol) else null
        )
    }

    fun deserializeFunctionCarrier(bytes: ByteArray): FunctionCarrier {
        val proto = PirFunctionCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return FunctionCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            deserializeType(proto.returnTypeField),
            if (proto.hasDispatchReceiverParameter()) deserializeValueParameter(proto.dispatchReceiverParameter) else null,
            if (proto.hasExtensionReceiverParameter()) deserializeValueParameter(proto.extensionReceiverParameter) else null,
            if (proto.hasBody()) deserializeBody(proto.body) else null,
            deserializeVisibility(proto.flags),
            proto.typeParametersList.map { deserializeTypeParameter(it) },
            proto.valueParametersList.map { deserializeValueParameter(it) },
            if (proto.hasCorrespondingPropertySymbol()) deserializePropertySymbol(proto.correspondingPropertySymbol) else null,
            proto.overriddenSymbolsList.map { deserializeSimpleFunctionSymbol(it) }
        )
    }

    fun deserializeLocalDelegatedPropertyCarrier(bytes: ByteArray): LocalDelegatedPropertyCarrier {
        val proto = PirLocalDelegatedPropertyCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return LocalDelegatedPropertyCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            deserializeType(proto.type),
            if (proto.hasDelegate()) deserializeVariable(proto.delegate) else null,
            if (proto.hasGetter()) deserializeSimpleFunction(proto.getter) else null,
            if (proto.hasSetter()) deserializeSimpleFunction(proto.setter) else null
        )
    }

    fun deserializePropertyCarrier(bytes: ByteArray): PropertyCarrier {
        val proto = PirPropertyCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return PropertyCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            if (proto.hasBackingField()) deserializeField(proto.backingField) else null,
            if (proto.hasGetter()) deserializeSimpleFunction(proto.getter) else null,
            if (proto.hasSetter()) deserializeSimpleFunction(proto.setter) else null,
            proto.overriddenSymbolsList.map { deserializePropertySymbol(it) }
        )
    }

    fun deserializeTypeAliasCarrier(bytes: ByteArray): TypeAliasCarrier {
        val proto = PirTypeAliasCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return TypeAliasCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            proto.typeParametersList.map { deserializeTypeParameter(it) },
            deserializeType(proto.expandedType)
        )
    }

    fun deserializeTypeParameterCarrier(bytes: ByteArray): TypeParameterCarrier {
        val proto = PirTypeParameterCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return TypeParameterCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            proto.superTypesList.map { deserializeSuperType(it) }
        )
    }

    fun deserializeValueParameterCarrier(bytes: ByteArray): ValueParameterCarrier {
        val proto = PirValueParameterCarrier.parseFrom(bytes.codedInputStream, ExtensionRegistryLite.newInstance())
        return ValueParameterCarrierImpl(
            proto.lastModified,
            if (proto.hasParentSymbol()) deserializeParentSymbol(proto.parentSymbol) else null,
            deserializeOrigin(proto.origin),
            proto.annotationList.map { deserializeAnnotation(it) },
            if (proto.hasDefaultValue()) deserializeExpressionBody(proto.defaultValue) else null,
            deserializeType(proto.type),
            if (proto.hasVarargElementType()) deserializeType(proto.varargElementType) else null
        )
    }
}
