/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.model.FlexibleTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001c\u0010\n\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/types/AbstractStrictEqualityTypeChecker;", "", "()V", "strictEqualTypes", "", "context", "Lorg/jetbrains/kotlin/types/model/TypeSystemContext;", "a", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "b", "strictEqualSimpleTypes", "Lorg/jetbrains/kotlin/types/model/SimpleTypeMarker;", "strictEqualTypesInternal", "compiler.common"})
public final class AbstractStrictEqualityTypeChecker {
    @NotNull
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    public final boolean strictEqualTypes(@NotNull TypeSystemContext context2, @NotNull KotlinTypeMarker a, @NotNull KotlinTypeMarker b) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.strictEqualTypesInternal(context2, a, b);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext $this$strictEqualTypesInternal, KotlinTypeMarker a, KotlinTypeMarker b) {
        if (a == b) {
            return true;
        }
        SimpleTypeMarker simpleA = $this$strictEqualTypesInternal.asSimpleType(a);
        SimpleTypeMarker simpleB = $this$strictEqualTypesInternal.asSimpleType(b);
        if (simpleA != null && simpleB != null) {
            return this.strictEqualSimpleTypes($this$strictEqualTypesInternal, simpleA, simpleB);
        }
        FlexibleTypeMarker flexibleA = $this$strictEqualTypesInternal.asFlexibleType(a);
        FlexibleTypeMarker flexibleB = $this$strictEqualTypesInternal.asFlexibleType(b);
        if (flexibleA != null && flexibleB != null) {
            return this.strictEqualSimpleTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.lowerBound(flexibleA), $this$strictEqualTypesInternal.lowerBound(flexibleB)) && this.strictEqualSimpleTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.upperBound(flexibleA), $this$strictEqualTypesInternal.upperBound(flexibleB));
        }
        return false;
    }

    private final boolean strictEqualSimpleTypes(TypeSystemContext $this$strictEqualSimpleTypes, SimpleTypeMarker a, SimpleTypeMarker b) {
        if ($this$strictEqualSimpleTypes.argumentsCount(a) != $this$strictEqualSimpleTypes.argumentsCount(b) || $this$strictEqualSimpleTypes.isMarkedNullable(a) != $this$strictEqualSimpleTypes.isMarkedNullable(b) || $this$strictEqualSimpleTypes.asDefinitelyNotNullType(a) == null != ($this$strictEqualSimpleTypes.asDefinitelyNotNullType(b) == null) || !$this$strictEqualSimpleTypes.areEqualTypeConstructors($this$strictEqualSimpleTypes.typeConstructor(a), $this$strictEqualSimpleTypes.typeConstructor(b))) {
            return false;
        }
        if ($this$strictEqualSimpleTypes.identicalArguments(a, b)) {
            return true;
        }
        int n = 0;
        int n2 = $this$strictEqualSimpleTypes.argumentsCount(a);
        while (n < n2) {
            int i = n++;
            TypeArgumentMarker aArg = $this$strictEqualSimpleTypes.getArgument(a, i);
            TypeArgumentMarker bArg = $this$strictEqualSimpleTypes.getArgument(b, i);
            if ($this$strictEqualSimpleTypes.isStarProjection(aArg) != $this$strictEqualSimpleTypes.isStarProjection(bArg)) {
                return false;
            }
            if ($this$strictEqualSimpleTypes.isStarProjection(aArg)) continue;
            if ($this$strictEqualSimpleTypes.getVariance(aArg) != $this$strictEqualSimpleTypes.getVariance(bArg)) {
                return false;
            }
            if (this.strictEqualTypesInternal($this$strictEqualSimpleTypes, $this$strictEqualSimpleTypes.getType(aArg), $this$strictEqualSimpleTypes.getType(bArg))) continue;
            return false;
        }
        return true;
    }
}

