/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/ir/ir.tree/tree-generator/ReadMe.md.
// DO NOT MODIFY IT MANUALLY.

package org.jetbrains.kotlin.ir.visitors

import org.jetbrains.kotlin.ir.IrElement
import org.jetbrains.kotlin.ir.declarations.*
import org.jetbrains.kotlin.ir.expressions.*
import org.jetbrains.kotlin.ir.types.IrSimpleType
import org.jetbrains.kotlin.ir.types.IrType
import org.jetbrains.kotlin.ir.types.IrTypeProjection

/**
 * Auto-generated by [org.jetbrains.kotlin.ir.generator.print.TypeVisitorVoidPrinter]
 */
abstract class IrTypeVisitorVoid : IrTypeVisitor<Unit, Nothing?>(), IrElementVisitorVoid {
    /**
     * A customization point called by [visitTypeRecursively] on each field of [container] that contains
     * an [IrType], as well as on all the latter's type arguments (for [IrSimpleType]s).
     */
    abstract fun visitType(container: IrElement, type: IrType)

    final override fun visitType(container: IrElement, type: IrType, data: Nothing?) {
        visitType(container, type)
    }

    /**
     * Called on each field of [container] that contains an [IrType].
     * The default implementation calls [visitType] for [type] and each of its type arguments
     * (for [IrSimpleType]s).
     */
    open fun visitTypeRecursively(container: IrElement, type: IrType) {
        visitType(container, type)
        if (type is IrSimpleType) {
            type.arguments.forEach {
                if (it is IrTypeProjection) {
                    visitTypeRecursively(container, it.type)
                }
            }
        }
    }

    final override fun visitTypeRecursively(container: IrElement, type: IrType, data: Nothing?) {
        visitTypeRecursively(container, type)
    }

    final override fun visitValueParameter(declaration: IrValueParameter, data: Nothing?) {
        visitValueParameter(declaration)
    }

    override fun visitValueParameter(declaration: IrValueParameter) {
        declaration.varargElementType?.let { visitTypeRecursively(declaration, it) }
        visitTypeRecursively(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitValueParameter(declaration)
    }

    final override fun visitClass(declaration: IrClass, data: Nothing?) {
        visitClass(declaration)
    }

    override fun visitClass(declaration: IrClass) {
        declaration.valueClassRepresentation?.mapUnderlyingType {
            visitTypeRecursively(declaration, it)
            it
        }
        declaration.superTypes.forEach { visitTypeRecursively(declaration, it) }
        super<IrElementVisitorVoid>.visitClass(declaration)
    }

    final override fun visitTypeParameter(declaration: IrTypeParameter, data: Nothing?) {
        visitTypeParameter(declaration)
    }

    override fun visitTypeParameter(declaration: IrTypeParameter) {
        declaration.superTypes.forEach { visitTypeRecursively(declaration, it) }
        super<IrElementVisitorVoid>.visitTypeParameter(declaration)
    }

    final override fun visitFunction(declaration: IrFunction, data: Nothing?) {
        visitFunction(declaration)
    }

    override fun visitFunction(declaration: IrFunction) {
        visitTypeRecursively(declaration, declaration.returnType)
        super<IrElementVisitorVoid>.visitFunction(declaration)
    }

    final override fun visitField(declaration: IrField, data: Nothing?) {
        visitField(declaration)
    }

    override fun visitField(declaration: IrField) {
        visitTypeRecursively(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitField(declaration)
    }

    final override fun visitLocalDelegatedProperty(declaration: IrLocalDelegatedProperty, data: Nothing?) {
        visitLocalDelegatedProperty(declaration)
    }

    override fun visitLocalDelegatedProperty(declaration: IrLocalDelegatedProperty) {
        visitTypeRecursively(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitLocalDelegatedProperty(declaration)
    }

    final override fun visitScript(declaration: IrScript, data: Nothing?) {
        visitScript(declaration)
    }

    override fun visitScript(declaration: IrScript) {
        declaration.baseClass?.let { visitTypeRecursively(declaration, it) }
        super<IrElementVisitorVoid>.visitScript(declaration)
    }

    final override fun visitTypeAlias(declaration: IrTypeAlias, data: Nothing?) {
        visitTypeAlias(declaration)
    }

    override fun visitTypeAlias(declaration: IrTypeAlias) {
        visitTypeRecursively(declaration, declaration.expandedType)
        super<IrElementVisitorVoid>.visitTypeAlias(declaration)
    }

    final override fun visitVariable(declaration: IrVariable, data: Nothing?) {
        visitVariable(declaration)
    }

    override fun visitVariable(declaration: IrVariable) {
        visitTypeRecursively(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitVariable(declaration)
    }

    final override fun visitExpression(expression: IrExpression, data: Nothing?) {
        visitExpression(expression)
    }

    override fun visitExpression(expression: IrExpression) {
        visitTypeRecursively(expression, expression.type)
        super<IrElementVisitorVoid>.visitExpression(expression)
    }

    final override fun visitMemberAccess(expression: IrMemberAccessExpression<*>, data: Nothing?) {
        visitMemberAccess(expression)
    }

    override fun visitMemberAccess(expression: IrMemberAccessExpression<*>) {
        (0 until expression.typeArgumentsCount).forEach {
            expression.getTypeArgument(it)?.let { type ->
                visitTypeRecursively(expression, type)
            }
        }
        super<IrElementVisitorVoid>.visitMemberAccess(expression)
    }

    final override fun visitClassReference(expression: IrClassReference, data: Nothing?) {
        visitClassReference(expression)
    }

    override fun visitClassReference(expression: IrClassReference) {
        visitTypeRecursively(expression, expression.classType)
        super<IrElementVisitorVoid>.visitClassReference(expression)
    }

    final override fun visitConstantObject(expression: IrConstantObject, data: Nothing?) {
        visitConstantObject(expression)
    }

    override fun visitConstantObject(expression: IrConstantObject) {
        expression.typeArguments.forEach { visitTypeRecursively(expression, it) }
        super<IrElementVisitorVoid>.visitConstantObject(expression)
    }

    final override fun visitTypeOperator(expression: IrTypeOperatorCall, data: Nothing?) {
        visitTypeOperator(expression)
    }

    override fun visitTypeOperator(expression: IrTypeOperatorCall) {
        visitTypeRecursively(expression, expression.typeOperand)
        super<IrElementVisitorVoid>.visitTypeOperator(expression)
    }

    final override fun visitVararg(expression: IrVararg, data: Nothing?) {
        visitVararg(expression)
    }

    override fun visitVararg(expression: IrVararg) {
        visitTypeRecursively(expression, expression.varargElementType)
        super<IrElementVisitorVoid>.visitVararg(expression)
    }
}
