/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinToolRunner;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizationCacheKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0014\u0010\u0012\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\u0013\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache;", "", "runner", "Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner;", "outputDirectory", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner;Ljava/io/File;)V", "successMarker", "isCached", "", "args", "", "", "logInfo", "", "message", "logQuiet", "run", "runIfNecessary", "successMarkerText", "Logging", "kotlin-gradle-plugin"})
public final class NativeDistributionCommonizationCache {
    @NotNull
    private final KotlinToolRunner runner;
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final File successMarker;

    public NativeDistributionCommonizationCache(@NotNull KotlinToolRunner runner, @NotNull File outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)runner, (String)"runner");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        this.runner = runner;
        this.outputDirectory = outputDirectory;
        this.successMarker = FilesKt.resolve((File)this.outputDirectory, (String)".commonized");
    }

    public final void runIfNecessary(@NotNull List<String> args) {
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        if (!this.isCached(args)) {
            this.run(args);
        }
    }

    private final boolean isCached(List<String> args) {
        if (!NativeDistributionCommonizationCacheKt.isNativeDistributionCommonizationCacheEnabled(this.runner.getProject())) {
            this.logInfo("Cache disabled");
            return false;
        }
        if (this.successMarker.exists() && this.successMarker.isFile()) {
            if (Intrinsics.areEqual((Object)FilesKt.readText$default((File)this.successMarker, null, (int)1, null), (Object)this.successMarkerText(args))) {
                this.logInfo(Intrinsics.stringPlus((String)"Cache hit for ", (Object)this.outputDirectory.getPath()));
                return true;
            }
            this.logQuiet(Intrinsics.stringPlus((String)"Cache miss. Different arguments for ", (Object)this.outputDirectory.getPath()));
            this.successMarker.delete();
        }
        return false;
    }

    private final void run(List<String> args) {
        FilesKt.deleteRecursively((File)this.outputDirectory);
        this.runner.run(args);
        FilesKt.writeText$default((File)this.successMarker, (String)this.successMarkerText(args), null, (int)2, null);
    }

    private final String successMarkerText(List<String> args) {
        return CollectionsKt.joinToString$default((Iterable)args, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final void logInfo(String message2) {
        this.runner.getProject().getLogger().info(Intrinsics.stringPlus((String)"Native Distribution Commonization: ", (Object)message2));
    }

    private final void logQuiet(String message2) {
        this.runner.getProject().getLogger().quiet(Intrinsics.stringPlus((String)"Native Distribution Commonization: ", (Object)message2));
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache$Logging;", "", "()V", "prefix", "", "kotlin-gradle-plugin"})
    private static final class Logging {
        @Deprecated
        @NotNull
        public static final Logging INSTANCE = new Logging();
        @NotNull
        public static final String prefix = "Native Distribution Commonization";

        private Logging() {
        }
    }
}

