/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.CommonizerExecutionEnvironment;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizerTaskKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.SuccessMarker;
import org.jetbrains.kotlin.gradle.targets.native.internal.TemporaryStagedDirectory;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\u00020\u00058G\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00020\u00058G\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\rR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0007R,\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u00170\u00158GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001c\u001a\u00020\u00058G\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\r\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "commonizerTargetOutputDirectories", "", "Ljava/io/File;", "getCommonizerTargetOutputDirectories", "()Ljava/util/List;", "konanHome", "kotlin.jvm.PlatformType", "originalCommonLibrariesDirectory", "originalCommonLibrariesDirectory$annotations", "getOriginalCommonLibrariesDirectory", "()Ljava/io/File;", "originalPlatformLibrariesDirectory", "originalPlatformLibrariesDirectory$annotations", "getOriginalPlatformLibrariesDirectory", "successMarkers", "successMarkers$annotations", "getSuccessMarkers", "targetGroups", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/KonanTargetGroup;", "getTargetGroups", "()Ljava/util/Set;", "setTargetGroups", "(Ljava/util/Set;)V", "taskMutex", "taskMutex$annotations", "getTaskMutex", "createExecutionEnvironment", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/CommonizerExecutionEnvironment;", "run", "", "kotlin-gradle-plugin"})
public class NativeDistributionCommonizerTask
extends DefaultTask {
    private final File konanHome;
    @NotNull
    private Set<? extends Set<? extends KonanTarget>> targetGroups;
    @NotNull
    private final File originalCommonLibrariesDirectory;
    @NotNull
    private final File originalPlatformLibrariesDirectory;
    @NotNull
    private final File taskMutex;

    public NativeDistributionCommonizerTask() {
        Object object;
        Project project = object = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project");
        this.konanHome = project.file((Object)NativeToolRunnersKt.getKonanHome(object));
        this.targetGroups = SetsKt.emptySet();
        object = this.konanHome;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"konanHome");
        this.originalCommonLibrariesDirectory = FilesKt.resolve((File)FilesKt.resolve((File)object, (String)"klib"), (String)"common");
        object = this.konanHome;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"konanHome");
        this.originalPlatformLibrariesDirectory = FilesKt.resolve((File)FilesKt.resolve((File)object, (String)"klib"), (String)"platform");
        object = this.getProject().getRootProject().file((Object)".commonizer-phantom-output");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.rootProject.file(\".commonizer-phantom-output\")");
        this.taskMutex = object;
    }

    @Input
    @NotNull
    public final Set<Set<KonanTarget>> getTargetGroups() {
        return this.targetGroups;
    }

    public final void setTargetGroups(@NotNull Set<? extends Set<? extends KonanTarget>> set2) {
        Intrinsics.checkParameterIsNotNull(set2, (String)"<set-?>");
        this.targetGroups = set2;
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputDirectory
    @NotNull
    public final File getOriginalCommonLibrariesDirectory() {
        return this.originalCommonLibrariesDirectory;
    }

    public static /* synthetic */ void originalCommonLibrariesDirectory$annotations() {
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputDirectory
    @NotNull
    public final File getOriginalPlatformLibrariesDirectory() {
        return this.originalPlatformLibrariesDirectory;
    }

    public static /* synthetic */ void originalPlatformLibrariesDirectory$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @OutputDirectories
    @NotNull
    public final List<File> getCommonizerTargetOutputDirectories() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.targetGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void targets;
            Set set2 = (Set)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            File file = NativeDistributionCommonizerTaskKt.nativeDistributionCommonizerOutputDirectory(project, (Set<? extends KonanTarget>)targets);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputFiles
    @NotNull
    public final List<File> getSuccessMarkers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.targetGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void targets;
            Set set2 = (Set)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            File file = SuccessMarker.Companion.getSuccessMarker(project, (Set<? extends KonanTarget>)targets).getFile();
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ void successMarkers$annotations() {
    }

    @OutputFile
    @NotNull
    public final File getTaskMutex() {
        return this.taskMutex;
    }

    public static /* synthetic */ void taskMutex$annotations() {
    }

    @TaskAction
    public final void run() {
        File file = this.konanHome;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"konanHome");
        NativeDistributionCommonizerTaskKt.access$cleanUp(FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"klib"), (String)"commonized"), this.getCommonizerTargetOutputDirectories());
        CommonizerExecutionEnvironment executionEnvironment = this.createExecutionEnvironment();
        try {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            NativeDistributionCommonizerTaskKt.callCommonizerCLI(project, executionEnvironment.getCommandLineArguments());
            Iterable $this$forEach$iv = executionEnvironment.getStagedDirectories();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TemporaryStagedDirectory stagedDirectory = (TemporaryStagedDirectory)element$iv;
                boolean bl = false;
                stagedDirectory.onSuccess();
            }
            $this$forEach$iv = executionEnvironment.getSuccessMarkers();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SuccessMarker successMarker = (SuccessMarker)element$iv;
                boolean bl = false;
                successMarker.writeSuccess();
            }
        }
        catch (Throwable e) {
            Iterable $this$forEach$iv = executionEnvironment.getStagedDirectories();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TemporaryStagedDirectory stagedDirectory = (TemporaryStagedDirectory)element$iv;
                boolean bl = false;
                stagedDirectory.onFailure();
            }
            $this$forEach$iv = executionEnvironment.getSuccessMarkers();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SuccessMarker successMarker = (SuccessMarker)element$iv;
                boolean bl = false;
                successMarker.delete();
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CommonizerExecutionEnvironment createExecutionEnvironment() {
        boolean bl = false;
        List stagedDirectories = new ArrayList();
        boolean bl2 = false;
        List successMarkers = new ArrayList();
        boolean bl3 = false;
        List arguments2 = new ArrayList();
        Iterable $this$forEach$iv = this.targetGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            Set targets = (Set)element$iv;
            boolean bl4 = false;
            if (targets.size() <= 1) continue;
            Iterable $this$map$iv = targets;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KonanTarget konanTarget2 = (KonanTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                String string = it.getName();
                collection.add(string);
            }
            List orderedTargetNames = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            Project $i$f$map22 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$map22, (String)"project");
            SuccessMarker successMarker = SuccessMarker.Companion.getSuccessMarker($i$f$map22, targets);
            if (successMarker.isSuccess()) continue;
            iterable = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"project");
            File file = NativeDistributionCommonizerTaskKt.createTempNativeDistributionCommonizerOutputDirectory((Project)iterable, targets);
            iterable = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"project");
            TemporaryStagedDirectory stagedDirectory = new TemporaryStagedDirectory(file, NativeDistributionCommonizerTaskKt.nativeDistributionCommonizerOutputDirectory((Project)iterable, targets));
            iterable = stagedDirectories;
            boolean bl6 = false;
            iterable.add(stagedDirectory);
            iterable = successMarkers;
            bl6 = false;
            iterable.add(successMarker);
            iterable = arguments2;
            String string = "native-dist-commonize";
            boolean bl7 = false;
            iterable.add(string);
            iterable = arguments2;
            string = "-distribution-path";
            bl7 = false;
            iterable.add(string);
            iterable = arguments2;
            string = this.konanHome.getAbsolutePath();
            bl7 = false;
            iterable.add(string);
            iterable = arguments2;
            string = "-output-path";
            bl7 = false;
            iterable.add(string);
            iterable = arguments2;
            string = stagedDirectory.getTemporaryDirectoryFile().getAbsolutePath();
            bl7 = false;
            iterable.add(string);
            iterable = arguments2;
            string = "-targets";
            bl7 = false;
            iterable.add(string);
            iterable = arguments2;
            string = CollectionsKt.joinToString$default((Iterable)orderedTargetNames, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            bl7 = false;
            iterable.add(string);
        }
        return new CommonizerExecutionEnvironment(arguments2, successMarkers, stagedDirectories);
    }
}

