/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionType;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionTypeProvider;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader;
import org.jetbrains.kotlin.gradle.utils.ResourceUtilsKt;
import org.jetbrains.kotlin.konan.CompilerVersion;
import org.jetbrains.kotlin.konan.CompilerVersionImpl;
import org.jetbrains.kotlin.konan.CompilerVersionKt;
import org.jetbrains.kotlin.konan.MetaVersion;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.util.DependencyDirectories;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\fH\u0002J\b\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020-J\u0010\u0010/\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\bH\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader;", "", "project", "Lorg/gradle/api/Project;", "compilerVersion", "Lorg/jetbrains/kotlin/konan/CompilerVersion;", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/konan/CompilerVersion;)V", "archiveExtension", "", "getArchiveExtension", "()Ljava/lang/String;", "compilerDirectory", "Ljava/io/File;", "getCompilerDirectory", "()Ljava/io/File;", "dependencyFileName", "getDependencyFileName", "dependencyName", "getDependencyName", "dependencyNameWithVersion", "getDependencyNameWithVersion", "distributionType", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "getDistributionType", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "kotlinProperties", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "getKotlinProperties", "()Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getProject", "()Lorg/gradle/api/Project;", "simpleOsName", "getSimpleOsName", "useZip", "", "getUseZip", "()Z", "archiveFileTree", "Lorg/gradle/api/file/FileTree;", "archive", "downloadAndExtract", "", "downloadIfNeeded", "removeRepo", "repo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "setupRepo", "repoUrl", "Companion", "kotlin-gradle-plugin_common"})
public final class NativeCompilerDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CompilerVersion compilerVersion;
    @NotNull
    private static final Lazy<CompilerVersion> DEFAULT_KONAN_VERSION$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_KONAN_VERSION.2.INSTANCE);
    @NotNull
    public static final String BASE_DOWNLOAD_URL = "https://download.jetbrains.com/kotlin/native/builds";

    public NativeCompilerDownloader(@NotNull Project project, @NotNull CompilerVersion compilerVersion2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerVersion2, (String)"compilerVersion");
        this.project = project;
        this.compilerVersion = compilerVersion2;
    }

    public /* synthetic */ NativeCompilerDownloader(Project project, CompilerVersion compilerVersion2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compilerVersion2 = NativeToolRunnersKt.getKonanVersion(project);
        }
        this(project, compilerVersion2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getCompilerDirectory() {
        return FilesKt.resolve((File)DependencyDirectories.INSTANCE.getLocalKonanDir(), (String)this.getDependencyNameWithVersion());
    }

    private final Logger getLogger() {
        Logger logger = this.project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        return logger;
    }

    private final PropertiesProvider getKotlinProperties() {
        return PropertiesProvider.Companion.invoke(this.project);
    }

    private final NativeDistributionType getDistributionType() {
        return new NativeDistributionTypeProvider(this.project).getDistributionType(this.compilerVersion);
    }

    private final String getSimpleOsName() {
        return CompilerVersionKt.isAtLeast(this.compilerVersion, new CompilerVersionImpl(null, 1, 5, 30, 0, 1466, 17, null)) ? HostManager.Companion.platformName() : HostManager.Companion.simpleOsName();
    }

    private final String getDependencyName() {
        String dependencySuffix = this.getDistributionType().getSuffix();
        return dependencySuffix != null ? "kotlin-native-" + dependencySuffix + '-' + this.getSimpleOsName() : "kotlin-native-" + this.getSimpleOsName();
    }

    private final String getDependencyNameWithVersion() {
        return this.getDependencyName() + '-' + this.compilerVersion;
    }

    private final String getDependencyFileName() {
        return this.getDependencyNameWithVersion() + '.' + this.getArchiveExtension();
    }

    private final boolean getUseZip() {
        return HostManager.Companion.getHostIsMingw();
    }

    private final String getArchiveExtension() {
        return this.getUseZip() ? "zip" : "tar.gz";
    }

    private final FileTree archiveFileTree(File archive) {
        FileTree fileTree;
        if (this.getUseZip()) {
            FileTree fileTree2 = this.project.zipTree((Object)archive);
            fileTree = fileTree2;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree2, (String)"{\n            project.zipTree(archive)\n        }");
        } else {
            FileTree fileTree3 = this.project.tarTree((Object)archive);
            fileTree = fileTree3;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree3, (String)"{\n            project.tarTree(archive)\n        }");
        }
        return fileTree;
    }

    private final ArtifactRepository setupRepo(String repoUrl) {
        IvyArtifactRepository ivyArtifactRepository = this.project.getRepositories().ivy(new Action(repoUrl){
            final /* synthetic */ String $repoUrl;
            {
                this.$repoUrl = $repoUrl;
            }

            public final void execute(IvyArtifactRepository repo2) {
                repo2.setUrl((Object)this.$repoUrl);
                repo2.patternLayout((Action)setupRepo.1.INSTANCE);
                repo2.metadataSources((Action)setupRepo.2.INSTANCE);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)ivyArtifactRepository, (String)"repoUrl: String): Artifa\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final void removeRepo(ArtifactRepository repo2) {
        this.project.getRepositories().remove((Object)repo2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadAndExtract() {
        Logger $this$lifecycleWithDuration$iv;
        String string;
        String string2;
        String string3;
        Long l;
        StringBuilder stringBuilder;
        StringBuilder $this$downloadAndExtract_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$downloadAndExtract_u24lambda_u2d0.append(this.getKotlinProperties().getNativeBaseDownloadUrl() + '/');
        $this$downloadAndExtract_u24lambda_u2d0.append(MetaVersion.equals-impl0(this.compilerVersion.getMeta-CSrMgVE(), MetaVersion.Companion.getDEV-CSrMgVE()) ? "dev/" : "releases/");
        $this$downloadAndExtract_u24lambda_u2d0.append("" + this.compilerVersion + '/');
        $this$downloadAndExtract_u24lambda_u2d0.append(this.getSimpleOsName());
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String repoUrl = string4;
        String dependencyUrl = repoUrl + '/' + this.getDependencyFileName();
        ArtifactRepository repo2 = this.setupRepo(repoUrl);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)this.getDependencyName()), TuplesKt.to((Object)"version", (Object)this.compilerVersion.toString()), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())};
        Dependency compilerDependency = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
        Dependency[] dependencyArray = new Dependency[]{compilerDependency};
        Configuration configuration2 = this.project.getConfigurations().detachedConfiguration(dependencyArray);
        this.getLogger().lifecycle("\nPlease wait while Kotlin/Native compiler " + this.compilerVersion + " is being installed.");
        Long l2 = ResourceUtilsKt.probeRemoteFileLength(this.project, dependencyUrl, 200);
        if (l2 != null) {
            l = l2;
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            string3 = " (" + FormattingUtilsKt.formatContentLength(it) + ')';
        } else {
            string3 = null;
        }
        if ((string2 = (string = string3)) == null) {
            string2 = "";
        }
        String suffix = string2;
        this.getLogger().lifecycle("Download " + dependencyUrl + suffix);
        l = this.getLogger();
        String messagePrefix$iv = "Download " + dependencyUrl + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl3 = false;
        Set set2 = configuration2.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"configuration.files");
        File result$iv = (File)CollectionsKt.single((Iterable)set2);
        long finishTime$iv = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        File archive = result$iv;
        GradleLoggingUtilsKt.kotlinInfo(this.getLogger(), "Using Kotlin/Native compiler archive: " + archive.getAbsolutePath());
        this.getLogger().lifecycle("Unpack Kotlin/Native compiler to " + this.getCompilerDirectory());
        $this$lifecycleWithDuration$iv = this.getLogger();
        messagePrefix$iv = "Unpack Kotlin/Native compiler to " + this.getCompilerDirectory() + " finished,";
        $i$f$lifecycleWithDuration = false;
        startTime$iv = System.currentTimeMillis();
        boolean bl4 = false;
        File it = finishTime$iv = this.getCompilerDirectory().getParentFile();
        boolean bl5 = false;
        it.mkdirs();
        File kotlinNativeDir = finishTime$iv;
        File tmpDir = Files.createTempDirectory(kotlinNativeDir.toPath(), "compiler-", new FileAttribute[0]).toFile();
        try {
            this.getLogger().debug("Unpacking Kotlin/Native compiler to tmp directory " + tmpDir);
            this.project.copy(new Action(this, archive, tmpDir){
                final /* synthetic */ NativeCompilerDownloader this$0;
                final /* synthetic */ File $archive;
                final /* synthetic */ File $tmpDir;
                {
                    this.this$0 = $receiver;
                    this.$archive = $archive;
                    this.$tmpDir = $tmpDir;
                }

                public final void execute(CopySpec it) {
                    Object[] objectArray = new Object[1];
                    File file = this.$archive;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"archive");
                    objectArray[0] = NativeCompilerDownloader.access$archiveFileTree(this.this$0, file);
                    it.from(objectArray);
                    it.into((Object)this.$tmpDir);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            File compilerTmp = FilesKt.resolve((File)tmpDir, (String)this.getDependencyNameWithVersion());
            if (!compilerTmp.renameTo(this.getCompilerDirectory())) {
                this.project.copy(new Action(compilerTmp, this){
                    final /* synthetic */ File $compilerTmp;
                    final /* synthetic */ NativeCompilerDownloader this$0;
                    {
                        this.$compilerTmp = $compilerTmp;
                        this.this$0 = $receiver;
                    }

                    public final void execute(CopySpec it) {
                        Object[] objectArray = new Object[]{this.$compilerTmp};
                        it.from(objectArray);
                        it.into((Object)this.this$0.getCompilerDirectory());
                    }
                });
            }
            this.getLogger().debug("Moved Kotlin/Native compiler from " + tmpDir + " to " + this.getCompilerDirectory());
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            FilesKt.deleteRecursively((File)tmpDir);
            throw throwable;
        }
        FilesKt.deleteRecursively((File)tmpDir);
        Unit result$iv2 = Unit.INSTANCE;
        long finishTime$iv2 = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv2 - startTime$iv));
        this.removeRepo(repo2);
    }

    public final void downloadIfNeeded() {
        block9: {
            block8: {
                boolean bl;
                block7: {
                    Set<File> classpath2 = new KotlinNativeCompilerRunner(this.project).getClasspath();
                    if (classpath2.isEmpty()) break block8;
                    Intrinsics.checkNotNullExpressionValue(classpath2, (String)"classpath");
                    Iterable $this$any$iv = classpath2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            File it = (File)element$iv;
                            boolean bl2 = false;
                            if (!(!it.exists())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            this.downloadAndExtract();
        }
    }

    public static final /* synthetic */ FileTree access$archiveFileTree(NativeCompilerDownloader $this, File archive) {
        return $this.archiveFileTree(archive);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$Companion;", "", "()V", "BASE_DOWNLOAD_URL", "", "DEFAULT_KONAN_VERSION", "Lorg/jetbrains/kotlin/konan/CompilerVersion;", "getDEFAULT_KONAN_VERSION", "()Lorg/jetbrains/kotlin/konan/CompilerVersion;", "DEFAULT_KONAN_VERSION$delegate", "Lkotlin/Lazy;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilerVersion getDEFAULT_KONAN_VERSION() {
            Lazy lazy = DEFAULT_KONAN_VERSION$delegate;
            return (CompilerVersion)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

