/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.util.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.util.concurrent.FluentFuture;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ListenableFuture;
import org.jetbrains.kotlin.com.google.common.util.concurrent.MoreExecutors;

@GwtIncompatible
final class TimeoutFuture<V>
extends FluentFuture.TrustedFuture<V> {
    private @Nullable ListenableFuture<V> delegateRef;
    private @Nullable ScheduledFuture<?> timer;

    static <V> ListenableFuture<V> create(ListenableFuture<V> delegate2, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result2 = new TimeoutFuture<V>(delegate2);
        Fire<V> fire = new Fire<V>(result2);
        result2.timer = scheduledExecutor.schedule(fire, time, unit);
        delegate2.addListener(fire, MoreExecutors.directExecutor());
        return result2;
    }

    private TimeoutFuture(ListenableFuture<V> delegate2) {
        this.delegateRef = Preconditions.checkNotNull(delegate2);
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<V> localInputFuture = this.delegateRef;
        ScheduledFuture<?> localTimer = this.timer;
        if (localInputFuture != null) {
            long delay;
            String message2 = "inputFuture=[" + localInputFuture + "]";
            if (localTimer != null && (delay = localTimer.getDelay(TimeUnit.MILLISECONDS)) > 0L) {
                message2 = message2 + ", remaining delay=[" + delay + " ms]";
            }
            return message2;
        }
        return null;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        ScheduledFuture<?> localTimer = this.timer;
        if (localTimer != null) {
            localTimer.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    private static final class TimeoutFutureException
    extends TimeoutException {
        private TimeoutFutureException(String message2) {
            super(message2);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            this.setStackTrace(new StackTraceElement[0]);
            return this;
        }
    }

    private static final class Fire<V>
    implements Runnable {
        @Nullable TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture delegate2 = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (delegate2 == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (delegate2.isDone()) {
                timeoutFuture.setFuture(delegate2);
            } else {
                try {
                    ScheduledFuture timer = ((TimeoutFuture)timeoutFuture).timer;
                    ((TimeoutFuture)timeoutFuture).timer = null;
                    String message2 = "Timed out";
                    try {
                        long overDelayMs;
                        if (timer != null && (overDelayMs = Math.abs(timer.getDelay(TimeUnit.MILLISECONDS))) > 10L) {
                            message2 = message2 + " (timeout delayed by " + overDelayMs + " ms after scheduled time)";
                        }
                        message2 = message2 + ": " + delegate2;
                    }
                    finally {
                        timeoutFuture.setException(new TimeoutFutureException(message2));
                    }
                }
                finally {
                    delegate2.cancel(true);
                }
            }
        }
    }
}

