/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilerExecutionStrategy;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001aQ\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\f2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a#\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0019\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a8\u0006\u001e"}, d2={"createLoggingMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "exitCodeFromProcessExitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "code", "", "loadCompilerVersion", "", "compilerClasspath", "", "Ljava/io/File;", "runToolInSeparateProcess", "argsArray", "", "compilerClassName", "classpath", "logger", "buildDir", "jvmArgs", "", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/io/File;Ljava/util/List;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "writeArgumentsToFile", "directory", "(Ljava/io/File;[Ljava/lang/String;)Ljava/io/File;", "logFinish", "", "strategy", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerExecutionStrategy;", "kotlin-gradle-plugin_common"})
public final class ReportUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String loadCompilerVersion(@NotNull Iterable<? extends File> compilerClasspath) {
        String string;
        Intrinsics.checkNotNullParameter(compilerClasspath, (String)"compilerClasspath");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = KotlinCompilerVersion.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"KotlinCompilerVersion::class.java.name");
            String versionClassFileName = stringBuilder.append(StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
            for (File file : compilerClasspath) {
                File file2;
                if (file.isFile()) {
                    String string3 = FilesKt.getExtension((File)file);
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                    if (Intrinsics.areEqual((Object)string4, (Object)"jar")) {
                        Closeable closeable = new ZipFile(file);
                        Throwable throwable = null;
                        try {
                            Object object;
                            Object object2;
                            ZipFile jar2 = (ZipFile)closeable;
                            boolean bl = false;
                            ZipEntry versionFileEntry = jar2.getEntry("/META-INF/compiler.version");
                            if (versionFileEntry != null) {
                                InputStream inputStream = jar2.getInputStream(versionFileEntry);
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"jar.getInputStream(versionFileEntry)");
                                Closeable closeable2 = inputStream;
                                object2 = Charsets.UTF_8;
                                Closeable closeable3 = closeable2;
                                closeable3 = new InputStreamReader((InputStream)closeable3, (Charset)object2);
                                int n = 8192;
                                closeable2 = closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n);
                                Ref.ObjectRef objectRef = result2;
                                object2 = null;
                                try {
                                    BufferedReader it = (BufferedReader)closeable2;
                                    boolean bl2 = false;
                                    object = TextStreamsKt.readText((Reader)it);
                                }
                                catch (Throwable throwable2) {
                                    object2 = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object2);
                                }
                                objectRef.element = object;
                            } else {
                                byte[] byArray;
                                object2 = jar2.getInputStream(jar2.getEntry(versionClassFileName));
                                object = null;
                                try {
                                    InputStream it = (InputStream)object2;
                                    boolean bl3 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                    byArray = ByteStreamsKt.readBytes((InputStream)it);
                                }
                                catch (Throwable throwable3) {
                                    object = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                                }
                                byte[] bytes = byArray;
                                ReportUtilsKt.loadCompilerVersion$checkVersion((Ref.ObjectRef<String>)result2, bytes);
                            }
                            file2 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }
                if (file.isDirectory()) {
                    File versionFile = new File(file, "/META-INF/compiler.version");
                    if (versionFile.isFile()) {
                        result2.element = FilesKt.readText$default((File)versionFile, null, (int)1, null);
                    } else {
                        File it = file2 = new File(file, versionClassFileName);
                        boolean bl = false;
                        File file3 = it.isFile() ? file2 : null;
                        if (file3 != null) {
                            it = file2 = file3;
                            boolean bl4 = false;
                            ReportUtilsKt.loadCompilerVersion$checkVersion((Ref.ObjectRef<String>)result2, FilesKt.readBytes((File)it));
                        }
                    }
                }
                if (result2.element == null) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if ((string = (String)result2.element) == null) {
            string = "<unknown>";
        }
        return string;
    }

    @NotNull
    public static final ExitCode runToolInSeparateProcess(@NotNull String[] argsArray, @NotNull String compilerClassName, @NotNull Iterable<? extends File> classpath2, @NotNull KotlinLogger logger, @NotNull File buildDir2, @NotNull List<String> jvmArgs2) {
        Intrinsics.checkNotNullParameter((Object)argsArray, (String)"argsArray");
        Intrinsics.checkNotNullParameter((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)buildDir2, (String)"buildDir");
        Intrinsics.checkNotNullParameter(jvmArgs2, (String)"jvmArgs");
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        String classpathString2 = CollectionsKt.joinToString$default(classpath2, (CharSequence)string, null, null, (int)0, null, (Function1)runToolInSeparateProcess.classpathString.1.INSTANCE, (int)30, null);
        File compilerOptions2 = ReportUtilsKt.writeArgumentsToFile(buildDir2, argsArray);
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)javaBin);
        Collection $this$toTypedArray$iv = jvmArgs2;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder.addSpread((Object)stringArray);
        spreadBuilder.add((Object)"-cp");
        spreadBuilder.add((Object)classpathString2);
        spreadBuilder.add((Object)compilerClassName);
        spreadBuilder.add((Object)('@' + compilerOptions2.getAbsolutePath()));
        ProcessBuilder builder = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        MessageCollector messageCollector = ReportUtilsKt.createLoggingMessageCollector(logger);
        Process process = NativePlatformUtilKt.launchProcessWithFallback$default((ProcessBuilder)builder, (DaemonReportingTargets)new DaemonReportingTargets(null, null, messageCollector, null, 11, null), null, (int)4, null);
        Thread readErrThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(process, logger){
            final /* synthetic */ Process $process;
            final /* synthetic */ KotlinLogger $logger;
            {
                this.$process = $process;
                this.$logger = $logger;
                super(0);
            }

            public final void invoke() {
                InputStream inputStream = this.$process.getErrorStream();
                Intrinsics.checkNotNull((Object)inputStream);
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Closeable closeable = inputStream2;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                int n = 8192;
                TextStreamsKt.forEachLine((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), (Function1)((Function1)new Function1<String, Unit>(this.$logger){
                    final /* synthetic */ KotlinLogger $logger;
                    {
                        this.$logger = $logger;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$logger.error(it);
                    }
                }));
            }
        }), (int)31, null);
        if (logger instanceof GradleKotlinLogger) {
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNull((Object)inputStream);
            thisCollection$iv = inputStream;
            Charset charset = Charsets.UTF_8;
            Object object = thisCollection$iv;
            object = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            TextStreamsKt.forEachLine((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)), (Function1)((Function1)new Function1<String, Unit>(logger){
                final /* synthetic */ KotlinLogger $logger;
                {
                    this.$logger = $logger;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ((GradleKotlinLogger)this.$logger).lifecycle(it);
                }
            }));
        } else {
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNull((Object)inputStream);
            thisCollection$iv = inputStream;
            Charset charset = Charsets.UTF_8;
            Object object = thisCollection$iv;
            object = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            TextStreamsKt.forEachLine((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)), (Function1)runToolInSeparateProcess.2.INSTANCE);
        }
        readErrThread2.join();
        int exitCode = process.waitFor();
        ReportUtilsKt.logFinish(logger, KotlinCompilerExecutionStrategy.OUT_OF_PROCESS);
        return ReportUtilsKt.exitCodeFromProcessExitCode(logger, exitCode);
    }

    public static /* synthetic */ ExitCode runToolInSeparateProcess$default(String[] stringArray, String string, Iterable iterable, KotlinLogger kotlinLogger2, File file, List list2, int n, Object object) {
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ReportUtilsKt.runToolInSeparateProcess(stringArray, string, iterable, kotlinLogger2, file, list2);
    }

    private static final File writeArgumentsToFile(File directory2, String[] argsArray) {
        String prefix = LocalDateTime.now().format(DateTimeFormatter.BASIC_ISO_DATE) + '_';
        String suffix = ".compiler.options";
        File compilerOptions2 = directory2.exists() ? Files.createTempFile(directory2.toPath(), prefix, suffix, new FileAttribute[0]).toFile() : Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)compilerOptions2, (String)"compilerOptions");
        FilesKt.writeText$default((File)compilerOptions2, (String)ArraysKt.joinToString$default((Object[])argsArray, (CharSequence)" ", null, null, (int)0, null, (Function1)writeArgumentsToFile.1.INSTANCE, (int)30, null), null, (int)2, null);
        return compilerOptions2;
    }

    private static final MessageCollector createLoggingMessageCollector(KotlinLogger log) {
        return new MessageCollector(log){
            private boolean hasErrors;
            private final MessageRenderer messageRenderer;
            final /* synthetic */ KotlinLogger $log;
            {
                this.$log = $log;
                this.messageRenderer = MessageRenderer.PLAIN_FULL_PATHS;
            }

            public void clear() {
                this.hasErrors = false;
            }

            public boolean hasErrors() {
                return this.hasErrors;
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                String locMessage = this.messageRenderer.render(severity, message2, location);
                switch (createLoggingMessageCollector.WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNullExpressionValue((Object)locMessage, (String)"locMessage");
                        this.$log.error(locMessage);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        Intrinsics.checkNotNullExpressionValue((Object)locMessage, (String)"locMessage");
                        this.$log.info(locMessage);
                        break;
                    }
                    case 6: {
                        Intrinsics.checkNotNullExpressionValue((Object)locMessage, (String)"locMessage");
                        this.$log.debug(locMessage);
                    }
                }
            }
        };
    }

    public static final void logFinish(@NotNull KotlinLogger $this$logFinish, @NotNull KotlinCompilerExecutionStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)$this$logFinish, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        $this$logFinish.debug("Finished executing kotlin compiler using " + (Object)((Object)strategy) + " strategy");
    }

    @NotNull
    public static final ExitCode exitCodeFromProcessExitCode(@NotNull KotlinLogger log, int code) {
        ExitCode exitCode;
        ExitCode exitCode2;
        block2: {
            ExitCode[] exitCodeArray;
            ExitCode[] exitCodeArray2;
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            ExitCode[] exitCodeArray3 = exitCodeArray2 = (exitCodeArray = ExitCode.values());
            int n = exitCodeArray3.length;
            for (int j = 0; j < n; ++j) {
                ExitCode exitCode3;
                ExitCode it = exitCode3 = exitCodeArray3[j];
                boolean bl = false;
                if (!(it.getCode() == code)) continue;
                exitCode2 = exitCode3;
                break block2;
            }
            exitCode2 = null;
        }
        ExitCode exitCode4 = exitCode = exitCode2;
        if (exitCode4 != null) {
            return exitCode4;
        }
        log.debug("Could not find exit code by value: " + code);
        return code == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
    }

    private static final void loadCompilerVersion$checkVersion(Ref.ObjectRef<String> result2, byte[] bytes) {
        new ClassReader(bytes).accept(new ClassVisitor(result2){
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.$result = $result;
                super(589824);
            }

            @NotNull
            public FieldVisitor visitField(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                if (Intrinsics.areEqual((Object)name2, (Object)"VERSION") && value instanceof String) {
                    this.$result.element = value;
                }
                FieldVisitor fieldVisitor = super.visitField(access, name2, desc, signature, value);
                Intrinsics.checkNotNullExpressionValue((Object)fieldVisitor, (String)"super.visitField(access,\u2026, desc, signature, value)");
                return fieldVisitor;
            }
        }, 7);
    }
}

