/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GFileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.internal.CleanableStore;
import org.jetbrains.kotlin.gradle.tasks.internal.DownloadedFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/internal/CleanableStoreImpl;", "Lorg/jetbrains/kotlin/gradle/tasks/internal/CleanableStore;", "dirPath", "", "(Ljava/lang/String;)V", "dir", "Ljava/io/File;", "cleanDir", "", "expirationDate", "Ljava/time/Instant;", "get", "Lorg/jetbrains/kotlin/gradle/tasks/internal/DownloadedFile;", "fileName", "markUsed", "kotlin-gradle-plugin_common"})
public final class CleanableStoreImpl
implements CleanableStore {
    @NotNull
    private final File dir;

    public CleanableStoreImpl(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        this.dir = new File(dirPath);
    }

    @Override
    @NotNull
    public DownloadedFile get(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new DownloadedFile(this, FilesKt.resolve((File)this.dir, (String)fileName));
    }

    @Override
    public void markUsed() {
        if (this.dir.exists()) {
            GFileUtils.touchExisting((File)this.dir);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanDir(@NotNull Instant expirationDate) {
        Intrinsics.checkNotNullParameter((Object)expirationDate, (String)"expirationDate");
        File[] fileArray = this.dir.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_9 = $this$filterTo$iv$iv;
            int n = ((void)var8_9).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void file = element$iv$iv = var8_9[j];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (!CleanableStoreImpl.cleanDir$modificationDate((File)file).isBefore(expirationDate)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                FilesKt.deleteRecursively((File)file);
            }
        }
    }

    private static final Instant cleanDir$modificationDate(File file) {
        Instant instant = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"getLastModifiedTime(file.toPath()).toInstant()");
        return instant;
    }
}

