/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.net.URLEncoder;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerLogLevel;
import org.jetbrains.kotlin.commonizer.NativeDistributionCommonizer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.compilerRunner.GradleCliCommonizerKt;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeCommonizerToolRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.targets.native.internal.CommonizerProjectExtensionsKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizationCache;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizerTaskKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0005R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00108AX\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\b\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "commonizer", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache;", "getCommonizer", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache;", "commonizer$delegate", "Lkotlin/Lazy;", "commonizerTargets", "", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "getCommonizerTargets", "()Ljava/util/Set;", "commonizerTargets$delegate", "konanHome", "Ljava/io/File;", "kotlin.jvm.PlatformType", "rootOutputDirectory", "getRootOutputDirectory$kotlin_gradle_plugin_common", "()Ljava/io/File;", "rootOutputDirectory$delegate", "run", "", "kotlin-gradle-plugin_common"})
public class NativeDistributionCommonizerTask
extends DefaultTask {
    private final File konanHome;
    @NotNull
    private final Lazy commonizerTargets$delegate;
    @NotNull
    private final Lazy commonizer$delegate;
    @NotNull
    private final Lazy rootOutputDirectory$delegate;

    public NativeDistributionCommonizerTask() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.konanHome = project.file((Object)NativeToolRunnersKt.getKonanHome(project2));
        this.commonizerTargets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends SharedCommonizerTarget>>(this){
            final /* synthetic */ NativeDistributionCommonizerTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<SharedCommonizerTarget> invoke() {
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return NativeDistributionCommonizerTaskKt.access$collectAllSharedCommonizerTargetsFromBuild(project);
            }
        }));
        this.commonizer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NativeDistributionCommonizationCache>(this){
            final /* synthetic */ NativeDistributionCommonizerTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativeDistributionCommonizationCache invoke() {
                Logger logger = this.this$0.getProject().getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                boolean bl = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getEnableNativeDistributionCommonizationCache();
                Project project2 = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                return new NativeDistributionCommonizationCache(logger, bl, (NativeDistributionCommonizer)GradleCliCommonizerKt.GradleCliCommonizer(new KotlinNativeCommonizerToolRunner(project2)));
            }
        }));
        this.rootOutputDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ NativeDistributionCommonizerTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                File file = this.this$0.getProject().file((Object)NativeDistributionCommonizerTask.access$getKonanHome$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(konanHome)");
                File file2 = FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"klib"), (String)"commonized");
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                String string = URLEncoder.encode(KotlinPluginWrapperKt.getKotlinPluginVersion(project), Charsets.UTF_8.name());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(project.getKotlin\u2026), Charsets.UTF_8.name())");
                return FilesKt.resolve((File)file2, (String)string);
            }
        }));
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        GradleCliCommonizerKt.registerCommonizerClasspathConfigurationIfNecessary(project3);
        Function1 function1 = (Function1)new Function1<Task, Boolean>(){

            @NotNull
            public final Boolean invoke(Task it) {
                NativeDistributionCommonizationCache nativeDistributionCommonizationCache = this.getCommonizer();
                File file = konanHome;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"konanHome");
                return nativeDistributionCommonizationCache.isUpToDate(file, this.getRootOutputDirectory$kotlin_gradle_plugin_common(), this.getCommonizerTargets());
            }
        };
        this.getOutputs().upToDateWhen(new Spec(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
    }

    private final Set<SharedCommonizerTarget> getCommonizerTargets() {
        Lazy lazy = this.commonizerTargets$delegate;
        return (Set)lazy.getValue();
    }

    private final NativeDistributionCommonizationCache getCommonizer() {
        Lazy lazy = this.commonizer$delegate;
        return (NativeDistributionCommonizationCache)lazy.getValue();
    }

    @Internal
    @NotNull
    public final File getRootOutputDirectory$kotlin_gradle_plugin_common() {
        Lazy lazy = this.rootOutputDirectory$delegate;
        return (File)lazy.getValue();
    }

    @TaskAction
    protected final void run() {
        NativeDistributionCommonizationCache nativeDistributionCommonizationCache = this.getCommonizer();
        File file = this.konanHome;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"konanHome");
        File file2 = this.getRootOutputDirectory$kotlin_gradle_plugin_common();
        Set<SharedCommonizerTarget> set2 = this.getCommonizerTargets();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        CommonizerLogLevel commonizerLogLevel = CommonizerProjectExtensionsKt.getCommonizerLogLevel(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        nativeDistributionCommonizationCache.commonizeNativeDistribution(file, file2, set2, commonizerLogLevel, CommonizerProjectExtensionsKt.getAdditionalCommonizerSettings(project2));
    }
}

