/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.util.concurrent;

import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ListenableFuture;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ListeningExecutorService;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ParametricNullness;
import org.jetbrains.kotlin.com.google.common.util.concurrent.TrustedListenableFutureTask;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@Beta
@CanIgnoreReturnValue
@GwtIncompatible
public abstract class AbstractListeningExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, @ParametricNullness T value2) {
        return TrustedListenableFutureTask.create(runnable, value2);
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return TrustedListenableFutureTask.create(callable);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task2) {
        return (ListenableFuture)super.submit(task2);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task2, @ParametricNullness T result2) {
        return (ListenableFuture)super.submit(task2, result2);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task2) {
        return (ListenableFuture)super.submit(task2);
    }
}

