/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0006\u0010+\u001a\u00020(J\u0006\u0010,\u001a\u00020(J\u0006\u0010-\u001a\u00020(J\u0018\u0010.\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u0018*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0018\u0010\u001e\u001a\u00020\u0018*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0018\u0010 \u001a\u00020!*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u0018\u0010#\u001a\u00020\u0018*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "snapshotsDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "outputsToRestore", "", "Ljava/io/File;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/gradle/api/file/FileSystemOperations;Lorg/gradle/api/file/DirectoryProperty;Lorg/gradle/api/provider/Provider;Ljava/util/List;Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)V", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "getLogger", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "getOutputsToRestore", "()Ljava/util/List;", "getSnapshotsDir", "()Lorg/gradle/api/provider/Provider;", "asNotExistsMarkerFile", "", "", "getAsNotExistsMarkerFile", "(I)Ljava/lang/String;", "asSnapshotArchiveName", "getAsSnapshotArchiveName", "asSnapshotDirectoryName", "getAsSnapshotDirectoryName", "isEmptyDirectory", "", "(Ljava/io/File;)Z", "normalizedToBeRelative", "Ljava/nio/file/Path;", "getNormalizedToBeRelative", "(Ljava/nio/file/Path;)Ljava/lang/String;", "compressDirectoryToZip", "", "snapshotFile", "outputPath", "createSnapshot", "deleteSnapshot", "restoreOutputs", "uncompressZipIntoDirectory", "outputDirectory", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nTasksOutputsBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksOutputsBackup.kt\norg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1872#2,3:192\n1872#2,3:195\n1863#2,2:201\n1317#3:198\n1318#3:200\n1#4:199\n*S KotlinDebug\n*F\n+ 1 TasksOutputsBackup.kt\norg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup\n*L\n43#1:192,3\n72#1:195,3\n140#1:201,2\n120#1:198\n120#1:200\n*E\n"})
public final class TaskOutputsBackup {
    @NotNull
    private final FileSystemOperations fileSystemOperations;
    @NotNull
    private final DirectoryProperty buildDirectory;
    @NotNull
    private final Provider<Directory> snapshotsDir;
    @NotNull
    private final List<File> outputsToRestore;
    @NotNull
    private final KotlinLogger logger;

    public TaskOutputsBackup(@NotNull FileSystemOperations fileSystemOperations, @NotNull DirectoryProperty buildDirectory, @NotNull Provider<Directory> snapshotsDir, @NotNull List<? extends File> outputsToRestore, @NotNull KotlinLogger logger) {
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        Intrinsics.checkNotNullParameter((Object)buildDirectory, (String)"buildDirectory");
        Intrinsics.checkNotNullParameter(snapshotsDir, (String)"snapshotsDir");
        Intrinsics.checkNotNullParameter(outputsToRestore, (String)"outputsToRestore");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.fileSystemOperations = fileSystemOperations;
        this.buildDirectory = buildDirectory;
        this.snapshotsDir = snapshotsDir;
        this.outputsToRestore = outputsToRestore;
        this.logger = logger;
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        return this.buildDirectory;
    }

    @NotNull
    public final Provider<Directory> getSnapshotsDir() {
        return this.snapshotsDir;
    }

    @NotNull
    public final List<File> getOutputsToRestore() {
        return this.outputsToRestore;
    }

    @NotNull
    public final KotlinLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void createSnapshot() {
        Iterable $this$forEachIndexed$iv = CollectionsKt.toSortedSet((Iterable)this.outputsToRestore);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object snapshotFile2;
            void outputPath;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            File file = (File)item$iv;
            int index = n;
            boolean bl = false;
            if (outputPath.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
                if (!this.isEmptyDirectory((File)outputPath)) {
                    snapshotFile2 = new File(((Directory)this.snapshotsDir.get()).getAsFile(), this.getAsSnapshotArchiveName(index));
                    this.logger.debug("Packing " + outputPath + " as " + snapshotFile2 + " to make a backup");
                    this.compressDirectoryToZip((File)snapshotFile2, (File)outputPath);
                    continue;
                }
            }
            if (!outputPath.exists()) {
                this.logger.debug("Ignoring " + outputPath + " in making a backup as it does not exist");
                File markerFile = new File(((Directory)this.snapshotsDir.get()).getAsFile(), this.getAsNotExistsMarkerFile(index));
                markerFile.getParentFile().mkdirs();
                markerFile.createNewFile();
                continue;
            }
            snapshotFile2 = this.snapshotsDir.map(new Transformer(this, index){
                final /* synthetic */ TaskOutputsBackup this$0;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                }

                public final File transform(Directory it) {
                    return it.file(TaskOutputsBackup.access$getAsSnapshotDirectoryName(this.this$0, this.$index)).getAsFile();
                }
            });
            this.logger.debug("Copying " + outputPath + " as " + snapshotFile2 + " to make a backup");
            this.fileSystemOperations.copy(new Action((File)outputPath, (Provider<File>)snapshotFile2){
                final /* synthetic */ File $outputPath;
                final /* synthetic */ Provider<File> $snapshotFile;
                {
                    this.$outputPath = $outputPath;
                    this.$snapshotFile = $snapshotFile;
                }

                public final void execute(CopySpec spec) {
                    Object[] objectArray = new Object[]{this.$outputPath};
                    spec.from(objectArray);
                    spec.into(this.$snapshotFile);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void restoreOutputs() {
        this.fileSystemOperations.delete(new Action(this){
            final /* synthetic */ TaskOutputsBackup this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DeleteSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getOutputsToRestore()};
                it.delete(objectArray);
            }
        });
        Iterable $this$forEachIndexed$iv = CollectionsKt.toSortedSet((Iterable)this.outputsToRestore);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void outputPath;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            File file = (File)item$iv;
            int index = n;
            boolean bl = false;
            File snapshotDir = ((Directory)this.snapshotsDir.get()).file(this.getAsSnapshotDirectoryName(index)).getAsFile();
            if (snapshotDir.isDirectory()) {
                this.logger.debug("Copying files from " + snapshotDir + " into " + outputPath.getParentFile() + " to restore from backup");
                this.fileSystemOperations.copy(new Action(snapshotDir, (File)outputPath){
                    final /* synthetic */ File $snapshotDir;
                    final /* synthetic */ File $outputPath;
                    {
                        this.$snapshotDir = $snapshotDir;
                        this.$outputPath = $outputPath;
                    }

                    public final void execute(CopySpec spec) {
                        Object[] objectArray = new Object[]{this.$snapshotDir};
                        spec.from(objectArray);
                        spec.into((Object)this.$outputPath.getParentFile());
                    }
                });
                continue;
            }
            if (((Directory)this.snapshotsDir.get()).file(this.getAsNotExistsMarkerFile(index)).getAsFile().exists()) continue;
            File snapshotArchive = ((Directory)this.snapshotsDir.get()).file(this.getAsSnapshotArchiveName(index)).getAsFile();
            this.logger.debug("Unpacking " + snapshotArchive + " into " + outputPath + " to restore from backup");
            if (!snapshotArchive.exists()) {
                this.logger.warn(StringsKt.trimMargin$default((String)("\n                        |Failed to restore task outputs as snapshot file " + snapshotArchive.getAbsolutePath() + " does not exist!\n                        |On recompilation full rebuild will be performed.\n                        "), null, (int)1, null));
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)snapshotArchive, (String)"snapshotArchive");
            Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
            this.uncompressZipIntoDirectory(snapshotArchive, (File)outputPath);
        }
    }

    public final void deleteSnapshot() {
        this.fileSystemOperations.delete(new Action(this){
            final /* synthetic */ TaskOutputsBackup this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DeleteSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getSnapshotsDir()};
                it.delete(objectArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void compressDirectoryToZip(File snapshotFile2, File outputPath) {
        snapshotFile2.getParentFile().mkdirs();
        snapshotFile2.createNewFile();
        Closeable closeable = new FileOutputStream(snapshotFile2);
        int n = 8192;
        closeable = new ZipOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipOutputStream zip = (ZipOutputStream)closeable;
            boolean bl = false;
            zip.setLevel(0);
            Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)outputPath)), (Function1)((Function1)new Function1<File, Boolean>(this){
                final /* synthetic */ TaskOutputsBackup this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return !file.isDirectory() || TaskOutputsBackup.access$isEmptyDirectory(this.this$0, file);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                String suffix = file.isDirectory() ? "/" : "";
                ZipEntry entry2 = new ZipEntry(FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file, (File)outputPath)) + suffix);
                zip.putNextEntry(entry2);
                if (!file.isDirectory()) {
                    Closeable closeable2 = new FileInputStream(file);
                    int n2 = 8192;
                    closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n2);
                    Throwable throwable2 = null;
                    try {
                        BufferedInputStream it = (BufferedInputStream)closeable2;
                        boolean bl3 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)zip, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zip.closeEntry();
            }
            zip.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void uncompressZipIntoDirectory(File snapshotFile2, File outputDirectory2) {
        Path outputPath = outputDirectory2.toPath();
        URI snapshotUri = URI.create("jar:" + snapshotFile2.toURI());
        Closeable closeable = FileSystems.newFileSystem(snapshotUri, MapsKt.emptyMap());
        Throwable throwable = null;
        try {
            FileSystem zipFs = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = zipFs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"zipFs.rootDirectories");
            Iterable<Path> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<Path> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Path element$iv;
                Path rootDir = element$iv = iterator.next();
                boolean bl2 = false;
                AutoCloseable autoCloseable = Files.walk(rootDir, new FileVisitOption[0]);
                Throwable throwable2 = null;
                try {
                    Stream paths = (Stream)autoCloseable;
                    boolean bl3 = false;
                    paths.forEach(new Consumer(outputPath, this){
                        final /* synthetic */ Path $outputPath;
                        final /* synthetic */ TaskOutputsBackup this$0;
                        {
                            this.$outputPath = $outputPath;
                            this.this$0 = $receiver;
                        }

                        public final void accept(Path it) {
                            if (Files.isDirectory(it, new LinkOption[0])) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                Files.createDirectories(this.$outputPath.resolve(TaskOutputsBackup.access$getNormalizedToBeRelative(this.this$0, it)), new FileAttribute[0]);
                            } else if (Files.isRegularFile(it, new LinkOption[0])) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(it, this.$outputPath.resolve(TaskOutputsBackup.access$getNormalizedToBeRelative(this.this$0, it)), copyOptionArray);
                            }
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isEmptyDirectory(File $this$isEmptyDirectory) {
        boolean bl;
        AutoCloseable autoCloseable = Files.list($this$isEmptyDirectory.toPath());
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl2 = false;
            bl = it.findFirst().isPresent();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return !bl;
    }

    private final String getNormalizedToBeRelative(Path $this$normalizedToBeRelative) {
        return Intrinsics.areEqual((Object)((Object)$this$normalizedToBeRelative).toString(), (Object)"/") ? "." : StringsKt.removePrefix((String)((Object)$this$normalizedToBeRelative).toString(), (CharSequence)"/");
    }

    private final String getAsSnapshotArchiveName(int $this$asSnapshotArchiveName) {
        return $this$asSnapshotArchiveName + ".zip";
    }

    private final String getAsNotExistsMarkerFile(int $this$asNotExistsMarkerFile) {
        return $this$asNotExistsMarkerFile + ".not-exists";
    }

    private final String getAsSnapshotDirectoryName(int $this$asSnapshotDirectoryName) {
        return String.valueOf($this$asSnapshotDirectoryName);
    }

    public static final /* synthetic */ String access$getAsSnapshotDirectoryName(TaskOutputsBackup $this, int $receiver) {
        return $this.getAsSnapshotDirectoryName($receiver);
    }

    public static final /* synthetic */ boolean access$isEmptyDirectory(TaskOutputsBackup $this, File $receiver) {
        return $this.isEmptyDirectory($receiver);
    }

    public static final /* synthetic */ String access$getNormalizedToBeRelative(TaskOutputsBackup $this, Path $receiver) {
        return $this.getNormalizedToBeRelative($receiver);
    }
}

