/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.configuration;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b0\u0019J \u0010\u001e\u001a\u00020\u001b2\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a\u0012\u0004\u0012\u00020\u001b0\u0019J\u0014\u0010\u001f\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a\u0012\u0004\u0012\u00020\u001b0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/configuration/TaskConfigAction;", "TASK", "Lorg/gradle/api/Task;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "executed", "", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "getProject", "()Lorg/gradle/api/Project;", "propertiesProvider", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "getPropertiesProvider", "()Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "taskConfigActions", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Function1;", "Lorg/gradle/api/tasks/TaskProvider;", "", "configureTask", "configAction", "configureTaskProvider", "execute", "taskProvider", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinCompileConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinCompileConfig.kt\norg/jetbrains/kotlin/gradle/tasks/configuration/TaskConfigAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1863#2,2:187\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinCompileConfig.kt\norg/jetbrains/kotlin/gradle/tasks/configuration/TaskConfigAction\n*L\n182#1:187,2\n*E\n"})
public abstract class TaskConfigAction<TASK extends Task> {
    @NotNull
    private final Project project;
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ProviderFactory providers;
    @NotNull
    private final PropertiesProvider propertiesProvider;
    private boolean executed;
    @NotNull
    private final ArrayDeque<Function1<TaskProvider<TASK>, Unit>> taskConfigActions;

    public TaskConfigAction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ObjectFactory objectFactory = this.project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        this.objectFactory = objectFactory;
        ProviderFactory providerFactory = this.project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        this.providers = providerFactory;
        this.propertiesProvider = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(this.project);
        this.taskConfigActions = new ArrayDeque();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @NotNull
    protected final ProviderFactory getProviders() {
        return this.providers;
    }

    @NotNull
    protected final PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public final void configureTaskProvider(@NotNull Function1<? super TaskProvider<TASK>, Unit> configAction) {
        Intrinsics.checkNotNullParameter(configAction, (String)"configAction");
        if (!(!this.executed)) {
            boolean bl = false;
            String string = "Task has already been configured. Configuration actions should be added to this object before `this.execute` method runs.";
            throw new IllegalStateException(string.toString());
        }
        this.taskConfigActions.addLast(configAction);
    }

    public final void configureTask(@NotNull Function1<? super TASK, Unit> configAction) {
        Intrinsics.checkNotNullParameter(configAction, (String)"configAction");
        this.configureTaskProvider((Function1)new Function1<TaskProvider<TASK>, Unit>(configAction){
            final /* synthetic */ Function1<TASK, Unit> $configAction;
            {
                this.$configAction = $configAction;
                super(1);
            }

            public final void invoke(TaskProvider<TASK> taskProvider2) {
                Intrinsics.checkNotNullParameter(taskProvider2, (String)"taskProvider");
                taskProvider2.configure(new Action(this.$configAction){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        this.function.invoke(p0);
                    }
                });
            }
        });
    }

    public final void execute(@NotNull TaskProvider<TASK> taskProvider2) {
        Intrinsics.checkNotNullParameter(taskProvider2, (String)"taskProvider");
        this.executed = true;
        Iterable $this$forEach$iv = (Iterable)this.taskConfigActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke(taskProvider2);
        }
    }
}

