/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.PropertiesManager;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.gradle.utils.GradleUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/PropertiesBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesBuildService$Params;", "()V", "propertiesManager", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/gradle/api/Project;", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesManager;", "get", "", "propertyName", "project", "property", "Lorg/gradle/api/provider/Provider;", "Companion", "Params", "kotlin-gradle-plugin_common"})
public abstract class PropertiesBuildService
implements BuildService<Params> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<Project, PropertiesManager> propertiesManager = new ConcurrentHashMap();

    @NotNull
    public final Provider<String> property(@NotNull String propertyName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.propertiesManager.computeIfAbsent(project, new Function(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ PropertiesBuildService this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public final PropertiesManager apply(Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = ((Params)this.this$0.getParameters()).getLocalProperties().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.localProperties.get()");
                return new PropertiesManager(this.$project, (Map)object);
            }
        }).property(propertyName);
    }

    @Nullable
    public final String get(@NotNull String propertyName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (String)this.property(propertyName, project).getOrNull();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/PropertiesBuildService$Companion;", "", "()V", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesBuildService;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<PropertiesBuildService> registerIfAbsent(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Gradle gradle = project.getGradle();
            Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
            return GradleUtilsKt.registerClassLoaderScopedBuildService(gradle, Reflection.getOrCreateKotlinClass(PropertiesBuildService.class), (Action)new Action(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void execute(BuildServiceSpec<Params> it) {
                    ((Params)it.getParameters()).getLocalProperties().set(FileUtilsKt.getLocalProperties(this.$project));
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/PropertiesBuildService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "localProperties", "Lorg/gradle/api/provider/MapProperty;", "", "getLocalProperties", "()Lorg/gradle/api/provider/MapProperty;", "kotlin-gradle-plugin_common"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public MapProperty<String, String> getLocalProperties();
    }
}

